/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.HeroJoinPartyEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.Messaging;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PartyAcceptCommand
extends BasicCommand {
    private final Heroes plugin;

    public PartyAcceptCommand(Heroes plugin) {
        super("Party Accept");
        this.plugin = plugin;
        this.setDescription("Accept a party invite");
        this.setUsage("/party accept \u00a79<player>");
        this.setArgumentRange(1, 1);
        this.setIdentifiers("party accept");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        if (this.plugin.getServer().getPlayer(args[0]) != null) {
            Player newPlayer = this.plugin.getServer().getPlayer(args[0]);
            Hero newHero = this.plugin.getCharacterManager().getHero(newPlayer);
            if (hero.getParty() != null) {
                if (Heroes.herochat != null) {
                    Messaging.send((CommandSender)player, ChatColor.GREEN.toString() + "[Party] " + ChatColor.WHITE + "Sorry, you're already in a party.", new Object[0]);
                } else {
                    Messaging.send((CommandSender)player, "Sorry, you're already in a party", new Object[0]);
                }
                return false;
            }
            if (newHero.getParty() != null && newHero.getParty().isInvited(player.getName())) {
                HeroJoinPartyEvent event = new HeroJoinPartyEvent(hero, newHero.getParty());
                this.plugin.getServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return false;
                }
                hero.setParty(newHero.getParty());
                newHero.getParty().addMember(hero);
                hero.getParty().messageParty("$1 has joined the party", player.getName());
                if (Heroes.herochat != null) {
                    Messaging.send((CommandSender)player, ChatColor.GREEN.toString() + "[Party] " + ChatColor.WHITE + "You're now in $1's party", newPlayer.getName());
                } else {
                    Messaging.send((CommandSender)player, "You're now in $1's party", newPlayer.getName());
                }
                hero.getParty().removeInvite(player);
            } else if (Heroes.herochat != null) {
                Messaging.send((CommandSender)player, ChatColor.GREEN.toString() + "[Party] " + ChatColor.WHITE + "Sorry, $1 hasn't invited you to their party", newPlayer.getName());
            } else {
                Messaging.send((CommandSender)player, "Sorry, $1 hasn't invited you to their party", newPlayer.getName());
            }
        } else if (Heroes.herochat != null) {
            Messaging.send((CommandSender)player, ChatColor.GREEN.toString() + "[Party] " + ChatColor.WHITE + "Sorry, $1 doesn't match anyone in-game.", args[0]);
        } else {
            Messaging.send((CommandSender)player, "Sorry, $1 doesn't match anyone in-game", args[0]);
        }
        return true;
    }
}

