/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.dthielke.herochat.Channel;
import com.dthielke.herochat.Chatter;
import com.dthielke.herochat.Herochat;
import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.party.HeroParty;
import com.herocraftonline.heroes.characters.party.PartyChannel;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.Messaging;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PartyHeroChatCommand
extends BasicCommand {
    private final Heroes plugin;

    public PartyHeroChatCommand(Heroes plugin) {
        super("Party Chat");
        this.plugin = plugin;
        this.setDescription("Sends messages to your party");
        this.setUsage("/party \u00a79<msg> OR /p \u00a79<msg>");
        this.setArgumentRange(0, 1000);
        this.setIdentifiers("pc", "p", "party");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        HeroParty party = hero.getParty();
        if (party == null) {
            if (Heroes.herochat != null) {
                Messaging.send((CommandSender)player, ChatColor.GREEN.toString() + "[Party] " + ChatColor.WHITE + "You are not in a party.", new Object[0]);
            }
            return false;
        }
        Set<Hero> partyMembers = party.getMembers();
        if (partyMembers.size() <= 1) {
            Messaging.send((CommandSender)player, ChatColor.GREEN.toString() + "[Party] " + ChatColor.WHITE + "Your party is empty.", new Object[0]);
            return false;
        }
        Chatter chatter = Herochat.getChatterManager().getChatter(hero.getPlayer());
        PartyChannel channel = this.plugin.getPartyChannelManager().getChannel(party);
        if (channel == null) {
            return false;
        }
        switch (args.length) {
            case 0: {
                chatter.setActiveChannel((Channel)channel, false, false);
                Messaging.send((CommandSender)player, ChatColor.YELLOW + "Now chatting to your " + ChatColor.DARK_AQUA + "Party" + ChatColor.YELLOW + ".", new Object[0]);
                return true;
            }
        }
        StringBuilder msg = new StringBuilder();
        for (String string : args) {
            msg.append(string).append(" ");
        }
        Channel active = chatter.getActiveChannel();
        chatter.setActiveChannel((Channel)channel, false, false);
        Herochat.getMessageHandler().handle(player, msg.toString().trim(), "<%1$s> %2$s");
        chatter.setActiveChannel(active, false, false);
        return true;
    }
}

