/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.PartyInviteEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.party.HeroParty;
import com.herocraftonline.heroes.characters.party.PartyChannelManager;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.Messaging;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PartyInviteCommand
extends BasicCommand {
    private final Heroes plugin;
    private final PartyChannelManager channelManager;

    public PartyInviteCommand(Heroes plugin) {
        super("Party Invite");
        this.plugin = plugin;
        this.channelManager = plugin.getPartyChannelManager();
        this.setDescription("Invites a player to your party");
        this.setUsage("/party invite \u00a79<player>");
        this.setArgumentRange(1, 1);
        this.setIdentifiers("party invite");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        HeroParty party;
        if (!(sender instanceof Player)) {
            Messaging.send(sender, "Only players can create parties", new Object[0]);
            return false;
        }
        Player player = (Player)sender;
        Player target = this.plugin.getServer().getPlayer(args[0]);
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        if (target == null) {
            if (this.channelManager != null) {
                Messaging.send((CommandSender)player, ChatColor.GREEN.toString() + "[Party] " + ChatColor.WHITE + "Player not found.", new Object[0]);
            } else {
                Messaging.send((CommandSender)player, "Player not found.", new Object[0]);
            }
            return false;
        }
        if (target.equals(player)) {
            if (this.channelManager != null) {
                Messaging.send((CommandSender)player, ChatColor.GREEN.toString() + "[Party] " + ChatColor.WHITE + "You cannot invite yourself.", new Object[0]);
            } else {
                Messaging.send((CommandSender)player, "You cannot invite yourself.", new Object[0]);
            }
            return false;
        }
        if (hero.getParty() == null) {
            HeroParty newParty = new HeroParty(hero, this.plugin);
            this.plugin.getPartyManager().addParty(newParty);
            if (this.channelManager != null) {
                this.channelManager.messageParty(newParty, "Your party has been created.", new Object[0]);
            } else {
                Messaging.send((CommandSender)player, "Your party has been created", new Object[0]);
            }
        }
        if ((party = hero.getParty()).getLeader() == null || !party.getLeader().equals(hero)) {
            if (this.channelManager != null) {
                Messaging.send((CommandSender)player, ChatColor.GREEN.toString() + "[Party] " + ChatColor.WHITE + "You are not leader of this party.", new Object[0]);
            } else {
                Messaging.send((CommandSender)player, "You are not leader of this party.", new Object[0]);
            }
            return false;
        }
        int memberCount = party.getMembers().size();
        if (memberCount >= Heroes.properties.maxPartySize) {
            if (this.channelManager != null) {
                Messaging.send((CommandSender)player, ChatColor.GREEN.toString() + "[Party] " + ChatColor.WHITE + "Your party is full!", new Object[0]);
            } else {
                Messaging.send((CommandSender)player, "Your party is full!", new Object[0]);
            }
            return false;
        }
        if (memberCount + party.getInviteCount() >= Heroes.properties.maxPartySize) {
            party.removeOldestInvite();
        }
        party.addInvite(target.getName());
        Bukkit.getPluginManager().callEvent((Event)new PartyInviteEvent(this.plugin.getCharacterManager().getHero(target), party));
        if (this.channelManager != null) {
            Messaging.send((CommandSender)target, ChatColor.GREEN.toString() + "[Party] " + ChatColor.WHITE + "$1 has invited you to their party", player.getName());
            Messaging.send((CommandSender)target, ChatColor.GREEN.toString() + "[Party] " + ChatColor.WHITE + "Type /party accept $1 to join", player.getName());
            Messaging.send((CommandSender)player, ChatColor.GREEN.toString() + "[Party] " + ChatColor.WHITE + "$1 has been invited to your party", target.getName());
        } else {
            Messaging.send((CommandSender)target, "$1 has invited you to their party", player.getName());
            Messaging.send((CommandSender)target, "Type /party accept $1 to join", player.getName());
            Messaging.send((CommandSender)player, "$1 has been invited to your party", target.getName());
        }
        return true;
    }
}

