/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.HeroLeavePartyEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.party.HeroParty;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.Messaging;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PartyKickCommand
extends BasicCommand {
    private final Heroes plugin;

    public PartyKickCommand(Heroes plugin) {
        super("Party Kick");
        this.plugin = plugin;
        this.setDescription("Kicks a player from the party");
        this.setUsage("/party kick \u00a79<player>");
        this.setArgumentRange(1, 1);
        this.setIdentifiers("party kick");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        HeroParty party = hero.getParty();
        if (party == null) {
            if (Heroes.herochat != null) {
                Messaging.send(sender, ChatColor.GREEN.toString() + "[Party] " + ChatColor.WHITE + "You don't have a party!", new Object[0]);
            } else {
                Messaging.send(sender, "You don't have a party!", new Object[0]);
            }
            return true;
        }
        if (party.getLeader() == null || !party.getLeader().equals(hero)) {
            if (Heroes.herochat != null) {
                Messaging.send(sender, ChatColor.GREEN.toString() + "[Party] " + ChatColor.WHITE + "You must be the leader to kick players from the party.", new Object[0]);
            } else {
                Messaging.send(sender, "You must be the leader to kick players from the party.", new Object[0]);
            }
            return true;
        }
        if (!party.getLeader().equals(hero)) {
            Messaging.send(sender, "Only the leader of a party can change give leadership to another hero!", new Object[0]);
            return true;
        }
        Player tPlayer = this.plugin.getServer().getPlayer(args[0]);
        if (tPlayer == null) {
            if (Heroes.herochat != null) {
                Messaging.send(sender, ChatColor.GREEN.toString() + "[Party] " + ChatColor.WHITE + "That player is not in your party.", new Object[0]);
            } else {
                Messaging.send(sender, "That player is not in your party.", new Object[0]);
            }
            return true;
        }
        Hero tHero = null;
        for (Hero found : party.getMembers()) {
            if (!found.getPlayer().equals(tPlayer)) continue;
            tHero = found;
            break;
        }
        if (tHero == null) {
            if (Heroes.herochat != null) {
                Messaging.send(sender, ChatColor.GREEN.toString() + "[Party] " + ChatColor.WHITE + "That player is not in your party.", new Object[0]);
            } else {
                Messaging.send(sender, "That player is not in your party.", new Object[0]);
            }
            return true;
        }
        HeroParty heroParty = hero.getParty();
        HeroLeavePartyEvent event = new HeroLeavePartyEvent(tHero, heroParty, HeroLeavePartyEvent.LeavePartyReason.KICK);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            if (Heroes.herochat != null) {
                Messaging.send(sender, ChatColor.GREEN.toString() + "[Party]" + ChatColor.WHITE + "You can not kick the player from the party at this time!", new Object[0]);
            } else {
                sender.sendMessage("You can not kick the player from the party at this time!");
            }
            return true;
        }
        heroParty.messageParty("$1 has been kicked from the party", tPlayer.getDisplayName());
        heroParty.removeMember(tHero);
        return true;
    }
}

