/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.party.HeroParty;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.Messaging;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PartyLeadCommand
extends BasicCommand {
    private final Heroes plugin;

    public PartyLeadCommand(Heroes plugin) {
        super("Party Lead");
        this.plugin = plugin;
        this.setDescription("Checks or sets the leader of the party.");
        this.setUsage("/party lead \u00a79<player>");
        this.setArgumentRange(0, 1);
        this.setIdentifiers("party lead", "party leader");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        HeroParty party = hero.getParty();
        if (party == null) {
            if (Heroes.herochat != null) {
                Messaging.send(sender, ChatColor.GREEN.toString() + "[Party] " + ChatColor.WHITE + "You don't have a party!", new Object[0]);
            } else {
                Messaging.send(sender, "You don't have a party!", new Object[0]);
            }
            return true;
        }
        if (party.getLeader() == null) {
            if (Heroes.herochat != null) {
                Messaging.send(sender, ChatColor.GREEN.toString() + "[Party] " + ChatColor.WHITE + "The party has no leader!", new Object[0]);
            } else {
                Messaging.send(sender, "The party has no leader!", new Object[0]);
            }
            return true;
        }
        if (args.length == 0) {
            if (Heroes.herochat != null) {
                Messaging.send(sender, ChatColor.GREEN.toString() + "[Party] " + ChatColor.WHITE + "The current party leader is $1.", party.getLeader().getPlayer().getDisplayName());
            } else {
                Messaging.send(sender, "The current party leader is $1.", party.getLeader().getPlayer().getDisplayName());
            }
            return true;
        }
        if (!party.getLeader().equals(hero)) {
            if (Heroes.herochat != null) {
                Messaging.send(sender, ChatColor.GREEN.toString() + "[Party] " + ChatColor.WHITE + "Only the leader of a part can give leadership to another hero!", new Object[0]);
            } else {
                Messaging.send(sender, "Only the leader of a party can change give leadership to another hero!", new Object[0]);
            }
            return true;
        }
        Player tPlayer = this.plugin.getServer().getPlayer(args[0]);
        if (tPlayer == null) {
            if (Heroes.herochat != null) {
                Messaging.send(sender, ChatColor.GREEN.toString() + "[Party] " + ChatColor.WHITE + "That player is not in your party!", new Object[0]);
            } else {
                Messaging.send(sender, "That player is not in your party.", new Object[0]);
            }
            return true;
        }
        Hero tHero = null;
        for (Hero found : party.getMembers()) {
            if (!found.getPlayer().equals(tPlayer)) continue;
            tHero = found;
            break;
        }
        if (tHero == null) {
            if (Heroes.herochat != null) {
                Messaging.send(sender, ChatColor.GREEN.toString() + "[Party] " + ChatColor.WHITE + "That player is not in your party.", new Object[0]);
            } else {
                Messaging.send(sender, "That player is not in your party.", new Object[0]);
            }
            Heroes.log(Level.INFO, "Hero not Found.");
            return true;
        }
        party.setLeader(tHero);
        party.messageParty("$1 is now the party leader.", tHero.getPlayer().getDisplayName());
        return true;
    }
}

