/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.HeroLeavePartyEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.party.HeroParty;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PartyLeaveCommand
extends BasicCommand {
    private final Heroes plugin;

    public PartyLeaveCommand(Heroes plugin) {
        super("Party Leave");
        this.plugin = plugin;
        this.setDescription("Leaves your party");
        this.setUsage("/party leave");
        this.setArgumentRange(0, 0);
        this.setIdentifiers("party leave");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        if (hero.getParty() == null) {
            Messaging.send(sender, "You don't have a party!", new Object[0]);
            return true;
        }
        HeroParty heroParty = hero.getParty();
        HeroLeavePartyEvent event = new HeroLeavePartyEvent(hero, heroParty, HeroLeavePartyEvent.LeavePartyReason.COMMAND);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            sender.sendMessage("You can not leave the party at this time!");
            return true;
        }
        heroParty.messageParty("$1 has left the party", player.getName());
        heroParty.removeMember(hero);
        if (heroParty.getMembers().size() == 0) {
            this.plugin.getPartyManager().removeParty(heroParty);
        }
        hero.setParty(null);
        return true;
    }
}

