/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.party.HeroParty;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.Messaging;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PartyWhoCommand
extends BasicCommand {
    private final Heroes plugin;

    public PartyWhoCommand(Heroes plugin) {
        super("Party Who");
        this.plugin = plugin;
        this.setDescription("Lists your party members");
        this.setUsage("/party who");
        this.setArgumentRange(0, 0);
        this.setIdentifiers("party who");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        if (hero.getParty() == null) {
            if (Heroes.herochat != null) {
                Messaging.send((CommandSender)player, ChatColor.GREEN.toString() + "[Party] " + ChatColor.WHITE + "Sorry, you aren't in a party.", new Object[0]);
            } else {
                Messaging.send((CommandSender)player, "Sorry, you aren't in a party.", new Object[0]);
            }
            return false;
        }
        if (Heroes.herochat != null) {
            Messaging.send((CommandSender)player, ChatColor.GREEN.toString() + "[Party] " + ChatColor.WHITE + "$1", this.partyDisplayNames(hero.getParty()).toString());
        } else {
            Messaging.send((CommandSender)player, "$1", this.partyNames(hero.getParty()).toString());
        }
        return true;
    }

    public Set<String> partyNames(HeroParty party) {
        HashSet<String> names = new HashSet<String>();
        for (Hero partyMember : party.getMembers()) {
            names.add(partyMember.getPlayer().getName());
        }
        return names;
    }

    private Set<String> partyDisplayNames(HeroParty party) {
        HashSet<String> dispNames = new HashSet<String>();
        for (Hero partyMember : party.getMembers()) {
            dispNames.add(partyMember.getPlayer().getDisplayName());
        }
        return dispNames;
    }
}

