/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.command.CommandHandler;
import java.util.ArrayList;
import org.bukkit.command.CommandSender;

public class PathsCommand
extends BasicCommand {
    private static final int PATHS_PER_PAGE = 8;
    private final Heroes plugin;

    public PathsCommand(Heroes plugin) {
        super("Paths");
        this.plugin = plugin;
        this.setDescription("Lists all paths available to you, primary and professions!");
        this.setUsage("/hero paths \u00a78[page#]");
        this.setArgumentRange(0, 1);
        this.setIdentifiers("hero paths");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        int page = 0;
        if (args.length != 0) {
            try {
                page = Integer.parseInt(args[0]) - 1;
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        ArrayList<HeroClass> paths = new ArrayList<HeroClass>();
        for (HeroClass hc : this.plugin.getClassManager().getClasses()) {
            if (hc.getTier() != 1) continue;
            paths.add(hc);
        }
        int numPages = paths.size() / 8;
        if (paths.size() % 8 != 0) {
            ++numPages;
        }
        if (page >= numPages || page < 0) {
            page = 0;
        }
        sender.sendMessage("\u00a7c-----[ \u00a7fHeroes Paths <" + (page + 1) + "/" + numPages + ">\u00a7c ]-----");
        int start = page * 8;
        int end = start + 8;
        if (end > paths.size()) {
            end = paths.size();
        }
        while (start < end) {
            HeroClass heroClass = (HeroClass)paths.get(start);
            if (heroClass.isDefault() || CommandHandler.hasPermission(sender, "heroes.classes." + heroClass.getName().toLowerCase())) {
                StringBuilder line = new StringBuilder();
                if (heroClass.isPrimary()) {
                    line.append("Pri");
                }
                if (heroClass.isSecondary()) {
                    if (heroClass.isPrimary()) {
                        line.insert(0, "  \u00a7d");
                        line.append(" | ");
                    } else {
                        line.append("  \u00a7c");
                    }
                    line.append("Prof");
                } else if (heroClass.isPrimary()) {
                    line.insert(0, "  \u00a79");
                }
                line.append(" | \u00a7a").append(heroClass.getName());
                String description = heroClass.getDescription();
                if (description != null && !description.isEmpty()) {
                    line.append(" - \u00a7f").append(heroClass.getDescription());
                }
                sender.sendMessage(line.toString());
            }
            ++start;
        }
        sender.sendMessage("\u00a7cTo choose a path, type \u00a7f/hero choose <path> \u00a7cor \u00a7f/hero prof <prof>");
        return true;
    }
}

