/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.ClassChangeEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.command.BasicInteractiveCommand;
import com.herocraftonline.heroes.command.BasicInteractiveCommandState;
import com.herocraftonline.heroes.command.CommandHandler;
import com.herocraftonline.heroes.util.Messaging;
import com.herocraftonline.heroes.util.Properties;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ProfessionCommand
extends BasicInteractiveCommand {
    private final Heroes plugin;
    private final Map<String, HeroClass> pendingClassSelections = new HashMap<String, HeroClass>();
    private final Map<String, Double> pendingClassCostStatus = new HashMap<String, Double>();

    public ProfessionCommand(Heroes plugin) {
        super("Choose Profession Class");
        this.plugin = plugin;
        this.setStates(new StateA(), new StateB());
        this.setDescription("Selects a new path or specialization as your profession");
        this.setUsage("/hero profession \u00a79<type>");
    }

    @Override
    public String getCancelIdentifier() {
        return "hero cancel";
    }

    @Override
    public void onCommandCancelled(CommandSender executor) {
        if (!(executor instanceof Player)) {
            return;
        }
        this.pendingClassSelections.remove(executor.getName());
        this.pendingClassCostStatus.remove(executor.getName());
    }

    class StateB
    extends BasicInteractiveCommandState {
        public StateB() {
            super("hero confirm");
            this.setArgumentRange(0, 0);
        }

        @Override
        public boolean execute(CommandSender executor, String identifier, String[] args) {
            if (!(executor instanceof Player)) {
                return true;
            }
            Player player = (Player)executor;
            Hero hero = ProfessionCommand.this.plugin.getCharacterManager().getHero(player);
            HeroClass currentClass = hero.getSecondClass();
            HeroClass newClass = (HeroClass)ProfessionCommand.this.pendingClassSelections.remove(player.getName());
            double cost = (Double)ProfessionCommand.this.pendingClassCostStatus.remove(player.getName());
            Properties prop = Heroes.properties;
            ClassChangeEvent event = new ClassChangeEvent(hero, currentClass, newClass, cost);
            ProfessionCommand.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                ProfessionCommand.this.cancelInteraction((CommandSender)player);
                Messaging.send((CommandSender)player, "You're not allowed to join that class", new Object[0]);
                return true;
            }
            cost = event.getCost();
            if (currentClass != null && (prop.resetExpOnClassChange && !hero.isMaster(currentClass) || prop.resetMasteryOnClassChange && hero.isMaster(currentClass))) {
                hero.setExperience(currentClass, 0.0);
            }
            if (cost > 0.0) {
                if (Heroes.econ.has(player.getName(), cost)) {
                    Heroes.econ.withdrawPlayer(player.getName(), cost);
                    Messaging.send((CommandSender)hero.getPlayer(), "The Gods are pleased with your offering of $1.", Heroes.econ.format(cost));
                } else {
                    Messaging.send((CommandSender)hero.getPlayer(), "You're unable to meet the offering of $1 to become $2.", Heroes.econ.format(cost), newClass.getName());
                    return true;
                }
            }
            hero.changeHeroClass(newClass, true);
            Messaging.send((CommandSender)player, "Welcome to the path of the $1!", newClass.getName());
            ProfessionCommand.this.plugin.getCharacterManager().saveHero(hero, false);
            return true;
        }
    }

    class StateA
    extends BasicInteractiveCommandState {
        public StateA() {
            super("hero prof", "hero profession");
            this.setArgumentRange(1, 1);
        }

        @Override
        public boolean execute(CommandSender executor, String identifier, String[] args) {
            if (!(executor instanceof Player)) {
                return false;
            }
            Properties props = Heroes.properties;
            Player player = (Player)executor;
            Hero hero = ProfessionCommand.this.plugin.getCharacterManager().getHero(player);
            HeroClass currentClass = hero.getSecondClass();
            HeroClass newClass = ProfessionCommand.this.plugin.getClassManager().getClass(args[0]);
            if (newClass == null) {
                Messaging.send((CommandSender)player, "Class not found.", new Object[0]);
                return false;
            }
            if (newClass.equals(currentClass) || newClass.equals(hero.getHeroClass())) {
                Messaging.send((CommandSender)player, "You are already set as this Class.", new Object[0]);
                return false;
            }
            if (!newClass.isSecondary()) {
                Messaging.send((CommandSender)player, "That is not a secondary Class!", new Object[0]);
                return false;
            }
            if (currentClass != null) {
                if (!hero.getHeroClass().isDefault() && hero.isMaster(currentClass) && currentClass.getParents().isEmpty() && props.lockAtHighestTier) {
                    Messaging.send((CommandSender)player, "You have mastered your class and can not choose a new one!", new Object[0]);
                    return false;
                }
                if (!hero.isMaster(currentClass) && props.lockPathTillMaster) {
                    Messaging.send((CommandSender)player, "You must master this class before swapping to another.", new Object[0]);
                    return false;
                }
            }
            if (!newClass.hasNoParents()) {
                for (HeroClass parentClass : newClass.getStrongParents()) {
                    if (hero.isMaster(parentClass)) continue;
                    Messaging.send((CommandSender)player, "$1 requires you to master: $2", newClass.getName(), newClass.getStrongParents().toString().replace("[", "").replace("]", ""));
                    return false;
                }
                boolean masteredOne = false;
                for (HeroClass parentClass : newClass.getWeakParents()) {
                    if (!hero.isMaster(parentClass)) continue;
                    masteredOne = true;
                    break;
                }
                if (!masteredOne && !newClass.getWeakParents().isEmpty()) {
                    Messaging.send((CommandSender)player, "$1 requires you to master one of: $2", newClass.getName(), newClass.getWeakParents().toString().replace("[", "").replace("]", ""));
                    return false;
                }
            }
            if (!newClass.isDefault() && !CommandHandler.hasPermission((CommandSender)player, "heroes.classes." + newClass.getName().toLowerCase())) {
                Messaging.send((CommandSender)player, "You don't have permission for $1.", newClass.getName());
                return false;
            }
            double cost = newClass.getCost();
            if (currentClass == null && Heroes.properties.firstSwitchFree) {
                cost = 0.0;
            } else if (hero.getExperience(newClass) > 0.0) {
                cost = Heroes.properties.oldProfSwapCost;
            }
            if (hero.isMaster(newClass) && props.swapMasterFree) {
                cost = 0.0;
            } else if (!props.economy || Heroes.econ == null || cost <= 0.0) {
                cost = 0.0;
            }
            if (props.economy && cost > 0.0 && !Heroes.econ.has(player.getName(), cost)) {
                Messaging.send((CommandSender)player, "It will cost $1 to swith professions, you only have $2", Heroes.econ.format(cost), Heroes.econ.format(Heroes.econ.getBalance(player.getName())));
                return false;
            }
            ProfessionCommand.this.pendingClassCostStatus.put(player.getName(), cost);
            Messaging.send(executor, "You have chosen...", new Object[0]);
            Messaging.send(executor, "$1: $2", newClass.getName(), newClass.getDescription().toLowerCase());
            String skills = "";
            for (String skillName : newClass.getSkillNames()) {
                if (skills.length() > 80) {
                    Messaging.send(executor, "Skills: " + skills, new Object[0]);
                    skills = "";
                }
                skills = skills + skillName + " ";
            }
            if (!skills.isEmpty()) {
                Messaging.send(executor, "Skills: " + skills, new Object[0]);
            }
            if (cost > 0.0) {
                Messaging.send(executor, "$1: $2", "Fee", Heroes.econ.format(cost));
            }
            Messaging.send(executor, "Please \u00a7a/hero confirm \u00a77or \u00a7c/hero cancel \u00a77this selection.", new Object[0]);
            ProfessionCommand.this.pendingClassSelections.put(player.getName(), newClass);
            return true;
        }
    }
}

