/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.gui.MenuHandler;
import com.herocraftonline.heroes.util.Messaging;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ScrollCommand
extends BasicCommand {
    private final Heroes plugin;

    public ScrollCommand(Heroes plugin) {
        super("Scroll");
        this.plugin = plugin;
        this.setDescription("This will convert a map in your inventory to a scroll!");
        this.setUsage("/scroll");
        this.setArgumentRange(0, 0);
        this.setIdentifiers("hero scroll");
        this.setPermission("heroes.scroll");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            Messaging.send(sender, "Only players may use that command!", new Object[0]);
            return true;
        }
        Player player = (Player)sender;
        int slot = player.getInventory().first(Material.MAP);
        if (slot == -1) {
            Messaging.send((CommandSender)player, "You need a map to convert into a scroll!", new Object[0]);
            return true;
        }
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        ItemStack map = player.getInventory().getItem(slot);
        map.setDurability(MenuHandler.views.get(hero.getHeroClass()).getMapView().getId());
        return true;
    }
}

