/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillListInfo;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.Messaging;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SkillListCommand
extends BasicCommand {
    private static final int SKILLS_PER_PAGE = 8;
    private final Heroes plugin;

    public SkillListCommand(Heroes plugin) {
        super("List Skills");
        this.plugin = plugin;
        this.setDescription("Displays a list of your class skills");
        this.setUsage("/skills \u00a78<prim|prof|heroclass> [page#]");
        this.setArgumentRange(0, 2);
        this.setIdentifiers("skills", "hero skills");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        int level;
        Skill skill;
        String title;
        HeroClass hc;
        boolean sec;
        boolean prim;
        int page;
        HeroClass secondClass;
        HeroClass heroClass;
        Hero hero;
        block24: {
            if (!(sender instanceof Player)) {
                return false;
            }
            Player player = (Player)sender;
            hero = this.plugin.getCharacterManager().getHero(player);
            heroClass = hero.getHeroClass();
            secondClass = hero.getSecondClass();
            page = 0;
            prim = true;
            sec = true;
            hc = null;
            title = "";
            if (args.length != 0) {
                try {
                    page = Integer.parseInt(args[0]) - 1;
                    title = "Your Class(es)";
                }
                catch (NumberFormatException e) {
                    if (args[0].toLowerCase().contains("prim")) {
                        sec = false;
                        title = heroClass.getName();
                    } else if (args[0].toLowerCase().contains("pro")) {
                        prim = false;
                        if (secondClass == null) {
                            Messaging.send(sender, "You don't have a secondary class!", new Object[0]);
                            return true;
                        }
                        title = secondClass.getName();
                    } else {
                        hc = this.plugin.getClassManager().getClass(args[0]);
                        if (hc != null) {
                            prim = false;
                            sec = false;
                            title = hc.getName();
                        } else {
                            Messaging.send(sender, "That class does not exist!", new Object[0]);
                            return true;
                        }
                    }
                    if (args.length <= 1) break block24;
                    try {
                        page = Integer.parseInt(args[1]) - 1;
                    }
                    catch (NumberFormatException f) {
                        // empty catch block
                    }
                }
            }
        }
        HashMap<SkillListInfo, Integer> skills = new HashMap<SkillListInfo, Integer>();
        if (prim) {
            for (String name : heroClass.getSkillNames()) {
                skill = this.plugin.getSkillManager().getSkill(name);
                level = SkillConfigManager.getSetting(heroClass, skill, SkillSetting.LEVEL.node(), 1);
                skills.put(new SkillListInfo(heroClass, skill), level);
            }
        }
        if (sec && secondClass != null) {
            for (String name : secondClass.getSkillNames()) {
                skill = this.plugin.getSkillManager().getSkill(name);
                level = SkillConfigManager.getSetting(secondClass, skill, SkillSetting.LEVEL.node(), 1);
                skills.put(new SkillListInfo(secondClass, skill), level);
            }
        }
        if (hc != null) {
            for (String name : hc.getSkillNames()) {
                skill = this.plugin.getSkillManager().getSkill(name);
                level = SkillConfigManager.getSetting(hc, skill, SkillSetting.LEVEL.node(), 1);
                skills.put(new SkillListInfo(hc, skill), level);
            }
        }
        int numPages = skills.size() / 8;
        if (skills.size() % 8 != 0) {
            ++numPages;
        }
        if (page >= numPages || page < 0) {
            page = 0;
        }
        sender.sendMessage(ChatColor.RED + "-----[ " + ChatColor.WHITE + title + " Skills <" + (page + 1) + "/" + numPages + ">" + ChatColor.RED + " ]-----");
        int start = page * 8;
        int end = start + 8;
        if (end > skills.size()) {
            end = skills.size();
        }
        int count = 0;
        for (Map.Entry entry : SkillListInfo.entriesSortedByValues(skills)) {
            if (count >= start && count < end) {
                SkillListInfo sli = (SkillListInfo)entry.getKey();
                int level2 = (Integer)entry.getValue();
                ChatColor color = level2 > hero.getLevel(hc = sli.getHeroClass()) ? ChatColor.RED : ChatColor.GREEN;
                sender.sendMessage("  " + color + " " + hc.getName().substring(0, 3 > hc.getName().length() ? hc.getName().length() : 3) + " " + level2 + " " + ChatColor.YELLOW + sli.getSkill().getName() + ": " + ChatColor.GOLD + sli.getSkill().getDescription(hero));
            }
            ++count;
        }
        sender.sendMessage(ChatColor.RED + "To use a skill, type " + ChatColor.WHITE + "/skill <name>" + ChatColor.RED + ". For info use " + ChatColor.WHITE + "/skill <name> ?");
        return true;
    }
}

