/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.Messaging;
import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SuppressCommand
extends BasicCommand {
    private final Heroes plugin;

    public SuppressCommand(Heroes plugin) {
        super("Suppress");
        this.plugin = plugin;
        this.setDescription("Toggles the suppression of skill messages");
        this.setUsage("/hero stfu \u00a79<skill>");
        this.setArgumentRange(1, 1);
        this.setIdentifiers("hero stfu", "hero suppress");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        if (args.length == 0) {
            Set<String> suppressions = hero.getSuppressedSkills();
            if (suppressions.isEmpty()) {
                Messaging.send((CommandSender)player, "No skills suppressed.", new Object[0]);
                return false;
            }
            StringBuilder list = new StringBuilder("Suppressing ");
            for (String skill : suppressions) {
                list.append(skill).append(", ");
            }
            Messaging.send((CommandSender)player, list.substring(0, list.length() - 2), new Object[0]);
        } else {
            Skill skill = this.plugin.getSkillManager().getSkill(args[0]);
            if (skill == null) {
                Messaging.send((CommandSender)player, "Skill not found.", new Object[0]);
                return false;
            }
            if (hero.isSuppressing(skill)) {
                hero.setSuppressed(skill, false);
                Messaging.send((CommandSender)player, "Messages from $1 are no longer suppressed.", skill.getName());
            } else {
                hero.setSuppressed(skill, true);
                Messaging.send((CommandSender)player, "Messages from $1 are now suppressed.", skill.getName());
            }
        }
        return true;
    }
}

