/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.CharacterDamageManager;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.MaterialUtil;
import com.herocraftonline.heroes.util.Messaging;
import com.herocraftonline.heroes.util.Util;
import java.util.EnumSet;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

public class ToolsCommand
extends BasicCommand {
    private final Heroes plugin;

    public ToolsCommand(Heroes plugin) {
        super("Tools");
        this.plugin = plugin;
        this.setDescription("Displays tools available for your class");
        this.setUsage("/hero tools");
        this.setArgumentRange(0, 1);
        this.setIdentifiers("hero tools");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        int i;
        if (!(sender instanceof Player)) {
            return false;
        }
        EnumSet<Material> allTools = EnumSet.noneOf(Material.class);
        Player player = (Player)sender;
        if (args.length == 0) {
            Hero hero = this.plugin.getCharacterManager().getHero(player);
            allTools.addAll(hero.getHeroClass().getAllowedWeapons());
            if (hero.getSecondClass() != null) {
                allTools.addAll(hero.getSecondClass().getAllowedWeapons());
            }
            allTools.add(Material.AIR);
        } else {
            HeroClass heroClass = this.plugin.getClassManager().getClass(args[0]);
            if (heroClass == null) {
                Messaging.send(sender, "$1 is not a valid class.", args[0]);
                return false;
            }
            allTools.addAll(heroClass.getAllowedWeapons());
        }
        if (allTools.size() < 2) {
            sender.sendMessage("Your classes do not allow you to use any tools or weapons");
            return false;
        }
        String[] categories = new String[]{"Sword", "Spade", "Pickaxe", "Axe", "Hoe", "Other"};
        String[] categorizedTools = new String[categories.length];
        for (int i2 = 0; i2 < categories.length; ++i2) {
            categorizedTools[i2] = "";
        }
        block1: for (Material mat : allTools) {
            String tool = mat.name();
            for (int i3 = 0; i3 < categories.length; ++i3) {
                Double damage;
                if (tool.endsWith(categories[i3].toUpperCase())) {
                    if (categorizedTools[i3] == null) {
                        categorizedTools[i3] = "";
                    }
                    if ((damage = this.plugin.getDamageManager().getItemDamage(mat, (HumanEntity)player)) == null) {
                        damage = Util.getDefaultDamage(mat);
                    }
                    int n = i3;
                    categorizedTools[n] = categorizedTools[n] + MaterialUtil.getFriendlyName(tool).split(" ")[0] + "\u00a78 " + damage + "\u00a7f, ";
                    continue block1;
                }
                if (!categories[i3].toUpperCase().equals("OTHER") || !tool.equals("BOW") && !tool.equals("FISHING_ROD") && !tool.equals("FLINT_AND_STEEL") && !tool.equals("AIR")) continue;
                if (categorizedTools[i3] == null) {
                    categorizedTools[i3] = "";
                }
                if ((damage = tool.equals("BOW") ? this.plugin.getDamageManager().getProjectileDamage(CharacterDamageManager.ProjectileType.ARROW, (HumanEntity)player) : this.plugin.getDamageManager().getItemDamage(mat, (HumanEntity)player)) == null) {
                    damage = Util.getDefaultDamage(mat);
                }
                if (tool.equals("AIR")) {
                    int n = i3;
                    categorizedTools[n] = categorizedTools[n] + "Fist \u00a78 " + damage + "\u00a7f, ";
                    continue block1;
                }
                int n = i3;
                categorizedTools[n] = categorizedTools[n] + MaterialUtil.getFriendlyName(tool).split(" ")[0] + "\u00a78 " + damage + "\u00a7f, ";
                continue block1;
            }
        }
        for (i = 0; i < categories.length; ++i) {
            if (categorizedTools[i].isEmpty()) continue;
            categorizedTools[i] = categorizedTools[i].substring(0, categorizedTools[i].length() - 2);
        }
        sender.sendMessage("\u00a7c--------[ \u00a7fAllowed Tools\u00a7c ]--------");
        for (i = 0; i < categories.length; ++i) {
            player.sendMessage("  \u00a7a" + categories[i] + ": \u00a7f" + categorizedTools[i]);
        }
        return true;
    }
}

