/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.Messaging;
import com.herocraftonline.heroes.util.Properties;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WhoisCommand
extends BasicCommand {
    private final Heroes plugin;

    public WhoisCommand(Heroes plugin) {
        super("Whois");
        this.plugin = plugin;
        this.setDescription("Checks for anyone with the given name");
        this.setUsage("/hero whois \u00a79<player>");
        this.setArgumentRange(1, 1);
        this.setIdentifiers("hero whois");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        Player searchedPlayer = this.plugin.getServer().getPlayer(args[0]);
        if (searchedPlayer != null) {
            if (sender instanceof Player && !((Player)sender).canSee(searchedPlayer)) {
                Messaging.send(sender, "That player is not online!", new Object[0]);
                return false;
            }
        } else {
            Messaging.send(sender, "That player is not online!", new Object[0]);
            return false;
        }
        Hero hero = this.plugin.getCharacterManager().getHero(searchedPlayer);
        int level = Properties.getLevel(hero.getExperience(hero.getHeroClass()));
        HeroClass sClass = hero.getSecondClass();
        String secondClassName = sClass != null ? " | " + sClass.getName() : "";
        String secondLevelInfo = sClass != null ? " | " + hero.getLevel(sClass) : "";
        sender.sendMessage("\u00a7c-----[ \u00a7f" + searchedPlayer.getName() + "\u00a7c ]-----");
        sender.sendMessage("  \u00a7aClass : " + hero.getHeroClass().getName() + secondClassName);
        sender.sendMessage("  \u00a7aLevel : " + level + secondLevelInfo);
        return true;
    }
}

