/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.gui;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.skill.ActiveSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.logging.Level;
import me.desht.scrollingmenusign.SMSException;
import me.desht.scrollingmenusign.SMSHandler;
import me.desht.scrollingmenusign.SMSMenu;
import me.desht.scrollingmenusign.ScrollingMenuSign;
import me.desht.scrollingmenusign.enums.SMSMenuAction;
import me.desht.scrollingmenusign.views.SMSMapView;
import me.desht.scrollingmenusign.views.SMSView;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class MenuHandler {
    public static SMSHandler smsHandler;
    public static Map<HeroClass, SMSMenu> menus;
    public static Map<HeroClass, SMSMapView> views;

    public static void setup(Plugin p) {
        if (p != null && p instanceof ScrollingMenuSign) {
            ScrollingMenuSign sms = (ScrollingMenuSign)p;
            smsHandler = sms.getHandler();
            Heroes.useSMS = true;
            Heroes.log(Level.INFO, "ScrollingMenuSign integration is enabled");
        }
    }

    public static void setupMenu(HeroClass hc, Heroes plugin) {
        String name = hc.getName();
        SMSMenu menu = null;
        if (smsHandler == null) {
            return;
        }
        try {
            menu = smsHandler.getMenu(name + " menu");
        }
        catch (SMSException e) {
            menu = smsHandler.createMenu(name + " menu", name + " Skills", name);
        }
        if (menu == null) {
            menu = smsHandler.createMenu(name + " menu", name + " Skills", name);
        }
        menu.removeAllItems();
        menu.setAutosave(false);
        menu.setAutosort(false);
        menus.put(hc, menu);
        for (String sn : hc.getSkillNames()) {
            Skill skill = plugin.getSkillManager().getSkill(sn);
            if (!(skill instanceof ActiveSkill)) continue;
            if (skill.getIdentifiers().length == 0) {
                Heroes.log(Level.SEVERE, "Skill " + sn + " has no valid identifiers and can not be used on the menu!  Please contact the author to fix the skill.");
                continue;
            }
            menu.addItem(skill.getName(), "/" + skill.getIdentifiers()[0], "");
        }
        menu.setAutosave(true);
        menu.setAutosort(true);
        SMSMapView view = null;
        try {
            view = (SMSMapView)SMSView.getView((String)(name + " view"));
        }
        catch (SMSException e) {
            short id = Bukkit.getServer().createMap((World)Bukkit.getWorlds().get(0)).getId();
            view = new SMSMapView(name + " view", menu);
            view.register();
            view.setMapId(id);
            view.update((Observable)menu, (Object)SMSMenuAction.REPAINT);
        }
        views.put(hc, view);
        view.setAutosave(true);
    }

    static {
        menus = new HashMap<HeroClass, SMSMenu>();
        views = new HashMap<HeroClass, SMSMapView>();
    }
}

