/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.listeners;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.HeroAttackDamageCause;
import com.herocraftonline.heroes.api.HeroDamageCause;
import com.herocraftonline.heroes.api.HeroSkillDamageCause;
import com.herocraftonline.heroes.api.SkillUseInfo;
import com.herocraftonline.heroes.api.events.CharacterDamageEvent;
import com.herocraftonline.heroes.api.events.SkillDamageEvent;
import com.herocraftonline.heroes.api.events.WeaponDamageEvent;
import com.herocraftonline.heroes.characters.CharacterDamageManager;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.party.HeroParty;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillType;
import com.herocraftonline.heroes.nms.NMSHandler;
import com.herocraftonline.heroes.util.Messaging;
import com.herocraftonline.heroes.util.Properties;
import com.herocraftonline.heroes.util.Util;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EnderDragonPart;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;

public class HDamageListener
implements Listener {
    private final Heroes plugin;
    private final CharacterDamageManager dm;

    public HDamageListener(Heroes plugin, CharacterDamageManager damageManager) {
        this.plugin = plugin;
        this.dm = damageManager;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onShootArrow(EntityShootBowEvent event) {
        if (event.getProjectile().getType() != EntityType.ARROW) {
            return;
        }
        Arrow arrow = (Arrow)event.getProjectile();
        double damage = 0.0;
        switch (event.getEntityType()) {
            case PLAYER: {
                damage = this.getPlayerProjectileDamage((Player)event.getEntity(), (Projectile)arrow, 0.0);
                damage += (double)this.getExtraBowDamage(event.getBow());
                break;
            }
            default: {
                return;
            }
        }
        if (damage > 0.0) {
            arrow.spigot().setDamage(damage);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerItemDamageEvent(PlayerItemDamageEvent event) {
        if (Util.isArmor(event.getItem().getType())) {
            event.setDamage(event.getDamage() / Properties.itemDamageReduce);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        if (event.getEntity().getType() != EntityType.ARROW) {
            return;
        }
        Arrow arrow = (Arrow)event.getEntity();
        ProjectileSource damageSource = event.getEntity().getShooter();
        double damage = 0.0;
        if (!(damageSource instanceof LivingEntity)) {
            Double environmentalProjectileDamage = this.plugin.getDamageManager().getEnvironmentalDamage(EntityDamageEvent.DamageCause.PROJECTILE);
            damage = environmentalProjectileDamage == null ? 1.0 : environmentalProjectileDamage;
        } else {
            LivingEntity shooter = (LivingEntity)damageSource;
            switch (shooter.getType()) {
                case PLAYER: {
                    return;
                }
                case SKELETON: 
                case ZOMBIE: 
                case PIG_ZOMBIE: {
                    damage = this.plugin.getCharacterManager().getMonster(shooter).getDamage();
                    break;
                }
            }
        }
        if (damage > 0.0) {
            arrow.spigot().setDamage(damage);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPotionSplash(PotionSplashEvent event) {
        if (event.getAffectedEntities().isEmpty() || !(event.getPotion().getShooter() instanceof Player)) {
            return;
        }
        boolean remove = false;
        for (PotionEffect effect : event.getPotion().getEffects()) {
            switch (effect.getType().getId()) {
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 14: 
                case 15: 
                case 16: 
                case 18: 
                case 19: {
                    remove = true;
                    break;
                }
            }
        }
        if (remove) {
            Hero hero = this.plugin.getCharacterManager().getHero((Player)event.getPotion().getShooter());
            for (LivingEntity le : event.getAffectedEntities()) {
                if (Skill.damageCheck(hero.getPlayer(), le)) continue;
                event.setIntensity(le, 0.0);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityRegainHealth(EntityRegainHealthEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        double amount = event.getAmount();
        Player player = (Player)event.getEntity();
        double maxHealth = player.getMaxHealth();
        switch (event.getRegainReason()) {
            case SATIATED: {
                double healPercent = Heroes.properties.foodHealPercent;
                amount = Math.ceil(maxHealth * healPercent);
                break;
            }
            case MAGIC: {
                double healPercent = amount / 6.0;
                amount = Math.ceil(healPercent * Heroes.properties.potHealthPerTier * maxHealth);
                break;
            }
            case CUSTOM: {
                double healPercent = amount / 20.0;
                amount = Math.ceil(maxHealth * healPercent);
                break;
            }
        }
        event.setAmount(amount);
    }

    private double onEntityDamageEntityAttackSkill(EntityDamageEvent event, Entity attacker, Entity defender, double damage) {
        if (event.getDamage() == 0.0) {
            return 0.0;
        }
        SkillUseInfo skillInfo = this.dm.removeSpellTarget(defender);
        if (event instanceof EntityDamageByEntityEvent) {
            if (this.resistanceCheck(defender, skillInfo.getSkill())) {
                skillInfo.getSkill().broadcast(defender.getLocation(), "$1 has resisted $2", Messaging.getLivingEntityName((LivingEntity)defender), skillInfo.getSkill().getName());
                event.setCancelled(true);
                return 0.0;
            }
            SkillDamageEvent spellDamageEvent = new SkillDamageEvent(damage, defender, skillInfo);
            this.plugin.getServer().getPluginManager().callEvent((Event)spellDamageEvent);
            if (spellDamageEvent.isCancelled()) {
                event.setCancelled(true);
                return 0.0;
            }
            damage = spellDamageEvent.getDamage();
            if (defender instanceof LivingEntity && attacker instanceof LivingEntity) {
                NMSHandler.getInterface().getPostArmorDamage((LivingEntity)defender, damage);
            }
            if (defender instanceof Player) {
                this.plugin.getCharacterManager().getHero((Player)defender).setLastDamageCause(new HeroSkillDamageCause(damage, event.getCause(), (Entity)skillInfo.getCharacter().getEntity(), skillInfo.getSkill()));
            }
        }
        return damage;
    }

    private double onEntityDamageCore(EntityDamageEvent event, Entity attacker, double damage) {
        if (event.getDamage() == 0.0) {
            return 0.0;
        }
        CharacterTemplate character = null;
        if (attacker.getType() == EntityType.PLAYER) {
            Hero hero;
            Player attackingPlayer = (Player)attacker;
            character = hero = this.plugin.getCharacterManager().getHero(attackingPlayer);
            if (!hero.canEquipItem(attackingPlayer.getInventory().getHeldItemSlot()) || hero.hasEffectType(EffectType.STUN)) {
                event.setCancelled(true);
                return 0.0;
            }
            damage = this.getPlayerDamage(attackingPlayer, damage, event.getEntity());
        } else if (attacker instanceof LivingEntity) {
            Monster monster = this.plugin.getCharacterManager().getMonster((LivingEntity)attacker);
            character = monster;
            damage = monster.getDamage();
        } else if (attacker instanceof Projectile) {
            Projectile projectile = (Projectile)attacker;
            if (projectile.getShooter() instanceof Player) {
                attacker = (Entity)projectile.getShooter();
                character = this.plugin.getCharacterManager().getHero((Player)attacker);
                if (projectile.getType() != EntityType.ARROW) {
                    damage = this.getPlayerProjectileDamage((Player)projectile.getShooter(), projectile, damage);
                    damage = (int)Math.ceil(damage / 3.0 * projectile.getVelocity().length());
                }
            } else if (projectile.getShooter() instanceof LivingEntity) {
                attacker = (Entity)projectile.getShooter();
                Monster monster = this.plugin.getCharacterManager().getMonster((LivingEntity)projectile.getShooter());
                character = monster;
                if (projectile.getType() != EntityType.ARROW) {
                    damage = monster.getDamage();
                }
            }
        }
        if (character != null) {
            WeaponDamageEvent weaponDamageEvent = new WeaponDamageEvent(damage, (EntityDamageByEntityEvent)event, character);
            this.plugin.getServer().getPluginManager().callEvent((Event)weaponDamageEvent);
            if (weaponDamageEvent.isCancelled()) {
                event.setCancelled(true);
                return 0.0;
            }
            damage = weaponDamageEvent.getDamage();
        }
        if (event.getEntity() instanceof Player) {
            Hero hero = this.plugin.getCharacterManager().getHero((Player)event.getEntity());
            hero.setLastDamageCause(new HeroAttackDamageCause(damage, event.getCause(), attacker));
        }
        return damage;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        Player player;
        Entity defender = event.getEntity();
        Entity attacker = null;
        HeroDamageCause lastDamage = null;
        double damage = event.getDamage();
        boolean skipEvent = false;
        if (event instanceof EntityDamageByEntityEvent) {
            attacker = ((EntityDamageByEntityEvent)event).getDamager();
        }
        if (defender instanceof LivingEntity) {
            CharacterTemplate character = this.plugin.getCharacterManager().getCharacter((LivingEntity)defender);
            if (defender.isDead() || ((LivingEntity)defender).getHealth() <= 0.0) {
                return;
            }
            if (defender instanceof Player) {
                player = (Player)defender;
                if (player.getGameMode() == GameMode.CREATIVE) {
                    return;
                }
                lastDamage = ((Hero)character).getLastDamageCause();
            }
        }
        if (this.dm.isSpellTarget(defender)) {
            switch (event.getCause()) {
                case ENTITY_ATTACK: {
                    skipEvent = true;
                    damage = this.onEntityDamageEntityAttackSkill(event, attacker, defender, damage);
                    break;
                }
                default: {
                    skipEvent = true;
                    damage = this.onSpellDamage(event, damage, defender);
                }
            }
            if (event.isCancelled()) {
                if (defender instanceof Player) {
                    this.plugin.getCharacterManager().getHero((Player)defender).setLastDamageCause(lastDamage);
                }
                return;
            }
        } else {
            EntityDamageEvent.DamageCause cause = event.getCause();
            switch (cause) {
                case SUICIDE: {
                    if (!(defender instanceof Player)) break;
                    skipEvent = true;
                    player = (Player)event.getEntity();
                    if (player.getLastDamageCause() != null && player.getLastDamageCause() instanceof EntityDamageByEntityEvent) {
                        Entity tempDamager = ((EntityDamageByEntityEvent)player.getLastDamageCause()).getDamager();
                        player.setLastDamageCause((EntityDamageEvent)new EntityDamageByEntityEvent(tempDamager, (Entity)player, EntityDamageEvent.DamageCause.ENTITY_ATTACK, 1000.0));
                        player.damage(1000.0, tempDamager);
                        event.setDamage(0.0);
                    } else {
                        event.setDamage(1000.0);
                    }
                    return;
                }
                case ENTITY_ATTACK: 
                case PROJECTILE: {
                    skipEvent = true;
                    damage = this.onEntityDamageCore(event, attacker, damage);
                    break;
                }
                case FALL: {
                    damage = this.onEntityFall(event.getDamage(), defender, event);
                    break;
                }
                case SUFFOCATION: {
                    damage = this.onEntitySuffocate(event.getDamage(), defender);
                    break;
                }
                case DROWNING: {
                    damage = this.onEntityDrown(event.getDamage(), defender, event);
                    break;
                }
                case STARVATION: {
                    damage = this.onEntityStarve(event.getDamage(), defender);
                    break;
                }
                case CONTACT: {
                    damage = this.onEntityContact(event.getDamage(), defender, event);
                    break;
                }
                case FIRE: 
                case LAVA: 
                case FIRE_TICK: {
                    damage = this.onEntityFlame(event.getDamage(), cause, defender, event);
                    break;
                }
                case POISON: {
                    damage = this.onEntityPoison(event.getDamage(), defender, event);
                    break;
                }
                case BLOCK_EXPLOSION: 
                case ENTITY_EXPLOSION: {
                    damage = this.onExplode(event.getDamage(), defender, event);
                    break;
                }
                case VOID: {
                    damage = this.onEntityVoid(event.getDamage(), defender);
                    break;
                }
            }
            if (event.isCancelled()) {
                if (defender instanceof Player) {
                    this.plugin.getCharacterManager().getHero((Player)defender).setLastDamageCause(lastDamage);
                }
                return;
            }
        }
        if (defender instanceof Player) {
            Player player2 = (Player)defender;
            if (player2.getNoDamageTicks() > 10 && damage > 0.0 || player2.isDead() || player2.getHealth() <= 0.0) {
                event.setCancelled(true);
                return;
            }
            Hero hero = this.plugin.getCharacterManager().getHero(player2);
            hero.checkInventory();
            if (hero.hasEffectType(EffectType.INVULNERABILITY)) {
                event.setCancelled(true);
                return;
            }
            if (attacker instanceof Projectile) {
                attacker = (Entity)((Projectile)attacker).getShooter();
            }
            if (!defender.equals(attacker) && damage > 0.0) {
                for (Effect effect : hero.getEffects()) {
                    if (!effect.isType(EffectType.ROOT) && !effect.isType(EffectType.INVIS) || effect.isType(EffectType.UNBREAKABLE)) continue;
                    hero.removeEffect(effect);
                }
            }
            if (attacker instanceof Player) {
                int heroLevel;
                int aLevel = this.plugin.getCharacterManager().getHero((Player)attacker).getTieredLevel(false);
                if (Math.abs(aLevel - (heroLevel = hero.getTieredLevel(false))) > Heroes.properties.pvpLevelRange) {
                    Messaging.send((CommandSender)((Player)attacker), "That player is outside of your level range!", new Object[0]);
                    event.setCancelled(true);
                    return;
                }
                if (heroLevel < Heroes.properties.minPvpLevel || aLevel < Heroes.properties.minPvpLevel) {
                    event.setCancelled(true);
                    Messaging.send((CommandSender)((Player)attacker), "You or your target is not a high enough level to PvP!", new Object[0]);
                    return;
                }
                HeroParty party = hero.getParty();
                if (party != null && party.isNoPvp().booleanValue() && party.isPartyMember((Player)attacker)) {
                    event.setCancelled(true);
                    return;
                }
            }
            if (!skipEvent) {
                CharacterDamageEvent cde = new CharacterDamageEvent(defender, event.getCause(), damage);
                Bukkit.getPluginManager().callEvent((Event)cde);
                if (cde.isCancelled()) {
                    event.setCancelled(true);
                    hero.setLastDamageCause(lastDamage);
                    return;
                }
                damage = cde.getDamage();
            }
            if (damage == 0.0) {
                event.setDamage(0.0);
                return;
            }
            event.setDamage(damage);
        } else if (defender instanceof EnderDragonPart || defender instanceof EnderDragon) {
            EnderDragon ed = null;
            ed = defender instanceof EnderDragon ? (EnderDragon)defender : ((EnderDragonPart)defender).getParent();
            if (ed.getNoDamageTicks() > 10 && damage > 0.0 || ed.isDead() || ed.getHealth() <= 0.0) {
                event.setCancelled(true);
                return;
            }
            event.setDamage(damage);
        } else if (defender instanceof LivingEntity) {
            if (((LivingEntity)defender).getNoDamageTicks() > 10 && damage > 0.0 || defender.isDead() || ((LivingEntity)defender).getHealth() <= 0.0) {
                event.setCancelled(true);
                return;
            }
            event.setDamage(damage);
        }
    }

    private double onExplode(double damage, Entity defender, EntityDamageEvent event) {
        if (!(defender instanceof LivingEntity)) {
            return damage;
        }
        EntityDamageEvent.DamageCause cause = event.getCause();
        Double percent = this.dm.getEnvironmentalDamage(EntityDamageEvent.DamageCause.BLOCK_EXPLOSION);
        LivingEntity living = (LivingEntity)defender;
        if (event instanceof EntityDamageByBlockEvent) {
            EntityDamageByBlockEvent edbe = (EntityDamageByBlockEvent)event;
            if (percent == null) {
                if (defender instanceof Player) {
                    Hero hero = this.plugin.getCharacterManager().getHero((Player)defender);
                    hero.setLastDamageCause(new HeroDamageCause(damage, cause));
                }
                return damage;
            }
            CharacterTemplate character = this.plugin.getCharacterManager().getCharacter((LivingEntity)defender);
            if (edbe.getDamager() != null) {
                percent = percent - 0.15 * (edbe.getDamager().getLocation().distance(defender.getLocation()) / 7.0);
            }
            percent = percent * living.getMaxHealth();
            if (character instanceof Hero) {
                ((Hero)character).setLastDamageCause(new HeroDamageCause(percent, cause));
            }
        } else if (event instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent edbe = (EntityDamageByEntityEvent)event;
            if (percent == null) {
                if (defender instanceof Player) {
                    Hero hero = this.plugin.getCharacterManager().getHero((Player)defender);
                    hero.setLastDamageCause(new HeroDamageCause(damage, cause));
                }
                return damage;
            }
            double amount = damage;
            CharacterTemplate character = this.plugin.getCharacterManager().getCharacter((LivingEntity)defender);
            amount = edbe.getDamager() instanceof Creeper ? this.plugin.getCharacterManager().getMonster((LivingEntity)edbe.getDamager()).getDamage() : living.getMaxHealth();
            percent = percent - 0.15 * (edbe.getDamager().getLocation().distance(defender.getLocation()) / 7.0);
            percent = percent * amount;
            if (character instanceof Hero) {
                ((Hero)character).setLastDamageCause(new HeroDamageCause(percent, cause));
            }
        }
        return percent < 1.0 ? 1.0 : (double)percent.intValue();
    }

    private double onSpellDamage(EntityDamageEvent event, double damage, Entity defender) {
        SkillUseInfo skillInfo = this.dm.removeSpellTarget(defender);
        if (event instanceof EntityDamageByEntityEvent) {
            if (this.resistanceCheck(defender, skillInfo.getSkill())) {
                skillInfo.getSkill().broadcast(defender.getLocation(), "$1 has resisted $2", Messaging.getLivingEntityName((LivingEntity)defender), skillInfo.getSkill().getName());
                event.setCancelled(true);
                return 0.0;
            }
            SkillDamageEvent spellDamageEvent = new SkillDamageEvent(damage, defender, skillInfo);
            this.plugin.getServer().getPluginManager().callEvent((Event)spellDamageEvent);
            if (spellDamageEvent.isCancelled()) {
                event.setCancelled(true);
                return 0.0;
            }
            damage = spellDamageEvent.getDamage();
            if (defender instanceof Player) {
                this.plugin.getCharacterManager().getHero((Player)defender).setLastDamageCause(new HeroSkillDamageCause(damage, event.getCause(), (Entity)skillInfo.getCharacter().getEntity(), skillInfo.getSkill()));
            }
        }
        return damage;
    }

    private double onEntityStarve(double defaultDamage, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return 0.0;
        }
        Double percent = this.dm.getEnvironmentalDamage(EntityDamageEvent.DamageCause.STARVATION);
        if (percent == null) {
            if (entity instanceof Player) {
                Hero hero = this.plugin.getCharacterManager().getHero((Player)entity);
                hero.setLastDamageCause(new HeroDamageCause(defaultDamage, EntityDamageEvent.DamageCause.STARVATION));
            }
            return defaultDamage;
        }
        CharacterTemplate character = this.plugin.getCharacterManager().getCharacter((LivingEntity)entity);
        percent = percent * ((LivingEntity)entity).getMaxHealth();
        if (character instanceof Hero) {
            ((Hero)character).setLastDamageCause(new HeroDamageCause(percent, EntityDamageEvent.DamageCause.STARVATION));
        }
        return percent < 1.0 ? 1.0 : percent;
    }

    private double onEntitySuffocate(double defaultDamage, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return 0.0;
        }
        Double percent = this.dm.getEnvironmentalDamage(EntityDamageEvent.DamageCause.SUFFOCATION);
        if (percent == null) {
            if (entity instanceof Player) {
                Hero hero = this.plugin.getCharacterManager().getHero((Player)entity);
                hero.setLastDamageCause(new HeroDamageCause(defaultDamage, EntityDamageEvent.DamageCause.SUFFOCATION));
            }
            return defaultDamage;
        }
        CharacterTemplate character = this.plugin.getCharacterManager().getCharacter((LivingEntity)entity);
        percent = percent * ((LivingEntity)entity).getMaxHealth();
        if (character instanceof Hero) {
            ((Hero)character).setLastDamageCause(new HeroDamageCause(percent, EntityDamageEvent.DamageCause.SUFFOCATION));
        }
        return percent < 1.0 ? 1.0 : percent;
    }

    private double onEntityVoid(double defaultDamage, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return 0.0;
        }
        Double percent = this.dm.getEnvironmentalDamage(EntityDamageEvent.DamageCause.VOID);
        if (percent == null) {
            if (entity instanceof Player) {
                Hero hero = this.plugin.getCharacterManager().getHero((Player)entity);
                hero.setLastDamageCause(new HeroDamageCause(defaultDamage, EntityDamageEvent.DamageCause.VOID));
            }
            return defaultDamage;
        }
        CharacterTemplate character = this.plugin.getCharacterManager().getCharacter((LivingEntity)entity);
        percent = percent * ((LivingEntity)entity).getMaxHealth();
        if (character instanceof Hero) {
            ((Hero)character).setLastDamageCause(new HeroDamageCause(percent, EntityDamageEvent.DamageCause.VOID));
        }
        return percent < 1.0 ? 1.0 : percent;
    }

    private double onEntityDrown(double defaultDamage, Entity entity, EntityDamageEvent event) {
        if (!(entity instanceof LivingEntity)) {
            return 0.0;
        }
        Double percent = this.dm.getEnvironmentalDamage(EntityDamageEvent.DamageCause.DROWNING);
        if (percent == null) {
            if (entity instanceof Player) {
                Hero hero = this.plugin.getCharacterManager().getHero((Player)entity);
                hero.setLastDamageCause(new HeroDamageCause(defaultDamage, EntityDamageEvent.DamageCause.DROWNING));
            }
            return defaultDamage;
        }
        CharacterTemplate character = this.plugin.getCharacterManager().getCharacter((LivingEntity)entity);
        if (character.hasEffectType(EffectType.WATER_BREATHING)) {
            event.setCancelled(true);
            return 0.0;
        }
        percent = percent * ((LivingEntity)entity).getMaxHealth();
        if (character instanceof Hero) {
            ((Hero)character).setLastDamageCause(new HeroDamageCause(percent, EntityDamageEvent.DamageCause.DROWNING));
        }
        return percent < 1.0 ? 1.0 : percent;
    }

    private double onEntityContact(double defaultDamage, Entity entity, EntityDamageEvent event) {
        if (!(entity instanceof LivingEntity)) {
            return defaultDamage;
        }
        Double damage = this.dm.getEnvironmentalDamage(EntityDamageEvent.DamageCause.CONTACT);
        if (damage == null) {
            if (entity instanceof Player) {
                Hero hero = this.plugin.getCharacterManager().getHero((Player)entity);
                hero.setLastDamageCause(new HeroDamageCause(defaultDamage, EntityDamageEvent.DamageCause.CONTACT));
            }
            return defaultDamage;
        }
        CharacterTemplate character = this.plugin.getCharacterManager().getCharacter((LivingEntity)entity);
        if (character instanceof Hero) {
            ((Hero)character).setLastDamageCause(new HeroDamageCause(damage, EntityDamageEvent.DamageCause.CONTACT));
        }
        return damage;
    }

    private double onEntityPoison(double defaultDamage, Entity entity, EntityDamageEvent event) {
        if (!(entity instanceof LivingEntity)) {
            return 0.0;
        }
        Double damage = this.dm.getEnvironmentalDamage(EntityDamageEvent.DamageCause.POISON);
        if (damage == null) {
            if (entity instanceof Player) {
                Hero hero = this.plugin.getCharacterManager().getHero((Player)entity);
                hero.setLastDamageCause(new HeroDamageCause(defaultDamage, EntityDamageEvent.DamageCause.POISON));
            }
            return defaultDamage;
        }
        CharacterTemplate character = this.plugin.getCharacterManager().getCharacter((LivingEntity)entity);
        if (character.hasEffectType(EffectType.RESIST_POISON)) {
            event.setCancelled(true);
            return 0.0;
        }
        if (character instanceof Hero) {
            ((Hero)character).setLastDamageCause(new HeroDamageCause(damage, EntityDamageEvent.DamageCause.POISON));
        }
        return damage.intValue();
    }

    private double onEntityFlame(double defaultDamage, EntityDamageEvent.DamageCause cause, Entity entity, EntityDamageEvent event) {
        Double damage = this.dm.getEnvironmentalDamage(cause);
        if (damage == null) {
            if (entity instanceof Player) {
                Hero hero = this.plugin.getCharacterManager().getHero((Player)entity);
                hero.setLastDamageCause(new HeroDamageCause(defaultDamage, cause));
            }
            return defaultDamage;
        }
        CharacterTemplate character = null;
        if (entity instanceof LivingEntity) {
            if (((LivingEntity)entity).hasPotionEffect(PotionEffectType.FIRE_RESISTANCE)) {
                event.setCancelled(true);
                return 0.0;
            }
            character = this.plugin.getCharacterManager().getCharacter((LivingEntity)entity);
        }
        if (damage == 0.0) {
            return 0.0;
        }
        if (character != null) {
            if (character.hasEffectType(EffectType.RESIST_FIRE)) {
                event.setCancelled(true);
                return 0.0;
            }
            if (cause != EntityDamageEvent.DamageCause.FIRE_TICK) {
                damage = damage * character.getEntity().getMaxHealth();
            }
            if (character instanceof Hero) {
                ((Hero)character).setLastDamageCause(new HeroDamageCause(damage, cause));
            }
        }
        return damage < 1.0 ? 1.0 : damage;
    }

    private double onEntityFall(double damage, Entity entity, EntityDamageEvent event) {
        if (!(entity instanceof LivingEntity)) {
            return 0.0;
        }
        Double damagePercent = this.dm.getEnvironmentalDamage(EntityDamageEvent.DamageCause.FALL);
        if (damagePercent == null) {
            return damage;
        }
        if (entity instanceof HumanEntity) {
            damage -= (double)Util.getFeatherFallLevel(((HumanEntity)entity).getInventory());
        }
        if (damage <= 0.0) {
            event.setCancelled(true);
            return 0.0;
        }
        CharacterTemplate character = this.plugin.getCharacterManager().getCharacter((LivingEntity)entity);
        if (character.hasEffectType(EffectType.SAFEFALL)) {
            event.setCancelled(true);
            return 0.0;
        }
        return (damage = damage * damagePercent * ((LivingEntity)entity).getMaxHealth()) < 1.0 ? 1.0 : damage;
    }

    private double getPlayerDamage(Player attacker, double damage, Entity defender) {
        ItemStack weapon = attacker.getItemInHand();
        Material weaponType = weapon.getType();
        Double tmpDamage = this.dm.getItemDamage(weaponType, (HumanEntity)attacker);
        if (tmpDamage != null && defender instanceof LivingEntity) {
            tmpDamage = tmpDamage + this.getExtraDamage(weapon, (LivingEntity)defender);
        }
        return tmpDamage == null ? damage : tmpDamage;
    }

    private double getPlayerProjectileDamage(Player attacker, Projectile projectile, double damage) {
        Double tmpDamage = this.dm.getProjectileDamage(CharacterDamageManager.ProjectileType.valueOf((Entity)projectile), (HumanEntity)attacker);
        return tmpDamage == null ? damage : tmpDamage;
    }

    private boolean resistanceCheck(Entity defender, Skill skill) {
        if (defender instanceof LivingEntity) {
            CharacterTemplate character = this.plugin.getCharacterManager().getCharacter((LivingEntity)defender);
            if (character.hasEffectType(EffectType.RESIST_FIRE) && skill.isType(SkillType.FIRE)) {
                return true;
            }
            if (character.hasEffectType(EffectType.RESIST_DARK) && skill.isType(SkillType.DARK)) {
                return true;
            }
            if (character.hasEffectType(EffectType.RESIST_LIGHT) && skill.isType(SkillType.LIGHT)) {
                return true;
            }
            if (character.hasEffectType(EffectType.RESIST_LIGHTNING) && skill.isType(SkillType.LIGHTNING)) {
                return true;
            }
            if (character.hasEffectType(EffectType.RESIST_ICE) && skill.isType(SkillType.ICE)) {
                return true;
            }
        }
        return false;
    }

    private double getExtraDamage(ItemStack item, LivingEntity target) {
        if (!Util.isWeapon(item.getType())) {
            return 0.0;
        }
        int amount = 0;
        for (Map.Entry entry : item.getEnchantments().entrySet()) {
            Double val = this.dm.getEnchantmentDamage((Enchantment)entry.getKey());
            if (val == null) continue;
            boolean extraDamage = false;
            String id = ((Enchantment)entry.getKey()).getName();
            switch (target.getType()) {
                case CAVE_SPIDER: 
                case SPIDER: 
                case SILVERFISH: {
                    extraDamage = id.equals(Enchantment.DAMAGE_ARTHROPODS.getName()) || id.equals(Enchantment.DAMAGE_ALL.getName());
                    break;
                }
                case SKELETON: 
                case ZOMBIE: 
                case PIG_ZOMBIE: 
                case WITHER: {
                    extraDamage = id.equals(Enchantment.DAMAGE_UNDEAD.getName()) || id.equals(Enchantment.DAMAGE_ALL.getName());
                    break;
                }
                default: {
                    boolean bl = extraDamage = id.equals(Enchantment.DAMAGE_ALL.getName()) || id.equals(Enchantment.FIRE_ASPECT.getName()) && !target.hasPotionEffect(PotionEffectType.FIRE_RESISTANCE);
                }
            }
            if (!extraDamage) continue;
            amount = (int)((double)amount + this.dm.getEnchantmentDamage((Enchantment)entry.getKey()) * (double)((Integer)entry.getValue()).intValue());
        }
        return amount;
    }

    private int getExtraBowDamage(ItemStack item) {
        if (item.getType() != Material.BOW) {
            return 0;
        }
        int amount = 0;
        for (Map.Entry entry : item.getEnchantments().entrySet()) {
            Double val = this.dm.getEnchantmentDamage((Enchantment)entry.getKey());
            if (val == null || !((Enchantment)entry.getKey()).getName().equals(Enchantment.ARROW_DAMAGE.getName())) continue;
            amount = (int)((double)amount + this.dm.getEnchantmentDamage((Enchantment)entry.getKey()) * (double)((Integer)entry.getValue()).intValue());
        }
        return amount;
    }
}

