/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.listeners;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.HeroEnterCombatEvent;
import com.herocraftonline.heroes.api.events.HeroKillCharacterEvent;
import com.herocraftonline.heroes.api.events.HeroRegainHealthEvent;
import com.herocraftonline.heroes.characters.CharacterManager;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.Monster;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.effects.CombatEffect;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.common.CombustEffect;
import com.herocraftonline.heroes.characters.effects.common.QuickenEffect;
import com.herocraftonline.heroes.characters.effects.common.SummonEffect;
import com.herocraftonline.heroes.characters.party.HeroParty;
import com.herocraftonline.heroes.util.Properties;
import com.herocraftonline.heroes.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Tameable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class HEntityListener
implements Listener {
    private final Heroes plugin;

    public HEntityListener(Heroes plugin) {
        this.plugin = plugin;
    }

    private Player getAttacker(EntityDamageEvent event) {
        CharacterTemplate character;
        if (event == null) {
            return null;
        }
        if (event instanceof EntityDamageByEntityEvent) {
            Entity damager = ((EntityDamageByEntityEvent)event).getDamager();
            if (damager instanceof Player) {
                return (Player)damager;
            }
            if (damager instanceof Projectile) {
                CharacterTemplate character2;
                Projectile projectile = (Projectile)damager;
                if (projectile.getShooter() instanceof Player) {
                    return (Player)projectile.getShooter();
                }
                if (projectile.getShooter() instanceof Skeleton && (character2 = this.plugin.getCharacterManager().getCharacter((LivingEntity)projectile.getShooter())).hasEffect("Summon")) {
                    SummonEffect sEffect = (SummonEffect)character2.getEffect("Summon");
                    return sEffect.getSummoner().getPlayer();
                }
            } else if (damager instanceof LivingEntity) {
                Tameable tamed;
                if (damager instanceof Tameable && (tamed = (Tameable)damager).isTamed() && tamed.getOwner() instanceof Player) {
                    return (Player)tamed.getOwner();
                }
                CharacterTemplate character3 = this.plugin.getCharacterManager().getCharacter((LivingEntity)damager);
                if (character3.hasEffect("Summon")) {
                    SummonEffect sEffect = (SummonEffect)character3.getEffect("Summon");
                    return sEffect.getSummoner().getPlayer();
                }
            }
        } else if (event.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK && event.getEntity() instanceof LivingEntity && (character = this.plugin.getCharacterManager().getCharacter((LivingEntity)event.getEntity())).hasEffect("Combust")) {
            return ((CombustEffect)character.getEffect("Combust")).getApplier();
        }
        return null;
    }

    private void awardKillExp(Hero attacker, LivingEntity defender) {
        Properties prop = Heroes.properties;
        double addedExp = 0.0;
        HeroClass.ExperienceType experienceType = null;
        if (attacker.isOwnedSummon(defender) || attacker.getPlayer().equals(defender)) {
            return;
        }
        if (defender instanceof Player) {
            Util.deaths.put(((Player)defender).getName(), defender.getLocation());
            addedExp = prop.playerKillingExp;
            int aLevel = attacker.getTieredLevel(false);
            int dLevel = this.plugin.getCharacterManager().getHero((Player)defender).getTieredLevel(false);
            addedExp *= this.findExpAdjustment(aLevel, dLevel);
            experienceType = HeroClass.ExperienceType.PVP;
        } else if (defender instanceof LivingEntity && !(defender instanceof Player)) {
            Monster monster = this.plugin.getCharacterManager().getMonster(defender);
            addedExp = monster.getExperience();
            if (addedExp == -1.0 && !prop.creatureKillingExp.containsKey(defender.getType())) {
                return;
            }
            if (addedExp == -1.0) {
                addedExp = prop.creatureKillingExp.get(defender.getType());
            }
            experienceType = HeroClass.ExperienceType.KILLING;
            if (prop.noSpawnCamp && monster.getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER) {
                addedExp *= prop.spawnCampExpMult;
            }
        }
        if (experienceType != null && addedExp > 0.0) {
            if (attacker.hasParty()) {
                attacker.getParty().gainExp(addedExp, experienceType, defender.getLocation());
            } else if (attacker.canGain(experienceType)) {
                attacker.gainExp(addedExp, experienceType, defender.getLocation());
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity defender = event.getEntity();
        Player attacker = this.getAttacker(defender.getLastDamageCause());
        CharacterManager characterManager = this.plugin.getCharacterManager();
        CharacterTemplate character = characterManager.getCharacter(defender);
        event.setDroppedExp(0);
        if (attacker != null) {
            HeroKillCharacterEvent hkc = new HeroKillCharacterEvent(character, characterManager.getHero(attacker));
            Bukkit.getPluginManager().callEvent((Event)hkc);
        }
        if (attacker != null && !attacker.equals(defender) && defender instanceof LivingEntity) {
            Hero hero = characterManager.getHero(attacker);
            this.awardKillExp(hero, defender);
        }
        if (defender instanceof Player) {
            Player player = (Player)defender;
            Hero heroDefender = (Hero)character;
            Util.deaths.put(player.getName(), event.getEntity().getLocation());
            heroDefender.cancelDelayedSkill();
            double multiplier = Heroes.properties.expLoss;
            if (attacker != null) {
                multiplier = Heroes.properties.pvpExpLossMultiplier;
            }
            if (heroDefender.isInCombat()) {
                if (defender.getLastDamageCause() != null && defender.getLastDamageCause().getCause() != EntityDamageEvent.DamageCause.SUICIDE) {
                    heroDefender.leaveCombat(CombatEffect.LeaveCombatReason.DEATH);
                } else {
                    heroDefender.leaveCombat(CombatEffect.LeaveCombatReason.SUICIDE);
                }
            }
            heroDefender.loseExpFromDeath(multiplier, attacker != null);
            for (Effect effect : heroDefender.getEffects()) {
                if (effect.isPersistent()) continue;
                heroDefender.removeEffect(effect);
            }
        } else {
            this.plugin.getCharacterManager().removeMonster(character.getEntity());
        }
        character.clearEffects();
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityTarget(EntityTargetEvent event) {
        if (!(event.getTarget() instanceof Player)) {
            return;
        }
        Hero hero = this.plugin.getCharacterManager().getHero((Player)event.getTarget());
        if (hero.hasEffect("Invisible") || hero.hasEffect("Invuln")) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityRegainHealth(EntityRegainHealthEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        if (!hero.hasParty()) {
            return;
        }
        HeroParty party = hero.getParty();
        if (event.getAmount() > 0.0) {
            party.update();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onHeroRegainHealth(HeroRegainHealthEvent event) {
        if (event.getSkill() == null) {
            return;
        }
        if (event.getHero().equals(event.getHealer())) {
            event.setAmount(Heroes.properties.selfHeal * event.getAmount());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        CombatEffect.CombatReason reason;
        Hero hero;
        if (event.getDamage() == 0.0 || event.getEntity().isDead() || !(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity defender = (LivingEntity)event.getEntity();
        Player attacker = this.getAttacker(event);
        if (attacker == null) {
            return;
        }
        if (attacker instanceof Player) {
            hero = this.plugin.getCharacterManager().getHero(attacker);
            if (hero.isInCombatWith(defender)) {
                hero.refreshCombat();
            } else {
                reason = defender instanceof Player ? CombatEffect.CombatReason.ATTACKED_PLAYER : CombatEffect.CombatReason.ATTACKED_MOB;
                this.plugin.getServer().getPluginManager().callEvent((Event)new HeroEnterCombatEvent(hero, defender, reason));
                hero.enterCombatWith(defender, reason);
            }
        }
        if (defender instanceof Player) {
            hero = this.plugin.getCharacterManager().getHero((Player)defender);
            if (hero.isInCombatWith((LivingEntity)attacker)) {
                hero.refreshCombat();
            } else {
                reason = attacker instanceof Player ? CombatEffect.CombatReason.DAMAGED_BY_PLAYER : CombatEffect.CombatReason.DAMAGED_BY_MOB;
                this.plugin.getServer().getPluginManager().callEvent((Event)new HeroEnterCombatEvent(hero, (LivingEntity)attacker, reason));
                hero.enterCombatWith((LivingEntity)attacker, reason);
            }
            for (Effect e : hero.getEffects()) {
                if (!(e instanceof QuickenEffect)) continue;
                e.reapplyToHero(hero);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityDamageEarly(EntityDamageEvent event) {
        EntityDamageByEntityEvent edbe;
        Entity e2;
        if (event.getEntity() instanceof LivingEntity) {
            this.plugin.getCharacterManager().getCharacter((LivingEntity)event.getEntity());
        }
        if (event instanceof EntityDamageByEntityEvent && (e2 = (edbe = (EntityDamageByEntityEvent)event).getDamager()) instanceof LivingEntity) {
            this.plugin.getCharacterManager().getCharacter((LivingEntity)e2);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onCreatureSpawnEarly(CreatureSpawnEvent event) {
        Monster.applyHealthChanges(event.getEntity());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCreatureSpawnLate(CreatureSpawnEvent event) {
        LivingEntity lEntity = event.getEntity();
        lEntity.setMetadata("Heroes: Spawn Reason", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)event.getSpawnReason()));
    }

    private double findExpAdjustment(int aLevel, int dLevel) {
        int diff = aLevel - dLevel;
        if (Math.abs(diff) <= Heroes.properties.pvpExpRange) {
            return 1.0;
        }
        if (diff >= Heroes.properties.pvpMaxExpRange) {
            return 0.0;
        }
        if (diff <= -Heroes.properties.pvpMaxExpRange) {
            return 2.0;
        }
        if (diff > 0) {
            return 1.0 - (double)((diff - Heroes.properties.pvpExpRange) / Heroes.properties.pvpMaxExpRange);
        }
        if (diff < 0) {
            return 1.0 + (double)((Math.abs(diff) - Heroes.properties.pvpExpRange) / Heroes.properties.pvpMaxExpRange);
        }
        return 1.0;
    }
}

