/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.listeners;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.HeroChangeLevelEvent;
import com.herocraftonline.heroes.api.events.HeroRegainHealthEvent;
import com.herocraftonline.heroes.api.events.SkillUseEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.party.HeroParty;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import com.herocraftonline.heroes.characters.skill.SkillType;
import com.herocraftonline.heroes.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class HEventListener
implements Listener {
    private final Heroes plugin;

    public HEventListener(Heroes heroes) {
        this.plugin = heroes;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onHeroChangeLevel(HeroChangeLevelEvent event) {
        Hero hero = event.getHero();
        HeroClass heroClass = event.getHeroClass();
        int level = event.getTo();
        if (level > event.getFrom()) {
            for (Skill skill : this.plugin.getSkillManager().getSkills()) {
                int levelRequired;
                if (!heroClass.hasSkill(skill.getName()) || !hero.canUseSkill(skill) || (levelRequired = SkillConfigManager.getUseSetting(hero, skill, SkillSetting.LEVEL, 1, true)) != level) continue;
                Messaging.send((CommandSender)event.getHero().getPlayer(), "\u00a77[\u00a7dLevel-Up\u00a77] You have learned $1.", skill.getName());
            }
        } else {
            for (Skill skill : this.plugin.getSkillManager().getSkills()) {
                int levelRequired;
                if (!heroClass.hasSkill(skill.getName()) || (levelRequired = SkillConfigManager.getUseSetting(hero, skill, SkillSetting.LEVEL, 1, true)) <= level || levelRequired > event.getFrom()) continue;
                Messaging.send((CommandSender)event.getHero().getPlayer(), "\u00a77[\u00a7dLevel-Up\u00a77] You have forgotton how to use $1", skill.getName());
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onHeroRegainHealth(HeroRegainHealthEvent event) {
        if (!event.getHero().hasParty()) {
            return;
        }
        HeroParty party = event.getHero().getParty();
        if (event.getAmount() > 0.0) {
            party.update();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onSkillUse(SkillUseEvent event) {
        Hero hero = event.getHero();
        if (hero.hasEffect("Root") && event.getSkill().isType(SkillType.MOVEMENT) && !event.getSkill().isType(SkillType.COUNTER)) {
            Messaging.send((CommandSender)hero.getPlayer(), "\u00a77[\u00a72Skill\u00a77] You can't use that skill while rooted!", new Object[0]);
            event.setCancelled(true);
        }
        if (hero.hasEffectType(EffectType.SILENCE) && event.getSkill().isType(SkillType.SILENCABLE)) {
            Messaging.send((CommandSender)hero.getPlayer(), "\u00a77[\u00a72Skill\u00a77] You can't use that skill while silenced!", new Object[0]);
            event.setCancelled(true);
        } else if ((hero.hasEffectType(EffectType.STUN) || hero.hasEffectType(EffectType.DISABLE)) && !event.getSkill().isType(SkillType.COUNTER)) {
            event.setCancelled(true);
        }
        if (!event.getSkill().isType(SkillType.STEALTHY)) {
            for (Effect effect : hero.getEffects()) {
                if (!effect.isType(EffectType.INVIS)) continue;
                hero.removeEffect(effect);
            }
        }
    }
}

