/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.listeners;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.util.Messaging;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class HInventoryListener
implements Listener {
    private final Heroes plugin;

    public HInventoryListener(Heroes heroes) {
        this.plugin = heroes;
    }

    private boolean hasItems(ItemStack stack) {
        return stack != null && stack.getAmount() > 0;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryClickEvent(InventoryClickEvent event) {
        if (event.getInventory() != null && event.getSlotType() == InventoryType.SlotType.RESULT) {
            switch (event.getInventory().getType()) {
                case CRAFTING: 
                case WORKBENCH: {
                    this.handleCrafting(event);
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    private void handleCrafting(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        ItemStack toCraft = event.getCurrentItem();
        ItemStack toStore = event.getCursor();
        if (player != null && this.hasItems(toCraft)) {
            Hero hero = this.plugin.getCharacterManager().getHero(player);
            if (!hero.canCraft(toCraft)) {
                Messaging.send((CommandSender)player, "You don't know how to craft $1", toCraft.getType().name().toLowerCase().replace("_", " "));
                Heroes.debugLog(Level.INFO, hero.getName() + " attempted to craft: " + toCraft.getTypeId() + " : " + toCraft.getDurability());
                event.setCancelled(true);
                player.updateInventory();
                return;
            }
            if (event.isShiftClick()) {
                this.schedulePostDetection(player, toCraft);
            } else if (this.isStackSumLegal(toCraft, toStore)) {
                this.handleCraftingExp(toCraft, player);
            }
        }
    }

    private boolean isStackSumLegal(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return true;
        }
        return a.getAmount() + b.getAmount() <= a.getType().getMaxStackSize();
    }

    private void schedulePostDetection(final Player player, final ItemStack compareItem) {
        final ItemStack[] preInv = player.getInventory().getContents();
        for (int i = 0; i < preInv.length; ++i) {
            preInv[i] = preInv[i] != null ? preInv[i].clone() : null;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                ItemStack[] postInv = player.getInventory().getContents();
                int craftedItems = 0;
                for (int i = 0; i < preInv.length; ++i) {
                    ItemStack pre = preInv[i];
                    ItemStack post = postInv[i];
                    if (!HInventoryListener.this.isSameItem(compareItem, post) || !HInventoryListener.this.isSameItem(compareItem, pre) && pre != null) continue;
                    craftedItems += post.getAmount() - (pre != null ? pre.getAmount() : 0);
                }
                if (craftedItems > 0) {
                    HInventoryListener.this.handleCraftingExp(compareItem.getType(), craftedItems, player);
                }
            }
        });
    }

    private boolean isSameItem(ItemStack a, ItemStack b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return a == null;
        }
        return a.getType() == b.getType() && this.j7ObjectsEquals(a.getData(), b.getData()) && this.j7ObjectsEquals(a.getEnchantments(), b.getEnchantments());
    }

    private boolean j7ObjectsEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    private boolean handleCraftingExp(ItemStack item, Player crafter) {
        return this.handleCraftingExp(item.getType(), item.getAmount(), crafter);
    }

    private boolean handleCraftingExp(Material type, int amount, Player crafter) {
        Hero hero = this.plugin.getCharacterManager().getHero(crafter);
        if (Heroes.properties.craftingExp.containsKey(type)) {
            if (hero.hasParty()) {
                hero.getParty().gainExp(Heroes.properties.craftingExp.get(type) * (double)amount, HeroClass.ExperienceType.CRAFTING, crafter.getLocation());
                return true;
            }
            hero.gainExp(Heroes.properties.craftingExp.get(type) * (double)amount, HeroClass.ExperienceType.CRAFTING, hero.getViewingLocation(1.0));
            return true;
        }
        return true;
    }
}

