/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.listeners;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.CharacterManager;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.effects.CombatEffect;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.effects.EffectType;
import com.herocraftonline.heroes.characters.effects.PeriodicEffect;
import com.herocraftonline.heroes.characters.effects.common.InvisibleEffect;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillType;
import com.herocraftonline.heroes.command.Command;
import com.herocraftonline.heroes.nms.NMSHandler;
import com.herocraftonline.heroes.util.Messaging;
import com.herocraftonline.heroes.util.Properties;
import com.herocraftonline.heroes.util.Util;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class HPlayerListener
implements Listener {
    public final Heroes plugin;

    public HPlayerListener(Heroes instance) {
        this.plugin = instance;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityTame(EntityTameEvent event) {
        if (!(event.getOwner() instanceof Player)) {
            return;
        }
        Hero hero = this.plugin.getCharacterManager().getHero((Player)event.getOwner());
        if (hero.hasParty()) {
            hero.getParty().gainExp(Heroes.properties.tameExp, HeroClass.ExperienceType.TAMING, event.getEntity().getLocation());
        } else if (hero.canGain(HeroClass.ExperienceType.TAMING)) {
            hero.gainExp(Heroes.properties.tameExp, HeroClass.ExperienceType.TAMING, event.getEntity().getLocation());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerExpChange(PlayerExpChangeEvent event) {
        int amount = event.getAmount();
        if (amount == 0) {
            return;
        }
        Hero hero = this.plugin.getCharacterManager().getHero(event.getPlayer());
        if (amount < 0) {
            hero.gainExp(event.getAmount(), HeroClass.ExperienceType.EXTERNAL, hero.getViewingLocation(1.0));
        }
        event.setAmount(0);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerFish(PlayerFishEvent event) {
        switch (event.getState()) {
            case CAUGHT_FISH: {
                Player player = event.getPlayer();
                Hero hero = this.plugin.getCharacterManager().getHero(player);
                if (hero.hasParty()) {
                    hero.getParty().gainExp(Heroes.properties.fishingExp, HeroClass.ExperienceType.FISHING, event.getPlayer().getLocation());
                    break;
                }
                if (!hero.canGain(HeroClass.ExperienceType.FISHING)) break;
                hero.gainExp(Heroes.properties.fishingExp, HeroClass.ExperienceType.FISHING, hero.getViewingLocation(1.0));
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onItemHeldChange(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        if (hero.hasEffectType(EffectType.DISARM)) {
            Util.disarmCheck(hero, this.plugin);
        }
        hero.checkInventory();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerBedEnter(PlayerBedEnterEvent event) {
        Properties props = Heroes.properties;
        if (!props.bedHeal) {
            return;
        }
        Hero hero = this.plugin.getCharacterManager().getHero(event.getPlayer());
        long period = props.healInterval * 1000;
        double tickHealPercent = (double)props.healPercent / 100.0;
        BedHealEffect bhEffect = new BedHealEffect(period, tickHealPercent);
        hero.addEffect(bhEffect);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerBedLeave(PlayerBedLeaveEvent event) {
        if (!Heroes.properties.bedHeal) {
            return;
        }
        Hero hero = this.plugin.getCharacterManager().getHero(event.getPlayer());
        if (hero.hasEffect("BedHeal")) {
            hero.removeEffect(hero.getEffect("BedHeal"));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        if (!hero.canEquipItem(player.getInventory().getHeldItemSlot())) {
            event.setCancelled(true);
            Util.syncInventory(player, this.plugin);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerShearEntity(PlayerShearEntityEvent event) {
        Player player = event.getPlayer();
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        if (!hero.canEquipItem(player.getInventory().getHeldItemSlot())) {
            event.setCancelled(true);
            Util.syncInventory(player, this.plugin);
            return;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerShearForExp(PlayerShearEntityEvent event) {
        Hero hero = this.plugin.getCharacterManager().getHero(event.getPlayer());
        if (hero.hasParty()) {
            hero.getParty().gainExp(Heroes.properties.shearExp, HeroClass.ExperienceType.SHEARING, event.getEntity().getLocation());
        } else if (hero.canGain(HeroClass.ExperienceType.SHEARING)) {
            hero.gainExp(Heroes.properties.shearExp, HeroClass.ExperienceType.SHEARING, event.getEntity().getLocation());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        if (!hero.canEquipItem(player.getInventory().getHeldItemSlot())) {
            event.setCancelled(true);
            Util.syncInventory(player, this.plugin);
            return;
        }
        if (!(event.useItemInHand() != Event.Result.DENY || event.getItem() != null && Util.isFood(event.getItem().getType()))) {
            return;
        }
        if (hero.hasEffectType(EffectType.DISARM)) {
            Util.disarmCheck(hero, this.plugin);
        } else if (hero.hasEffectType(EffectType.STUN)) {
            event.setCancelled(true);
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock != null && Util.interactableBlocks.contains(clickedBlock.getType())) {
            hero.cancelDelayedSkill();
        }
        boolean isStealthy = false;
        if (player.getItemInHand() != null && player.hasPermission("heroes.bind")) {
            Material material = player.getItemInHand().getType();
            if (hero.hasBind(material)) {
                if (!material.isBlock() && (event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) || material.isBlock() && (event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_BLOCK)) {
                    String[] args = hero.getBind(material);
                    this.plugin.getCommandHandler().dispatch((CommandSender)player, "skill", "skill", args);
                    try {
                        StringBuilder ident = new StringBuilder("skill");
                        for (String arg : args) {
                            ident.append(' ').append(arg);
                        }
                        Skill skill = this.plugin.getSkillManager().getSkillFromIdent(ident.toString(), (CommandSender)player);
                        if (skill == null && args.length > 1) {
                            skill = this.plugin.getSkillManager().getSkillFromIdent("skill " + args[0], (CommandSender)player);
                        }
                        isStealthy = skill.isType(SkillType.STEALTHY);
                    }
                    catch (Exception e) {
                        String val = "";
                        for (String arg : args) {
                            val = val + arg + " ";
                        }
                        Heroes.log(Level.SEVERE, player.getName() + " attempted to use bind for command: " + val + " but that command was not found!");
                    }
                } else {
                    hero.cancelDelayedSkill();
                }
            } else {
                hero.cancelDelayedSkill();
            }
        }
        if (!isStealthy) {
            for (Effect effect : hero.getEffects()) {
                if (!effect.isType(EffectType.INVIS)) continue;
                hero.removeEffect(effect);
            }
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        CharacterManager cm = this.plugin.getCharacterManager();
        final Hero hero = cm.getHero(player);
        double currentHP = player.getHealth();
        double maxHP = player.getMaxHealth();
        hero.resetMaxHP();
        double ratio = currentHP / maxHP;
        if (ratio > 1.0) {
            ratio = 1.0;
        }
        player.setHealth(ratio * player.getMaxHealth());
        if (!hero.hasEffect("Combat")) {
            hero.resetCombatEffect();
        }
        cm.checkClasses(hero);
        hero.syncExperience();
        hero.checkInventory();
        if (Heroes.properties.prefixClassName) {
            player.setDisplayName("[" + hero.getHeroClass().getName() + "]" + player.getName());
        }
        if (System.currentTimeMillis() < Heroes.properties.expiration) {
            Messaging.send((CommandSender)player, Heroes.properties.bonusMessage, new Object[0]);
        }
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                HPlayerListener.this.plugin.getCharacterManager().performSkillChecks(hero);
                hero.checkInventory();
            }
        }, 5L);
        if (!player.hasPermission("heroes.admin.seeinvis")) {
            for (String name : InvisibleEffect.hiddenPlayers) {
                player.hidePlayer(Bukkit.getPlayerExact((String)name));
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        final Hero hero = this.plugin.getCharacterManager().getHero(event.getPlayer());
        if (hero.hasEffectType(EffectType.DISARM) && Util.isWeapon(event.getItem().getItemStack().getType())) {
            event.setCancelled(true);
            return;
        }
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                hero.checkInventory();
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerKick(PlayerKickEvent event) {
        CharacterManager heroManager = this.plugin.getCharacterManager();
        Hero hero = heroManager.getHero(event.getPlayer());
        hero.recheckCombat();
        if (hero.isInCombat()) {
            hero.leaveCombat(CombatEffect.LeaveCombatReason.KICK);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        CharacterManager heroManager = this.plugin.getCharacterManager();
        Hero hero = heroManager.getHero(player);
        hero.cancelDelayedSkill();
        hero.clearEffects();
        hero.recheckCombat();
        if (hero.isInCombat()) {
            hero.leaveCombat(CombatEffect.LeaveCombatReason.LOGOUT);
        }
        heroManager.saveHero(hero, true);
        heroManager.removeHero(hero);
        for (Command command : this.plugin.getCommandHandler().getCommands()) {
            if (!command.isInteractive()) continue;
            command.cancelInteraction((CommandSender)player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        final Hero hero = this.plugin.getCharacterManager().getHero(player);
        hero.setMana(0);
        NMSHandler.getInterface().setPlayerExpZero(player);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                HPlayerListener.this.plugin.getCharacterManager().performSkillChecks(hero);
                hero.checkInventory();
                hero.syncExperience();
            }
        }, 20L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (event.getFrom().getWorld().equals(event.getTo().getWorld())) {
            return;
        }
        final Hero hero = this.plugin.getCharacterManager().getHero(event.getPlayer());
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                HPlayerListener.this.plugin.getCharacterManager().performSkillChecks(hero);
                hero.checkInventory();
            }
        }, 5L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerWorldChange(PlayerChangedWorldEvent event) {
        Hero hero = this.plugin.getCharacterManager().getHero(event.getPlayer());
        for (Effect effect : hero.getEffects()) {
            if (effect.isPersistent()) continue;
            hero.removeEffect(effect);
        }
    }

    public class BedHealEffect
    extends PeriodicEffect {
        private final double tickHealPercent;

        public BedHealEffect(long period, double tickHealPercent) {
            super((Skill)null, "BedHeal", period);
            this.tickHealPercent = tickHealPercent;
        }

        @Override
        public void applyToHero(Hero hero) {
            super.applyToHero(hero);
            this.lastTickTime = System.currentTimeMillis();
        }

        @Override
        public void tickHero(Hero hero) {
            super.tickHero(hero);
            Player player = hero.getPlayer();
            double healAmount = Math.ceil(player.getMaxHealth() * this.tickHealPercent);
            hero.heal(healAmount);
            if (hero.isVerbose()) {
                player.sendMessage(Messaging.createFullHealthBar(player.getHealth(), player.getMaxHealth()));
            }
        }
    }
}

