/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.nms;

import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;

public abstract class NMSHandler {
    private static NMSHandler activeInterface;
    private int versionNumber = -1;

    public static final NMSHandler getInterface() {
        if (activeInterface == null) {
            String packageName = Bukkit.getServer().getClass().getPackage().getName();
            String version = packageName.substring(packageName.lastIndexOf(46) + 1);
            if (version.equals("craftbukkit")) {
                version = "pre";
            }
            try {
                Class<?> clazz = Class.forName("com.herocraftonline.heroes.nms.versions.Handler_" + version);
                if (NMSHandler.class.isAssignableFrom(clazz)) {
                    activeInterface = (NMSHandler)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    activeInterface.setVersionNumber(Integer.valueOf(version.replaceAll("[^0-9]", "")));
                }
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("You are attempting to load Heroes on version " + version + " which is not supported!");
            }
            catch (Exception e) {
                throw new RuntimeException("Unknown exception loading version handler", e);
            }
        }
        return activeInterface;
    }

    public final void setVersionNumber(int version) {
        this.versionNumber = version;
    }

    public final int getVersionNumber() {
        return this.versionNumber;
    }

    public abstract double getPostArmorDamage(LivingEntity var1, double var2);

    public abstract void setPlayerExpZero(Player var1);

    public abstract boolean damageEntity(LivingEntity var1, LivingEntity var2, double var3, EntityDamageEvent.DamageCause var5, boolean var6);

    public abstract void knockBack(LivingEntity var1, LivingEntity var2, double var3);

    public abstract void refreshLastPlayerDamageTime(LivingEntity var1);

    public abstract void sendFakePotionEffectPacket(PotionEffect var1, Player var2);

    public abstract void sendFakePotionEffectPackets(Set<PotionEffect> var1, Player var2);

    public abstract void removeFakePotionEffectPacket(PotionEffect var1, Player var2);

    public abstract void removeFakePotionEffectPackets(Set<PotionEffect> var1, Player var2);

    public abstract void bukkit_setArrowDamage(Arrow var1, double var2);

    protected abstract float getSoundStrength(LivingEntity var1);

    protected static String getSoundName(EntityType type) {
        switch (type) {
            case BLAZE: {
                return "mob.blaze.death";
            }
            case CHICKEN: {
                return "mob.chickenhurt";
            }
            case CREEPER: {
                return "mob.creeperdeath";
            }
            case MAGMA_CUBE: 
            case SLIME: {
                return "mob.slime";
            }
            case SKELETON: {
                return "mob.skeletonhurt";
            }
            case IRON_GOLEM: {
                return "mob.irongolem.death";
            }
            case GHAST: {
                return "mob.ghast.death";
            }
            case PIG: {
                return "mob.pigdeath";
            }
            case OCELOT: {
                return "mob.cat.hitt";
            }
            case SHEEP: {
                return "mob.sheep";
            }
            case SPIDER: {
                return "mob.spiderdeath";
            }
            case WOLF: {
                return "mob.wolf.death";
            }
            case ZOMBIE: {
                return "mob.zombiedeath";
            }
        }
        return "damage.hurtflesh";
    }

    public abstract void playClientEffect(Player var1, Location var2, String var3, Vector var4, float var5, int var6, boolean var7);
}

