/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.nms.versions;

import com.herocraftonline.heroes.nms.NMSHandler;
import java.lang.reflect.Field;
import java.util.Random;
import java.util.Set;
import net.minecraft.server.v1_7_R2.DamageSource;
import net.minecraft.server.v1_7_R2.Entity;
import net.minecraft.server.v1_7_R2.EntityGolem;
import net.minecraft.server.v1_7_R2.EntityHuman;
import net.minecraft.server.v1_7_R2.EntityLiving;
import net.minecraft.server.v1_7_R2.EntityMonster;
import net.minecraft.server.v1_7_R2.EntityPlayer;
import net.minecraft.server.v1_7_R2.MobEffect;
import net.minecraft.server.v1_7_R2.Packet;
import net.minecraft.server.v1_7_R2.PacketPlayOutEntityEffect;
import net.minecraft.server.v1_7_R2.PacketPlayOutRemoveEntityEffect;
import net.minecraft.server.v1_7_R2.PacketPlayOutWorldParticles;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_7_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_7_R2.entity.CraftArrow;
import org.bukkit.craftbukkit.v1_7_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_7_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_7_R2.event.CraftEventFactory;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Giant;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.Spider;
import org.bukkit.entity.Wolf;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;

public class Handler_v1_7_R2
extends NMSHandler {
    private Field ldbpt;
    private Random random;

    public Handler_v1_7_R2() {
        try {
            this.ldbpt = EntityLiving.class.getDeclaredField("lastDamageByPlayerTime");
            this.ldbpt.setAccessible(true);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        this.random = new Random();
    }

    @Override
    public final double getPostArmorDamage(LivingEntity defender, double damage) {
        int i = 25 - ((CraftLivingEntity)defender).getHandle().aU();
        float f1 = (float)damage * (float)i;
        return f1 / 25.0f;
    }

    @Override
    public void bukkit_setArrowDamage(Arrow arrow, double damage) {
        ((CraftArrow)arrow).getHandle().b(damage);
    }

    @Override
    public void setPlayerExpZero(Player player) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        entityPlayer.exp = 0.0f;
        entityPlayer.expTotal = 0;
        entityPlayer.expLevel = 0;
    }

    @Override
    public void knockBack(LivingEntity target, LivingEntity attacker, double damage) {
        EntityLiving el = ((CraftLivingEntity)target).getHandle();
        EntityLiving aEL = ((CraftLivingEntity)attacker).getHandle();
        el.velocityChanged = true;
        double d0 = aEL.locX - el.locX;
        double d1 = aEL.locZ - el.locZ;
        while (d0 * d0 + d1 * d1 < 1.0E-4) {
            d0 = (Math.random() - Math.random()) * 0.01;
            d1 = (Math.random() - Math.random()) * 0.01;
        }
        el.az = (float)(Math.atan2(d1, d0) * 180.0 / 3.1415927410125732) - el.yaw;
        el.a((Entity)aEL, (float)damage, d0, d1);
    }

    @Override
    public void refreshLastPlayerDamageTime(LivingEntity entity) {
        try {
            this.ldbpt.set(((CraftLivingEntity)entity).getHandle(), 60);
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Override
    public boolean damageEntity(LivingEntity target, LivingEntity attacker, double damage, EntityDamageEvent.DamageCause cause, boolean knockback) {
        if (target.isDead() || target.getHealth() <= 0.0) {
            return false;
        }
        int originalNoDamageTicks = target.getNoDamageTicks();
        target.setNoDamageTicks(0);
        EntityDamageByEntityEvent edbe = new EntityDamageByEntityEvent((org.bukkit.entity.Entity)attacker, (org.bukkit.entity.Entity)target, cause, damage);
        Bukkit.getServer().getPluginManager().callEvent((Event)edbe);
        if (edbe.isCancelled()) {
            return false;
        }
        target.setLastDamageCause((EntityDamageEvent)edbe);
        double oldHealth = target.getHealth();
        double newHealth = oldHealth - edbe.getDamage();
        if (newHealth < 0.0) {
            newHealth = 0.0;
        }
        EntityLiving el = ((CraftLivingEntity)target).getHandle();
        el.lastDamage = (float)edbe.getDamage();
        el.aw = (float)oldHealth;
        el.ay = 10;
        el.hurtTicks = 10;
        el.az = 0.0f;
        if (knockback) {
            this.knockBack(target, attacker, edbe.getDamage());
        }
        el.world.broadcastEntityEffect((Entity)el, (byte)2);
        el.lastDamager = ((CraftLivingEntity)attacker).getHandle();
        if (attacker instanceof Player) {
            try {
                this.ldbpt.set(el, 60);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        el.setHealth((float)newHealth);
        if (newHealth <= 0.0) {
            el.world.makeSound((Entity)el, Handler_v1_7_R2.getSoundName(target.getType()), 1.0f, this.getSoundStrength(target));
            if (attacker instanceof Player) {
                EntityPlayer p = ((CraftPlayer)attacker).getHandle();
                el.killer = p;
                el.die(DamageSource.playerAttack((EntityHuman)p));
            } else {
                EntityLiving att = ((CraftLivingEntity)attacker).getHandle();
                el.die(DamageSource.mobAttack((EntityLiving)att));
            }
        } else {
            target.setNoDamageTicks(originalNoDamageTicks);
            EntityLiving attackEntity = ((CraftLivingEntity)attacker).getHandle();
            if (target instanceof Monster) {
                EntityMonster em;
                EntityTargetEvent event;
                if ((target instanceof Blaze || target instanceof Enderman || target instanceof Spider || target instanceof Giant || target instanceof Silverfish) && !(event = CraftEventFactory.callEntityTargetEvent((Entity)(em = (EntityMonster)el), (Entity)attackEntity, (EntityTargetEvent.TargetReason)EntityTargetEvent.TargetReason.TARGET_ATTACKED_ENTITY)).isCancelled()) {
                    em.setTarget((Entity)attackEntity);
                }
            } else if (target instanceof IronGolem) {
                EntityGolem eg = (EntityGolem)el;
                eg.setTarget((Entity)((CraftLivingEntity)attacker).getHandle());
            } else if (target instanceof Wolf && ((Wolf)target).getTarget() == null) {
                Wolf wolf = (Wolf)target;
                wolf.setAngry(true);
                wolf.setTarget(attacker);
            }
            if (target instanceof PigZombie) {
                ((PigZombie)target).setAngry(true);
            }
        }
        return true;
    }

    @Override
    protected float getSoundStrength(LivingEntity entity) {
        EntityLiving el = ((CraftLivingEntity)entity).getHandle();
        return el.isBaby() ? (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.5f : (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f;
    }

    @Override
    public void playClientEffect(Player player, Location startLocation, String particle, Vector offset, float speed, int count, boolean sendToAll) {
        if (!(player instanceof CraftPlayer)) {
            throw new IllegalArgumentException("The provided player is NOT a CraftPlayer!");
        }
        try {
            PacketPlayOutWorldParticles clientEffectPacket = new PacketPlayOutWorldParticles(particle, (float)startLocation.getX(), (float)(startLocation.getY() + 0.5), (float)startLocation.getZ(), (float)(offset.getX() + 0.5), (float)(offset.getY() + 0.3), (float)(offset.getZ() + 0.5), speed, count);
            if (sendToAll) {
                ((CraftWorld)startLocation.getWorld()).getHandle().getTracker().sendPacketToEntity((Entity)((CraftPlayer)player).getHandle(), (Packet)clientEffectPacket);
            } else {
                ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)clientEffectPacket);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void sendFakePotionEffectPacket(PotionEffect effect, Player player) {
        EntityPlayer ePlayer = ((CraftPlayer)player).getHandle();
        ePlayer.playerConnection.sendPacket((Packet)new PacketPlayOutEntityEffect(ePlayer.getId(), new MobEffect(effect.getType().getId(), effect.getDuration(), effect.getAmplifier())));
    }

    @Override
    public void sendFakePotionEffectPackets(Set<PotionEffect> effects, Player player) {
        EntityPlayer ePlayer = ((CraftPlayer)player).getHandle();
        for (PotionEffect effect : effects) {
            ePlayer.playerConnection.sendPacket((Packet)new PacketPlayOutEntityEffect(ePlayer.getId(), new MobEffect(effect.getType().getId(), effect.getDuration(), effect.getAmplifier())));
        }
    }

    @Override
    public void removeFakePotionEffectPacket(PotionEffect effect, Player player) {
        EntityPlayer ePlayer = ((CraftPlayer)player).getHandle();
        ePlayer.playerConnection.sendPacket((Packet)new PacketPlayOutRemoveEntityEffect(ePlayer.getId(), new MobEffect(effect.getType().getId(), effect.getDuration(), effect.getAmplifier())));
    }

    @Override
    public void removeFakePotionEffectPackets(Set<PotionEffect> effects, Player player) {
        EntityPlayer ePlayer = ((CraftPlayer)player).getHandle();
        for (PotionEffect effect : effects) {
            ePlayer.playerConnection.sendPacket((Packet)new PacketPlayOutRemoveEntityEffect(ePlayer.getId(), new MobEffect(effect.getType().getId(), effect.getDuration(), effect.getAmplifier())));
        }
    }
}

