/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.storage.managers;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.nms.NMSHandler;
import com.herocraftonline.heroes.storage.Storage;
import com.herocraftonline.heroes.util.Properties;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.FileUtil;

public class YMLStorage
extends Storage {
    private final File playerFolder;
    private final Map<String, Hero> toSave = new ConcurrentHashMap<String, Hero>();
    private final int SAVE_INTERVAL = 6000;
    private final BukkitTask id;
    private final boolean preUUID;

    public YMLStorage(Heroes plugin) {
        super(plugin, "YMLStorage");
        this.playerFolder = new File(plugin.getDataFolder(), "players");
        this.playerFolder.mkdirs();
        this.id = Bukkit.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)plugin, (Runnable)new HeroSaveThread(), 6000L, 6000L);
        this.preUUID = NMSHandler.getInterface().getVersionNumber() < 173;
    }

    @Override
    public Hero loadHero(Player player) {
        Hero hero = this.preUUID ? this.loadHeroLegacy(player) : this.loadHeroUUID(player);
        if (hero == null) {
            Heroes.log(Level.INFO, "Created hero: " + player.getName());
            return this.createNewHero(player);
        }
        return hero;
    }

    public Hero loadHeroUUID(Player player) {
        UUID id = player.getUniqueId();
        if (this.toSave.containsKey(player.getName())) {
            Hero hero = this.toSave.get(player.getName());
            hero.setPlayer(player);
            return hero;
        }
        File playerFile = new File(this.playerFolder, id.toString() + ".yml");
        if (playerFile.exists()) {
            YamlConfiguration playerConfig = YamlConfiguration.loadConfiguration((File)playerFile);
            HeroClass playerClass = this.loadClass(player, (Configuration)playerConfig);
            if (playerClass == null) {
                Heroes.log(Level.INFO, "Invalid class found for " + player.getName() + ". Resetting player.");
                return this.createNewHero(player);
            }
            HeroClass secondClass = this.loadSecondaryClass(player, (Configuration)playerConfig);
            Hero playerHero = new Hero(this.plugin, player, playerClass, secondClass);
            this.loadCooldowns(playerHero, playerConfig.getConfigurationSection("cooldowns"));
            this.loadExperience(playerHero, playerConfig.getConfigurationSection("experience"));
            this.loadMasteries(playerHero, playerConfig.getConfigurationSection("masteries"));
            this.loadBinds(playerHero, playerConfig.getConfigurationSection("binds"));
            this.loadSkillSettings(playerHero, playerConfig.getConfigurationSection("skill-settings"));
            playerHero.setMana(playerConfig.getInt("mana", 0));
            playerHero.setVerbose(playerConfig.getBoolean("verbose", true));
            playerHero.setSuppressedSkills(playerConfig.getStringList("suppressed"));
            return playerHero;
        }
        Hero hero = this.loadHeroLegacy(player);
        if (hero != null) {
            this.migrateLegacyFile(player);
            this.saveHero(hero, true);
        }
        return hero;
    }

    private void migrateLegacyFile(Player player) {
        File pFolder = new File(this.playerFolder, player.getName().toLowerCase().substring(0, 1));
        File playerFile = new File(pFolder, player.getName() + ".yml");
        File migFolder = new File(this.playerFolder, "migrated");
        migFolder.mkdir();
        File migPlayerFolder = new File(migFolder, player.getName().toLowerCase().substring(0, 1));
        migPlayerFolder.mkdir();
        File migFile = new File(migPlayerFolder, player.getName() + ".yml");
        try {
            migFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FileUtil.copy((File)playerFile, (File)migFile);
        playerFile.delete();
        Heroes.log(Level.INFO, "Migrated hero with name " + player.getName() + " to UUID " + player.getUniqueId());
    }

    private Hero loadHeroLegacy(Player player) {
        if (this.toSave.containsKey(player.getName())) {
            Hero hero = this.toSave.get(player.getName());
            hero.setPlayer(player);
            return hero;
        }
        File pFolder = new File(this.playerFolder, player.getName().toLowerCase().substring(0, 1));
        pFolder.mkdirs();
        File playerFile = new File(pFolder, player.getName() + ".yml");
        if (playerFile.exists()) {
            YamlConfiguration playerConfig = YamlConfiguration.loadConfiguration((File)playerFile);
            HeroClass playerClass = this.loadClass(player, (Configuration)playerConfig);
            if (playerClass == null) {
                Heroes.log(Level.INFO, "Invalid class found for " + player.getName() + ". Resetting player.");
                return this.createNewHero(player);
            }
            HeroClass secondClass = this.loadSecondaryClass(player, (Configuration)playerConfig);
            Hero playerHero = new Hero(this.plugin, player, playerClass, secondClass);
            this.loadCooldowns(playerHero, playerConfig.getConfigurationSection("cooldowns"));
            this.loadExperience(playerHero, playerConfig.getConfigurationSection("experience"));
            this.loadMasteries(playerHero, playerConfig.getConfigurationSection("masteries"));
            this.loadBinds(playerHero, playerConfig.getConfigurationSection("binds"));
            this.loadSkillSettings(playerHero, playerConfig.getConfigurationSection("skill-settings"));
            playerHero.setMana(playerConfig.getInt("mana", 0));
            playerHero.setVerbose(playerConfig.getBoolean("verbose", true));
            playerHero.setSuppressedSkills(playerConfig.getStringList("suppressed"));
            return playerHero;
        }
        return null;
    }

    @Override
    public void saveHero(Hero hero, boolean now) {
        try {
            this.doSave(hero);
        }
        catch (IOException e) {
            Heroes.log(Level.SEVERE, "There was a problem saving the Hero: " + hero.getName());
            this.toSave.put(hero.getPlayer().getName(), hero);
        }
    }

    public boolean doSave(Hero hero) throws IOException {
        if (this.preUUID) {
            String name = hero.getName();
            return this.doSave(hero, new File(this.playerFolder, name.toLowerCase().substring(0, 1)), name);
        }
        return this.doSave(hero, this.playerFolder, hero.getPlayer().getUniqueId().toString());
    }

    private boolean doSave(Hero hero, File folder, String name) throws IOException {
        File playerFile = new File(folder, name + ".yml");
        YamlConfiguration playerConfig = new YamlConfiguration();
        playerConfig.set("class", (Object)hero.getHeroClass().toString());
        if (hero.getSecondClass() != null) {
            playerConfig.set("secondary-class", (Object)hero.getSecondClass().toString());
        }
        playerConfig.set("verbose", (Object)hero.isVerbose());
        playerConfig.set("suppressed", new ArrayList<String>(hero.getSuppressedSkills()));
        playerConfig.set("mana", (Object)hero.getMana());
        this.saveSkillSettings(hero, playerConfig.createSection("skill-settings"));
        this.saveCooldowns(hero, playerConfig.createSection("cooldowns"));
        this.saveExperience(hero, playerConfig.createSection("experience"));
        this.saveMasteries(hero, playerConfig.createSection("masteries"));
        this.saveBinds(hero, playerConfig.createSection("binds"));
        playerConfig.save(playerFile);
        return true;
    }

    private void loadBinds(Hero hero, ConfigurationSection section) {
        if (section == null) {
            return;
        }
        Set bindKeys = section.getKeys(false);
        if (bindKeys != null && bindKeys.size() > 0) {
            for (String material : bindKeys) {
                try {
                    Material item = Material.valueOf((String)material);
                    String bind = section.getString(material, "");
                    if (bind.length() <= 0) continue;
                    hero.bind(item, bind.split(" "));
                }
                catch (IllegalArgumentException e) {
                    Heroes.log(Level.WARNING, material + " isn't a valid Item to bind a Skill to.");
                }
            }
        }
    }

    private HeroClass loadClass(Player player, Configuration config) {
        HeroClass playerClass = null;
        HeroClass defaultClass = this.plugin.getClassManager().getDefaultClass();
        if (config.getString("class") != null) {
            playerClass = this.plugin.getClassManager().getClass(config.getString("class"));
            if (playerClass == null) {
                playerClass = defaultClass;
            } else if (!playerClass.isPrimary()) {
                playerClass = defaultClass;
            }
        } else {
            playerClass = defaultClass;
        }
        return playerClass;
    }

    private HeroClass loadSecondaryClass(Player player, Configuration config) {
        HeroClass playerClass = null;
        if (!(config.getString("secondary-class") == null || (playerClass = this.plugin.getClassManager().getClass(config.getString("secondary-class"))) != null && playerClass.isSecondary())) {
            Heroes.log(Level.SEVERE, "Invalid secondary class was defined for " + player.getName() + " resetting to nothing!");
            return null;
        }
        return playerClass;
    }

    private void loadCooldowns(Hero hero, ConfigurationSection section) {
        if (section == null) {
            return;
        }
        Set storedCooldowns = section.getKeys(false);
        if (storedCooldowns != null) {
            long time = System.currentTimeMillis();
            for (String skillName : storedCooldowns) {
                try {
                    long cooldown = Long.valueOf(section.getString(skillName, "0"));
                    if (!hero.hasAccessToSkill(skillName) || cooldown <= time) continue;
                    hero.setCooldown(skillName, cooldown);
                }
                catch (NumberFormatException e) {}
            }
        }
    }

    private void loadExperience(Hero hero, ConfigurationSection section) {
        if (hero == null || hero.getClass() == null || section == null) {
            return;
        }
        Set expList = section.getKeys(false);
        if (expList != null) {
            for (String className : expList) {
                double exp = section.getDouble(className, 0.0);
                HeroClass heroClass = this.plugin.getClassManager().getClass(className);
                if (heroClass == null || hero.getExperience(heroClass) != 0.0) continue;
                if (exp > (double)Properties.maxExp) {
                    exp = Properties.maxExp;
                }
                hero.setExperience(heroClass, exp);
            }
        }
    }

    private void loadMasteries(Hero hero, ConfigurationSection section) {
        if (hero == null || hero.getClass() == null || section == null) {
            return;
        }
        Set masteries = section.getKeys(false);
        if (masteries != null) {
            for (String className : masteries) {
                HeroClass heroClass = this.plugin.getClassManager().getClass(className);
                if (heroClass == null || hero.hasMastered(heroClass)) continue;
                hero.setMastered(heroClass);
            }
        }
    }

    private void loadSkillSettings(Hero hero, ConfigurationSection section) {
        if (section == null || section.getKeys(false) == null) {
            return;
        }
        for (String skill : section.getKeys(false)) {
            if (!section.isConfigurationSection(skill)) continue;
            ConfigurationSection skillSection = section.getConfigurationSection(skill);
            for (String key : skillSection.getKeys(true)) {
                if (skillSection.isConfigurationSection(key)) continue;
                hero.setSkillSetting(skill, key, skillSection.get(key));
            }
        }
    }

    private void saveBinds(Hero hero, ConfigurationSection section) {
        if (section == null) {
            return;
        }
        Map<Material, String[]> binds = hero.getBinds();
        for (Material material : binds.keySet()) {
            String[] bindArgs = binds.get(material);
            StringBuilder bind = new StringBuilder();
            for (String arg : bindArgs) {
                bind.append(arg).append(" ");
            }
            section.set(material.toString(), (Object)bind.toString().substring(0, bind.toString().length() - 1));
        }
    }

    private void saveCooldowns(Hero hero, ConfigurationSection section) {
        if (section == null) {
            if (Heroes.properties.debug) {
                Heroes.debugLog(Level.SEVERE, "Could not create cooldown section for " + hero.getName());
            }
            return;
        }
        long time = System.currentTimeMillis();
        Map<String, Long> cooldowns = hero.getCooldowns();
        for (Map.Entry<String, Long> entry : cooldowns.entrySet()) {
            String skillName = entry.getKey();
            Long cooldown = entry.getValue();
            if (cooldown <= time) continue;
            if (Heroes.properties.debug) {
                Heroes.debugLog(Level.INFO, hero.getName() + ": - " + skillName + " @ " + cooldown);
            }
            section.set(skillName, (Object)cooldown.toString());
        }
    }

    private void saveExperience(Hero hero, ConfigurationSection section) {
        if (hero == null || hero.getClass() == null || section == null) {
            return;
        }
        Map<String, Double> expMap = hero.getExperienceMap();
        for (Map.Entry<String, Double> entry : expMap.entrySet()) {
            section.set(entry.getKey(), (Object)entry.getValue());
        }
    }

    private void saveMasteries(Hero hero, ConfigurationSection section) {
        if (hero == null || hero.getMasteredClasses() == null || section == null) {
            return;
        }
        HashSet<String> masteriesList = new HashSet<String>();
        masteriesList.addAll(hero.getMasteredClasses());
        for (String mastered : masteriesList) {
            section.set(mastered, (Object)true);
        }
    }

    private void saveSkillSettings(Hero hero, ConfigurationSection config) {
        for (Map.Entry<String, ConfigurationSection> entry : hero.getSkillSettings().entrySet()) {
            for (String key : entry.getValue().getKeys(true)) {
                if (entry.getValue().isConfigurationSection(key)) continue;
                config.set(entry.getKey() + "." + key, entry.getValue().get(key));
            }
        }
    }

    @Override
    public void shutdown() {
        this.id.cancel();
        Collection<Hero> unsaved = this.plugin.getCharacterManager().getHeroes();
        Iterator<Map.Entry<String, Hero>> iter = this.toSave.entrySet().iterator();
        while (iter.hasNext()) {
            Hero hero = iter.next().getValue();
            try {
                this.doSave(hero);
                unsaved.remove(hero);
            }
            catch (Exception e) {
                Heroes.log(Level.SEVERE, "There was a problem saving the hero: " + hero.getName());
                continue;
            }
            iter.remove();
        }
        for (Hero hero : unsaved) {
            try {
                this.doSave(hero);
            }
            catch (IOException e) {
                Heroes.log(Level.SEVERE, "There was a problem saving the hero: " + hero.getName());
            }
        }
    }

    protected class HeroSaveThread
    implements Runnable {
        protected HeroSaveThread() {
        }

        @Override
        public void run() {
            if (YMLStorage.this.toSave.isEmpty()) {
                return;
            }
            Iterator iter = YMLStorage.this.toSave.entrySet().iterator();
            while (iter.hasNext()) {
                Hero hero = (Hero)iter.next().getValue();
                try {
                    YMLStorage.this.doSave(hero);
                }
                catch (Exception e) {
                    Heroes.log(Level.SEVERE, "There was a problem saving the Hero: " + hero.getName());
                    e.printStackTrace();
                    continue;
                }
                iter.remove();
            }
        }
    }
}

