/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.util;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClassManager;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.util.ItemData;
import com.herocraftonline.heroes.util.RecipeGroup;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ConfigManager {
    protected final Heroes plugin;
    protected static File classConfigFolder;
    protected static File expConfigFile;
    protected static File damageConfigFile;
    protected static File recipesConfigFile;
    private static Configuration damageConfig;
    private static Configuration expConfig;
    private static Configuration recipeConfig;

    public ConfigManager(Heroes plugin) {
        this.plugin = plugin;
        File dataFolder = plugin.getDataFolder();
        classConfigFolder = new File(dataFolder + File.separator + "classes");
        expConfigFile = new File(dataFolder, "experience.yml");
        damageConfigFile = new File(dataFolder, "damages.yml");
        recipesConfigFile = new File(dataFolder, "recipes.yml");
    }

    public void load() throws Exception {
        this.checkForConfig(expConfigFile);
        this.checkForConfig(damageConfigFile);
        this.checkForConfig(recipesConfigFile);
        if (!classConfigFolder.exists()) {
            classConfigFolder.mkdirs();
            this.checkForConfig(new File(classConfigFolder, "admin.yml"));
            this.checkForConfig(new File(classConfigFolder, "citizen.yml"));
            this.checkForConfig(new File(classConfigFolder, "rogue.yml"));
            this.checkForConfig(new File(classConfigFolder, "cleric.yml"));
            this.checkForConfig(new File(classConfigFolder, "mage.yml"));
            this.checkForConfig(new File(classConfigFolder, "warrior.yml"));
        }
        this.plugin.setSkillConfigs(new SkillConfigManager(this.plugin));
        this.plugin.getSkillConfigs().load();
    }

    public boolean loadManagers() {
        YamlConfiguration defConfig;
        damageConfig = YamlConfiguration.loadConfiguration((File)damageConfigFile);
        InputStream defConfigStream = this.plugin.getResource("defaults" + File.separator + "damages.yml");
        if (defConfigStream != null) {
            defConfig = YamlConfiguration.loadConfiguration((InputStream)defConfigStream);
            damageConfig.setDefaults((Configuration)defConfig);
        }
        this.plugin.getDamageManager().load(damageConfig);
        expConfig = YamlConfiguration.loadConfiguration((File)expConfigFile);
        defConfigStream = this.plugin.getResource("defaults" + File.separator + "experience.yml");
        if (defConfigStream != null) {
            defConfig = YamlConfiguration.loadConfiguration((InputStream)defConfigStream);
            expConfig.setDefaults((Configuration)defConfig);
        }
        this.loadExperience();
        recipeConfig = YamlConfiguration.loadConfiguration((File)recipesConfigFile);
        this.loadRecipes();
        HeroClassManager heroClassManager = new HeroClassManager(this.plugin);
        if (!heroClassManager.loadClasses(classConfigFolder)) {
            return false;
        }
        this.plugin.setClassManager(heroClassManager);
        return true;
    }

    public boolean reload() {
        try {
            this.plugin.getCharacterManager().shutdown();
            this.plugin.getSkillConfigs().reload();
            damageConfig = null;
            expConfig = null;
            recipeConfig = null;
            this.plugin.setClassManager(null);
            this.loadManagers();
            for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                Hero hero = this.plugin.getCharacterManager().getHero(player);
                this.plugin.getCharacterManager().performSkillChecks(hero);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Heroes.log(Level.SEVERE, "Critical error encountered while reloading. Disabling...");
            this.plugin.getServer().getPluginManager().disablePlugin((Plugin)this.plugin);
            return false;
        }
        Heroes.log(Level.INFO, "Reloaded Configuration");
        return true;
    }

    public void checkForConfig(File config) {
        if (!config.exists()) {
            try {
                int length;
                Heroes.log(Level.WARNING, "File " + config.getName() + " not found - generating defaults.");
                config.getParentFile().mkdir();
                config.createNewFile();
                FileOutputStream output = new FileOutputStream(config, false);
                InputStream input = ConfigManager.class.getResourceAsStream("/defaults/" + config.getName());
                byte[] buf = new byte[8192];
                while ((length = input.read(buf)) >= 0) {
                    ((OutputStream)output).write(buf, 0, length);
                }
                input.close();
                ((OutputStream)output).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void loadRecipes() {
        Set recipes = recipeConfig.getKeys(false);
        if (recipes.isEmpty()) {
            Heroes.log(Level.WARNING, "No recipes found!");
        }
        for (String key : recipes) {
            List deniedItems;
            short j;
            int level = recipeConfig.getInt(key + ".level", 1);
            RecipeGroup rg = new RecipeGroup(key, level);
            List items = recipeConfig.getStringList(key + ".items");
            if (items != null && !items.isEmpty()) {
                for (String i : items) {
                    String[] vals = i.split(":");
                    if (vals[0].equalsIgnoreCase("*") || vals[0].equalsIgnoreCase("all")) {
                        rg.setAllRecipes(true);
                        break;
                    }
                    try {
                        Material mat = Material.getMaterial((int)Integer.valueOf(vals[0]));
                        if (mat == null) {
                            Heroes.log(Level.SEVERE, "Invalid item ID in recipe group " + key + " ID: " + vals[0] + " is not a block ID!");
                            continue;
                        }
                        short subType = this.getMinDataVal(mat);
                        if (vals.length > 1) {
                            if (vals[1].equals("*")) {
                                for (j = this.getMinDataVal(mat); j <= this.getMaxDataVal(mat); j = (short)(j + 1)) {
                                    rg.put(new ItemData(mat, j), true);
                                }
                                continue;
                            }
                            subType = Short.valueOf(vals[1]);
                            if (subType < this.getMinDataVal(mat) || subType > this.getMaxDataVal(mat)) {
                                Heroes.log(Level.WARNING, "Invalid item SubType in recipe group " + key + " ID: " + vals[0] + " subtype: " + vals[1] + " is below or above min/max values.  Default to " + this.getMinDataVal(mat));
                                subType = this.getMinDataVal(mat);
                            }
                            rg.put(new ItemData(mat, subType), true);
                            continue;
                        }
                        rg.put(new ItemData(mat, subType), true);
                    }
                    catch (NumberFormatException e) {
                        Heroes.log(Level.SEVERE, "Invalid item ID in recipe group" + key);
                    }
                }
            }
            if ((deniedItems = recipeConfig.getStringList(key + ".denied-items")) != null && !deniedItems.isEmpty()) {
                for (String i : deniedItems) {
                    String[] vals = i.split(":");
                    try {
                        Material mat = Material.getMaterial((int)Integer.valueOf(vals[0]));
                        if (vals.length > 1) {
                            if (vals[1].equals("*")) {
                                for (j = 0; j < this.getMaxDataVal(mat); j = (short)(j + 1)) {
                                    rg.put(new ItemData(mat, j), false);
                                }
                                continue;
                            }
                            short subType = Short.valueOf(vals[1]);
                            rg.put(new ItemData(mat, subType), false);
                            continue;
                        }
                        rg.put(new ItemData(mat, 0), false);
                    }
                    catch (NumberFormatException e) {
                        Heroes.log(Level.SEVERE, "Invalid item ID in recipe group" + key);
                    }
                }
            }
            Heroes.properties.recipes.put(key.toLowerCase(), rg);
        }
    }

    private void loadExperience() {
        ConfigurationSection section = expConfig.getConfigurationSection("killing");
        if (section == null) {
            Heroes.log(Level.WARNING, "No Experience Section Killing defined!");
            return;
        }
        Set keys = section.getKeys(false);
        boolean errored = false;
        if (keys != null && !keys.isEmpty()) {
            for (String item : keys) {
                try {
                    double exp = section.getDouble(item, 0.0);
                    if (item.equalsIgnoreCase("Player")) {
                        Heroes.properties.playerKillingExp = exp;
                        continue;
                    }
                    EntityType type = EntityType.fromName((String)item);
                    if (type == null) {
                        throw new IllegalArgumentException();
                    }
                    Heroes.properties.creatureKillingExp.put(type, exp);
                }
                catch (IllegalArgumentException e) {
                    Heroes.log(Level.WARNING, "Invalid creature type (" + item + ") found in experience.yml.");
                    errored = true;
                }
            }
        } else {
            Heroes.log(Level.WARNING, "No Experience Section Killing defined!");
        }
        if (errored) {
            Heroes.log(Level.WARNING, "Remember, creature-names are case-sensetive, and must be exactly the same as found in the defaults!");
        }
        Heroes.properties.miningExp = this.loadMaterialExperience(expConfig.getConfigurationSection("mining"));
        Heroes.properties.farmingExp = this.loadMaterialExperience(expConfig.getConfigurationSection("farming"));
        Heroes.properties.loggingExp = this.loadMaterialExperience(expConfig.getConfigurationSection("logging"));
        Heroes.properties.craftingExp = this.loadMaterialExperience(expConfig.getConfigurationSection("crafting"));
        Heroes.properties.buildingExp = this.loadMaterialExperience(expConfig.getConfigurationSection("building"));
        Heroes.properties.fishingExp = expConfig.getDouble("fishing", 0.0);
        Heroes.properties.shearExp = expConfig.getDouble("shearing", 0.0);
        Heroes.properties.tameExp = expConfig.getDouble("taming", 0.0);
    }

    private Map<Material, Double> loadMaterialExperience(ConfigurationSection section) {
        HashMap<Material, Double> expMap = new HashMap<Material, Double>();
        if (section != null) {
            Set keys = section.getKeys(false);
            for (String item : keys) {
                double exp = section.getDouble(item, 0.0);
                Material type = Material.matchMaterial((String)item);
                if (type != null) {
                    expMap.put(type, exp);
                    continue;
                }
                Heroes.log(Level.WARNING, "Invalid material type (" + item + ") found in experience.yml.");
            }
        }
        return expMap;
    }

    private short getMinDataVal(Material mat) {
        switch (mat) {
            case PISTON_BASE: 
            case PISTON_STICKY_BASE: {
                return 7;
            }
        }
        return 0;
    }

    private short getMaxDataVal(Material mat) {
        switch (mat) {
            case COAL: {
                return 1;
            }
            case SANDSTONE: 
            case LONG_GRASS: {
                return 2;
            }
            case LOG: 
            case WOOD: 
            case SAPLING: 
            case SMOOTH_BRICK: 
            case WOOD_STEP: 
            case WOOD_DOUBLE_STEP: {
                return 3;
            }
            case PISTON_BASE: 
            case PISTON_STICKY_BASE: 
            case STEP: 
            case DOUBLE_STEP: 
            case LEAVES: {
                return 7;
            }
            case INK_SACK: 
            case WOOL: {
                return 15;
            }
        }
        return 0;
    }
}

