/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.util;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.util.Properties;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public final class Messaging {
    public static void broadcast(Heroes plugin, String msg, Object ... params) {
        plugin.getServer().broadcastMessage(Messaging.parameterizeMessage(msg, params));
    }

    public static String createFullHealthBar(double health, double maxHealth) {
        return "\u00a7aHP: \u00a7f" + (int)Math.ceil(health) + "/" + (int)Math.ceil(maxHealth) + " " + Messaging.createHealthBar(health, maxHealth);
    }

    public static String createHealthBar(double health, double maxHealth) {
        int i;
        StringBuilder healthBar = new StringBuilder(ChatColor.RED + "[" + ChatColor.GREEN);
        int progress = (int)(health / maxHealth * 50.0);
        for (i = 0; i < progress; ++i) {
            healthBar.append('|');
        }
        healthBar.append(ChatColor.DARK_RED);
        for (i = 0; i < 50 - progress; ++i) {
            healthBar.append('|');
        }
        healthBar.append(ChatColor.RED).append(']');
        return healthBar + " - " + ChatColor.GREEN + (int)(health / maxHealth * 100.0) + "%";
    }

    public static String createManaBar(int mana, int maxMana) {
        int i;
        StringBuilder manaBar = new StringBuilder(ChatColor.RED + "[" + ChatColor.BLUE);
        int percent = (int)((double)mana / (double)maxMana * 100.0);
        int progress = percent / 2;
        for (i = 0; i < progress; ++i) {
            manaBar.append('|');
        }
        manaBar.append(ChatColor.DARK_RED);
        for (i = 0; i < 50 - progress; ++i) {
            manaBar.append('|');
        }
        manaBar.append(ChatColor.RED).append(']');
        return manaBar + " - " + ChatColor.BLUE + percent + "%";
    }

    public static String createExperienceBar(int exp, int currentLevelExp, int nextLevelExp) {
        int i;
        StringBuilder expBar = new StringBuilder(ChatColor.RED + "[" + ChatColor.DARK_GREEN);
        int progress = (int)((double)(exp - currentLevelExp) / (double)(nextLevelExp - currentLevelExp) * 50.0);
        for (i = 0; i < progress; ++i) {
            expBar.append('|');
        }
        expBar.append(ChatColor.DARK_RED);
        for (i = 0; i < 50 - progress; ++i) {
            expBar.append('|');
        }
        expBar.append(ChatColor.RED + "]");
        expBar.append(" - " + ChatColor.DARK_GREEN + progress * 2 + "%  ");
        expBar.append("" + ChatColor.DARK_GREEN + (exp - currentLevelExp) + ChatColor.RED + "/" + ChatColor.DARK_GREEN + (nextLevelExp - currentLevelExp));
        return expBar.toString();
    }

    public static String createExperienceBar(Hero hero, HeroClass heroClass) {
        int level = hero.getLevel(heroClass);
        return Messaging.createExperienceBar((int)hero.getExperience(heroClass), Properties.getTotalExp(level), Properties.getTotalExp(level + 1));
    }

    public static String getLivingEntityName(CharacterTemplate character) {
        return Messaging.getLivingEntityName(character.getEntity());
    }

    public static String getLivingEntityName(LivingEntity lEntity) {
        switch (lEntity.getType()) {
            case PLAYER: {
                return ((Player)lEntity).getDisplayName();
            }
            case BLAZE: {
                return "Blaze";
            }
            case CAVE_SPIDER: {
                return "Cave Spider";
            }
            case MUSHROOM_COW: {
                return "Mushroom Cow";
            }
            case COW: {
                return "Cow";
            }
            case CHICKEN: {
                return "Chicken";
            }
            case CREEPER: {
                return "Creeper";
            }
            case ENDER_DRAGON: {
                return "Ender Dragon";
            }
            case ENDERMAN: {
                return "Enderman";
            }
            case GHAST: {
                return "Ghast";
            }
            case GIANT: {
                return "Giant";
            }
            case IRON_GOLEM: {
                return "Iron Golem";
            }
            case MAGMA_CUBE: {
                return "Magma Cube";
            }
            case OCELOT: {
                return "Ocelot";
            }
            case PIG: {
                return "Pig";
            }
            case PIG_ZOMBIE: {
                return "Pig Zombie";
            }
            case SHEEP: {
                return "Sheep";
            }
            case SKELETON: {
                return "Skeleton";
            }
            case SILVERFISH: {
                return "Silverfish";
            }
            case SLIME: {
                return "Slime";
            }
            case SNOWMAN: {
                return "Snowman";
            }
            case SPIDER: {
                return "Spider";
            }
            case SQUID: {
                return "Squid";
            }
            case WOLF: {
                return "Wolf";
            }
            case VILLAGER: {
                return "Villager";
            }
            case ZOMBIE: {
                return "Zombie";
            }
            case BAT: {
                return "Bat";
            }
            case WITHER: {
                return "Wither";
            }
            case WITCH: {
                return "Witch";
            }
        }
        return "Unknown";
    }

    public static void send(CommandSender player, String msg, Object ... params) {
        player.sendMessage(Messaging.parameterizeMessage(msg, params));
    }

    public static String parameterizeMessage(String msg, Object ... params) {
        msg = ChatColor.GRAY + msg;
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                msg = msg.replace("$" + (i + 1), ChatColor.WHITE + params[i].toString() + ChatColor.GRAY);
            }
        }
        return msg;
    }
}

