/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.util;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.nms.NMSHandler;
import com.herocraftonline.heroes.util.RecipeGroup;
import com.herocraftonline.heroes.util.Util;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;

public class Properties {
    public static ServerType serverType;
    public double power;
    public static int maxExp;
    public static int maxLevel;
    public static boolean padMaxLevel;
    public static int[] levels;
    public double expLoss;
    public double pvpExpLossMultiplier = 0.0;
    public boolean levelsViaExpLoss = false;
    public boolean masteryLoss = false;
    public int maxPartySize = 6;
    public double partyBonus = 0.0;
    public double playerKillingExp = 0.0;
    public boolean noSpawnCamp = false;
    public double spawnCampExpMult;
    public boolean resetOnDeath;
    public int pvpLevelRange = 50;
    public int minPvpLevel = 1;
    public boolean orbExp;
    public int pvpMaxExpRange = 0;
    public int pvpExpRange = 0;
    public static double[] partyMults;
    public double swapCost;
    public double oldClassSwapCost;
    public double profSwapCost;
    public double oldProfSwapCost;
    public boolean firstSwitchFree;
    public boolean swapMasterFree;
    public boolean prefixClassName;
    public boolean resetExpOnClassChange = true;
    public boolean resetMasteryOnClassChange = false;
    public boolean resetProfMasteryOnClassChange = false;
    public boolean resetProfOnPrimaryChange = false;
    public boolean lockPathTillMaster = false;
    public boolean lockAtHighestTier = false;
    public double selfHeal = 1.0;
    public static long classCooldown;
    public boolean oneHealthBar;
    public double healthPerBar = 20.0;
    public boolean debug;
    public String storageType;
    public boolean economy;
    public int blockTrackingDuration;
    public int maxTrackedBlocks;
    public double foodHealPercent = 0.05;
    public int globalCooldown = 0;
    public double enchantXPMultiplier;
    public boolean slowCasting = true;
    public static int combatTime;
    public static int itemDamageReduce;
    public static boolean silencePassiveSkills;
    public boolean bedHeal;
    public int healInterval;
    public int healPercent;
    public int manaRegenInterval;
    public int hatsLevel;
    public boolean allowHats;
    public double expBonus;
    public long expiration;
    public String bonusMessage;
    public Map<EntityType, Double> creatureKillingExp = new EnumMap<EntityType, Double>(EntityType.class);
    public Map<Material, Double> miningExp = new EnumMap<Material, Double>(Material.class);
    public Map<Material, Double> farmingExp = new EnumMap<Material, Double>(Material.class);
    public Map<Material, Double> loggingExp = new EnumMap<Material, Double>(Material.class);
    public Map<Material, Double> craftingExp = new EnumMap<Material, Double>(Material.class);
    public Map<Material, Double> buildingExp = new EnumMap<Material, Double>(Material.class);
    public Map<String, String> skillInfo = new HashMap<String, String>();
    public Map<String, RecipeGroup> recipes = new HashMap<String, RecipeGroup>();
    public double fishingExp = 0.0;
    public double shearExp = 0.0;
    public double tameExp = 0.0;
    private Heroes plugin;
    public double potHealthPerTier;

    public Properties() {
        Heroes.properties = this;
        String serverString = Bukkit.getServer().getVersion().split("-")[1].toLowerCase();
        serverType = serverString.equals("spigot") ? ServerType.SPIGOT : ServerType.BUKKIT;
        Heroes.log(Level.INFO, "The detected server mod is " + serverType.toString() + ". Heroes will use " + serverType.toString() + " compatibility!");
        NMSHandler.getInterface();
    }

    public void load(Heroes plugin) {
        this.plugin = plugin;
        FileConfiguration config = plugin.getConfig();
        config.options().copyDefaults(true);
        plugin.saveConfig();
        this.loadLevelConfig(config.getConfigurationSection("leveling"));
        this.loadClassConfig(config.getConfigurationSection("classes"));
        this.loadProperties(config.getConfigurationSection("properties"));
        this.loadManaConfig(config.getConfigurationSection("mana"));
        this.loadBedConfig(config.getConfigurationSection("bed"));
        this.loadHatsConfig(config.getConfigurationSection("hats"));
        this.loadBonusConfig(config.getConfigurationSection("bonus"));
        this.loadHealthBarConfig(config.getConfigurationSection("healthbar"));
    }

    private void loadHealthBarConfig(ConfigurationSection section) {
        if (section == null) {
            return;
        }
        this.oneHealthBar = section.getBoolean("limit-one-bar");
        this.healthPerBar = section.getDouble("health-per-bar");
        if (this.healthPerBar < 20.0) {
            Heroes.log(Level.SEVERE, "For safety reasons, the minimum health that can be displayed on a health bar is 20 unless using limit-one-bar!");
            this.healthPerBar = 20.0;
        }
    }

    private void loadBonusConfig(ConfigurationSection section) {
        if (section == null) {
            return;
        }
        this.expBonus = section.getDouble("exp", 1.0);
        this.expiration = section.getLong("expiration", 0L);
        this.bonusMessage = section.getString("message");
    }

    private void loadBedConfig(ConfigurationSection section) {
        if (section == null) {
            return;
        }
        this.bedHeal = section.getBoolean("enabled", true);
        this.healInterval = Util.toIntNonNull(section.get("interval", (Object)30), "interval");
        this.healPercent = Util.toIntNonNull(section.get("percent", (Object)5), "percent");
    }

    private void loadHatsConfig(ConfigurationSection section) {
        if (section == null) {
            return;
        }
        this.hatsLevel = Util.toIntNonNull(section.get("level", (Object)1), "level");
        this.allowHats = section.getBoolean("enabled", false);
    }

    private void loadLevelConfig(ConfigurationSection section) {
        if (section == null) {
            return;
        }
        this.power = Util.toDoubleNonNull(section.get("exp-curve", (Object)1.0), "exp-curve");
        maxExp = Util.toIntNonNull(section.get("max-exp", (Object)100000), "max-exp");
        maxLevel = Util.toIntNonNull(section.get("max-level", (Object)20), "max-level");
        padMaxLevel = section.getBoolean("pad-max-level", true);
        this.maxPartySize = Util.toIntNonNull(section.get("max-party-size"), "max-party-size");
        this.partyBonus = Util.toDoubleNonNull(section.get("party-exp-bonus", (Object)0.2), "party-exp-bonus");
        this.expLoss = Util.toDoubleNonNull(section.get("exp-loss", (Object)0.05), "expLoss");
        this.pvpExpLossMultiplier = Util.toDoubleNonNull(section.get("pvp-exp-loss", (Object)1.0), "pvp-exp-loss");
        this.levelsViaExpLoss = section.getBoolean("level-loss", false);
        this.masteryLoss = section.getBoolean("mastery-loss", false);
        this.noSpawnCamp = section.getBoolean("spawner-checks", false);
        this.spawnCampExpMult = Util.toDoubleNonNull(section.get("spawner-exp-mult", (Object)0.5), "spawner-exp-mult");
        this.resetOnDeath = section.getBoolean("reset-on-death", false);
        this.pvpLevelRange = Util.toIntNonNull(section.get("pvp-range", (Object)50), "pvp-range");
        this.minPvpLevel = Util.toIntNonNull(section.get("min-pvp-level", (Object)1), "min-pvp-level");
        this.pvpExpRange = Util.toIntNonNull(section.get("pvp-exp-range", (Object)10), "pvp-exp-range");
        this.pvpMaxExpRange = Util.toIntNonNull(section.get("pvp-max-exp-range", (Object)40), "pvp-max-exp-range");
        this.pvpMaxExpRange -= this.pvpExpRange;
        Heroes.log(Level.INFO, "Minimum PvP Level is set to: " + this.minPvpLevel);
        this.calcExp();
        if (section.getBoolean("dump-exp-file", false)) {
            this.dumpExpLevels();
        }
        this.calcPartyMultipliers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpExpLevels() {
        File levelFile = new File(this.plugin.getDataFolder(), "levels.txt");
        if (levelFile.exists()) {
            levelFile.delete();
        }
        BufferedWriter bos = null;
        try {
            levelFile.createNewFile();
            bos = new BufferedWriter(new FileWriter(levelFile));
            for (int i = 0; i < maxLevel; ++i) {
                bos.append(i + " - " + Properties.getTotalExp(i + 1) + "\n");
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private void loadClassConfig(ConfigurationSection section) {
        if (section == null) {
            return;
        }
        this.prefixClassName = section.getBoolean("use-prefix", false);
        this.resetExpOnClassChange = section.getBoolean("reset-exp-on-change", true);
        this.resetMasteryOnClassChange = section.getBoolean("reset-master-on-change", false);
        this.resetProfMasteryOnClassChange = section.getBoolean("reset-prof-master-on-change", false);
        this.resetProfOnPrimaryChange = section.getBoolean("reset-prof-on-pri-change", false);
        this.lockPathTillMaster = section.getBoolean("lock-till-master", false);
        this.lockAtHighestTier = section.getBoolean("lock-at-max-level", false);
        this.swapMasterFree = section.getBoolean("master-swap-free", true);
        this.firstSwitchFree = section.getBoolean("first-swap-free", true);
        this.swapCost = Util.toDoubleNonNull(section.get("swap-cost", (Object)0), "swap-cost");
        this.oldClassSwapCost = Util.toDoubleNonNull(section.get("old-swap-cost", (Object)0), "old-swap-cost");
        this.profSwapCost = Util.toDoubleNonNull(section.get("prof-swap-cost", (Object)0.0), "prof-swap-cost");
        this.oldProfSwapCost = Util.toDoubleNonNull(section.get("old-prof-swap-cost", (Object)0.0), "old-prof-swap-cost");
        this.selfHeal = Util.toDoubleNonNull(section.get("self-heal"), "self-heal");
        classCooldown = section.getLong("class-change-cooldown", 600000L);
    }

    private void loadManaConfig(ConfigurationSection section) {
        if (section == null) {
            return;
        }
        this.manaRegenInterval = Util.toIntNonNull(section.get("interval", (Object)5), "interval");
    }

    private void loadProperties(ConfigurationSection section) {
        if (section == null) {
            return;
        }
        this.storageType = section.getString("storage-type", "yml");
        this.economy = section.getBoolean("economy", false);
        this.debug = section.getBoolean("debug", false);
        this.foodHealPercent = Util.toDoubleNonNull(section.get("food-heal-percent", (Object)0.05), "food-heal-percent");
        this.globalCooldown = Util.toIntNonNull(section.get("global-cooldown", (Object)1), "global-cooldown");
        this.blockTrackingDuration = Util.toIntNonNull(section.get("block-tracking-duration", (Object)600000), "block-tracking-duration");
        this.maxTrackedBlocks = Util.toIntNonNull(section.get("max-tracked-blocks", (Object)1000), "max-tracked-blocks");
        this.enchantXPMultiplier = Util.toDoubleNonNull(section.get("enchant-exp-mult", (Object)1), "enchant-exp-mult");
        this.slowCasting = section.getBoolean("slow-while-casting", true);
        combatTime = Util.toIntNonNull(section.get("combat-time", (Object)10000), "combat-time");
        itemDamageReduce = Util.toIntNonNull(section.getInt("reduce-item-damage", 4), "reduce-item-damage");
        silencePassiveSkills = section.getBoolean("silence-passive-skill-messages", false);
    }

    protected void calcExp() {
        levels = new int[maxLevel + 1];
        double A = (double)maxExp * Math.pow(maxLevel - 1, -(this.power + 1.0));
        for (int i = 0; i < maxLevel + 1; ++i) {
            Properties.levels[i] = (int)(A * Math.pow(i, this.power + 1.0));
        }
        Properties.levels[Properties.maxLevel - 1] = maxExp;
    }

    protected void calcPartyMultipliers() {
        partyMults = new double[this.maxPartySize];
        for (int i = 0; i < this.maxPartySize; ++i) {
            Properties.partyMults[i] = ((double)this.maxPartySize - 1.0) / ((double)this.maxPartySize * Math.log(this.maxPartySize)) * Math.log(i + 1);
        }
    }

    public static int getTotalExp(int level) {
        if (level >= levels.length) {
            return levels[levels.length - 1];
        }
        if (level < 1) {
            return levels[0];
        }
        return levels[level - 1];
    }

    public static int getExp(int level) {
        if (level <= 1) {
            return 0;
        }
        return Properties.getTotalExp(level) - Properties.getTotalExp(level - 1);
    }

    public static int getLevel(double exp) {
        for (int i = maxLevel - 1; i >= 0; --i) {
            if (!(exp >= (double)levels[i])) continue;
            return i + 1;
        }
        return -1;
    }

    public void saveConfig() {
        FileConfiguration config = this.plugin.getConfig();
        config.set("bonus.message", (Object)this.bonusMessage);
        config.set("bonus.exp", (Object)this.expBonus);
        config.set("bonus.expiration", (Object)this.expiration);
        this.plugin.saveConfig();
    }

    static {
        itemDamageReduce = 4;
        silencePassiveSkills = false;
    }

    public static enum ServerType {
        BUKKIT,
        SPIGOT;

    }
}

