/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.util;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.HeroLeavePartyEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.Effect;
import com.herocraftonline.heroes.characters.party.HeroParty;
import com.herocraftonline.heroes.nms.NMSHandler;
import com.herocraftonline.heroes.util.MaterialUtil;
import com.herocraftonline.heroes.util.Messaging;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public final class Util {
    public static final List<String> swords;
    public static final List<String> axes;
    public static final List<String> shovels;
    public static final List<String> picks;
    public static final List<String> hoes;
    public static final List<String> weapons;
    public static final List<String> armors;
    public static final List<String> tools;
    public static final Set<Material> interactableBlocks;
    public static final HashSet<Byte> interactableIds;
    public static final Set<Material> transparentBlocks;
    public static final HashSet<Byte> transparentIds;
    private static final Random rand;
    public static final HashMap<String, Location> deaths;
    public static final DecimalFormat smallDecFormat;
    public static final DecimalFormat decFormat;
    public static final DecimalFormat largeDecFormat;
    public static final DecimalFormat decFormatCDs;

    public static double getDefaultMaxHealth(LivingEntity entity) {
        switch (entity.getType()) {
            case WITHER: {
                return 300.0;
            }
            case ENDER_DRAGON: {
                return 200.0;
            }
            case IRON_GOLEM: {
                return 100.0;
            }
            case ENDERMAN: {
                return 40.0;
            }
            case WITCH: {
                return 26.0;
            }
            case VILLAGER: 
            case PIG_ZOMBIE: 
            case BLAZE: 
            case CREEPER: 
            case SKELETON: 
            case ZOMBIE: {
                return 20.0;
            }
            case SPIDER: {
                return 16.0;
            }
            case HORSE: {
                return 0.0;
            }
            case CAVE_SPIDER: {
                return 12.0;
            }
            case COW: 
            case MUSHROOM_COW: 
            case OCELOT: 
            case PIG: 
            case SQUID: {
                return 10.0;
            }
            case SHEEP: 
            case SILVERFISH: {
                return 8.0;
            }
            case BAT: {
                return 6.0;
            }
            case SNOWMAN: {
                return 4.0;
            }
            case WOLF: {
                if (((Wolf)entity).isTamed()) {
                    return 20.0;
                }
                return 8.0;
            }
            case SLIME: 
            case MAGMA_CUBE: {
                int size = ((Slime)entity).getSize();
                return Math.pow(size, 2.0);
            }
        }
        return 0.0;
    }

    public static double getDefaultDamage(Material item) {
        switch (item) {
            case WOOD_PICKAXE: 
            case GOLD_PICKAXE: 
            case STONE_SPADE: {
                return 2.0;
            }
            case WOOD_AXE: 
            case GOLD_AXE: 
            case STONE_PICKAXE: 
            case IRON_SPADE: {
                return 3.0;
            }
            case WOOD_SWORD: 
            case GOLD_SWORD: 
            case STONE_AXE: 
            case DIAMOND_SPADE: 
            case IRON_PICKAXE: {
                return 4.0;
            }
            case DIAMOND_PICKAXE: 
            case IRON_AXE: 
            case STONE_SWORD: {
                return 5.0;
            }
            case IRON_SWORD: 
            case DIAMOND_AXE: {
                return 6.0;
            }
            case DIAMOND_SWORD: {
                return 7.0;
            }
        }
        return 1.0;
    }

    public static boolean leaveParty(Heroes plugin, Hero hero, HeroLeavePartyEvent.LeavePartyReason leaveReason) {
        Player player = hero.getPlayer();
        HeroParty heroParty = hero.getParty();
        if (heroParty == null) {
            if (Heroes.herochat != null) {
                Messaging.send((CommandSender)player, ChatColor.GREEN.toString() + "[Party] " + ChatColor.WHITE + "You don't have a party!", new Object[0]);
            } else {
                Messaging.send((CommandSender)player, "You don't have a party!", new Object[0]);
            }
            return false;
        }
        HeroLeavePartyEvent event = new HeroLeavePartyEvent(hero, heroParty, leaveReason);
        plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            if (Heroes.herochat != null) {
                Messaging.send((CommandSender)player, ChatColor.GREEN.toString() + "[Party] " + ChatColor.WHITE + "You can not leave the party at this time!", new Object[0]);
            } else {
                player.sendMessage("You can not leave the party at this time!");
            }
            return false;
        }
        heroParty.messageParty("$1 has left the party", player.getName());
        heroParty.removeMember(hero);
        if (heroParty.getMembers().size() == 0) {
            plugin.getPartyManager().removeParty(heroParty);
        }
        hero.setParty(null);
        return true;
    }

    public static boolean isUndead(Heroes plugin, LivingEntity entity) {
        if (entity instanceof Zombie || entity instanceof Skeleton || entity instanceof PigZombie || entity instanceof Ghast) {
            return true;
        }
        if (entity instanceof Player) {
            Hero hero = plugin.getCharacterManager().getHero((Player)entity);
            boolean isUndead = false;
            for (Effect effect : hero.getEffects()) {
                if (effect.getName() != "Undead" && effect.getName() != "BecomeDeath") continue;
                isUndead = true;
            }
            return isUndead;
        }
        return false;
    }

    public static boolean isNearSpawner(Entity entity, int radius) {
        Location location = entity.getLocation();
        for (int i = 0 - radius; i <= radius; ++i) {
            for (int j = 0 - radius; j <= radius; ++j) {
                for (int k = 0 - radius; k <= radius; ++k) {
                    if (!location.getBlock().getRelative(i, j, k).getType().equals((Object)Material.MOB_SPAWNER)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void playClientEffect(Player player, String particle, Vector offset, float speed, int count, boolean sendToAll) {
        Util.playClientEffect(player, player.getLocation(), particle, offset, speed, count, sendToAll);
    }

    public static void playClientEffect(Player player, Location startLocation, String particle, Vector offset, float speed, int count, boolean sendToAll) {
        NMSHandler.getInterface().playClientEffect(player, startLocation, particle, offset, speed, count, sendToAll);
    }

    public static List<Location> getCircleLocationList(Location startingLocation, Integer radius, Integer height, boolean isHollow, boolean isSphere, int plus_y) {
        ArrayList<Location> circleblocks = new ArrayList<Location>();
        int cx = startingLocation.getBlockX();
        int cy = startingLocation.getBlockY();
        int cz = startingLocation.getBlockZ();
        for (int x = cx - radius; x <= cx + radius; ++x) {
            for (int z = cz - radius; z <= cz + radius; ++z) {
                for (int y = isSphere ? cy - radius : cy; y < (isSphere ? cy + radius : cy + height); ++y) {
                    double dist = (cx - x) * (cx - x) + (cz - z) * (cz - z) + (isSphere ? (cy - y) * (cy - y) : 0);
                    if (!(dist < (double)(radius * radius)) || isHollow && dist < (double)((radius - 1) * (radius - 1))) continue;
                    Location l = new Location(startingLocation.getWorld(), (double)x, (double)(y + plus_y), (double)z);
                    circleblocks.add(l);
                }
            }
        }
        return circleblocks;
    }

    public static boolean isInBorder(Location center, Location targetLocation, int radiusX, int radiusY, int radiusZ) {
        int x1 = center.getBlockX();
        int y1 = center.getBlockY();
        int z1 = center.getBlockZ();
        int x2 = targetLocation.getBlockX();
        int y2 = targetLocation.getBlockY();
        int z2 = targetLocation.getBlockZ();
        return x2 < x1 + radiusX && x2 > x1 - radiusX && y2 < y1 + radiusY && y2 > y1 - radiusY && z2 < z1 + radiusZ && z2 > z1 - radiusZ;
    }

    public static int firstEmpty(ItemStack[] inventory) {
        for (int i = 9; i < inventory.length; ++i) {
            if (inventory[i] != null) continue;
            return i;
        }
        return -1;
    }

    public static boolean moveItem(Hero hero, int slot, ItemStack item) {
        Player player = hero.getPlayer();
        PlayerInventory inv = player.getInventory();
        int empty = Util.firstEmpty(inv.getContents());
        if (empty == -1) {
            player.getWorld().dropItemNaturally(player.getLocation(), item);
            if (slot != -1) {
                inv.clear(slot);
            }
            return false;
        }
        inv.setItem(empty, item);
        if (slot != -1) {
            inv.clear(slot);
        }
        Messaging.send((CommandSender)player, "You are not trained to use a $1.", MaterialUtil.getFriendlyName(item.getType()));
        return true;
    }

    public static void syncInventory(final Player player, Heroes plugin) {
        plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                player.updateInventory();
            }
        });
    }

    public static boolean isWeapon(Material mat) {
        switch (mat) {
            case WOOD_PICKAXE: 
            case GOLD_PICKAXE: 
            case STONE_SPADE: 
            case WOOD_AXE: 
            case GOLD_AXE: 
            case STONE_PICKAXE: 
            case IRON_SPADE: 
            case WOOD_SWORD: 
            case GOLD_SWORD: 
            case STONE_AXE: 
            case DIAMOND_SPADE: 
            case IRON_PICKAXE: 
            case DIAMOND_PICKAXE: 
            case IRON_AXE: 
            case STONE_SWORD: 
            case IRON_SWORD: 
            case DIAMOND_AXE: 
            case DIAMOND_SWORD: 
            case IRON_HOE: 
            case STONE_HOE: 
            case GOLD_HOE: 
            case GOLD_SPADE: 
            case WOOD_HOE: 
            case WOOD_SPADE: 
            case DIAMOND_HOE: 
            case BOW: 
            case FISHING_ROD: 
            case CARROT_STICK: 
            case SHEARS: {
                return true;
            }
        }
        return false;
    }

    public static boolean isAwkwardWeapon(Material mat) {
        switch (mat) {
            case NOTE_BLOCK: 
            case JUKEBOX: 
            case RECORD_3: 
            case RECORD_4: 
            case RECORD_5: 
            case RECORD_6: 
            case RECORD_7: 
            case RECORD_8: 
            case RECORD_9: 
            case RECORD_10: 
            case RECORD_11: 
            case RECORD_12: 
            case GREEN_RECORD: 
            case GOLD_RECORD: 
            case STICK: 
            case RAW_FISH: 
            case BLAZE_ROD: {
                return true;
            }
        }
        return false;
    }

    public static boolean isArmor(Material mat) {
        switch (mat) {
            case LEATHER_HELMET: 
            case LEATHER_LEGGINGS: 
            case LEATHER_BOOTS: 
            case LEATHER_CHESTPLATE: 
            case IRON_HELMET: 
            case IRON_LEGGINGS: 
            case IRON_CHESTPLATE: 
            case IRON_BOOTS: 
            case CHAINMAIL_HELMET: 
            case CHAINMAIL_LEGGINGS: 
            case CHAINMAIL_BOOTS: 
            case CHAINMAIL_CHESTPLATE: 
            case GOLD_HELMET: 
            case GOLD_LEGGINGS: 
            case GOLD_CHESTPLATE: 
            case GOLD_BOOTS: 
            case DIAMOND_HELMET: 
            case DIAMOND_LEGGINGS: 
            case DIAMOND_CHESTPLATE: 
            case DIAMOND_BOOTS: 
            case PUMPKIN: {
                return true;
            }
        }
        return false;
    }

    public static void disarmCheck(Hero hero, Heroes plugin) {
        ItemStack[] contents = hero.getPlayer().getInventory().getContents();
        boolean changed = false;
        for (int i = 0; i < 9; ++i) {
            if (contents[i] == null || !Util.isWeapon(contents[i].getType())) continue;
            Util.moveItem(hero, i, contents[i]);
            changed = true;
        }
        if (changed) {
            Util.syncInventory(hero.getPlayer(), plugin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void moveFile(File from, File to) {
        if (!from.exists()) {
            return;
        }
        OutputStream output = null;
        InputStream input = null;
        try {
            int out;
            to.getParentFile().mkdirs();
            to.createNewFile();
            output = new FileOutputStream(to, false);
            input = new FileInputStream(from);
            while ((out = input.read()) != -1) {
                output.write(out);
            }
            if (input != null) {
                input.close();
            }
            if (output != null) {
                output.close();
            }
            from.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                input.close();
                output.close();
            }
            catch (IOException e) {}
        }
    }

    public static int getMCExperience(int level) {
        return level * 7;
    }

    public static Integer toInt(Object val) {
        if (val instanceof String) {
            try {
                return Integer.valueOf((String)val);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (!(val instanceof Number)) {
            return null;
        }
        if (val instanceof Integer) {
            return (Integer)val;
        }
        if (val instanceof Double) {
            return ((Double)val).intValue();
        }
        if (val instanceof Float) {
            return ((Float)val).intValue();
        }
        if (val instanceof Long) {
            return ((Long)val).intValue();
        }
        if (val instanceof BigDecimal) {
            return ((BigDecimal)val).intValue();
        }
        return null;
    }

    public static int toIntNonNull(Object val, String name) {
        Integer newVal = Util.toInt(val);
        if (newVal == null) {
            throw new IllegalArgumentException(name + " must be a numeral!");
        }
        return newVal;
    }

    public static double toDoubleNonNull(Object val, String name) {
        Double newVal = Util.toDouble(val);
        if (newVal == null) {
            throw new IllegalArgumentException(name + " must be a numeral!");
        }
        return newVal;
    }

    public static boolean isFood(Material mat) {
        switch (mat) {
            case RAW_FISH: 
            case COOKIE: 
            case MELON: 
            case POTATO_ITEM: 
            case CARROT_ITEM: 
            case CAKE_BLOCK: 
            case RAW_CHICKEN: 
            case SPIDER_EYE: 
            case RAW_BEEF: 
            case PORK: 
            case APPLE: 
            case PUMPKIN_PIE: 
            case ROTTEN_FLESH: 
            case BREAD: 
            case COOKED_FISH: 
            case BAKED_POTATO: 
            case COOKED_CHICKEN: 
            case COOKED_BEEF: 
            case GOLDEN_APPLE: 
            case GRILLED_PORK: 
            case MUSHROOM_SOUP: 
            case GOLDEN_CARROT: {
                return true;
            }
        }
        return false;
    }

    public static Double toDouble(Object val) {
        if (val instanceof String) {
            try {
                return Double.valueOf((String)val);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (!(val instanceof Number)) {
            return null;
        }
        if (val instanceof Integer) {
            return ((Integer)val).doubleValue();
        }
        if (val instanceof Double) {
            return (Double)val;
        }
        if (val instanceof Float) {
            return ((Float)val).doubleValue();
        }
        if (val instanceof Long) {
            return ((Long)val).doubleValue();
        }
        if (val instanceof BigDecimal) {
            return ((BigDecimal)val).doubleValue();
        }
        return null;
    }

    public static String stringDouble(double d) {
        return String.valueOf(Util.formatDouble(d));
    }

    public static double formatDouble(double d) {
        int val = (int)(d * 1000.0);
        return (double)val / 1000.0;
    }

    public static ItemStack itemFromString(String[] vals, int amount) {
        ItemStack stack = null;
        try {
            int id = Integer.parseInt(vals[0]);
            byte sub = 0;
            if (vals.length > 1) {
                sub = (byte)Integer.parseInt(vals[1]);
            }
            stack = new ItemStack(id, amount, (short)sub);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return stack;
    }

    public static int getFeatherFallLevel(PlayerInventory inv) {
        int level = 0;
        for (ItemStack armor : inv.getArmorContents()) {
            if (armor == null || !armor.containsEnchantment(Enchantment.PROTECTION_FALL)) continue;
            level += armor.getEnchantmentLevel(Enchantment.PROTECTION_FALL);
        }
        return level;
    }

    public static final double nextRand() {
        return (double)rand.nextInt(10000) / 10000.0;
    }

    public static final int nextInt(int max) {
        return rand.nextInt(max);
    }

    static {
        rand = new SecureRandom();
        smallDecFormat = new DecimalFormat("#0.#");
        decFormat = new DecimalFormat("#0.##");
        largeDecFormat = new DecimalFormat("#0.###");
        decFormatCDs = new DecimalFormat("#0.0");
        swords = new ArrayList<String>(5);
        swords.add("WOOD_SWORD");
        swords.add("STONE_SWORD");
        swords.add("IRON_SWORD");
        swords.add("GOLD_SWORD");
        swords.add("DIAMOND_SWORD");
        axes = new ArrayList<String>(5);
        axes.add("WOOD_AXE");
        axes.add("STONE_AXE");
        axes.add("IRON_AXE");
        axes.add("GOLD_AXE");
        axes.add("DIAMOND_AXE");
        shovels = new ArrayList<String>(5);
        shovels.add("WOOD_SPADE");
        shovels.add("STONE_SPADE");
        shovels.add("IRON_SPADE");
        shovels.add("GOLD_SPADE");
        shovels.add("DIAMOND_SPADE");
        picks = new ArrayList<String>(5);
        picks.add("WOOD_PICKAXE");
        picks.add("STONE_PICKAXE");
        picks.add("IRON_PICKAXE");
        picks.add("GOLD_PICKAXE");
        picks.add("DIAMOND_PICKAXE");
        hoes = new ArrayList<String>(5);
        hoes.add("WOOD_HOE");
        hoes.add("STONE_HOE");
        hoes.add("IRON_HOE");
        hoes.add("GOLD_HOE");
        hoes.add("DIAMOND_HOE");
        tools = new ArrayList<String>(2);
        tools.add("SHEARS");
        tools.add("FISHING_ROD");
        tools.add("CARROT_STICK");
        tools.addAll(shovels);
        tools.addAll(hoes);
        weapons = new ArrayList<String>(26);
        weapons.addAll(picks);
        weapons.addAll(axes);
        weapons.addAll(swords);
        weapons.addAll(tools);
        weapons.add("BOW");
        armors = new ArrayList<String>(21);
        armors.add("LEATHER_HELMET");
        armors.add("LEATHER_LEGGINGS");
        armors.add("LEATHER_BOOTS");
        armors.add("LEATHER_CHESTPLATE");
        armors.add("IRON_HELMET");
        armors.add("IRON_LEGGINGS");
        armors.add("IRON_CHESTPLATE");
        armors.add("IRON_BOOTS");
        armors.add("CHAINMAIL_HELMET");
        armors.add("CHAINMAIL_LEGGINGS");
        armors.add("CHAINMAIL_BOOTS");
        armors.add("CHAINMAIL_CHESTPLATE");
        armors.add("GOLD_HELMET");
        armors.add("GOLD_LEGGINGS");
        armors.add("GOLD_CHESTPLATE");
        armors.add("GOLD_BOOTS");
        armors.add("DIAMOND_HELMET");
        armors.add("DIAMOND_LEGGINGS");
        armors.add("DIAMOND_CHESTPLATE");
        armors.add("DIAMOND_BOOTS");
        armors.add("PUMPKIN");
        armors.add("SKULL_ITEM");
        interactableBlocks = new HashSet<Material>(40);
        interactableBlocks.add(Material.CHEST);
        interactableBlocks.add(Material.LOCKED_CHEST);
        interactableBlocks.add(Material.IRON_DOOR_BLOCK);
        interactableBlocks.add(Material.SIGN);
        interactableBlocks.add(Material.WALL_SIGN);
        interactableBlocks.add(Material.SIGN_POST);
        interactableBlocks.add(Material.WORKBENCH);
        interactableBlocks.add(Material.STONE_BUTTON);
        interactableBlocks.add(Material.WOOD_BUTTON);
        interactableBlocks.add(Material.LEVER);
        interactableBlocks.add(Material.WOODEN_DOOR);
        interactableBlocks.add(Material.TRAP_DOOR);
        interactableBlocks.add(Material.TRAPPED_CHEST);
        interactableBlocks.add(Material.DIODE);
        interactableBlocks.add(Material.DIODE_BLOCK_ON);
        interactableBlocks.add(Material.DIODE_BLOCK_OFF);
        interactableBlocks.add(Material.DISPENSER);
        interactableBlocks.add(Material.HOPPER);
        interactableBlocks.add(Material.DROPPER);
        interactableBlocks.add(Material.REDSTONE_COMPARATOR);
        interactableBlocks.add(Material.REDSTONE_COMPARATOR_ON);
        interactableBlocks.add(Material.REDSTONE_COMPARATOR_OFF);
        interactableBlocks.add(Material.FURNACE);
        interactableBlocks.add(Material.BURNING_FURNACE);
        interactableBlocks.add(Material.CAULDRON);
        interactableBlocks.add(Material.JUKEBOX);
        interactableBlocks.add(Material.NOTE_BLOCK);
        interactableBlocks.add(Material.STORAGE_MINECART);
        interactableBlocks.add(Material.ENDER_CHEST);
        interactableBlocks.add(Material.FENCE_GATE);
        interactableBlocks.add(Material.ENCHANTMENT_TABLE);
        interactableBlocks.add(Material.BREWING_STAND);
        interactableBlocks.add(Material.ITEM_FRAME);
        interactableBlocks.add(Material.BOAT);
        interactableBlocks.add(Material.MINECART);
        interactableBlocks.add(Material.FLOWER_POT);
        interactableBlocks.add(Material.BEACON);
        interactableBlocks.add(Material.BED_BLOCK);
        interactableBlocks.add(Material.ANVIL);
        interactableBlocks.add(Material.COMMAND);
        interactableIds = new HashSet(40);
        interactableIds.add((byte)Material.CHEST.getId());
        interactableIds.add((byte)Material.LOCKED_CHEST.getId());
        interactableIds.add((byte)Material.IRON_DOOR_BLOCK.getId());
        interactableIds.add((byte)Material.SIGN.getId());
        interactableIds.add((byte)Material.WALL_SIGN.getId());
        interactableIds.add((byte)Material.SIGN_POST.getId());
        interactableIds.add((byte)Material.WORKBENCH.getId());
        interactableIds.add((byte)Material.STONE_BUTTON.getId());
        interactableIds.add((byte)Material.WOOD_BUTTON.getId());
        interactableIds.add((byte)Material.LEVER.getId());
        interactableIds.add((byte)Material.WOODEN_DOOR.getId());
        interactableIds.add((byte)Material.TRAP_DOOR.getId());
        interactableIds.add((byte)Material.TRAPPED_CHEST.getId());
        interactableIds.add((byte)Material.DIODE.getId());
        interactableIds.add((byte)Material.DIODE_BLOCK_ON.getId());
        interactableIds.add((byte)Material.DIODE_BLOCK_OFF.getId());
        interactableIds.add((byte)Material.DISPENSER.getId());
        interactableIds.add((byte)Material.HOPPER.getId());
        interactableIds.add((byte)Material.DROPPER.getId());
        interactableIds.add((byte)Material.REDSTONE_COMPARATOR.getId());
        interactableIds.add((byte)Material.REDSTONE_COMPARATOR_ON.getId());
        interactableIds.add((byte)Material.REDSTONE_COMPARATOR_OFF.getId());
        interactableIds.add((byte)Material.FURNACE.getId());
        interactableIds.add((byte)Material.BURNING_FURNACE.getId());
        interactableIds.add((byte)Material.CAULDRON.getId());
        interactableIds.add((byte)Material.JUKEBOX.getId());
        interactableIds.add((byte)Material.NOTE_BLOCK.getId());
        interactableIds.add((byte)Material.STORAGE_MINECART.getId());
        interactableIds.add((byte)Material.ENDER_CHEST.getId());
        interactableIds.add((byte)Material.FENCE_GATE.getId());
        interactableIds.add((byte)Material.ENCHANTMENT_TABLE.getId());
        interactableIds.add((byte)Material.BREWING_STAND.getId());
        interactableIds.add((byte)Material.ITEM_FRAME.getId());
        interactableIds.add((byte)Material.BOAT.getId());
        interactableIds.add((byte)Material.MINECART.getId());
        interactableIds.add((byte)Material.FLOWER_POT.getId());
        interactableIds.add((byte)Material.BEACON.getId());
        interactableIds.add((byte)Material.BED_BLOCK.getId());
        interactableIds.add((byte)Material.ANVIL.getId());
        interactableIds.add((byte)Material.COMMAND.getId());
        transparentBlocks = new HashSet<Material>(42);
        transparentBlocks.add(Material.AIR);
        transparentBlocks.add(Material.CARPET);
        transparentBlocks.add(Material.CROPS);
        transparentBlocks.add(Material.DEAD_BUSH);
        transparentBlocks.add(Material.DETECTOR_RAIL);
        transparentBlocks.add(Material.DIODE_BLOCK_OFF);
        transparentBlocks.add(Material.DIODE_BLOCK_ON);
        transparentBlocks.add(Material.DIODE);
        transparentBlocks.add(Material.FENCE_GATE);
        transparentBlocks.add(Material.FLOWER_POT);
        transparentBlocks.add(Material.LADDER);
        transparentBlocks.add(Material.LEVER);
        transparentBlocks.add(Material.LONG_GRASS);
        transparentBlocks.add(Material.NETHER_WARTS);
        transparentBlocks.add(Material.PORTAL);
        transparentBlocks.add(Material.POWERED_RAIL);
        transparentBlocks.add(Material.RAILS);
        transparentBlocks.add(Material.RED_ROSE);
        transparentBlocks.add(Material.REDSTONE_COMPARATOR_OFF);
        transparentBlocks.add(Material.REDSTONE_COMPARATOR_ON);
        transparentBlocks.add(Material.REDSTONE_COMPARATOR);
        transparentBlocks.add(Material.REDSTONE_TORCH_OFF);
        transparentBlocks.add(Material.REDSTONE_TORCH_ON);
        transparentBlocks.add(Material.REDSTONE_WIRE);
        transparentBlocks.add(Material.SAPLING);
        transparentBlocks.add(Material.SIGN_POST);
        transparentBlocks.add(Material.SIGN);
        transparentBlocks.add(Material.SNOW);
        transparentBlocks.add(Material.STATIONARY_LAVA);
        transparentBlocks.add(Material.STATIONARY_WATER);
        transparentBlocks.add(Material.STONE_BUTTON);
        transparentBlocks.add(Material.STONE_PLATE);
        transparentBlocks.add(Material.SUGAR_CANE_BLOCK);
        transparentBlocks.add(Material.TORCH);
        transparentBlocks.add(Material.TRIPWIRE);
        transparentBlocks.add(Material.VINE);
        transparentBlocks.add(Material.WALL_SIGN);
        transparentBlocks.add(Material.WATER_LILY);
        transparentBlocks.add(Material.WATER);
        transparentBlocks.add(Material.WEB);
        transparentBlocks.add(Material.WOOD_BUTTON);
        transparentBlocks.add(Material.WOOD_PLATE);
        transparentBlocks.add(Material.YELLOW_FLOWER);
        transparentIds = new HashSet(42);
        transparentIds.add((byte)Material.AIR.getId());
        transparentIds.add((byte)Material.CARPET.getId());
        transparentIds.add((byte)Material.CROPS.getId());
        transparentIds.add((byte)Material.DEAD_BUSH.getId());
        transparentIds.add((byte)Material.DETECTOR_RAIL.getId());
        transparentIds.add((byte)Material.DIODE_BLOCK_OFF.getId());
        transparentIds.add((byte)Material.DIODE_BLOCK_ON.getId());
        transparentIds.add((byte)Material.DIODE.getId());
        transparentIds.add((byte)Material.FENCE_GATE.getId());
        transparentIds.add((byte)Material.FLOWER_POT.getId());
        transparentIds.add((byte)Material.LADDER.getId());
        transparentIds.add((byte)Material.LEVER.getId());
        transparentIds.add((byte)Material.LONG_GRASS.getId());
        transparentIds.add((byte)Material.NETHER_WARTS.getId());
        transparentIds.add((byte)Material.PORTAL.getId());
        transparentIds.add((byte)Material.POWERED_RAIL.getId());
        transparentIds.add((byte)Material.RAILS.getId());
        transparentIds.add((byte)Material.RED_ROSE.getId());
        transparentIds.add((byte)Material.REDSTONE_COMPARATOR_OFF.getId());
        transparentIds.add((byte)Material.REDSTONE_COMPARATOR_ON.getId());
        transparentIds.add((byte)Material.REDSTONE_COMPARATOR.getId());
        transparentIds.add((byte)Material.REDSTONE_TORCH_OFF.getId());
        transparentIds.add((byte)Material.REDSTONE_TORCH_ON.getId());
        transparentIds.add((byte)Material.REDSTONE_WIRE.getId());
        transparentIds.add((byte)Material.SAPLING.getId());
        transparentIds.add((byte)Material.SIGN_POST.getId());
        transparentIds.add((byte)Material.SIGN.getId());
        transparentIds.add((byte)Material.SNOW.getId());
        transparentIds.add((byte)Material.STATIONARY_LAVA.getId());
        transparentIds.add((byte)Material.STATIONARY_WATER.getId());
        transparentIds.add((byte)Material.STONE_BUTTON.getId());
        transparentIds.add((byte)Material.STONE_PLATE.getId());
        transparentIds.add((byte)Material.SUGAR_CANE_BLOCK.getId());
        transparentIds.add((byte)Material.TORCH.getId());
        transparentIds.add((byte)Material.TRIPWIRE.getId());
        transparentIds.add((byte)Material.VINE.getId());
        transparentIds.add((byte)Material.WALL_SIGN.getId());
        transparentIds.add((byte)Material.WATER_LILY.getId());
        transparentIds.add((byte)Material.WATER.getId());
        transparentIds.add((byte)Material.WEB.getId());
        transparentIds.add((byte)Material.WOOD_BUTTON.getId());
        transparentIds.add((byte)Material.WOOD_PLATE.getId());
        transparentIds.add((byte)Material.YELLOW_FLOWER.getId());
        deaths = new LinkedHashMap<String, Location>(){
            private static final int MAX_ENTRIES = 50;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Location> eldest) {
                return this.size() > 50;
            }
        };
    }
}

