/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ChunkNotification {
    public static String notificationFormat = "\u00a76 ~ %s";
    public static String notificationSpliter = "\u00a77 - ";
    public static String areaWildernessNotificationFormat = "\u00a72%s";
    public static String areaWildernessPvPNotificationFormat = "\u00a72%s";
    public static String areaTownNotificationFormat = "\u00a72%s";
    public static String areaTownPvPNotificationFormat = "\u00a72%s";
    public static String ownerNotificationFormat = "\u00a7a%s";
    public static String noOwnerNotificationFormat = "\u00a7a%s";
    public static String plotNotficationSplitter = " ";
    public static String plotNotificationFormat = "%s";
    public static String homeBlockNotification = "\u00a7b[Home]";
    public static String outpostBlockNotification = "\u00a7b[Outpost]";
    public static String forSaleNotificationFormat = "\u00a7e[For Sale: %s]";
    public static String plotTypeNotificationFormat = "\u00a76[%s]";
    WorldCoord from;
    WorldCoord to;
    boolean fromWild = false;
    boolean toWild = false;
    boolean toForSale = false;
    boolean toHomeBlock = false;
    boolean toOutpostBlock = false;
    TownBlock fromTownBlock;
    TownBlock toTownBlock = null;
    Town fromTown = null;
    Town toTown = null;
    Resident fromResident = null;
    Resident toResident = null;
    TownBlockType fromPlotType = null;
    TownBlockType toPlotType = null;

    public static void loadFormatStrings() {
        notificationFormat = TownySettings.getConfigLang(ConfigNodes.NOTIFICATION_FORMAT);
        notificationSpliter = TownySettings.getConfigLang(ConfigNodes.NOTIFICATION_SPLITTER);
        areaWildernessNotificationFormat = TownySettings.getConfigLang(ConfigNodes.NOTIFICATION_AREA_WILDERNESS);
        areaWildernessPvPNotificationFormat = TownySettings.getConfigLang(ConfigNodes.NOTIFICATION_AREA_WILDERNESS_PVP);
        areaTownNotificationFormat = TownySettings.getConfigLang(ConfigNodes.NOTIFICATION_AREA_TOWN);
        areaTownPvPNotificationFormat = TownySettings.getConfigLang(ConfigNodes.NOTIFICATION_AREA_TOWN_PVP);
        ownerNotificationFormat = TownySettings.getConfigLang(ConfigNodes.NOTIFICATION_OWNER);
        noOwnerNotificationFormat = TownySettings.getConfigLang(ConfigNodes.NOTIFICATION_NO_OWNER);
        plotNotficationSplitter = TownySettings.getConfigLang(ConfigNodes.NOTIFICATION_PLOT_SPLITTER);
        plotNotificationFormat = TownySettings.getConfigLang(ConfigNodes.NOTIFICATION_PLOT_FORMAT);
        homeBlockNotification = TownySettings.getConfigLang(ConfigNodes.NOTIFICATION_PLOT_HOMEBLOCK);
        outpostBlockNotification = TownySettings.getConfigLang(ConfigNodes.NOTIFICATION_PLOT_OUTPOSTBLOCK);
        forSaleNotificationFormat = TownySettings.getConfigLang(ConfigNodes.NOTIFICATION_PLOT_FORSALE);
        plotTypeNotificationFormat = TownySettings.getConfigLang(ConfigNodes.NOTIFICATION_PLOT_TYPE);
    }

    public ChunkNotification(WorldCoord from, WorldCoord to) {
        this.from = from;
        this.to = to;
        try {
            this.fromTownBlock = from.getTownBlock();
            this.fromPlotType = this.fromTownBlock.getType();
            try {
                this.fromTown = this.fromTownBlock.getTown();
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
            try {
                this.fromResident = this.fromTownBlock.getResident();
            }
            catch (NotRegisteredException notRegisteredException) {}
        }
        catch (NotRegisteredException e) {
            this.fromWild = true;
        }
        try {
            this.toTownBlock = to.getTownBlock();
            this.toPlotType = this.toTownBlock.getType();
            try {
                this.toTown = this.toTownBlock.getTown();
            }
            catch (NotRegisteredException e) {
                // empty catch block
            }
            try {
                this.toResident = this.toTownBlock.getResident();
            }
            catch (NotRegisteredException e) {
                // empty catch block
            }
            this.toForSale = this.toTownBlock.getPlotPrice() != -1.0;
            this.toHomeBlock = this.toTownBlock.isHomeBlock();
            this.toOutpostBlock = this.toTownBlock.isOutpost();
        }
        catch (NotRegisteredException e) {
            this.toWild = true;
        }
    }

    public String getNotificationString(Resident resident) {
        if (notificationFormat.length() == 0) {
            return null;
        }
        List<String> outputContent = this.getNotificationContent(resident);
        if (outputContent.size() == 0) {
            return null;
        }
        return String.format(notificationFormat, StringMgmt.join(outputContent, notificationSpliter));
    }

    public List<String> getNotificationContent(Resident resident) {
        ArrayList<String> out = new ArrayList<String>();
        String output = this.getAreaNotification(resident);
        if (output != null && output.length() > 0) {
            out.add(output);
        }
        if ((output = this.getAreaPvPNotification()) != null && output.length() > 0) {
            out.add(output);
        }
        if (!resident.hasMode("ignoreplots") && (output = this.getOwnerNotification()) != null && output.length() > 0) {
            out.add(output);
        }
        if ((output = this.getTownPVPNotification()) != null && output.length() > 0) {
            out.add(output);
        }
        if (!resident.hasMode("ignoreplots") && (output = this.getPlotNotification()) != null && output.length() > 0) {
            out.add(output);
        }
        return out;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getAreaNotification(Resident resident) {
        if (this.fromWild ^ this.toWild || !this.fromWild && !this.toWild && this.fromTown != null && this.toTown != null && this.fromTown != this.toTown) {
            if (!this.toWild) return String.format(areaTownNotificationFormat, TownyFormatter.getFormattedName(this.toTown));
            try {
                if (!TownySettings.getNationZonesEnabled() || !TownySettings.getNationZonesShowNotifications()) return String.format(areaWildernessNotificationFormat, this.to.getTownyWorld().getUnclaimedZoneName());
                Player player = BukkitTools.getPlayer(resident.getName());
                TownyWorld toWorld = this.to.getTownyWorld();
                try {
                    if (!PlayerCacheUtil.getTownBlockStatus(player, this.to).equals((Object)PlayerCache.TownBlockStatus.NATION_ZONE)) return String.format(areaWildernessNotificationFormat, this.to.getTownyWorld().getUnclaimedZoneName());
                    Town nearestTown = null;
                    nearestTown = toWorld.getClosestTownWithNationFromCoord(this.to.getCoord(), nearestTown);
                    return String.format(areaWildernessNotificationFormat, String.format(TownySettings.getLangString("nation_zone_this_area_under_protection_of"), toWorld.getUnclaimedZoneName(), nearestTown.getNation().getName()));
                }
                catch (NotRegisteredException nearestTown) {
                    // empty catch block
                }
                return String.format(areaWildernessNotificationFormat, this.to.getTownyWorld().getUnclaimedZoneName());
            }
            catch (NotRegisteredException player) {
                return null;
            }
        }
        if (!this.fromWild || !this.toWild) return null;
        try {
            if (!TownySettings.getNationZonesEnabled() || !TownySettings.getNationZonesShowNotifications()) return null;
            Player player = BukkitTools.getPlayer(resident.getName());
            TownyWorld toWorld = this.to.getTownyWorld();
            try {
                if (PlayerCacheUtil.getTownBlockStatus(player, this.to).equals((Object)PlayerCache.TownBlockStatus.NATION_ZONE) && PlayerCacheUtil.getTownBlockStatus(player, this.from).equals((Object)PlayerCache.TownBlockStatus.UNCLAIMED_ZONE)) {
                    Town nearestTown = null;
                    nearestTown = toWorld.getClosestTownWithNationFromCoord(this.to.getCoord(), nearestTown);
                    return String.format(areaWildernessNotificationFormat, String.format(TownySettings.getLangString("nation_zone_this_area_under_protection_of"), toWorld.getUnclaimedZoneName(), nearestTown.getNation().getName()));
                }
                if (!PlayerCacheUtil.getTownBlockStatus(player, this.to).equals((Object)PlayerCache.TownBlockStatus.UNCLAIMED_ZONE) || !PlayerCacheUtil.getTownBlockStatus(player, this.from).equals((Object)PlayerCache.TownBlockStatus.NATION_ZONE)) return null;
                return String.format(areaWildernessNotificationFormat, this.to.getTownyWorld().getUnclaimedZoneName());
            }
            catch (NotRegisteredException notRegisteredException) {}
            return null;
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        return null;
    }

    public String getAreaPvPNotification() {
        if ((this.fromWild ^ this.toWild || !this.fromWild && !this.toWild && this.fromTown != null && this.toTown != null && this.fromTown != this.toTown) && this.toWild) {
            try {
                return String.format(areaWildernessPvPNotificationFormat, this.to.getTownyWorld().isPVP() && this.testWorldPVP() ? "\u00a74 (PvP)" : "");
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getOwnerNotification() {
        if ((this.fromResident != this.toResident || this.fromTownBlock != null && this.toTownBlock != null && !this.fromTownBlock.getName().equalsIgnoreCase(this.toTownBlock.getName())) && !this.toWild) {
            if (this.toResident != null) {
                if (TownySettings.isNotificationOwnerShowingNationTitles()) {
                    return String.format(ownerNotificationFormat, this.toTownBlock.getName().isEmpty() ? TownyFormatter.getFormattedResidentTitleName(this.toResident) : this.toTownBlock.getName());
                }
                return String.format(ownerNotificationFormat, this.toTownBlock.getName().isEmpty() ? TownyFormatter.getFormattedName(this.toResident) : this.toTownBlock.getName());
            }
            return String.format(noOwnerNotificationFormat, this.toTownBlock.getName().isEmpty() ? TownySettings.getUnclaimedPlotName() : this.toTownBlock.getName());
        }
        return null;
    }

    public String getTownPVPNotification() {
        if (!this.toWild && (this.fromWild || this.toTownBlock.getPermissions().pvp != this.fromTownBlock.getPermissions().pvp && !this.toTown.isPVP())) {
            try {
                return String.format(areaTownPvPNotificationFormat, this.testWorldPVP() && !this.toTown.isAdminDisabledPVP() && (this.to.getTownyWorld().isForcePVP() || this.toTown.isPVP() || this.toTownBlock.getPermissions().pvp) ? "\u00a74(PvP)" : "\u00a72(No PVP)");
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean testWorldPVP() {
        try {
            return Bukkit.getServer().getWorld(this.to.getTownyWorld().getName()).getPVP();
        }
        catch (NotRegisteredException e) {
            return true;
        }
    }

    public String getPlotNotification() {
        if (plotNotificationFormat.length() == 0) {
            return null;
        }
        List<String> outputContent = this.getPlotNotificationContent();
        if (outputContent.size() == 0) {
            return null;
        }
        return String.format(plotNotificationFormat, StringMgmt.join(outputContent, plotNotficationSplitter));
    }

    public List<String> getPlotNotificationContent() {
        ArrayList<String> out = new ArrayList<String>();
        String output = this.getHomeblockNotification();
        if (output != null && output.length() > 0) {
            out.add(output);
        }
        if ((output = this.getOutpostblockNotification()) != null && output.length() > 0) {
            out.add(output);
        }
        if ((output = this.getForSaleNotification()) != null && output.length() > 0) {
            out.add(output);
        }
        if ((output = this.getPlotTypeNotification()) != null && output.length() > 0) {
            out.add(output);
        }
        return out;
    }

    public String getHomeblockNotification() {
        if (this.toHomeBlock) {
            return homeBlockNotification;
        }
        return null;
    }

    public String getOutpostblockNotification() {
        if (this.toOutpostBlock) {
            return outpostBlockNotification;
        }
        return null;
    }

    public String getForSaleNotification() {
        if (this.toForSale) {
            return String.format(forSaleNotificationFormat, TownyEconomyHandler.getFormattedBalance(this.toTownBlock.getPlotPrice()));
        }
        return null;
    }

    public String getPlotTypeNotification() {
        if (this.fromPlotType != this.toPlotType && this.toPlotType != null && this.toPlotType != TownBlockType.RESIDENTIAL) {
            return String.format(plotTypeNotificationFormat, this.toPlotType.toString());
        }
        return null;
    }
}

