/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.earth2me.essentials.Essentials;
import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.metrics.Metrics;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownyPlaceholderExpansion;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.chat.TNCRegister;
import com.palmergames.bukkit.towny.command.InviteCommand;
import com.palmergames.bukkit.towny.command.NationCommand;
import com.palmergames.bukkit.towny.command.PlotCommand;
import com.palmergames.bukkit.towny.command.ResidentCommand;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.command.TownyAdminCommand;
import com.palmergames.bukkit.towny.command.TownyCommand;
import com.palmergames.bukkit.towny.command.TownyWorldCommand;
import com.palmergames.bukkit.towny.command.commandobjects.AcceptCommand;
import com.palmergames.bukkit.towny.command.commandobjects.CancelCommand;
import com.palmergames.bukkit.towny.command.commandobjects.ConfirmCommand;
import com.palmergames.bukkit.towny.command.commandobjects.DenyCommand;
import com.palmergames.bukkit.towny.confirmations.ConfirmationHandler;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.huds.HUDManager;
import com.palmergames.bukkit.towny.invites.InviteHandler;
import com.palmergames.bukkit.towny.listeners.TownyBlockListener;
import com.palmergames.bukkit.towny.listeners.TownyCustomListener;
import com.palmergames.bukkit.towny.listeners.TownyEntityListener;
import com.palmergames.bukkit.towny.listeners.TownyEntityMonitorListener;
import com.palmergames.bukkit.towny.listeners.TownyLoginListener;
import com.palmergames.bukkit.towny.listeners.TownyPlayerListener;
import com.palmergames.bukkit.towny.listeners.TownyVehicleListener;
import com.palmergames.bukkit.towny.listeners.TownyWeatherListener;
import com.palmergames.bukkit.towny.listeners.TownyWorldListener;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.permissions.BukkitPermSource;
import com.palmergames.bukkit.towny.permissions.GroupManagerSource;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.permissions.VaultPermSource;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import com.palmergames.bukkit.towny.utils.SpawnUtil;
import com.palmergames.bukkit.towny.war.flagwar.TownyWar;
import com.palmergames.bukkit.towny.war.flagwar.listeners.TownyWarBlockListener;
import com.palmergames.bukkit.towny.war.flagwar.listeners.TownyWarCustomListener;
import com.palmergames.bukkit.towny.war.flagwar.listeners.TownyWarEntityListener;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.JavaUtil;
import com.palmergames.util.StringMgmt;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.permission.Permission;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class Towny
extends JavaPlugin {
    private static final Logger LOGGER = LogManager.getLogger((String)"com.palmergames.bukkit.towny");
    private String version = "2.0.0";
    private final TownyPlayerListener playerListener = new TownyPlayerListener(this);
    private final TownyVehicleListener vehicleListener = new TownyVehicleListener(this);
    private final TownyBlockListener blockListener = new TownyBlockListener(this);
    private final TownyCustomListener customListener = new TownyCustomListener(this);
    private final TownyEntityListener entityListener = new TownyEntityListener(this);
    private final TownyWeatherListener weatherListener = new TownyWeatherListener(this);
    private final TownyEntityMonitorListener entityMonitorListener = new TownyEntityMonitorListener(this);
    private final TownyWorldListener worldListener = new TownyWorldListener();
    private final TownyWarBlockListener townyWarBlockListener = new TownyWarBlockListener(this);
    private final TownyWarCustomListener townyWarCustomListener = new TownyWarCustomListener(this);
    private final TownyWarEntityListener townyWarEntityListener = new TownyWarEntityListener();
    private final TownyLoginListener loginListener = new TownyLoginListener();
    private final HUDManager HUDManager = new HUDManager(this);
    private TownyUniverse townyUniverse;
    private Map<String, PlayerCache> playerCache = Collections.synchronizedMap(new HashMap());
    private Essentials essentials = null;
    private boolean citizens2 = false;
    public static boolean isSpigot = false;
    private boolean error = false;
    private static Towny plugin;

    public Towny() {
        plugin = this;
    }

    public void onEnable() {
        System.out.println("====================      Towny      ========================");
        this.version = this.getDescription().getVersion();
        this.townyUniverse = TownyUniverse.getInstance();
        isSpigot = BukkitTools.isSpigot();
        BukkitTools.initialize(this);
        TownyTimerHandler.initialize(this);
        TownyEconomyHandler.initialize(this);
        TownyFormatter.initialize(this);
        TownyRegenAPI.initialize(this);
        PlayerCacheUtil.initialize(this);
        SpawnUtil.initialize(this);
        TownyPerms.initialize(this);
        InviteHandler.initialize(this);
        ConfirmationHandler.initialize(this);
        if (this.load()) {
            this.registerSpecialCommands();
            this.getCommand("townyadmin").setExecutor((CommandExecutor)new TownyAdminCommand(this));
            this.getCommand("townyworld").setExecutor((CommandExecutor)new TownyWorldCommand(this));
            this.getCommand("resident").setExecutor((CommandExecutor)new ResidentCommand(this));
            this.getCommand("towny").setExecutor((CommandExecutor)new TownyCommand(this));
            this.getCommand("town").setExecutor((CommandExecutor)new TownCommand(this));
            this.getCommand("nation").setExecutor((CommandExecutor)new NationCommand(this));
            this.getCommand("plot").setExecutor((CommandExecutor)new PlotCommand(this));
            this.getCommand("invite").setExecutor((CommandExecutor)new InviteCommand(this));
            this.addMetricsCharts();
            TownyWar.onEnable();
            if (TownySettings.isTownyUpdating(this.getVersion())) {
                this.update();
            }
            TownyPerms.registerPermissionNodes();
        }
        this.registerEvents();
        System.out.println("=============================================================");
        if (this.isError()) {
            System.out.println("[WARNING] - ***** SAFE MODE ***** " + this.version);
        } else {
            System.out.println("[Towny] Version: " + this.version + " - Mod Enabled");
        }
        System.out.println("=============================================================");
        if (!this.isError()) {
            for (Player player : BukkitTools.getOnlinePlayers()) {
                if (player == null) continue;
                this.townyUniverse.onLogin(player);
            }
        }
    }

    public void setWorldFlags() {
        TownyUniverse universe = TownyUniverse.getInstance();
        for (Town town : universe.getDataSource().getTowns()) {
            if (town.getWorld() != null) continue;
            LOGGER.warn("[Towny Error] Detected an error with the world files. Attempting to repair");
            if (town.hasHomeBlock()) {
                try {
                    TownyWorld world = town.getHomeBlock().getWorld();
                    if (world.hasTown(town)) continue;
                    world.addTown(town);
                    universe.getDataSource().saveTown(town);
                    universe.getDataSource().saveWorld(world);
                }
                catch (TownyException e) {
                    LOGGER.warn("[Towny Error] Failed get world data for: " + town.getName());
                }
                continue;
            }
            LOGGER.warn("[Towny Error] No Homeblock - Failed to detect world for: " + town.getName());
        }
    }

    public void onDisable() {
        System.out.println("==============================================================");
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (townyUniverse.getDataSource() != null && !this.error) {
            townyUniverse.getDataSource().saveQueues();
        }
        if (!this.error) {
            TownyWar.onDisable();
        }
        if (TownyAPI.getInstance().isWarTime()) {
            TownyUniverse.getInstance().getWarEvent().toggleEnd();
        }
        TownyTimerHandler.toggleTownyRepeatingTimer(false);
        TownyTimerHandler.toggleDailyTimer(false);
        TownyTimerHandler.toggleMobRemoval(false);
        TownyTimerHandler.toggleHealthRegen(false);
        TownyTimerHandler.toggleTeleportWarmup(false);
        TownyTimerHandler.toggleDrawSmokeTask(false);
        TownyRegenAPI.cancelProtectionRegenTasks();
        this.playerCache.clear();
        try {
            townyUniverse.getDataSource().cancelTask();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.townyUniverse = null;
        System.out.println("[Towny] Version: " + this.version + " - Mod Disabled");
        System.out.println("=============================================================");
    }

    public boolean load() {
        if (!this.townyUniverse.loadSettings()) {
            this.setError(true);
            return false;
        }
        this.checkPlugins();
        this.setWorldFlags();
        TownyTimerHandler.toggleTownyRepeatingTimer(false);
        TownyTimerHandler.toggleDailyTimer(false);
        TownyTimerHandler.toggleMobRemoval(false);
        TownyTimerHandler.toggleHealthRegen(false);
        TownyTimerHandler.toggleTeleportWarmup(false);
        TownyTimerHandler.toggleCooldownTimer(false);
        TownyTimerHandler.toggleDrawSmokeTask(false);
        TownyTimerHandler.toggleTownyRepeatingTimer(true);
        TownyTimerHandler.toggleDailyTimer(true);
        TownyTimerHandler.toggleMobRemoval(true);
        TownyTimerHandler.toggleHealthRegen(TownySettings.hasHealthRegen());
        TownyTimerHandler.toggleTeleportWarmup(TownySettings.getTeleportWarmupTime() > 0);
        TownyTimerHandler.toggleCooldownTimer(TownySettings.getPVPCoolDownTime() > 0 || TownySettings.getSpawnCooldownTime() > 0);
        TownyTimerHandler.toggleDrawSmokeTask(true);
        this.resetCache();
        return true;
    }

    private void checkPlugins() {
        ArrayList<String> using = new ArrayList<String>();
        Plugin test = this.getServer().getPluginManager().getPlugin("GroupManager");
        if (test != null) {
            TownyUniverse.getInstance().setPermissionSource(new GroupManagerSource(this, test));
            using.add(String.format("%s v%s", "GroupManager", test.getDescription().getVersion()));
        } else {
            test = this.getServer().getPluginManager().getPlugin("Vault");
            if (test != null) {
                Chat chat = (Chat)this.getServer().getServicesManager().load(Chat.class);
                if (chat == null) {
                    test = null;
                } else {
                    TownyUniverse.getInstance().setPermissionSource(new VaultPermSource(this, chat));
                    RegisteredServiceProvider vaultPermProvider = plugin.getServer().getServicesManager().getRegistration(Permission.class);
                    if (vaultPermProvider != null) {
                        using.add(vaultPermProvider.getPlugin().getName() + " " + vaultPermProvider.getPlugin().getDescription().getVersion() + " via Vault " + test.getDescription().getVersion());
                    } else {
                        using.add(String.format("%s v%s", "Vault", test.getDescription().getVersion()));
                    }
                }
            }
            if (test == null) {
                TownyUniverse.getInstance().setPermissionSource(new BukkitPermSource(this));
                using.add("BukkitPermissions");
            }
        }
        if (TownySettings.isUsingEconomy()) {
            if (TownyEconomyHandler.setupEconomy().booleanValue()) {
                using.add(TownyEconomyHandler.getVersion());
            } else {
                TownyMessaging.sendErrorMsg("No compatible Economy plugins found. Install Vault.jar with any of the supported eco systems.");
                TownyMessaging.sendErrorMsg("If you do not want an economy to be used, set using_economy: false in your Towny config.yml.");
            }
        }
        if ((test = this.getServer().getPluginManager().getPlugin("Essentials")) == null) {
            TownySettings.setUsingEssentials(false);
        } else if (TownySettings.isUsingEssentials()) {
            this.essentials = (Essentials)test;
            using.add(String.format("%s v%s", "Essentials", test.getDescription().getVersion()));
        }
        test = this.getServer().getPluginManager().getPlugin("Questioner");
        if (test != null) {
            TownyMessaging.sendErrorMsg("Questioner.jar present on server, Towny no longer requires Questioner for invites/confirmations.");
            TownyMessaging.sendErrorMsg("You may safely remove Questioner.jar from your plugins folder.");
        }
        if ((test = this.getServer().getPluginManager().getPlugin("Citizens")) != null && this.getServer().getPluginManager().getPlugin("Citizens").isEnabled()) {
            this.citizens2 = test.getDescription().getVersion().startsWith("2");
        }
        if ((test = this.getServer().getPluginManager().getPlugin("PlaceholderAPI")) != null) {
            new TownyPlaceholderExpansion(this).register();
            using.add(String.format("%s v%s", "PlaceholderAPI", test.getDescription().getVersion()));
        }
        if (using.size() > 0) {
            System.out.println("[Towny] Using: " + StringMgmt.join(using, ", "));
        }
        if (Bukkit.getPluginManager().isPluginEnabled("TheNewChat")) {
            TNCRegister.initialize();
        }
    }

    private void registerEvents() {
        PluginManager pluginManager = this.getServer().getPluginManager();
        if (!this.isError()) {
            pluginManager.registerEvents((Listener)this.townyWarBlockListener, (Plugin)this);
            pluginManager.registerEvents((Listener)this.townyWarEntityListener, (Plugin)this);
            pluginManager.registerEvents((Listener)this.HUDManager, (Plugin)this);
            pluginManager.registerEvents((Listener)this.entityMonitorListener, (Plugin)this);
            pluginManager.registerEvents((Listener)this.vehicleListener, (Plugin)this);
            pluginManager.registerEvents((Listener)this.weatherListener, (Plugin)this);
            pluginManager.registerEvents((Listener)this.townyWarCustomListener, (Plugin)this);
            pluginManager.registerEvents((Listener)this.customListener, (Plugin)this);
            pluginManager.registerEvents((Listener)this.worldListener, (Plugin)this);
            pluginManager.registerEvents((Listener)this.loginListener, (Plugin)this);
        }
        pluginManager.registerEvents((Listener)this.playerListener, (Plugin)this);
        pluginManager.registerEvents((Listener)this.blockListener, (Plugin)this);
        pluginManager.registerEvents((Listener)this.entityListener, (Plugin)this);
    }

    private void update() {
        try {
            List<String> changeLog = JavaUtil.readTextFromJar("/ChangeLog.txt");
            boolean display = false;
            System.out.println("------------------------------------");
            System.out.println("[Towny] ChangeLog up until v" + this.getVersion());
            String lastVersion = TownySettings.getLastRunVersion(this.getVersion()).split("_")[0];
            for (String line : changeLog) {
                if (line.startsWith(lastVersion)) {
                    display = true;
                }
                if (!display || line.replaceAll(" ", "").replaceAll("\t", "").length() <= 0) continue;
                System.out.println(line);
            }
            System.out.println("------------------------------------");
        }
        catch (IOException e) {
            TownyMessaging.sendDebugMsg("Could not read ChangeLog.txt");
        }
        TownySettings.setLastRunVersion(this.getVersion());
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        townyUniverse.getDataSource().saveAll();
        townyUniverse.getDataSource().cleanup();
    }

    public TownyUniverse getTownyUniverse() {
        return this.townyUniverse;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isError() {
        return this.error;
    }

    protected void setError(boolean error) {
        this.error = error;
    }

    public boolean isEssentials() {
        return TownySettings.isUsingEssentials() && this.essentials != null;
    }

    public boolean isCitizens2() {
        return this.citizens2;
    }

    public Essentials getEssentials() throws TownyException {
        if (this.essentials == null) {
            throw new TownyException("Essentials is not installed, or not enabled!");
        }
        return this.essentials;
    }

    public World getServerWorld(String name) throws NotRegisteredException {
        for (World world : BukkitTools.getWorlds()) {
            if (!world.getName().equals(name)) continue;
            return world;
        }
        throw new NotRegisteredException(String.format("A world called '$%s' has not been registered.", name));
    }

    public boolean hasCache(Player player) {
        return this.playerCache.containsKey(player.getName().toLowerCase());
    }

    public void newCache(Player player) {
        try {
            this.playerCache.put(player.getName().toLowerCase(), new PlayerCache(TownyUniverse.getInstance().getDataSource().getWorld(player.getWorld().getName()), player));
        }
        catch (NotRegisteredException e) {
            TownyMessaging.sendErrorMsg((Object)player, "Could not create permission cache for this world (" + player.getWorld().getName() + ".");
        }
    }

    public void deleteCache(Player player) {
        this.deleteCache(player.getName());
    }

    public void deleteCache(String name) {
        this.playerCache.remove(name.toLowerCase());
    }

    public PlayerCache getCache(Player player) {
        if (!this.hasCache(player)) {
            this.newCache(player);
            this.getCache(player).setLastTownBlock(new WorldCoord(player.getWorld().getName(), Coord.parseCoord((Entity)player)));
        }
        return this.playerCache.get(player.getName().toLowerCase());
    }

    public void resetCache() {
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null) continue;
            this.getCache(player).resetAndUpdate(new WorldCoord(player.getWorld().getName(), Coord.parseCoord((Entity)player)));
        }
    }

    public void updateCache(WorldCoord worldCoord) {
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null || !Coord.parseCoord((Entity)player).equals(worldCoord)) continue;
            this.getCache(player).resetAndUpdate(worldCoord);
        }
    }

    public void updateCache() {
        WorldCoord worldCoord = null;
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null) continue;
            worldCoord = new WorldCoord(player.getWorld().getName(), Coord.parseCoord((Entity)player));
            PlayerCache cache = this.getCache(player);
            if (cache.getLastTownBlock() == worldCoord) continue;
            cache.resetAndUpdate(worldCoord);
        }
    }

    public void updateCache(Player player) {
        WorldCoord worldCoord = new WorldCoord(player.getWorld().getName(), Coord.parseCoord((Entity)player));
        PlayerCache cache = this.getCache(player);
        if (cache.getLastTownBlock() != worldCoord) {
            cache.resetAndUpdate(worldCoord);
        }
    }

    public void resetCache(Player player) {
        this.getCache(player).resetAndUpdate(new WorldCoord(player.getWorld().getName(), Coord.parseCoord((Entity)player)));
    }

    public void setPlayerMode(Player player, String[] modes, boolean notify) {
        if (player == null) {
            return;
        }
        try {
            Resident resident = TownyUniverse.getInstance().getDataSource().getResident(player.getName());
            resident.setModes(modes, notify);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
    }

    public void removePlayerMode(Player player) {
        try {
            Resident resident = TownyUniverse.getInstance().getDataSource().getResident(player.getName());
            resident.clearModes();
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
    }

    public List<String> getPlayerMode(Player player) {
        return this.getPlayerMode(player.getName());
    }

    public List<String> getPlayerMode(String name) {
        try {
            Resident resident = TownyUniverse.getInstance().getDataSource().getResident(name);
            return resident.getModes();
        }
        catch (NotRegisteredException e) {
            return null;
        }
    }

    public boolean hasPlayerMode(Player player, String mode) {
        return this.hasPlayerMode(player.getName(), mode);
    }

    public boolean hasPlayerMode(String name, String mode) {
        try {
            Resident resident = TownyUniverse.getInstance().getDataSource().getResident(name);
            return resident.hasMode(mode);
        }
        catch (NotRegisteredException e) {
            return false;
        }
    }

    public String getConfigPath() {
        return this.getDataFolder().getPath() + File.separator + "settings" + File.separator + "config.yml";
    }

    public Object getSetting(String root) {
        return TownySettings.getProperty(root);
    }

    public void log(String msg) {
        if (TownySettings.isLogging()) {
            LOGGER.info(ChatColor.stripColor((String)msg));
        }
    }

    public boolean parseOnOff(String s) throws Exception {
        if (s.equalsIgnoreCase("on")) {
            return true;
        }
        if (s.equalsIgnoreCase("off")) {
            return false;
        }
        throw new Exception(String.format(TownySettings.getLangString("msg_err_invalid_input"), " on/off."));
    }

    public static Towny getPlugin() {
        return plugin;
    }

    public TownyPlayerListener getPlayerListener() {
        return this.playerListener;
    }

    public TownyVehicleListener getVehicleListener() {
        return this.vehicleListener;
    }

    public TownyEntityListener getEntityListener() {
        return this.entityListener;
    }

    public TownyWeatherListener getWeatherListener() {
        return this.weatherListener;
    }

    public TownyEntityMonitorListener getEntityMonitorListener() {
        return this.entityMonitorListener;
    }

    public TownyWorldListener getWorldListener() {
        return this.worldListener;
    }

    public TownyWarBlockListener getTownyWarBlockListener() {
        return this.townyWarBlockListener;
    }

    public TownyWarCustomListener getTownyWarCustomListener() {
        return this.townyWarCustomListener;
    }

    public TownyWarEntityListener getTownyWarEntityListener() {
        return this.townyWarEntityListener;
    }

    public HUDManager getHUDManager() {
        return this.HUDManager;
    }

    private void registerSpecialCommands() {
        ArrayList<BukkitCommand> commands = new ArrayList<BukkitCommand>();
        commands.add(new AcceptCommand(TownySettings.getAcceptCommand()));
        commands.add(new DenyCommand(TownySettings.getDenyCommand()));
        commands.add(new ConfirmCommand(TownySettings.getConfirmCommand()));
        commands.add(new CancelCommand(TownySettings.getCancelCommand()));
        try {
            Field bukkitCommandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            bukkitCommandMap.setAccessible(true);
            CommandMap commandMap = (CommandMap)bukkitCommandMap.get(Bukkit.getServer());
            commandMap.registerAll("towny", commands);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    private void addMetricsCharts() {
        Metrics metrics = new Metrics((Plugin)this);
        metrics.addCustomChart(new Metrics.SimplePie("language", new Callable<String>(){

            @Override
            public String call() throws Exception {
                return TownySettings.getString(ConfigNodes.LANGUAGE);
            }
        }));
        metrics.addCustomChart(new Metrics.SimplePie("server_type", new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (Bukkit.getServer().getName().equalsIgnoreCase("paper")) {
                    return "Paper";
                }
                if (Bukkit.getServer().getName().equalsIgnoreCase("craftbukkit")) {
                    if (isSpigot) {
                        return "Spigot";
                    }
                    return "CraftBukkit";
                }
                return "Unknown";
            }
        }));
        metrics.addCustomChart(new Metrics.SimplePie("nation_zones_enabled", new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (TownySettings.getNationZonesEnabled()) {
                    return "true";
                }
                return "false";
            }
        }));
        metrics.addCustomChart(new Metrics.SimplePie("database_type", new Callable<String>(){

            @Override
            public String call() throws Exception {
                return TownySettings.getSaveDatabase();
            }
        }));
    }
}

