/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.db.TownyDataSource;
import com.palmergames.bukkit.towny.exceptions.KeyAlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.permissions.TownyPermissionSource;
import com.palmergames.bukkit.towny.tasks.TeleportWarmupTimerTask;
import com.palmergames.bukkit.towny.war.eventwar.War;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class TownyAPI {
    private static TownyAPI instance;
    private final Towny towny = Towny.getPlugin();
    private final TownyUniverse townyUniverse = TownyUniverse.getInstance();

    private TownyAPI() {
    }

    public Location getTownSpawnLocation(Player player) {
        try {
            Resident resident = this.townyUniverse.getDataSource().getResident(player.getName());
            Town town = resident.getTown();
            return town.getSpawn();
        }
        catch (TownyException x) {
            return null;
        }
    }

    public Location getNationSpawnLocation(Player player) {
        try {
            Resident resident = this.townyUniverse.getDataSource().getResident(player.getName());
            Nation nation = resident.getTown().getNation();
            return nation.getNationSpawn();
        }
        catch (TownyException x) {
            return null;
        }
    }

    public Player getPlayer(Resident resident) {
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null || !player.getName().equals(resident.getName())) continue;
            return player;
        }
        return null;
    }

    public UUID getPlayerUUID(Resident resident) {
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null || !player.getName().equals(resident.getName())) continue;
            return player.getUniqueId();
        }
        return null;
    }

    public List<Player> getOnlinePlayers(ResidentList residentList) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null || !residentList.hasResident(player.getName())) continue;
            players.add(player);
        }
        return players;
    }

    public List<Player> getOnlinePlayers(Town town) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null || !town.hasResident(player.getName())) continue;
            players.add(player);
        }
        return players;
    }

    public List<Player> getOnlinePlayers(Nation nation) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (Town town : nation.getTowns()) {
            players.addAll(this.getOnlinePlayers(town));
        }
        return players;
    }

    public List<Player> getOnlinePlayersAlliance(Nation nation) {
        ArrayList<Player> players = new ArrayList<Player>();
        players.addAll(this.getOnlinePlayers(nation));
        if (!nation.getAllies().isEmpty()) {
            for (Nation nations : nation.getAllies()) {
                players.addAll(this.getOnlinePlayers(nations));
            }
        }
        return players;
    }

    @Deprecated
    public boolean isWilderness(Block block) {
        WorldCoord worldCoord;
        try {
            worldCoord = new WorldCoord(this.townyUniverse.getDataSource().getWorld(block.getWorld().getName()).getName(), Coord.parseCoord(block));
        }
        catch (NotRegisteredException e) {
            return true;
        }
        try {
            return worldCoord.getTownBlock().getTown() == null;
        }
        catch (NotRegisteredException e) {
            return true;
        }
    }

    public boolean isWilderness(Location location) {
        WorldCoord worldCoord;
        try {
            worldCoord = new WorldCoord(this.townyUniverse.getDataSource().getWorld(location.getWorld().getName()).getName(), Coord.parseCoord(location));
        }
        catch (NotRegisteredException e) {
            return true;
        }
        try {
            return worldCoord.getTownBlock().getTown() == null;
        }
        catch (NotRegisteredException e) {
            return true;
        }
    }

    public boolean isTownyWorld(World world) {
        try {
            return this.townyUniverse.getDataSource().getWorld(world.getName()).isUsingTowny();
        }
        catch (NotRegisteredException e) {
            return false;
        }
    }

    public String getTownName(Location location) {
        try {
            WorldCoord worldCoord = new WorldCoord(this.townyUniverse.getDataSource().getWorld(location.getWorld().getName()).getName(), Coord.parseCoord(location));
            return worldCoord.getTownBlock().getTown().getName();
        }
        catch (NotRegisteredException e) {
            return null;
        }
    }

    public UUID getTownUUID(Location location) {
        try {
            WorldCoord worldCoord = new WorldCoord(this.townyUniverse.getDataSource().getWorld(location.getWorld().getName()).getName(), Coord.parseCoord(location));
            return worldCoord.getTownBlock().getTown().getUuid();
        }
        catch (NotRegisteredException e) {
            return null;
        }
    }

    public TownBlock getTownBlock(Location location) {
        try {
            WorldCoord worldCoord = new WorldCoord(this.townyUniverse.getDataSource().getWorld(location.getWorld().getName()).getName(), Coord.parseCoord(location));
            return worldCoord.getTownBlock();
        }
        catch (NotRegisteredException e) {
            return null;
        }
    }

    public List<Resident> getActiveResidents() {
        ArrayList<Resident> activeResidents = new ArrayList<Resident>();
        for (Resident resident : this.townyUniverse.getDataSource().getResidents()) {
            if (!this.isActiveResident(resident)) continue;
            activeResidents.add(resident);
        }
        return activeResidents;
    }

    public boolean isActiveResident(Resident resident) {
        return System.currentTimeMillis() - resident.getLastOnline() < 20L * TownySettings.getInactiveAfter() || BukkitTools.isOnline(resident.getName());
    }

    public TownyDataSource getDataSource() {
        return this.townyUniverse.getDataSource();
    }

    public TownyPermissionSource getPermissionSource() {
        return this.townyUniverse.getPermissionSource();
    }

    public boolean isWarTime() {
        return this.townyUniverse.getWarEvent() != null && this.townyUniverse.getWarEvent().isWarTime();
    }

    public List<Resident> getOnlineResidents(ResidentList residentList) {
        ArrayList<Resident> onlineResidents = new ArrayList<Resident>();
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null) continue;
            for (Resident resident : residentList.getResidents()) {
                if (!resident.getName().equalsIgnoreCase(player.getName())) continue;
                onlineResidents.add(resident);
            }
        }
        return onlineResidents;
    }

    public void jailTeleport(Player player, Location location) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.towny, () -> player.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN), (long)(TownySettings.getTeleportWarmupTime() * 20));
    }

    public War getWarEvent() {
        return TownyUniverse.getInstance().getWarEvent();
    }

    public void clearWarEvent() {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        townyUniverse.getWarEvent().cancelTasks(BukkitTools.getScheduler());
        townyUniverse.setWarEvent(null);
    }

    public void requestTeleport(Player player, Location spawnLoc) {
        try {
            TeleportWarmupTimerTask.requestTeleport(this.getDataSource().getResident(player.getName().toLowerCase()), spawnLoc);
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
        }
    }

    public void abortTeleportRequest(Resident resident) {
        TeleportWarmupTimerTask.abortTeleportRequest(resident);
    }

    public void registerCustomDataField(CustomDataField field) throws KeyAlreadyRegisteredException {
        this.townyUniverse.addCustomCustomDataField(field);
    }

    public static TownyAPI getInstance() {
        if (instance == null) {
            instance = new TownyAPI();
        }
        return instance;
    }
}

