/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Compass;
import org.bukkit.entity.Player;

public class TownyAsciiMap {
    public static final int lineWidth = 27;
    public static final int halfLineWidth = 13;
    public static final String[] help = new String[]{"  \u00a78-\u00a77 = " + TownySettings.getLangString("towny_map_unclaimed"), "  \u00a7f+\u00a77 = " + TownySettings.getLangString("towny_map_claimed"), "  \u00a7f$\u00a77 = " + TownySettings.getLangString("towny_map_forsale"), "  \u00a7a+\u00a77 = " + TownySettings.getLangString("towny_map_yourtown"), "  \u00a7e+\u00a77 = " + TownySettings.getLangString("towny_map_yourplot"), "  \u00a72+\u00a77 = " + TownySettings.getLangString("towny_map_ally"), "  \u00a74+\u00a77 = " + TownySettings.getLangString("towny_map_enemy")};

    public static String[] generateCompass(Player player) {
        Compass.Point dir = Compass.getCompassPointForDirection(player.getLocation().getYaw());
        return new String[]{"\u00a70  -----  ", "\u00a70  -" + (dir == Compass.Point.NW ? "\u00a76\\" : "-") + (dir == Compass.Point.N ? "\u00a76" : "\u00a7f") + "N" + (dir == Compass.Point.NE ? "\u00a76/\u00a70" : "\u00a70-") + "-  ", "\u00a70  -" + (dir == Compass.Point.W ? "\u00a76W" : "\u00a7fW") + "\u00a77" + "+" + (dir == Compass.Point.E ? "\u00a76" : "\u00a7f") + "E" + "\u00a70" + "-  ", "\u00a70  -" + (dir == Compass.Point.SW ? "\u00a76/" : "-") + (dir == Compass.Point.S ? "\u00a76" : "\u00a7f") + "S" + (dir == Compass.Point.SE ? "\u00a76\\\u00a70" : "\u00a70-") + "-  "};
    }

    public static void generateAndSend(Towny plugin, Player player, int lineHeight) {
        TownyWorld world;
        Resident resident;
        boolean hasTown = false;
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        try {
            resident = townyUniverse.getDataSource().getResident(player.getName());
            if (resident.hasTown()) {
                hasTown = true;
            }
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        try {
            world = townyUniverse.getDataSource().getWorld(player.getWorld().getName());
        }
        catch (NotRegisteredException e1) {
            TownyMessaging.sendErrorMsg((Object)player, "You are not in a registered world.");
            return;
        }
        if (!world.isUsingTowny()) {
            TownyMessaging.sendErrorMsg((Object)player, "This world is not using towny.");
            return;
        }
        Coord pos = Coord.parseCoord(plugin.getCache(player).getLastLocation());
        int halfLineHeight = lineHeight / 2;
        String[][] townyMap = new String[27][lineHeight];
        int y = 0;
        for (int tby = pos.getX() + 13; tby >= pos.getX() - 13; --tby) {
            int x = 0;
            for (int tbx = pos.getZ() - halfLineHeight; tbx <= pos.getZ() + (lineHeight - halfLineHeight - 1); ++tbx) {
                try {
                    TownBlock townblock = world.getTownBlock(tby, tbx);
                    if (!townblock.hasTown()) {
                        throw new TownyException();
                    }
                    if (x == halfLineHeight && y == 13) {
                        townyMap[y][x] = "\u00a76";
                    } else if (hasTown) {
                        if (resident.getTown() == townblock.getTown()) {
                            townyMap[y][x] = "\u00a7a";
                            try {
                                if (resident == townblock.getResident()) {
                                    townyMap[y][x] = "\u00a7e";
                                }
                            }
                            catch (NotRegisteredException notRegisteredException) {}
                        } else {
                            Nation nation;
                            townyMap[y][x] = resident.hasNation() ? (resident.getTown().getNation().hasTown(townblock.getTown()) ? "\u00a72" : (townblock.getTown().hasNation() ? ((nation = resident.getTown().getNation()).hasAlly(townblock.getTown().getNation()) ? "\u00a72" : (nation.hasEnemy(townblock.getTown().getNation()) ? "\u00a74" : "\u00a7f")) : "\u00a7f")) : "\u00a7f";
                        }
                    } else {
                        townyMap[y][x] = "\u00a7f";
                    }
                    if (townblock.getPlotPrice() != -1.0) {
                        if (townblock.getType().equals((Object)TownBlockType.COMMERCIAL)) {
                            townyMap[y][x] = "\u00a73";
                        }
                        String[] stringArray = townyMap[y];
                        int n = x;
                        stringArray[n] = stringArray[n] + "$";
                    } else if (townblock.isHomeBlock()) {
                        String[] stringArray = townyMap[y];
                        int n = x;
                        stringArray[n] = stringArray[n] + "H";
                    } else {
                        String[] stringArray = townyMap[y];
                        int n = x;
                        stringArray[n] = stringArray[n] + townblock.getType().getAsciiMapKey();
                    }
                }
                catch (TownyException e) {
                    townyMap[y][x] = x == halfLineHeight && y == 13 ? "\u00a76" : "\u00a78";
                    String[] stringArray = townyMap[y];
                    int n = x;
                    stringArray[n] = stringArray[n] + "-";
                }
                ++x;
            }
            ++y;
        }
        String[] compass = TownyAsciiMap.generateCompass(player);
        player.sendMessage(ChatTools.formatTitle(TownySettings.getLangString("towny_map_header") + "\u00a7f" + "(" + pos.toString() + ")"));
        int lineCount = 0;
        for (int my = 0; my < lineHeight; ++my) {
            String line = compass[0];
            if (lineCount < compass.length) {
                line = compass[lineCount];
            }
            for (int mx = 26; mx >= 0; --mx) {
                line = line + townyMap[mx][my];
            }
            if (lineCount < help.length) {
                line = line + help[lineCount];
            }
            player.sendMessage(line);
            ++lineCount;
        }
        try {
            TownBlock townblock = world.getTownBlock(pos);
            TownyMessaging.sendMsg((Object)player, TownySettings.getLangString("town_sing") + ": " + (townblock.hasTown() ? townblock.getTown().getName() : TownySettings.getLangString("status_no_town")) + " : " + TownySettings.getLangString("owner_status") + ": " + (townblock.hasResident() ? townblock.getResident().getName() : TownySettings.getLangString("status_no_town")));
        }
        catch (TownyException e) {
            player.sendMessage("");
        }
    }
}

