/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.event.TownyPreTransactionEvent;
import com.palmergames.bukkit.towny.event.TownyTransactionEvent;
import com.palmergames.bukkit.towny.object.Transaction;
import com.palmergames.bukkit.towny.object.TransactionType;
import com.palmergames.bukkit.util.BukkitTools;
import java.math.BigDecimal;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import net.tnemc.core.Reserve;
import net.tnemc.core.economy.EconomyAPI;
import net.tnemc.core.economy.ExtendedEconomyAPI;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class TownyEconomyHandler {
    private static Towny plugin = null;
    private static Economy vaultEconomy = null;
    private static EconomyAPI reserveEconomy = null;
    private static EcoType Type = EcoType.NONE;
    private static String version = "";

    public static void initialize(Towny plugin) {
        TownyEconomyHandler.plugin = plugin;
    }

    public static EcoType getType() {
        return Type;
    }

    public static boolean isActive() {
        return Type != EcoType.NONE;
    }

    public static String getVersion() {
        return version;
    }

    private static void setVersion(String version) {
        TownyEconomyHandler.version = version;
    }

    public static Boolean setupEconomy() {
        Plugin economyProvider = null;
        try {
            RegisteredServiceProvider vaultEcoProvider = plugin.getServer().getServicesManager().getRegistration(Economy.class);
            if (vaultEcoProvider != null) {
                vaultEconomy = (Economy)vaultEcoProvider.getProvider();
                TownyEconomyHandler.setVersion(String.format("%s %s", ((Economy)vaultEcoProvider.getProvider()).getName(), "via Vault"));
                Type = EcoType.VAULT;
                return true;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        economyProvider = plugin.getServer().getPluginManager().getPlugin("Reserve");
        if (economyProvider != null && ((Reserve)economyProvider).economyProvided()) {
            reserveEconomy = ((Reserve)economyProvider).economy();
            TownyEconomyHandler.setVersion(String.format("%s %s", reserveEconomy.name(), "via Reserve"));
            Type = EcoType.RESERVE;
            return true;
        }
        return false;
    }

    private static Object getEconomyAccount(String accountName) {
        switch (Type) {
            case RESERVE: {
                if (!(reserveEconomy instanceof ExtendedEconomyAPI)) break;
                return ((ExtendedEconomyAPI)reserveEconomy).getAccount(accountName);
            }
        }
        return null;
    }

    public static boolean hasEconomyAccount(String accountName) {
        switch (Type) {
            case RESERVE: {
                return reserveEconomy.hasAccount(accountName);
            }
            case VAULT: {
                return vaultEconomy.hasAccount(accountName);
            }
        }
        return false;
    }

    public static boolean hasEconomyAccount(UUID uniqueId) {
        switch (Type) {
            case RESERVE: {
                return reserveEconomy.hasAccount(uniqueId);
            }
            case VAULT: {
                return vaultEconomy.hasAccount(Bukkit.getOfflinePlayer((UUID)uniqueId));
            }
        }
        return false;
    }

    public static void removeAccount(String accountName) {
        try {
            switch (Type) {
                case RESERVE: {
                    reserveEconomy.deleteAccount(accountName);
                    break;
                }
                case VAULT: {
                    if (!vaultEconomy.hasAccount(accountName)) {
                        vaultEconomy.createPlayerAccount(accountName);
                    }
                    vaultEconomy.withdrawPlayer(accountName, vaultEconomy.getBalance(accountName));
                    return;
                }
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public static double getBalance(String accountName, World world) {
        switch (Type) {
            case RESERVE: {
                if (!reserveEconomy.hasAccount(accountName)) {
                    reserveEconomy.createAccount(accountName);
                }
                return reserveEconomy.getHoldings(accountName, world.getName()).doubleValue();
            }
            case VAULT: {
                if (!vaultEconomy.hasAccount(accountName)) {
                    vaultEconomy.createPlayerAccount(accountName);
                }
                return vaultEconomy.getBalance(accountName);
            }
        }
        return 0.0;
    }

    public static boolean hasEnough(String accountName, Double amount, World world) {
        return TownyEconomyHandler.getBalance(accountName, world) >= amount;
    }

    public static boolean subtract(String accountName, Double amount, World world) {
        Player player = Bukkit.getServer().getPlayer(accountName);
        Transaction transaction = new Transaction(TransactionType.SUBTRACT, player, amount.intValue());
        TownyTransactionEvent event = new TownyTransactionEvent(transaction);
        TownyPreTransactionEvent preEvent = new TownyPreTransactionEvent(transaction);
        BukkitTools.getPluginManager().callEvent((Event)preEvent);
        if (preEvent.isCancelled()) {
            TownyMessaging.sendErrorMsg((Object)player, preEvent.getCancelMessage());
            return false;
        }
        switch (Type) {
            case RESERVE: {
                if (!reserveEconomy.hasAccount(accountName)) {
                    reserveEconomy.createAccount(accountName);
                }
                BukkitTools.getPluginManager().callEvent((Event)event);
                return reserveEconomy.removeHoldings(accountName, new BigDecimal(amount), world.getName());
            }
            case VAULT: {
                if (!vaultEconomy.hasAccount(accountName)) {
                    vaultEconomy.createPlayerAccount(accountName);
                }
                BukkitTools.getPluginManager().callEvent((Event)event);
                return TownyEconomyHandler.vaultEconomy.withdrawPlayer((String)accountName, (double)amount.doubleValue()).type == EconomyResponse.ResponseType.SUCCESS;
            }
        }
        return false;
    }

    public static boolean add(String accountName, Double amount, World world) {
        Player player = Bukkit.getServer().getPlayer(accountName);
        Transaction transaction = new Transaction(TransactionType.ADD, player, amount.intValue());
        TownyTransactionEvent event = new TownyTransactionEvent(transaction);
        TownyPreTransactionEvent preEvent = new TownyPreTransactionEvent(transaction);
        BukkitTools.getPluginManager().callEvent((Event)preEvent);
        if (preEvent.isCancelled()) {
            TownyMessaging.sendErrorMsg((Object)player, preEvent.getCancelMessage());
            return false;
        }
        switch (Type) {
            case RESERVE: {
                if (!reserveEconomy.hasAccount(accountName)) {
                    reserveEconomy.createAccount(accountName);
                }
                Bukkit.getPluginManager().callEvent((Event)event);
                return reserveEconomy.addHoldings(accountName, new BigDecimal(amount), world.getName());
            }
            case VAULT: {
                if (!vaultEconomy.hasAccount(accountName)) {
                    vaultEconomy.createPlayerAccount(accountName);
                }
                Bukkit.getPluginManager().callEvent((Event)event);
                return TownyEconomyHandler.vaultEconomy.depositPlayer((String)accountName, (double)amount.doubleValue()).type == EconomyResponse.ResponseType.SUCCESS;
            }
        }
        return false;
    }

    public static boolean setBalance(String accountName, Double amount, World world) {
        switch (Type) {
            case RESERVE: {
                if (!reserveEconomy.hasAccount(accountName)) {
                    reserveEconomy.createAccount(accountName);
                }
                return reserveEconomy.setHoldings(accountName, new BigDecimal(amount), world.getName());
            }
            case VAULT: {
                if (!vaultEconomy.hasAccount(accountName)) {
                    vaultEconomy.createPlayerAccount(accountName);
                }
                return TownyEconomyHandler.vaultEconomy.depositPlayer((String)accountName, (double)(amount.doubleValue() - TownyEconomyHandler.vaultEconomy.getBalance((String)accountName))).type == EconomyResponse.ResponseType.SUCCESS;
            }
        }
        return false;
    }

    public static String getFormattedBalance(double balance) {
        try {
            switch (Type) {
                case RESERVE: {
                    return reserveEconomy.format(new BigDecimal(balance));
                }
                case VAULT: {
                    return vaultEconomy.format(balance);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.format("%.2f", balance);
    }

    public static enum EcoType {
        NONE,
        VAULT,
        RESERVE;

    }
}

