/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.util.StringMgmt;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.bukkit.entity.Player;

public class TownyFormatter {
    public static final SimpleDateFormat lastOnlineFormat = new SimpleDateFormat("MMMMM dd '@' HH:mm");
    public static final SimpleDateFormat lastOnlineFormatIncludeYear = new SimpleDateFormat("MMMMM dd yyyy");
    public static final SimpleDateFormat registeredFormat = new SimpleDateFormat("MMM d yyyy");
    public static final String residentListPrefixFormat = "%3$s%1$s %4$s[%2$d]%3$s:%5$s ";
    public static final String embassyTownListPrefixFormat = "%3$s%1$s:%5$s ";

    public static void initialize(Towny plugin) {
    }

    public static List<String> getFormattedOnlineResidents(String prefix, ResidentList residentList, Player player) {
        List<Resident> onlineResidents = TownCommand.getOnlineResidentsViewable(player, residentList);
        return TownyFormatter.getFormattedResidents(prefix, onlineResidents);
    }

    public static List<String> getFormattedResidents(Town town) {
        ArrayList<String> out = new ArrayList<String>();
        String[] residents = TownyFormatter.getFormattedNames(town.getResidents().toArray(new Resident[0]));
        out.addAll(ChatTools.listArr(residents, "\u00a72" + TownySettings.getLangString("res_list") + " " + "\u00a7a" + "[" + town.getNumResidents() + "]" + "\u00a72" + ":" + "\u00a7f" + " "));
        return out;
    }

    public static List<String> getFormattedOutlaws(Town town) {
        ArrayList<String> out = new ArrayList<String>();
        String[] residents = TownyFormatter.getFormattedNames(town.getOutlaws().toArray(new Resident[0]));
        out.addAll(ChatTools.listArr(residents, TownySettings.getLangString("outlaws") + " "));
        return out;
    }

    public static List<String> getFormattedResidents(String prefix, List<Resident> residentList) {
        return ChatTools.listArr(TownyFormatter.getFormattedNames(residentList), String.format(residentListPrefixFormat, prefix, residentList.size(), TownySettings.getLangString("res_format_list_1"), TownySettings.getLangString("res_format_list_2"), TownySettings.getLangString("res_format_list_3")));
    }

    public static List<String> getFormattedTowns(String prefix, List<Town> townList) {
        Town[] arrayTowns = townList.toArray(new Town[0]);
        return ChatTools.listArr(TownyFormatter.getFormattedNames(arrayTowns), String.format(embassyTownListPrefixFormat, prefix, townList.size(), TownySettings.getLangString("res_format_list_1"), TownySettings.getLangString("res_format_list_2"), TownySettings.getLangString("res_format_list_3")));
    }

    public static String[] getFormattedNames(List<Resident> residentList) {
        return TownyFormatter.getFormattedNames(residentList.toArray(new Resident[0]));
    }

    public static String getTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("hh:mm aa");
        return sdf.format(System.currentTimeMillis());
    }

    public static List<String> getStatus(TownBlock townBlock) {
        List<String> out = new ArrayList<String>();
        try {
            Town town = townBlock.getTown();
            TownyWorld world = townBlock.getWorld();
            TownBlockOwner owner = townBlock.hasResident() ? townBlock.getResident() : townBlock.getTown();
            out.add(ChatTools.formatTitle(TownyFormatter.getFormattedName(owner) + (BukkitTools.isOnline(owner.getName()) ? TownySettings.getLangString("online") : "")));
            if (!townBlock.getType().equals((Object)TownBlockType.RESIDENTIAL)) {
                out.add(TownySettings.getLangString("status_plot_type") + townBlock.getType().toString());
            }
            out.add(TownySettings.getLangString("status_perm") + (owner instanceof Resident ? townBlock.getPermissions().getColourString().replace("n", "t") : townBlock.getPermissions().getColourString().replace("f", "r")));
            out.add(TownySettings.getLangString("status_perm") + (owner instanceof Resident ? townBlock.getPermissions().getColourString2().replace("n", "t") : townBlock.getPermissions().getColourString2().replace("f", "r")));
            out.add(TownySettings.getLangString("status_pvp") + (town.isPVP() || world.isForcePVP() || townBlock.getPermissions().pvp ? TownySettings.getLangString("status_on") : TownySettings.getLangString("status_off")) + TownySettings.getLangString("explosions") + (world.isForceExpl() || townBlock.getPermissions().explosion ? TownySettings.getLangString("status_on") : TownySettings.getLangString("status_off")) + TownySettings.getLangString("firespread") + (town.isFire() || world.isForceFire() || townBlock.getPermissions().fire ? TownySettings.getLangString("status_on") : TownySettings.getLangString("status_off")) + TownySettings.getLangString("mobspawns") + (town.hasMobs() || world.isForceTownMobs() || townBlock.getPermissions().mobs ? TownySettings.getLangString("status_on") : TownySettings.getLangString("status_off")));
        }
        catch (NotRegisteredException e) {
            out.add("Error: " + e.getMessage());
        }
        out = TownyFormatter.formatStatusScreens(out);
        return out;
    }

    public static List<String> getStatus(Resident resident, Player player) {
        List<String> out = new ArrayList<String>();
        out.add(ChatTools.formatTitle(TownyFormatter.getFormattedName(resident) + (BukkitTools.isOnline(resident.getName()) && player != null && player.canSee(BukkitTools.getPlayer(resident.getName())) ? TownySettings.getLangString("online2") : "")));
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(resident.getLastOnline());
        int currentYear = cal.get(1);
        cal.setTimeInMillis(System.currentTimeMillis());
        int lastOnlineYear = cal.get(1);
        if (currentYear == lastOnlineYear) {
            out.add(String.format(TownySettings.getLangString("registered_last_online"), registeredFormat.format(resident.getRegistered()), lastOnlineFormat.format(resident.getLastOnline())));
        } else {
            out.add(String.format(TownySettings.getLangString("registered_last_online"), registeredFormat.format(resident.getRegistered()), lastOnlineFormatIncludeYear.format(resident.getLastOnline())));
        }
        out.add(String.format(TownySettings.getLangString("owner_of_x_plots"), resident.getTownBlocks().size()));
        out.add(TownySettings.getLangString("status_perm") + resident.getPermissions().getColourString().replace("n", "t"));
        out.add(TownySettings.getLangString("status_perm") + resident.getPermissions().getColourString2().replace("n", "t"));
        out.add(TownySettings.getLangString("status_pvp") + (resident.getPermissions().pvp ? TownySettings.getLangString("status_on") : TownySettings.getLangString("status_off")) + TownySettings.getLangString("explosions") + (resident.getPermissions().explosion ? TownySettings.getLangString("status_on") : TownySettings.getLangString("status_off")) + TownySettings.getLangString("firespread") + (resident.getPermissions().fire ? TownySettings.getLangString("status_on") : TownySettings.getLangString("status_off")) + TownySettings.getLangString("mobspawns") + (resident.getPermissions().mobs ? TownySettings.getLangString("status_on") : TownySettings.getLangString("status_off")));
        if (TownySettings.isUsingEconomy() && TownyEconomyHandler.isActive()) {
            out.add(String.format(TownySettings.getLangString("status_bank"), resident.getHoldingFormattedBalance()));
        }
        String line = TownySettings.getLangString("status_town");
        if (!resident.hasTown()) {
            line = line + TownySettings.getLangString("status_no_town");
        } else {
            try {
                line = line + TownyFormatter.getFormattedName(resident.getTown());
            }
            catch (TownyException e) {
                line = line + "Error: " + e.getMessage();
            }
        }
        out.add(line);
        ArrayList<Town> townEmbassies = new ArrayList<Town>();
        try {
            String actualTown = resident.hasTown() ? resident.getTown().getName() : "";
            for (TownBlock tB : resident.getTownBlocks()) {
                if (actualTown.equals(tB.getTown().getName()) || townEmbassies.contains(tB.getTown())) continue;
                townEmbassies.add(tB.getTown());
            }
        }
        catch (NotRegisteredException actualTown) {
            // empty catch block
        }
        if (townEmbassies.size() > 0) {
            out.addAll(TownyFormatter.getFormattedTowns(TownySettings.getLangString("status_embassy_town"), townEmbassies));
        }
        if (resident.hasTown() && !resident.getTownRanks().isEmpty()) {
            out.add(TownySettings.getLangString("status_town_ranks") + StringMgmt.join(resident.getTownRanks(), ","));
        }
        if (resident.hasNation() && !resident.getNationRanks().isEmpty()) {
            out.add(TownySettings.getLangString("status_nation_ranks") + StringMgmt.join(resident.getNationRanks(), ","));
        }
        if (resident.isJailed()) {
            out.add(String.format(TownySettings.getLangString("jailed_in_town"), resident.getJailTown()) + (resident.hasJailDays() ? String.format(TownySettings.getLangString("msg_jailed_for_x_days"), resident.getJailDays()) : ""));
        }
        List<Resident> friends = resident.getFriends();
        out.addAll(TownyFormatter.getFormattedResidents(TownySettings.getLangString("status_friends"), friends));
        out = TownyFormatter.formatStatusScreens(out);
        return out;
    }

    public static List<String> getRanks(Town town) {
        ArrayList<String> ranklist = new ArrayList<String>();
        String towntitle = TownyFormatter.getFormattedName(town);
        towntitle = towntitle + TownySettings.getLangString("rank_list_title");
        ranklist.add(ChatTools.formatTitle(towntitle));
        ranklist.add(String.format(TownySettings.getLangString("rank_list_mayor"), TownyFormatter.getFormattedName(town.getMayor())));
        List<Resident> residents = town.getResidents();
        List<String> townranks = TownyPerms.getTownRanks();
        ArrayList<Resident> residentwithrank = new ArrayList<Resident>();
        for (String rank : townranks) {
            for (Resident r : residents) {
                if (r.getTownRanks() == null || !r.getTownRanks().contains(rank)) continue;
                residentwithrank.add(r);
            }
            ranklist.addAll(TownyFormatter.getFormattedResidents(rank, residentwithrank));
            residentwithrank.clear();
        }
        return ranklist;
    }

    public static List<String> formatStatusScreens(List<String> out) {
        ArrayList<String> formattedOut = new ArrayList<String>();
        for (String line : out) {
            if (line.length() > 80) {
                int after;
                int before;
                int middle = line.length() / 2;
                middle = middle - (before = line.lastIndexOf(32, middle)) < (after = line.lastIndexOf(32, middle + 1)) - middle ? before : after;
                String first = line.substring(0, middle);
                String second = line.substring(middle + 1);
                formattedOut.add(first);
                formattedOut.add(second);
                continue;
            }
            formattedOut.add(line);
        }
        return formattedOut;
    }

    public static List<String> getStatus(Town town) {
        TownyWorld world;
        List<String> out = new ArrayList<String>();
        try {
            world = town.getWorld();
        }
        catch (NullPointerException e) {
            world = TownyUniverse.getInstance().getDataSource().getWorlds().get(0);
        }
        String title = TownyFormatter.getFormattedName(town);
        title = title + (!town.isAdminDisabledPVP() && (town.isPVP() || town.getWorld().isForcePVP()) ? TownySettings.getLangString("status_title_pvp") : "");
        title = title + (town.isOpen() ? TownySettings.getLangString("status_title_open") : "");
        out.add(ChatTools.formatTitle(title));
        try {
            out.addAll(ChatTools.color(String.format(TownySettings.getLangString("status_town_board"), town.getTownBoard())));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Long registered = town.getRegistered();
        if (registered != 0L) {
            out.add(String.format(TownySettings.getLangString("status_founded"), registeredFormat.format(town.getRegistered())));
        }
        try {
            out.add(String.format(TownySettings.getLangString("status_town_size_part_1"), town.getTownBlocks().size(), TownySettings.getMaxTownBlocks(town)) + (TownySettings.isSellingBonusBlocks(town) ? String.format(TownySettings.getLangString("status_town_size_part_2"), town.getPurchasedBlocks(), TownySettings.getMaxPurchedBlocks(town)) : "") + (town.getBonusBlocks() > 0 ? String.format(TownySettings.getLangString("status_town_size_part_3"), town.getBonusBlocks()) : "") + (TownySettings.getNationBonusBlocks(town) > 0 ? String.format(TownySettings.getLangString("status_town_size_part_4"), TownySettings.getNationBonusBlocks(town)) : "") + (town.isPublic() ? TownySettings.getLangString("status_town_size_part_5") + (TownySettings.getTownDisplaysXYZ() ? (town.hasSpawn() ? BukkitTools.convertCoordtoXYZ(town.getSpawn()) : TownySettings.getLangString("status_no_town")) + "]" : (town.hasHomeBlock() ? town.getHomeBlock().getCoord().toString() : TownySettings.getLangString("status_no_town")) + "]") : ""));
        }
        catch (TownyException townyException) {
            // empty catch block
        }
        if (TownySettings.isAllowingOutposts()) {
            if (TownySettings.isOutpostsLimitedByLevels()) {
                if (town.hasOutpostSpawn()) {
                    if (!town.hasNation()) {
                        out.add(String.format(TownySettings.getLangString("status_town_outposts"), town.getMaxOutpostSpawn(), town.getOutpostLimit()));
                    } else {
                        int nationBonus = 0;
                        try {
                            nationBonus = (Integer)TownySettings.getNationLevel(town.getNation()).get((Object)TownySettings.NationLevel.NATION_BONUS_OUTPOST_LIMIT);
                        }
                        catch (NotRegisteredException notRegisteredException) {
                            // empty catch block
                        }
                        out.add(String.format(TownySettings.getLangString("status_town_outposts"), town.getMaxOutpostSpawn(), town.getOutpostLimit()) + (nationBonus > 0 ? String.format(TownySettings.getLangString("status_town_outposts2"), nationBonus) : ""));
                    }
                } else {
                    out.add(String.format(TownySettings.getLangString("status_town_outposts3"), town.getOutpostLimit()));
                }
            } else if (town.hasOutpostSpawn()) {
                out.add(String.format(TownySettings.getLangString("status_town_outposts4"), town.getMaxOutpostSpawn()));
            }
        }
        out.add(TownySettings.getLangString("status_perm") + town.getPermissions().getColourString().replace("f", "r"));
        out.add(TownySettings.getLangString("status_perm") + town.getPermissions().getColourString2().replace("f", "r"));
        out.add(TownySettings.getLangString("explosions2") + (town.isBANG() || world.isForceExpl() ? TownySettings.getLangString("status_on") : TownySettings.getLangString("status_off")) + TownySettings.getLangString("firespread") + (town.isFire() || world.isForceFire() ? TownySettings.getLangString("status_on") : TownySettings.getLangString("status_off")) + TownySettings.getLangString("mobspawns") + (town.hasMobs() || world.isForceTownMobs() ? TownySettings.getLangString("status_on") : TownySettings.getLangString("status_off")));
        String bankString = "";
        if (TownySettings.isUsingEconomy()) {
            if (TownyEconomyHandler.isActive()) {
                bankString = String.format(TownySettings.getLangString("status_bank"), town.getHoldingFormattedBalance());
                if (town.hasUpkeep()) {
                    bankString = bankString + String.format(TownySettings.getLangString("status_bank_town2"), new BigDecimal(TownySettings.getTownUpkeepCost(town)).setScale(2, RoundingMode.HALF_UP).doubleValue());
                }
                if (TownySettings.getUpkeepPenalty() > 0.0 && town.isOverClaimed()) {
                    bankString = bankString + String.format(TownySettings.getLangString("status_bank_town_penalty_upkeep"), TownySettings.getTownPenaltyUpkeepCost(town));
                }
                bankString = bankString + String.format(TownySettings.getLangString("status_bank_town3"), town.getTaxes()) + (town.isTaxPercentage() ? "%" : "");
            }
            out.add(bankString);
        }
        out.add(String.format(TownySettings.getLangString("rank_list_mayor"), TownyFormatter.getFormattedName(town.getMayor())));
        ArrayList<String> ranklist = new ArrayList<String>();
        List<Resident> residentss = town.getResidents();
        List<String> townranks = TownyPerms.getTownRanks();
        ArrayList<Resident> residentwithrank = new ArrayList<Resident>();
        for (String rank : townranks) {
            for (Resident r : residentss) {
                if (r.getTownRanks() == null || !r.getTownRanks().contains(rank)) continue;
                residentwithrank.add(r);
            }
            ranklist.addAll(TownyFormatter.getFormattedResidents(rank, residentwithrank));
            residentwithrank.clear();
        }
        out.addAll(ranklist);
        try {
            out.add(String.format(TownySettings.getLangString("status_town_nation"), TownyFormatter.getFormattedName(town.getNation())));
        }
        catch (TownyException townyException) {
            // empty catch block
        }
        String[] residents = TownyFormatter.getFormattedNames(town.getResidents().toArray(new Resident[0]));
        if (residents.length > 34) {
            String[] entire = residents;
            residents = new String[36];
            System.arraycopy(entire, 0, residents, 0, 35);
            residents[35] = TownySettings.getLangString("status_town_reslist_overlength");
        }
        out.addAll(ChatTools.listArr(residents, String.format(TownySettings.getLangString("status_town_reslist"), town.getNumResidents())));
        out = TownyFormatter.formatStatusScreens(out);
        return out;
    }

    public static List<String> getStatus(Nation nation) {
        String[] towns2;
        List<String> out = new ArrayList<String>();
        String title = TownyFormatter.getFormattedName(nation);
        title = title + (nation.isOpen() ? TownySettings.getLangString("status_title_open") : "");
        out.add(ChatTools.formatTitle(title));
        Long registered = nation.getRegistered();
        if (registered != 0L) {
            out.add(String.format(TownySettings.getLangString("status_founded"), registeredFormat.format(nation.getRegistered())));
        }
        String line = "";
        if (TownySettings.isUsingEconomy() && TownyEconomyHandler.isActive()) {
            line = String.format(TownySettings.getLangString("status_bank"), nation.getHoldingFormattedBalance());
            if (TownySettings.getNationUpkeepCost(nation) > 0.0) {
                line = line + String.format(TownySettings.getLangString("status_bank_town2"), TownySettings.getNationUpkeepCost(nation));
            }
        }
        if (nation.isNeutral()) {
            if (line.length() > 0) {
                line = line + "\u00a78 | ";
            }
            line = line + TownySettings.getLangString("status_nation_peaceful");
        }
        if (nation.isPublic()) {
            if (line.length() > 0) {
                line = line + "\u00a78 | ";
            }
            try {
                line = line + (nation.isPublic() ? TownySettings.getLangString("status_town_size_part_5") + (nation.hasNationSpawn() ? Coord.parseCoord(nation.getNationSpawn()).toString() : TownySettings.getLangString("status_no_town")) + "]" : "");
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
        if (line.length() > 0) {
            out.add(line);
        }
        if (nation.getNumTowns() > 0 && nation.hasCapital() && nation.getCapital().hasMayor()) {
            out.add(String.format(TownySettings.getLangString("status_nation_king"), TownyFormatter.getFormattedName(nation.getCapital().getMayor())) + String.format(TownySettings.getLangString("status_nation_tax"), nation.getTaxes()));
        }
        ArrayList<String> ranklist = new ArrayList<String>();
        List<Town> towns = nation.getTowns();
        ArrayList<Resident> residents = new ArrayList<Resident>();
        for (Town town : towns) {
            residents.addAll(town.getResidents());
        }
        List<String> nationranks = TownyPerms.getNationRanks();
        ArrayList<Resident> residentwithrank = new ArrayList<Resident>();
        for (String rank : nationranks) {
            for (Resident r : residents) {
                if (r.getNationRanks() == null || !r.getNationRanks().contains(rank)) continue;
                residentwithrank.add(r);
            }
            ranklist.addAll(TownyFormatter.getFormattedResidents(rank, residentwithrank));
            residentwithrank.clear();
        }
        if (ranklist != null) {
            out.addAll(ranklist);
        }
        if ((towns2 = TownyFormatter.getFormattedNames(nation.getTowns().toArray(new Town[0]))).length > 10) {
            String[] entire = towns2;
            towns2 = new String[12];
            System.arraycopy(entire, 0, towns2, 0, 11);
            towns2[11] = TownySettings.getLangString("status_town_reslist_overlength");
        }
        out.addAll(ChatTools.listArr(towns2, String.format(TownySettings.getLangString("status_nation_towns"), nation.getNumTowns())));
        String[] allies = TownyFormatter.getFormattedNames(nation.getAllies().toArray(new Nation[0]));
        if (allies.length > 10) {
            String[] entire = allies;
            allies = new String[12];
            System.arraycopy(entire, 0, allies, 0, 11);
            allies[11] = TownySettings.getLangString("status_town_reslist_overlength");
        }
        out.addAll(ChatTools.listArr(allies, String.format(TownySettings.getLangString("status_nation_allies"), nation.getAllies().size())));
        String[] enemies = TownyFormatter.getFormattedNames(nation.getEnemies().toArray(new Nation[0]));
        if (enemies.length > 10) {
            String[] entire = enemies;
            enemies = new String[12];
            System.arraycopy(entire, 0, enemies, 0, 11);
            enemies[11] = TownySettings.getLangString("status_town_reslist_overlength");
        }
        out.addAll(ChatTools.listArr(enemies, String.format(TownySettings.getLangString("status_nation_enemies"), nation.getEnemies().size())));
        out = TownyFormatter.formatStatusScreens(out);
        return out;
    }

    public static List<String> getStatus(TownyWorld world) {
        List<String> out = new ArrayList<String>();
        String title = TownyFormatter.getFormattedName(world);
        title = title + (world.isPVP() || world.isForcePVP() ? TownySettings.getLangString("status_title_pvp") : "");
        title = title + (world.isClaimable() ? TownySettings.getLangString("status_world_claimable") : TownySettings.getLangString("status_world_noclaims"));
        out.add(ChatTools.formatTitle(title));
        if (!world.isUsingTowny()) {
            out.add(TownySettings.getLangString("msg_set_use_towny_off"));
        } else {
            out.add(TownySettings.getLangString("status_world_forcepvp") + (world.isForcePVP() ? TownySettings.getLangString("status_on") : TownySettings.getLangString("status_off")) + "\u00a78" + " | " + TownySettings.getLangString("status_world_fire") + (world.isFire() ? TownySettings.getLangString("status_on") : TownySettings.getLangString("status_off")) + "\u00a78" + " | " + TownySettings.getLangString("status_world_forcefire") + (world.isForceFire() ? TownySettings.getLangString("status_forced") : TownySettings.getLangString("status_adjustable")));
            out.add(TownySettings.getLangString("explosions2") + ": " + (world.isExpl() ? TownySettings.getLangString("status_on") : TownySettings.getLangString("status_off")) + "\u00a78" + " | " + TownySettings.getLangString("status_world_forceexplosion") + (world.isForceExpl() ? TownySettings.getLangString("status_forced") : TownySettings.getLangString("status_adjustable")));
            out.add(TownySettings.getLangString("status_world_worldmobs") + (world.hasWorldMobs() ? TownySettings.getLangString("status_on") : TownySettings.getLangString("status_off")) + "\u00a78" + " | " + TownySettings.getLangString("status_world_forcetownmobs") + (world.isForceTownMobs() ? TownySettings.getLangString("status_forced") : TownySettings.getLangString("status_adjustable")));
            out.add("\u00a72" + (world.isWarAllowed() ? TownySettings.getLangString("msg_set_war_allowed_on") : TownySettings.getLangString("msg_set_war_allowed_off")));
            out.add(TownySettings.getLangString("status_world_unclaimrevert") + (world.isUsingPlotManagementRevert() ? TownySettings.getLangString("status_on_good") : TownySettings.getLangString("status_off_bad")) + "\u00a78" + " | " + TownySettings.getLangString("status_world_explrevert") + (world.isUsingPlotManagementWildRevert() ? TownySettings.getLangString("status_on_good") : TownySettings.getLangString("status_off_bad")));
            out.add("\u00a72" + world.getUnclaimedZoneName() + ":");
            out.add("    " + (world.getUnclaimedZoneBuild() != false ? "\u00a7a" : "\u00a7c") + "Build" + "\u00a78" + ", " + (world.getUnclaimedZoneDestroy() != false ? "\u00a7a" : "\u00a7c") + "Destroy" + "\u00a78" + ", " + (world.getUnclaimedZoneSwitch() != false ? "\u00a7a" : "\u00a7c") + "Switch" + "\u00a78" + ", " + (world.getUnclaimedZoneItemUse() != false ? "\u00a7a" : "\u00a7c") + "ItemUse");
            out.add("    " + TownySettings.getLangString("status_world_ignoredblocks") + "\u00a7a" + " " + StringMgmt.join(world.getUnclaimedZoneIgnoreMaterials(), ", "));
        }
        out = TownyFormatter.formatStatusScreens(out);
        return out;
    }

    public static List<String> getTaxStatus(Resident resident) {
        ArrayList<String> out = new ArrayList<String>();
        Town town = null;
        double plotTax = 0.0;
        out.add(ChatTools.formatTitle(TownyFormatter.getFormattedName(resident) + (BukkitTools.isOnline(resident.getName()) ? "\u00a7a (Online)" : "")));
        if (resident.hasTown()) {
            try {
                town = resident.getTown();
                out.add(String.format(TownySettings.getLangString("owner_of_x_plots"), resident.getTownBlocks().size()));
                if (TownyPerms.getResidentPerms(resident).containsKey("towny.tax_exempt")) {
                    out.add(TownySettings.getLangString("status_res_taxexempt"));
                } else if (town.isTaxPercentage()) {
                    out.add(String.format(TownySettings.getLangString("status_res_tax"), resident.getHoldingBalance() * town.getTaxes() / 100.0));
                } else {
                    out.add(String.format(TownySettings.getLangString("status_res_tax"), town.getTaxes()));
                    if (resident.getTownBlocks().size() > 0) {
                        for (TownBlock townBlock : new ArrayList<TownBlock>(resident.getTownBlocks())) {
                            plotTax += townBlock.getType().getTax(townBlock.getTown());
                        }
                        out.add(TownySettings.getLangString("status_res_plottax") + plotTax);
                    }
                    out.add(TownySettings.getLangString("status_res_totaltax") + (town.getTaxes() + plotTax));
                }
            }
            catch (NotRegisteredException notRegisteredException) {
            }
            catch (EconomyException economyException) {
                // empty catch block
            }
        }
        return out;
    }

    public static String getNamePrefix(Resident resident) {
        if (resident == null) {
            return "";
        }
        if (resident.isKing()) {
            return TownySettings.getKingPrefix(resident);
        }
        if (resident.isMayor()) {
            return TownySettings.getMayorPrefix(resident);
        }
        return "";
    }

    public static String getNamePostfix(Resident resident) {
        if (resident == null) {
            return "";
        }
        if (resident.isKing()) {
            return TownySettings.getKingPostfix(resident);
        }
        if (resident.isMayor()) {
            return TownySettings.getMayorPostfix(resident);
        }
        return "";
    }

    public static String getFormattedName(TownyObject obj) {
        if (obj == null) {
            return "Null";
        }
        if (obj instanceof Resident) {
            return TownyFormatter.getFormattedResidentName((Resident)obj);
        }
        if (obj instanceof Town) {
            return TownyFormatter.getFormattedTownName((Town)obj);
        }
        if (obj instanceof Nation) {
            return TownyFormatter.getFormattedNationName((Nation)obj);
        }
        return obj.getName().replaceAll("_", " ");
    }

    public static String getFormattedResidentName(Resident resident) {
        if (resident == null) {
            return "null";
        }
        if (resident.isKing()) {
            return (resident.hasTitle() ? resident.getTitle() + " " : TownySettings.getKingPrefix(resident)) + resident.getName() + (resident.hasSurname() ? " " + resident.getSurname() : TownySettings.getKingPostfix(resident));
        }
        if (resident.isMayor()) {
            return (resident.hasTitle() ? resident.getTitle() + " " : TownySettings.getMayorPrefix(resident)) + resident.getName() + (resident.hasSurname() ? " " + resident.getSurname() : TownySettings.getMayorPostfix(resident));
        }
        return (resident.hasTitle() ? resident.getTitle() + " " : "") + resident.getName() + (resident.hasSurname() ? " " + resident.getSurname() : "");
    }

    public static String getFormattedTownName(Town town) {
        if (town.isCapital()) {
            return TownySettings.getCapitalPrefix(town) + town.getName().replaceAll("_", " ") + TownySettings.getCapitalPostfix(town);
        }
        return TownySettings.getTownPrefix(town) + town.getName().replaceAll("_", " ") + TownySettings.getTownPostfix(town);
    }

    public static String getFormattedNationName(Nation nation) {
        return TownySettings.getNationPrefix(nation) + nation.getName().replaceAll("_", " ") + TownySettings.getNationPostfix(nation);
    }

    public static String getFormattedResidentTitleName(Resident resident) {
        if (!resident.hasTitle()) {
            return TownyFormatter.getFormattedName(resident);
        }
        return resident.getTitle() + " " + resident.getName();
    }

    public static String[] getFormattedNames(Resident[] residents) {
        ArrayList<String> names = new ArrayList<String>();
        for (Resident resident : residents) {
            names.add(TownyFormatter.getFormattedName(resident));
        }
        return names.toArray(new String[0]);
    }

    public static String[] getFormattedNames(Town[] towns) {
        ArrayList<String> names = new ArrayList<String>();
        for (Town town : towns) {
            names.add(TownyFormatter.getFormattedName(town));
        }
        return names.toArray(new String[0]);
    }

    public static String[] getFormattedNames(Nation[] nations) {
        ArrayList<String> names = new ArrayList<String>();
        for (Nation nation : nations) {
            names.add(TownyFormatter.getFormattedName(nation));
        }
        return names.toArray(new String[0]);
    }
}

