/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyEconomyObject;
import java.io.File;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.bukkit.Bukkit;

public class TownyLogger {
    private static final TownyLogger instance = new TownyLogger();
    private static final Logger LOGGER_MONEY = LogManager.getLogger((String)"com.palmergames.bukkit.towny.money");
    private final LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
    private final Configuration config = this.ctx.getConfiguration();
    private Appender townyMainAppender;
    private Appender townyMoneyAppender;
    private Appender townyDebugAppender;
    private Appender consoleAppender;

    private TownyLogger() {
        String logFolderName = TownyUniverse.getInstance().getRootFolder() + File.separator + "logs";
        PatternLayout standardLayout = PatternLayout.newBuilder().withCharset(StandardCharsets.UTF_8).withPattern("%d [%t] %p %c - %m%n").withConfiguration(this.config).build();
        this.createMainAppender(logFolderName, (Layout<String>)standardLayout);
        this.createMoneyAppender(logFolderName);
        this.createDebugAppender(logFolderName, (Layout<String>)standardLayout);
        this.createConsoleAppender();
        this.townyMainAppender.start();
        this.config.addAppender(this.townyMainAppender);
        this.townyMoneyAppender.start();
        this.config.addAppender(this.townyMoneyAppender);
        this.townyDebugAppender.start();
        this.config.addAppender(this.townyDebugAppender);
        this.enableMainLogger();
        this.enableMoneyLogger();
        this.updateLoggers();
    }

    private void createMainAppender(String logFolderName, Layout<String> standardLayout) {
        this.townyMainAppender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().withFileName(logFolderName + File.separator + "towny.log").withName("Towny")).withAppend(TownySettings.isAppendingToLog()).withIgnoreExceptions(false)).withBufferedIo(false)).withBufferSize(0)).setConfiguration(this.config)).withLayout(standardLayout)).build();
    }

    private void createMoneyAppender(String logFolderName) {
        this.townyMoneyAppender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().withFileName(logFolderName + File.separator + "money.csv").withName("Towny-Money")).withAppend(TownySettings.isAppendingToLog()).withIgnoreExceptions(false)).withBufferedIo(false)).withBufferSize(0)).setConfiguration(this.config)).withLayout((Layout)PatternLayout.newBuilder().withCharset(StandardCharsets.UTF_8).withPattern("%d{dd MMM yyyy HH:mm:ss},%m%n").withConfiguration(this.config).build())).build();
    }

    private void createDebugAppender(String logFolderName, Layout<String> standardLayout) {
        this.townyDebugAppender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().withFileName(logFolderName + File.separator + "debug.log").withName("Towny-Debug")).withAppend(TownySettings.isAppendingToLog()).withIgnoreExceptions(false)).withBufferedIo(false)).withBufferSize(0)).setConfiguration(this.config)).withLayout(standardLayout)).build();
    }

    private void createConsoleAppender() {
        if (!Bukkit.getVersion().contains("Paper")) {
            this.consoleAppender = this.config.getAppender("TerminalConsole");
        } else {
            this.consoleAppender = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)((ConsoleAppender.Builder)((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().withName("Towny-Console-Paper")).withBufferedIo(false)).withBufferSize(0)).setConfiguration(this.config)).withLayout((Layout)PatternLayout.newBuilder().withCharset(StandardCharsets.UTF_8).withPattern("%minecraftFormatting{%msg}%n%xEx").withConfiguration(this.config).build())).build();
            this.config.addAppender(this.consoleAppender);
            this.consoleAppender.start();
        }
    }

    private void enableMainLogger() {
        LoggerConfig townyMainConfig = LoggerConfig.createLogger((boolean)false, (Level)Level.ALL, (String)"Towny", null, (AppenderRef[])new AppenderRef[]{AppenderRef.createAppenderRef((String)this.townyMainAppender.getName(), (Level)Level.ALL, null)}, null, (Configuration)this.config, null);
        townyMainConfig.addAppender(this.townyMainAppender, Level.ALL, null);
        townyMainConfig.addAppender(this.config.getAppender("File"), Level.INFO, null);
        townyMainConfig.addAppender(this.consoleAppender, Level.INFO, null);
        this.config.addLogger("com.palmergames.bukkit.towny", townyMainConfig);
    }

    public void enableDebugLogger() {
        LoggerConfig townyDebugConfig = LoggerConfig.createLogger((boolean)false, (Level)Level.ALL, (String)"Towny-Debug", null, (AppenderRef[])new AppenderRef[]{AppenderRef.createAppenderRef((String)this.townyDebugAppender.getName(), (Level)Level.ALL, null)}, null, (Configuration)this.config, null);
        townyDebugConfig.addAppender(this.townyDebugAppender, Level.ALL, null);
        townyDebugConfig.addAppender(this.config.getAppender("File"), Level.INFO, null);
        townyDebugConfig.addAppender(this.consoleAppender, Level.INFO, null);
        this.config.addLogger("com.palmergames.bukkit.towny.debug", townyDebugConfig);
    }

    public void toggleDebugLogger() {
        LoggerConfig townyDebugConfig = this.config.getLoggerConfig("Towny-Debug");
        if (townyDebugConfig.isStarted()) {
            townyDebugConfig.stop();
        } else {
            townyDebugConfig.start();
        }
    }

    private void enableMoneyLogger() {
        LoggerConfig townyMoneyConfig = LoggerConfig.createLogger((boolean)false, (Level)Level.ALL, (String)"Towny-Money", null, (AppenderRef[])new AppenderRef[]{AppenderRef.createAppenderRef((String)this.townyMoneyAppender.getName(), (Level)Level.ALL, null)}, null, (Configuration)this.config, null);
        townyMoneyConfig.addAppender(this.townyMoneyAppender, Level.ALL, null);
        this.config.addLogger("com.palmergames.bukkit.towny.money", townyMoneyConfig);
    }

    public void logMoneyTransaction(TownyEconomyObject a, double amount, TownyEconomyObject b, String reason) {
        if (reason == null) {
            LOGGER_MONEY.info(String.format("%s,%s,%s,%s", "Unknown Reason", this.getObjectName(a), amount, this.getObjectName(b)));
        } else {
            LOGGER_MONEY.info(String.format("%s,%s,%s,%s", reason, this.getObjectName(a), amount, this.getObjectName(b)));
        }
    }

    private String getObjectName(TownyEconomyObject obj) {
        String type = obj == null ? "Server" : (obj instanceof Resident ? "Resident" : (obj instanceof Town ? "Town" : (obj instanceof Nation ? "Nation" : "?")));
        return String.format("[%s] %s", type, obj != null ? obj.getName() : "");
    }

    public void updateLoggers() {
        this.ctx.updateLoggers();
    }

    public static TownyLogger getInstance() {
        return instance;
    }
}

