/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.config.CommentedConfiguration;
import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.ChunkNotification;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.NationSpawnLevel;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownSpawnLevel;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.war.flagwar.TownyWarConfig;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.FileMgmt;
import com.palmergames.util.StringMgmt;
import com.palmergames.util.TimeTools;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.entity.Player;

public class TownySettings {
    private static CommentedConfiguration config;
    private static CommentedConfiguration newConfig;
    private static CommentedConfiguration language;
    private static CommentedConfiguration newLanguage;
    private static CommentedConfiguration playermap;
    private static final SortedMap<Integer, Map<TownLevel, Object>> configTownLevel;
    private static final SortedMap<Integer, Map<NationLevel, Object>> configNationLevel;

    public static void newTownLevel(int numResidents, String namePrefix, String namePostfix, String mayorPrefix, String mayorPostfix, int townBlockLimit, double townUpkeepMultiplier, int townOutpostLimit, int townBlockBuyBonusLimit) {
        ConcurrentHashMap<TownLevel, Object> m = new ConcurrentHashMap<TownLevel, Object>();
        m.put(TownLevel.NAME_PREFIX, namePrefix);
        m.put(TownLevel.NAME_POSTFIX, namePostfix);
        m.put(TownLevel.MAYOR_PREFIX, mayorPrefix);
        m.put(TownLevel.MAYOR_POSTFIX, mayorPostfix);
        m.put(TownLevel.TOWN_BLOCK_LIMIT, townBlockLimit);
        m.put(TownLevel.UPKEEP_MULTIPLIER, townUpkeepMultiplier);
        m.put(TownLevel.OUTPOST_LIMIT, townOutpostLimit);
        m.put(TownLevel.TOWN_BLOCK_BUY_BONUS_LIMIT, townBlockBuyBonusLimit);
        configTownLevel.put(numResidents, m);
    }

    public static void newNationLevel(int numResidents, String namePrefix, String namePostfix, String capitalPrefix, String capitalPostfix, String kingPrefix, String kingPostfix, int townBlockLimitBonus, double nationUpkeepMultiplier, double nationTownUpkeepMultiplier, int nationZonesSize, int nationBonusOutpostLimit) {
        ConcurrentHashMap<NationLevel, Object> m = new ConcurrentHashMap<NationLevel, Object>();
        m.put(NationLevel.NAME_PREFIX, namePrefix);
        m.put(NationLevel.NAME_POSTFIX, namePostfix);
        m.put(NationLevel.CAPITAL_PREFIX, capitalPrefix);
        m.put(NationLevel.CAPITAL_POSTFIX, capitalPostfix);
        m.put(NationLevel.KING_PREFIX, kingPrefix);
        m.put(NationLevel.KING_POSTFIX, kingPostfix);
        m.put(NationLevel.TOWN_BLOCK_LIMIT_BONUS, townBlockLimitBonus);
        m.put(NationLevel.UPKEEP_MULTIPLIER, nationUpkeepMultiplier);
        m.put(NationLevel.NATION_TOWN_UPKEEP_MULTIPLIER, nationTownUpkeepMultiplier);
        m.put(NationLevel.NATIONZONES_SIZE, nationZonesSize);
        m.put(NationLevel.NATION_BONUS_OUTPOST_LIMIT, nationBonusOutpostLimit);
        configNationLevel.put(numResidents, m);
    }

    public static void loadTownLevelConfig() throws IOException {
        List levels = config.getMapList("levels.town_level");
        for (Map level : levels) {
            try {
                TownySettings.newTownLevel((Integer)level.get("numResidents"), (String)level.get("namePrefix"), (String)level.get("namePostfix"), (String)level.get("mayorPrefix"), (String)level.get("mayorPostfix"), (Integer)level.get("townBlockLimit"), (Double)level.get("upkeepModifier"), (Integer)level.get("townOutpostLimit"), (Integer)level.get("townBlockBuyBonusLimit"));
            }
            catch (NullPointerException e) {
                System.out.println("Your Towny config.yml's town_level section is out of date.");
                System.out.println("This can be fixed automatically by deleting the town_level section and letting Towny remake it on the next startup.");
                throw new IOException("Config.yml town_levels incomplete.");
            }
        }
    }

    public static void loadNationLevelConfig() throws IOException {
        List levels = config.getMapList("levels.nation_level");
        for (Map level : levels) {
            try {
                TownySettings.newNationLevel((Integer)level.get("numResidents"), (String)level.get("namePrefix"), (String)level.get("namePostfix"), (String)level.get("capitalPrefix"), (String)level.get("capitalPostfix"), (String)level.get("kingPrefix"), (String)level.get("kingPostfix"), level.containsKey("townBlockLimitBonus") ? (Integer)level.get("townBlockLimitBonus") : 0, (Double)level.get("upkeepModifier"), level.containsKey("nationTownUpkeepModifier") ? (Double)level.get("nationTownUpkeepModifier") : 1.0, (Integer)level.get("nationZonesSize"), (Integer)level.get("nationBonusOutpostLimit"));
            }
            catch (Exception e) {
                System.out.println("Your Towny config.yml's nation_level section is out of date.");
                System.out.println("This can be fixed automatically by deleting the nation_level section and letting Towny remake it on the next startup.");
                throw new IOException("Config.yml nation_levels incomplete.");
            }
        }
    }

    public static Map<TownLevel, Object> getTownLevel(int numResidents) {
        return (Map)configTownLevel.get(numResidents);
    }

    public static Map<NationLevel, Object> getNationLevel(int numResidents) {
        return (Map)configNationLevel.get(numResidents);
    }

    public static Map<TownLevel, Object> getTownLevel(Town town) {
        return TownySettings.getTownLevel(TownySettings.calcTownLevel(town));
    }

    public static Map<NationLevel, Object> getNationLevel(Nation nation) {
        return TownySettings.getNationLevel(TownySettings.calcNationLevel(nation));
    }

    public static int calcTownLevel(Town town) {
        int n = town.getNumResidents();
        for (Integer level : configTownLevel.keySet()) {
            if (n < level) continue;
            return level;
        }
        return 0;
    }

    public static int calcNationLevel(Nation nation) {
        int n = nation.getNumResidents();
        for (Integer level : configNationLevel.keySet()) {
            if (n < level) continue;
            return level;
        }
        return 0;
    }

    public static void loadConfig(String filepath, String version) throws IOException {
        if (FileMgmt.checkOrCreateFile(filepath)) {
            File file = new File(filepath);
            config = new CommentedConfiguration(file);
            if (!config.load()) {
                System.out.print("Failed to load Config!");
            }
            TownySettings.setDefaults(version, file);
            config.save();
            TownySettings.loadCachedObjects();
        }
    }

    public static void loadPlayerMap(String filepath) {
        File file;
        if (FileMgmt.checkOrCreateFile(filepath) && !(playermap = new CommentedConfiguration(file = new File(filepath))).load()) {
            System.out.println("Failed to load playermap!");
        }
    }

    public static void loadCachedObjects() throws IOException {
        TownyWarConfig.setFlagBaseMaterial(Material.matchMaterial((String)TownySettings.getString(ConfigNodes.WAR_ENEMY_FLAG_BASE_BLOCK)));
        TownyWarConfig.setFlagLightMaterial(Material.matchMaterial((String)TownySettings.getString(ConfigNodes.WAR_ENEMY_FLAG_LIGHT_BLOCK)));
        TownyWarConfig.setBeaconWireFrameMaterial(Material.matchMaterial((String)TownySettings.getString(ConfigNodes.WAR_ENEMY_BEACON_WIREFRAME_BLOCK)));
        TownySettings.loadTownLevelConfig();
        TownySettings.loadNationLevelConfig();
        TownyWarConfig.setEditableMaterialsInWarZone(TownySettings.getAllowedMaterials(ConfigNodes.WAR_WARZONE_EDITABLE_MATERIALS));
        ChunkNotification.loadFormatStrings();
    }

    public static void loadLanguage(String filepath, String defaultRes) throws IOException {
        String res = TownySettings.getString(ConfigNodes.LANGUAGE.getRoot(), defaultRes);
        String fullPath = filepath + File.separator + res;
        File file = FileMgmt.unpackResourceFile(fullPath, res, defaultRes);
        if (file != null) {
            language = new CommentedConfiguration(file);
            language.load();
            newLanguage = new CommentedConfiguration(file);
            try {
                newLanguage.loadFromString(FileMgmt.convertStreamToString("/" + res));
            }
            catch (IOException e) {
                TownyMessaging.sendMsg("Custom language file detected, not updating.");
                return;
            }
            catch (InvalidConfigurationException e) {
                TownyMessaging.sendMsg("Invalid Configuration in language file detected.");
            }
            String resVersion = newLanguage.getString("version");
            String langVersion = TownySettings.getLangString("version");
            if (!langVersion.equalsIgnoreCase(resVersion)) {
                language = newLanguage;
                newLanguage = null;
                TownyMessaging.sendMsg("Newer language file available, language file updated.");
                FileMgmt.stringToFile(FileMgmt.convertStreamToString("/" + res), file);
            }
        }
    }

    private static void sendError(String msg) {
        System.out.println("[Towny] Error could not read " + msg);
    }

    private static String[] parseString(String str) {
        return TownySettings.parseSingleLineString(str).split("@");
    }

    public static String parseSingleLineString(String str) {
        return str.replaceAll("&", "\u00a7");
    }

    public static TownSpawnLevel.SpawnLevel getSpawnLevel(ConfigNodes node) {
        TownSpawnLevel.SpawnLevel level = TownSpawnLevel.SpawnLevel.valueOf(config.getString(node.getRoot()).toUpperCase());
        if (level == null) {
            level = TownSpawnLevel.SpawnLevel.valueOf(node.getDefault().toUpperCase());
        }
        return level;
    }

    public static NationSpawnLevel.NSpawnLevel getNSpawnLevel(ConfigNodes node) {
        NationSpawnLevel.NSpawnLevel level = NationSpawnLevel.NSpawnLevel.valueOf(config.getString(node.getRoot()).toUpperCase());
        if (level == null) {
            level = NationSpawnLevel.NSpawnLevel.valueOf(node.getDefault().toUpperCase());
        }
        return level;
    }

    public static boolean getBoolean(ConfigNodes node) {
        return Boolean.parseBoolean(config.getString(node.getRoot().toLowerCase(), node.getDefault()));
    }

    public static double getDouble(ConfigNodes node) {
        try {
            return Double.parseDouble(config.getString(node.getRoot().toLowerCase(), node.getDefault()).trim());
        }
        catch (NumberFormatException e) {
            TownySettings.sendError(node.getRoot().toLowerCase() + " from config.yml");
            return 0.0;
        }
    }

    public static int getInt(ConfigNodes node) {
        try {
            return Integer.parseInt(config.getString(node.getRoot().toLowerCase(), node.getDefault()).trim());
        }
        catch (NumberFormatException e) {
            TownySettings.sendError(node.getRoot().toLowerCase() + " from config.yml");
            return 0;
        }
    }

    public static String getString(ConfigNodes node) {
        return config.getString(node.getRoot().toLowerCase(), node.getDefault());
    }

    public static String getString(String root, String def) {
        String data = config.getString(root.toLowerCase(), def);
        if (data == null) {
            TownySettings.sendError(root.toLowerCase() + " from config.yml");
            return "";
        }
        return data;
    }

    public static String getLangString(String root) {
        String data = language.getString(root.toLowerCase());
        if (data == null) {
            TownySettings.sendError(root.toLowerCase() + " from " + config.getString("language"));
            return "";
        }
        return TownySettings.parseSingleLineString(data);
    }

    public static String getConfigLang(ConfigNodes node) {
        return TownySettings.parseSingleLineString(TownySettings.getString(node));
    }

    public static List<Integer> getIntArr(ConfigNodes node) {
        String[] strArray = TownySettings.getString(node.getRoot(), node.getDefault()).split(",");
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (strArray != null) {
            for (String aStrArray : strArray) {
                if (aStrArray == null) continue;
                try {
                    list.add(Integer.parseInt(aStrArray.trim()));
                }
                catch (NumberFormatException e) {
                    TownySettings.sendError(node.getRoot().toLowerCase() + " from config.yml");
                }
            }
        }
        return list;
    }

    public static List<String> getStrArr(ConfigNodes node) {
        String[] strArray = TownySettings.getString(node.getRoot().toLowerCase(), node.getDefault()).split(",");
        ArrayList<String> list = new ArrayList<String>();
        if (strArray != null) {
            for (String aStrArray : strArray) {
                if (aStrArray == null) continue;
                list.add(aStrArray.trim());
            }
        }
        return list;
    }

    public static long getSeconds(ConfigNodes node) {
        try {
            return TimeTools.getSeconds(TownySettings.getString(node));
        }
        catch (NumberFormatException e) {
            TownySettings.sendError(node.getRoot().toLowerCase() + " from config.yml");
            return 1L;
        }
    }

    public static Set<Material> getAllowedMaterials(ConfigNodes node) {
        HashSet<Material> allowedMaterials = new HashSet<Material>();
        for (String material : TownySettings.getStrArr(node)) {
            if (material.equals("*")) {
                allowedMaterials.addAll(Arrays.asList(Material.values()));
                continue;
            }
            if (material.startsWith("-")) {
                allowedMaterials.remove(Material.matchMaterial((String)material));
                continue;
            }
            allowedMaterials.add(Material.matchMaterial((String)material));
        }
        return allowedMaterials;
    }

    public static void addComment(String root, String ... comments) {
        newConfig.addComment(root.toLowerCase(), comments);
    }

    private static void setDefaults(String version, File file) {
        newConfig = new CommentedConfiguration(file);
        newConfig.load();
        for (ConfigNodes root : ConfigNodes.values()) {
            if (root.getComments().length > 0) {
                TownySettings.addComment(root.getRoot(), root.getComments());
            }
            if (root.getRoot() == ConfigNodes.LEVELS.getRoot()) {
                TownySettings.setDefaultLevels();
                continue;
            }
            if (root.getRoot() == ConfigNodes.LEVELS_TOWN_LEVEL.getRoot() || root.getRoot() == ConfigNodes.LEVELS_NATION_LEVEL.getRoot()) continue;
            if (root.getRoot() == ConfigNodes.VERSION.getRoot()) {
                TownySettings.setNewProperty(root.getRoot(), version);
                continue;
            }
            if (root.getRoot() == ConfigNodes.LAST_RUN_VERSION.getRoot()) {
                TownySettings.setNewProperty(root.getRoot(), TownySettings.getLastRunVersion(version));
                continue;
            }
            if (root.getRoot() == ConfigNodes.PROT_ITEM_USE_MAT.getRoot()) {
                TownySettings.setNewProperty(root.getRoot(), TownySettings.convertIds(TownySettings.getStrArr(ConfigNodes.PROT_ITEM_USE_MAT)));
                continue;
            }
            if (root.getRoot() == ConfigNodes.PROT_SWITCH_MAT.getRoot()) {
                TownySettings.setNewProperty(root.getRoot(), TownySettings.convertIds(TownySettings.getStrArr(ConfigNodes.PROT_SWITCH_MAT)));
                continue;
            }
            if (root.getRoot() == ConfigNodes.NWS_PLOT_MANAGEMENT_DELETE.getRoot()) {
                TownySettings.setNewProperty(root.getRoot(), TownySettings.convertIds(TownySettings.getStrArr(ConfigNodes.NWS_PLOT_MANAGEMENT_DELETE)));
                continue;
            }
            if (root.getRoot() == ConfigNodes.NWS_PLOT_MANAGEMENT_REVERT_IGNORE.getRoot()) {
                TownySettings.setNewProperty(root.getRoot(), TownySettings.convertIds(TownySettings.getStrArr(ConfigNodes.NWS_PLOT_MANAGEMENT_REVERT_IGNORE)));
                continue;
            }
            if (root.getRoot() == ConfigNodes.UNCLAIMED_ZONE_IGNORE.getRoot()) {
                TownySettings.setNewProperty(root.getRoot(), TownySettings.convertIds(TownySettings.getStrArr(ConfigNodes.UNCLAIMED_ZONE_IGNORE)));
                continue;
            }
            TownySettings.setNewProperty(root.getRoot(), config.get(root.getRoot().toLowerCase()) != null ? config.get(root.getRoot().toLowerCase()) : root.getDefault());
        }
        config = newConfig;
        newConfig = null;
    }

    private static String convertIds(List<String> list) {
        ArrayList<String> newValues = new ArrayList<String>();
        for (String id : list) {
            try {
                int value = Integer.parseInt(id);
                newValues.add(BukkitTools.getMaterial(value).name());
            }
            catch (NumberFormatException e) {
                newValues.add(id);
            }
            catch (NullPointerException e) {
                if (!id.startsWith("X")) {
                    newValues.add("X" + id);
                    continue;
                }
                newValues.add(id);
            }
        }
        return StringMgmt.join(newValues, ",");
    }

    private static void setDefaultLevels() {
        HashMap<String, Object> level;
        ArrayList levels;
        TownySettings.addComment(ConfigNodes.LEVELS_TOWN_LEVEL.getRoot(), "# default Town levels.");
        if (!config.contains(ConfigNodes.LEVELS_TOWN_LEVEL.getRoot())) {
            levels = new ArrayList();
            level = new HashMap<String, Object>();
            level.put("numResidents", 0);
            level.put("namePrefix", "");
            level.put("namePostfix", " Ruins");
            level.put("mayorPrefix", "Spirit ");
            level.put("mayorPostfix", "");
            level.put("townBlockLimit", 1);
            level.put("upkeepModifier", 1.0);
            level.put("townOutpostLimit", 0);
            level.put("townBlockBuyBonusLimit", 0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 1);
            level.put("namePrefix", "");
            level.put("namePostfix", " (Settlement)");
            level.put("mayorPrefix", "Hermit ");
            level.put("mayorPostfix", "");
            level.put("townBlockLimit", 16);
            level.put("upkeepModifier", 1.0);
            level.put("townOutpostLimit", 0);
            level.put("townBlockBuyBonusLimit", 0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 2);
            level.put("namePrefix", "");
            level.put("namePostfix", " (Hamlet)");
            level.put("mayorPrefix", "Chief ");
            level.put("mayorPostfix", "");
            level.put("townBlockLimit", 32);
            level.put("upkeepModifier", 1.0);
            level.put("townOutpostLimit", 1);
            level.put("townBlockBuyBonusLimit", 0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 6);
            level.put("namePrefix", "");
            level.put("namePostfix", " (Village)");
            level.put("mayorPrefix", "Baron Von ");
            level.put("mayorPostfix", "");
            level.put("townBlockLimit", 96);
            level.put("upkeepModifier", 1.0);
            level.put("townOutpostLimit", 1);
            level.put("townBlockBuyBonusLimit", 0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 10);
            level.put("namePrefix", "");
            level.put("namePostfix", " (Town)");
            level.put("mayorPrefix", "Viscount ");
            level.put("mayorPostfix", "");
            level.put("townBlockLimit", 160);
            level.put("upkeepModifier", 1.0);
            level.put("townOutpostLimit", 2);
            level.put("townBlockBuyBonusLimit", 0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 14);
            level.put("namePrefix", "");
            level.put("namePostfix", " (Large Town)");
            level.put("mayorPrefix", "Count Von ");
            level.put("mayorPostfix", "");
            level.put("townBlockLimit", 224);
            level.put("upkeepModifier", 1.0);
            level.put("townOutpostLimit", 2);
            level.put("townBlockBuyBonusLimit", 0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 20);
            level.put("namePrefix", "");
            level.put("namePostfix", " (City)");
            level.put("mayorPrefix", "Earl ");
            level.put("mayorPostfix", "");
            level.put("townBlockLimit", 320);
            level.put("upkeepModifier", 1.0);
            level.put("townOutpostLimit", 3);
            level.put("townBlockBuyBonusLimit", 0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 24);
            level.put("namePrefix", "");
            level.put("namePostfix", " (Large City)");
            level.put("mayorPrefix", "Duke ");
            level.put("mayorPostfix", "");
            level.put("townBlockLimit", 384);
            level.put("upkeepModifier", 1.0);
            level.put("townOutpostLimit", 3);
            level.put("townBlockBuyBonusLimit", 0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 28);
            level.put("namePrefix", "");
            level.put("namePostfix", " (Metropolis)");
            level.put("mayorPrefix", "Lord ");
            level.put("mayorPostfix", "");
            level.put("townBlockLimit", 448);
            level.put("upkeepModifier", 1.0);
            level.put("townOutpostLimit", 4);
            level.put("townBlockBuyBonusLimit", 0);
            levels.add(new HashMap(level));
            level.clear();
            newConfig.set(ConfigNodes.LEVELS_TOWN_LEVEL.getRoot(), levels);
        } else {
            newConfig.set(ConfigNodes.LEVELS_TOWN_LEVEL.getRoot(), config.get(ConfigNodes.LEVELS_TOWN_LEVEL.getRoot()));
        }
        TownySettings.addComment(ConfigNodes.LEVELS_NATION_LEVEL.getRoot(), "# default Nation levels.");
        if (!config.contains(ConfigNodes.LEVELS_NATION_LEVEL.getRoot())) {
            levels = new ArrayList();
            level = new HashMap();
            level.put("numResidents", 0);
            level.put("namePrefix", "Land of ");
            level.put("namePostfix", " (Nation)");
            level.put("capitalPrefix", "");
            level.put("capitalPostfix", "");
            level.put("kingPrefix", "Leader ");
            level.put("kingPostfix", "");
            level.put("townBlockLimitBonus", 10);
            level.put("upkeepModifier", 1.0);
            level.put("nationTownUpkeepModifier", 1.0);
            level.put("nationZonesSize", 1);
            level.put("nationBonusOutpostLimit", 0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 10);
            level.put("namePrefix", "Federation of ");
            level.put("namePostfix", " (Nation)");
            level.put("capitalPrefix", "");
            level.put("capitalPostfix", "");
            level.put("kingPrefix", "Count ");
            level.put("kingPostfix", "");
            level.put("townBlockLimitBonus", 20);
            level.put("upkeepModifier", 1.0);
            level.put("nationTownUpkeepModifier", 1.0);
            level.put("nationZonesSize", 1);
            level.put("nationBonusOutpostLimit", 1);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 20);
            level.put("namePrefix", "Dominion of ");
            level.put("namePostfix", " (Nation)");
            level.put("capitalPrefix", "");
            level.put("capitalPostfix", "");
            level.put("kingPrefix", "Duke ");
            level.put("kingPostfix", "");
            level.put("townBlockLimitBonus", 40);
            level.put("upkeepModifier", 1.0);
            level.put("nationTownUpkeepModifier", 1.0);
            level.put("nationZonesSize", 1);
            level.put("nationBonusOutpostLimit", 2);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 30);
            level.put("namePrefix", "Kingdom of ");
            level.put("namePostfix", " (Nation)");
            level.put("capitalPrefix", "");
            level.put("capitalPostfix", "");
            level.put("kingPrefix", "King ");
            level.put("kingPostfix", "");
            level.put("townBlockLimitBonus", 60);
            level.put("upkeepModifier", 1.0);
            level.put("nationTownUpkeepModifier", 1.0);
            level.put("nationZonesSize", 2);
            level.put("nationBonusOutpostLimit", 3);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 40);
            level.put("namePrefix", "The ");
            level.put("namePostfix", " Empire");
            level.put("capitalPrefix", "");
            level.put("capitalPostfix", "");
            level.put("kingPrefix", "Emperor ");
            level.put("kingPostfix", "");
            level.put("townBlockLimitBonus", 100);
            level.put("upkeepModifier", 1.0);
            level.put("nationTownUpkeepModifier", 1.0);
            level.put("nationZonesSize", 2);
            level.put("nationBonusOutpostLimit", 4);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 60);
            level.put("namePrefix", "The ");
            level.put("namePostfix", " Realm");
            level.put("capitalPrefix", "");
            level.put("capitalPostfix", "");
            level.put("kingPrefix", "God Emperor ");
            level.put("kingPostfix", "");
            level.put("townBlockLimitBonus", 140);
            level.put("upkeepModifier", 1.0);
            level.put("nationTownUpkeepModifier", 1.0);
            level.put("nationZonesSize", 3);
            level.put("nationBonusOutpostLimit", 5);
            levels.add(new HashMap(level));
            level.clear();
            newConfig.set(ConfigNodes.LEVELS_NATION_LEVEL.getRoot(), levels);
        } else {
            newConfig.set(ConfigNodes.LEVELS_NATION_LEVEL.getRoot(), config.get(ConfigNodes.LEVELS_NATION_LEVEL.getRoot()));
        }
    }

    public static String[] getRegistrationMsg(String name) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_REGISTRATION"), name));
    }

    public static String[] getNewTownMsg(String who, String town) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_NEW_TOWN"), who, town));
    }

    public static String[] getNewNationMsg(String who, String nation) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_NEW_NATION"), who, nation));
    }

    public static String[] getJoinTownMsg(String who) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_JOIN_TOWN"), who));
    }

    public static String[] getJoinNationMsg(String who) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_JOIN_NATION"), who));
    }

    public static String[] getNewMayorMsg(String who) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_NEW_MAYOR"), who));
    }

    public static String[] getNewKingMsg(String who, String nation) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_NEW_KING"), who, nation));
    }

    public static String[] getJoinWarMsg(TownyObject obj) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_WAR_JOIN"), obj.getName()));
    }

    public static String[] getWarTimeEliminatedMsg(String who) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_WAR_ELIMINATED"), who));
    }

    public static String[] getWarTimeForfeitMsg(String who) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_WAR_FORFEITED"), who));
    }

    public static String[] getWarTimeLoseTownBlockMsg(WorldCoord worldCoord, String town) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_WAR_LOSE_BLOCK"), worldCoord.toString(), town));
    }

    public static String[] getWarTimeScoreMsg(Town town, int n) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_WAR_SCORE"), town.getName(), n));
    }

    public static String[] getWarTimeScoreNationEliminatedMsg(Town town, int n, Nation fallenNation) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_WAR_SCORE_NATION_ELIM"), town.getName(), n, fallenNation.getName()));
    }

    public static String[] getWarTimeScoreTownEliminatedMsg(Town town, int n, Town fallenTown, int fallenTownBlocks) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_WAR_SCORE_TOWN_ELIM"), town.getName(), n, fallenTown.getName(), fallenTownBlocks));
    }

    public static String[] getWarTimeScoreTownBlockEliminatedMsg(Town town, int n, TownBlock fallenTownBlock) {
        String townBlockName = "";
        try {
            Town fallenTown = fallenTownBlock.getTown();
            townBlockName = "[" + fallenTown.getName() + "](" + fallenTownBlock.getCoord().toString() + ")";
        }
        catch (NotRegisteredException e) {
            townBlockName = "(" + fallenTownBlock.getCoord().toString() + ")";
        }
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_WAR_SCORE_TOWNBLOCK_ELIM"), town.getName(), n, townBlockName));
    }

    public static String[] getWarTimeScorePlayerKillMsg(Player attacker, Player dead, int n, Town attackingTown) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_WAR_SCORE_PLAYER_KILL"), attacker.getName(), dead.getName(), n, attackingTown.getName()));
    }

    public static String[] getWarTimeScorePlayerKillMsg(Player attacker, Player dead, Player defender, int n, Town attackingTown) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_WAR_SCORE_PLAYER_KILL_DEFENDING"), attacker.getName(), dead.getName(), defender.getName(), n, attackingTown.getName()));
    }

    public static String[] getWarTimeKingKilled(Nation kingsNation) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_WAR_KING_KILLED"), kingsNation.getName()));
    }

    public static String[] getWarTimeMayorKilled(Town mayorsTown) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_WAR_MAYOR_KILLED"), mayorsTown.getName()));
    }

    public static String[] getWarTimeWinningNationSpoilsMsg(Nation winningNation, String money) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_WAR_WINNING_NATION_SPOILS"), winningNation.getName(), money));
    }

    public static String[] getWarTimeWinningTownSpoilsMsg(Town winningTown, String money, int score) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_WAR_WINNING_TOWN_SPOILS"), winningTown.getName(), money, score));
    }

    public static String[] getCouldntPayTaxesMsg(TownyObject obj, String type) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_COULDNT_PAY_TAXES"), obj.getName(), type));
    }

    public static String getPayedTownTaxMsg() {
        return TownySettings.getLangString("MSG_PAYED_TOWN_TAX");
    }

    public static String getPayedResidentTaxMsg() {
        return TownySettings.getLangString("MSG_PAYED_RESIDENT_TAX");
    }

    public static String getTaxExemptMsg() {
        return TownySettings.getLangString("MSG_TAX_EXEMPT");
    }

    public static String[] getDelResidentMsg(Resident resident) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_DEL_RESIDENT"), resident.getName()));
    }

    public static String[] getDelTownMsg(Town town) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_DEL_TOWN"), town.getName()));
    }

    public static String[] getDelNationMsg(Nation nation) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_DEL_NATION"), nation.getName()));
    }

    public static String[] getBuyResidentPlotMsg(String who, String owner, Double price) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_BUY_RESIDENT_PLOT"), who, owner, price));
    }

    public static String[] getPlotForSaleMsg(String who, WorldCoord worldCoord) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_PLOT_FOR_SALE"), who, worldCoord.toString()));
    }

    public static String getMayorAbondonMsg() {
        return TownySettings.parseSingleLineString(TownySettings.getLangString("MSG_MAYOR_ABANDON"));
    }

    public static String getNotPermToNewTownLine() {
        return TownySettings.parseSingleLineString(TownySettings.getLangString("MSG_ADMIN_ONLY_CREATE_TOWN"));
    }

    public static String getNotPermToNewNationLine() {
        return TownySettings.parseSingleLineString(TownySettings.getLangString("MSG_ADMIN_ONLY_CREATE_NATION"));
    }

    public static String getKingPrefix(Resident resident) {
        try {
            return (String)TownySettings.getNationLevel(resident.getTown().getNation()).get((Object)NationLevel.KING_PREFIX);
        }
        catch (NotRegisteredException e) {
            TownySettings.sendError("getKingPrefix.");
            return "";
        }
    }

    public static String getMayorPrefix(Resident resident) {
        try {
            return (String)TownySettings.getTownLevel(resident.getTown()).get((Object)TownLevel.MAYOR_PREFIX);
        }
        catch (NotRegisteredException e) {
            TownySettings.sendError("getMayorPrefix.");
            return "";
        }
    }

    public static String getCapitalPostfix(Town town) {
        try {
            return (String)TownySettings.getNationLevel(town.getNation()).get((Object)NationLevel.CAPITAL_POSTFIX);
        }
        catch (NotRegisteredException e) {
            TownySettings.sendError("getCapitalPostfix.");
            return "";
        }
    }

    public static String getTownPostfix(Town town) {
        try {
            return (String)TownySettings.getTownLevel(town).get((Object)TownLevel.NAME_POSTFIX);
        }
        catch (Exception e) {
            TownySettings.sendError("getTownPostfix.");
            return "";
        }
    }

    public static String getNationPostfix(Nation nation) {
        try {
            return (String)TownySettings.getNationLevel(nation).get((Object)NationLevel.NAME_POSTFIX);
        }
        catch (Exception e) {
            TownySettings.sendError("getNationPostfix.");
            return "";
        }
    }

    public static String getNationPrefix(Nation nation) {
        try {
            return (String)TownySettings.getNationLevel(nation).get((Object)NationLevel.NAME_PREFIX);
        }
        catch (Exception e) {
            TownySettings.sendError("getNationPrefix.");
            return "";
        }
    }

    public static String getTownPrefix(Town town) {
        try {
            return (String)TownySettings.getTownLevel(town).get((Object)TownLevel.NAME_PREFIX);
        }
        catch (Exception e) {
            TownySettings.sendError("getTownPrefix.");
            return "";
        }
    }

    public static String getCapitalPrefix(Town town) {
        try {
            return (String)TownySettings.getNationLevel(town.getNation()).get((Object)NationLevel.CAPITAL_PREFIX);
        }
        catch (NotRegisteredException e) {
            TownySettings.sendError("getCapitalPrefix.");
            return "";
        }
    }

    public static String getKingPostfix(Resident resident) {
        try {
            return (String)TownySettings.getNationLevel(resident.getTown().getNation()).get((Object)NationLevel.KING_POSTFIX);
        }
        catch (NotRegisteredException e) {
            TownySettings.sendError("getKingPostfix.");
            return "";
        }
    }

    public static String getMayorPostfix(Resident resident) {
        try {
            return (String)TownySettings.getTownLevel(resident.getTown()).get((Object)TownLevel.MAYOR_POSTFIX);
        }
        catch (NotRegisteredException e) {
            TownySettings.sendError("getMayorPostfix.");
            return "";
        }
    }

    public static String getNPCPrefix() {
        return TownySettings.getString(ConfigNodes.FILTERS_NPC_PREFIX.getRoot(), ConfigNodes.FILTERS_NPC_PREFIX.getDefault());
    }

    public static long getInactiveAfter() {
        return TownySettings.getSeconds(ConfigNodes.RES_SETTING_INACTIVE_AFTER_TIME);
    }

    public static boolean getBedUse() {
        return TownySettings.getBoolean(ConfigNodes.RES_SETTING_DENY_BED_USE);
    }

    public static String getLoadDatabase() {
        return TownySettings.getString(ConfigNodes.PLUGIN_DATABASE_LOAD);
    }

    public static String getSaveDatabase() {
        return TownySettings.getString(ConfigNodes.PLUGIN_DATABASE_SAVE);
    }

    public static String getSQLHostName() {
        return TownySettings.getString(ConfigNodes.PLUGIN_DATABASE_HOSTNAME);
    }

    public static String getSQLPort() {
        return TownySettings.getString(ConfigNodes.PLUGIN_DATABASE_PORT);
    }

    public static String getSQLDBName() {
        return TownySettings.getString(ConfigNodes.PLUGIN_DATABASE_DBNAME);
    }

    public static String getSQLTablePrefix() {
        return TownySettings.getString(ConfigNodes.PLUGIN_DATABASE_TABLEPREFIX);
    }

    public static String getSQLUsername() {
        return TownySettings.getString(ConfigNodes.PLUGIN_DATABASE_USERNAME);
    }

    public static String getSQLPassword() {
        return TownySettings.getString(ConfigNodes.PLUGIN_DATABASE_PASSWORD);
    }

    public static boolean getSQLUsingSSL() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_DATABASE_SSL);
    }

    public static int getMaxTownBlocks(Town town) {
        int ratio = TownySettings.getTownBlockRatio();
        int n = town.getBonusBlocks() + town.getPurchasedBlocks();
        n = ratio == 0 ? (n += ((Integer)TownySettings.getTownLevel(town).get((Object)TownLevel.TOWN_BLOCK_LIMIT)).intValue()) : (n += town.getNumResidents() * ratio);
        if (town.hasNation()) {
            try {
                n += ((Integer)TownySettings.getNationLevel(town.getNation()).get((Object)NationLevel.TOWN_BLOCK_LIMIT_BONUS)).intValue();
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        return n;
    }

    public static int getMaxOutposts(Town town) {
        int townOutposts = (Integer)TownySettings.getTownLevel(town).get((Object)TownLevel.OUTPOST_LIMIT);
        int nationOutposts = 0;
        if (town.hasNation()) {
            try {
                nationOutposts = (Integer)TownySettings.getNationLevel(town.getNation()).get((Object)NationLevel.NATION_BONUS_OUTPOST_LIMIT);
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        int n = townOutposts + nationOutposts;
        return n;
    }

    public static int getMaxBonusBlocks(Town town) {
        return (Integer)TownySettings.getTownLevel(town).get((Object)TownLevel.TOWN_BLOCK_BUY_BONUS_LIMIT);
    }

    public static int getNationBonusBlocks(Nation nation) {
        return (Integer)TownySettings.getNationLevel(nation).get((Object)NationLevel.TOWN_BLOCK_LIMIT_BONUS);
    }

    public static int getNationBonusBlocks(Town town) {
        if (town.hasNation()) {
            try {
                return TownySettings.getNationBonusBlocks(town.getNation());
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        return 0;
    }

    public static int getTownBlockRatio() {
        return TownySettings.getInt(ConfigNodes.TOWN_TOWN_BLOCK_RATIO);
    }

    public static int getTownBlockSize() {
        return TownySettings.getInt(ConfigNodes.TOWN_TOWN_BLOCK_SIZE);
    }

    public static boolean getFriendlyFire() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_FRIENDLY_FIRE);
    }

    public static boolean isUsingEconomy() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_USING_ECONOMY);
    }

    public static boolean isFakeResident(String name) {
        return TownySettings.getString(ConfigNodes.PLUGIN_MODS_FAKE_RESIDENTS).toLowerCase().contains(name.toLowerCase());
    }

    public static boolean isUsingEssentials() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_USING_ESSENTIALS);
    }

    public static void setUsingEssentials(boolean newSetting) {
        TownySettings.setProperty(ConfigNodes.PLUGIN_USING_ESSENTIALS.getRoot(), newSetting);
    }

    public static double getNewTownPrice() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_NEW_TOWN);
    }

    public static double getNewNationPrice() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_NEW_NATION);
    }

    public static boolean getUnclaimedZoneBuildRights() {
        return TownySettings.getBoolean(ConfigNodes.UNCLAIMED_ZONE_BUILD);
    }

    public static boolean getUnclaimedZoneDestroyRights() {
        return TownySettings.getBoolean(ConfigNodes.UNCLAIMED_ZONE_DESTROY);
    }

    public static boolean getUnclaimedZoneItemUseRights() {
        return TownySettings.getBoolean(ConfigNodes.UNCLAIMED_ZONE_ITEM_USE);
    }

    public static boolean getDebug() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_DEBUG_MODE);
    }

    public static String getTool() {
        return TownySettings.getString(ConfigNodes.PLUGIN_INFO_TOOL);
    }

    public static void setDebug(boolean b) {
        TownySettings.setProperty(ConfigNodes.PLUGIN_DEBUG_MODE.getRoot(), b);
    }

    public static boolean getShowTownNotifications() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_SHOW_TOWN_NOTIFICATIONS);
    }

    public static boolean isNotificationOwnerShowingNationTitles() {
        return TownySettings.getBoolean(ConfigNodes.NOTIFICATION_OWNER_SHOWS_NATION_TITLE);
    }

    public static boolean getShowTownBoardOnLogin() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_DISPLAY_TOWNBOARD_ONLOGIN);
    }

    public static boolean getShowNationBoardOnLogin() {
        return TownySettings.getBoolean(ConfigNodes.GNATION_SETTINGS_DISPLAY_NATIONBOARD_ONLOGIN);
    }

    public static String getUnclaimedZoneName() {
        return TownySettings.getLangString("UNCLAIMED_ZONE_NAME");
    }

    public static int getMaxTitleLength() {
        return TownySettings.getInt(ConfigNodes.FILTERS_MODIFY_CHAT_MAX_LGTH);
    }

    public static int getMaxNameLength() {
        return TownySettings.getInt(ConfigNodes.FILTERS_MAX_NAME_LGTH);
    }

    public static long getDeleteTime() {
        return TownySettings.getSeconds(ConfigNodes.RES_SETTING_DELETE_OLD_RESIDENTS_TIME);
    }

    public static boolean isDeleteEcoAccount() {
        return TownySettings.getBoolean(ConfigNodes.RES_SETTING_DELETE_OLD_RESIDENTS_ECO);
    }

    public static boolean isDeleteTownlessOnly() {
        return TownySettings.getBoolean(ConfigNodes.RES_SETTING_DELETE_OLD_RESIDENTS_TOWNLESS_ONLY);
    }

    public static boolean isDeletingOldResidents() {
        return TownySettings.getBoolean(ConfigNodes.RES_SETTING_DELETE_OLD_RESIDENTS_ENABLE);
    }

    public static int getWarTimeWarningDelay() {
        return TownySettings.getInt(ConfigNodes.WAR_EVENT_WARNING_DELAY);
    }

    public static boolean isWarTimeTownsNeutral() {
        return TownySettings.getBoolean(ConfigNodes.WAR_EVENT_TOWNS_NEUTRAL);
    }

    public static boolean isAllowWarBlockGriefing() {
        return TownySettings.getBoolean(ConfigNodes.WAR_EVENT_BLOCK_GRIEFING);
    }

    public static int getWarzoneTownBlockHealth() {
        return TownySettings.getInt(ConfigNodes.WAR_EVENT_TOWN_BLOCK_HP);
    }

    public static int getWarzoneHomeBlockHealth() {
        return TownySettings.getInt(ConfigNodes.WAR_EVENT_HOME_BLOCK_HP);
    }

    public static String[] getWarTimeLoseTownBlockMsg(WorldCoord worldCoord) {
        return TownySettings.getWarTimeLoseTownBlockMsg(worldCoord, "");
    }

    public static String getDefaultTownName() {
        return TownySettings.getString(ConfigNodes.RES_SETTING_DEFAULT_TOWN_NAME);
    }

    public static int getWarPointsForTownBlock() {
        return TownySettings.getInt(ConfigNodes.WAR_EVENT_POINTS_TOWNBLOCK);
    }

    public static int getWarPointsForTown() {
        return TownySettings.getInt(ConfigNodes.WAR_EVENT_POINTS_TOWN);
    }

    public static int getWarPointsForNation() {
        return TownySettings.getInt(ConfigNodes.WAR_EVENT_POINTS_NATION);
    }

    public static int getWarPointsForKill() {
        return TownySettings.getInt(ConfigNodes.WAR_EVENT_POINTS_KILL);
    }

    public static int getMinWarHeight() {
        return TownySettings.getInt(ConfigNodes.WAR_EVENT_MIN_HEIGHT);
    }

    public static List<String> getWorldMobRemovalEntities() {
        if (TownySettings.getDebug()) {
            System.out.println("[Towny] Debug: Reading World Mob removal entities. ");
        }
        return TownySettings.getStrArr(ConfigNodes.PROT_MOB_REMOVE_WORLD);
    }

    public static List<String> getTownMobRemovalEntities() {
        if (TownySettings.getDebug()) {
            System.out.println("[Towny] Debug: Reading Town Mob removal entities. ");
        }
        return TownySettings.getStrArr(ConfigNodes.PROT_MOB_REMOVE_TOWN);
    }

    public static boolean isEconomyAsync() {
        return TownySettings.getBoolean(ConfigNodes.ECO_USE_ASYNC);
    }

    public static boolean isRemovingVillagerBabiesWorld() {
        return TownySettings.getBoolean(ConfigNodes.PROT_MOB_REMOVE_VILLAGER_BABIES_WORLD);
    }

    public static boolean isCreatureTriggeringPressurePlateDisabled() {
        return TownySettings.getBoolean(ConfigNodes.PROT_MOB_DISABLE_TRIGGER_PRESSURE_PLATE_STONE);
    }

    public static boolean isRemovingVillagerBabiesTown() {
        return TownySettings.getBoolean(ConfigNodes.PROT_MOB_REMOVE_VILLAGER_BABIES_TOWN);
    }

    public static List<String> getWildExplosionProtectionEntities() {
        if (TownySettings.getDebug()) {
            System.out.println("[Towny] Debug: Wilderness explosion protection entities. ");
        }
        return TownySettings.getStrArr(ConfigNodes.NWS_PLOT_MANAGEMENT_WILD_ENTITY_REVERT_LIST);
    }

    public static long getMobRemovalSpeed() {
        return TownySettings.getSeconds(ConfigNodes.PROT_MOB_REMOVE_SPEED);
    }

    public static long getHealthRegenSpeed() {
        return TownySettings.getSeconds(ConfigNodes.GTOWN_SETTINGS_REGEN_SPEED);
    }

    public static boolean hasHealthRegen() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_REGEN_ENABLE);
    }

    public static boolean getTownDefaultPublic() {
        return TownySettings.getBoolean(ConfigNodes.TOWN_DEF_PUBLIC);
    }

    public static boolean getTownDefaultOpen() {
        return TownySettings.getBoolean(ConfigNodes.TOWN_DEF_OPEN);
    }

    public static boolean getNationDefaultOpen() {
        return TownySettings.getBoolean(ConfigNodes.GNATION_DEF_OPEN);
    }

    public static double getTownDefaultTax() {
        return TownySettings.getDouble(ConfigNodes.TOWN_DEF_TAXES_TAX);
    }

    public static double getTownDefaultShopTax() {
        return TownySettings.getDouble(ConfigNodes.TOWN_DEF_TAXES_SHOP_TAX);
    }

    public static double getTownDefaultEmbassyTax() {
        return TownySettings.getDouble(ConfigNodes.TOWN_DEF_TAXES_EMBASSY_TAX);
    }

    public static double getTownDefaultPlotTax() {
        return TownySettings.getDouble(ConfigNodes.TOWN_DEF_TAXES_PLOT_TAX);
    }

    public static boolean getTownDefaultTaxPercentage() {
        return TownySettings.getBoolean(ConfigNodes.TOWN_DEF_TAXES_TAXPERCENTAGE);
    }

    public static double getTownDefaultTaxMinimumTax() {
        return TownySettings.getDouble(ConfigNodes.TOWN_DEF_TAXES_MINIMUMTAX);
    }

    public static boolean hasTownLimit() {
        return TownySettings.getTownLimit() != 0;
    }

    public static int getTownLimit() {
        return TownySettings.getInt(ConfigNodes.TOWN_LIMIT);
    }

    public static int getMaxPurchedBlocks(Town town) {
        if (TownySettings.isBonusBlocksPerTownLevel()) {
            return TownySettings.getMaxBonusBlocks(town);
        }
        return TownySettings.getInt(ConfigNodes.TOWN_MAX_PURCHASED_BLOCKS);
    }

    public static int getMaxClaimRadiusValue() {
        return TownySettings.getInt(ConfigNodes.TOWN_MAX_CLAIM_RADIUS_VALUE);
    }

    public static boolean isSellingBonusBlocks(Town town) {
        return TownySettings.getMaxPurchedBlocks(town) != 0;
    }

    public static boolean isBonusBlocksPerTownLevel() {
        return TownySettings.getBoolean(ConfigNodes.TOWN_MAX_PURCHASED_BLOCKS_USES_TOWN_LEVELS);
    }

    public static double getPurchasedBonusBlocksCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_PURCHASED_BONUS_TOWNBLOCK);
    }

    public static double getPurchasedBonusBlocksIncreaseValue() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_PURCHASED_BONUS_TOWNBLOCK_INCREASE);
    }

    public static boolean isTownSpawnPaidToTown() {
        return TownySettings.getBoolean(ConfigNodes.ECO_PRICE_TOWN_SPAWN_PAID_TO_TOWN);
    }

    public static double getNationNeutralityCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_NATION_NEUTRALITY);
    }

    public static boolean isAllowingOutposts() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_ALLOW_OUTPOSTS);
    }

    public static boolean isOutpostsLimitedByLevels() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_LIMIT_OUTPOST_USING_LEVELS);
    }

    public static boolean isOutpostLimitStoppingTeleports() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_OVER_OUTPOST_LIMIT_STOP_TELEPORT);
    }

    public static double getOutpostCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_OUTPOST);
    }

    private static List<String> getSwitchMaterials() {
        return TownySettings.getStrArr(ConfigNodes.PROT_SWITCH_MAT);
    }

    private static List<String> getItemUseMaterials() {
        return TownySettings.getStrArr(ConfigNodes.PROT_ITEM_USE_MAT);
    }

    public static boolean isSwitchMaterial(String mat) {
        return TownySettings.getSwitchMaterials().contains(mat);
    }

    public static boolean isItemUseMaterial(String mat) {
        return TownySettings.getItemUseMaterials().contains(mat);
    }

    public static List<String> getUnclaimedZoneIgnoreMaterials() {
        return TownySettings.getStrArr(ConfigNodes.UNCLAIMED_ZONE_IGNORE);
    }

    public static List<String> getEntityTypes() {
        return TownySettings.getStrArr(ConfigNodes.PROT_MOB_TYPES);
    }

    public static List<String> getPotionTypes() {
        return TownySettings.getStrArr(ConfigNodes.PROT_POTION_TYPES);
    }

    private static void setProperty(String root, Object value) {
        config.set(root.toLowerCase(), value.toString());
    }

    private static void setNewProperty(String root, Object value) {
        if (value == null) {
            value = "";
        }
        newConfig.set(root.toLowerCase(), value.toString());
    }

    public static Object getProperty(String root) {
        return config.get(root.toLowerCase());
    }

    public static double getClaimPrice() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_CLAIM_TOWNBLOCK);
    }

    public static double getClaimPriceIncreaseValue() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_CLAIM_TOWNBLOCK_INCREASE);
    }

    public static double getClaimRefundPrice() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_CLAIM_TOWNBLOCK_REFUND);
    }

    public static boolean getUnclaimedZoneSwitchRights() {
        return TownySettings.getBoolean(ConfigNodes.UNCLAIMED_ZONE_SWITCH);
    }

    public static boolean getEndermanProtect() {
        return TownySettings.getBoolean(ConfigNodes.NWS_WORLD_ENDERMAN);
    }

    public static String getUnclaimedPlotName() {
        return TownySettings.getLangString("UNCLAIMED_PLOT_NAME");
    }

    public static long getDayInterval() {
        return TownySettings.getSeconds(ConfigNodes.PLUGIN_DAY_INTERVAL);
    }

    public static long getNewDayTime() {
        long day;
        long time = TownySettings.getSeconds(ConfigNodes.PLUGIN_NEWDAY_TIME);
        if (time > (day = TownySettings.getDayInterval())) {
            TownySettings.setProperty(ConfigNodes.PLUGIN_NEWDAY_TIME.getRoot(), day);
            return day;
        }
        return time;
    }

    public static TownSpawnLevel.SpawnLevel isAllowingTownSpawn() {
        return TownySettings.getSpawnLevel(ConfigNodes.GTOWN_SETTINGS_ALLOW_TOWN_SPAWN);
    }

    public static TownSpawnLevel.SpawnLevel isAllowingPublicTownSpawnTravel() {
        return TownySettings.getSpawnLevel(ConfigNodes.GTOWN_SETTINGS_ALLOW_TOWN_SPAWN_TRAVEL);
    }

    public static NationSpawnLevel.NSpawnLevel isAllowingNationSpawn() {
        return TownySettings.getNSpawnLevel(ConfigNodes.GNATION_SETTINGS_ALLOW_NATION_SPAWN);
    }

    public static NationSpawnLevel.NSpawnLevel isAllowingPublicNationSpawnTravel() {
        return TownySettings.getNSpawnLevel(ConfigNodes.GNATION_SETTINGS_ALLOW_NATION_SPAWN_TRAVEL);
    }

    public static List<String> getDisallowedTownSpawnZones() {
        if (TownySettings.getDebug()) {
            System.out.println("[Towny] Debug: Reading disallowed town spawn zones. ");
        }
        return TownySettings.getStrArr(ConfigNodes.GTOWN_SETTINGS_PREVENT_TOWN_SPAWN_IN);
    }

    public static boolean isTaxingDaily() {
        return TownySettings.getBoolean(ConfigNodes.ECO_DAILY_TAXES_ENABLED);
    }

    public static double getMaxTax() {
        return TownySettings.getDouble(ConfigNodes.ECO_DAILY_TAXES_MAX_TAX);
    }

    public static double getMaxPlotPrice() {
        return TownySettings.getDouble(ConfigNodes.GTOWN_MAX_PLOT_PRICE_COST);
    }

    public static double getMaxTaxPercent() {
        return TownySettings.getDouble(ConfigNodes.ECO_DAILY_TAXES_MAX_TAX_PERCENT);
    }

    public static boolean isBackingUpDaily() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_DAILY_BACKUPS);
    }

    public static double getBaseSpoilsOfWar() {
        return TownySettings.getDouble(ConfigNodes.WAR_EVENT_BASE_SPOILS);
    }

    public static boolean getOnlyAttackEdgesInWar() {
        return TownySettings.getBoolean(ConfigNodes.WAR_EVENT_ENEMY_ONLY_ATTACK_BORDER);
    }

    public static boolean getPlotsHealableInWar() {
        return TownySettings.getBoolean(ConfigNodes.WAR_EVENT_PLOTS_HEALABLE);
    }

    public static boolean getPlotsFireworkOnAttacked() {
        return TownySettings.getBoolean(ConfigNodes.WAR_EVENT_PLOTS_FIREWORK_ON_ATTACKED);
    }

    public static double getWartimeDeathPrice() {
        return TownySettings.getDouble(ConfigNodes.WAR_EVENT_PRICE_DEATH);
    }

    public static boolean getWarEventCostsTownblocks() {
        return TownySettings.getBoolean(ConfigNodes.WAR_EVENT_COSTS_TOWNBLOCKS);
    }

    public static boolean getWarEventWinnerTakesOwnershipOfTownblocks() {
        return TownySettings.getBoolean(ConfigNodes.WAR_EVENT_WINNER_TAKES_OWNERSHIP_OF_TOWNBLOCKS);
    }

    public static boolean isChargingDeath() {
        return TownySettings.getDeathPrice() > 0.0 || TownySettings.getDeathPriceTown() > 0.0 || TownySettings.getDeathPriceNation() > 0.0;
    }

    public static boolean isDeathPriceType() {
        return TownySettings.getString(ConfigNodes.ECO_PRICE_DEATH_TYPE).equalsIgnoreCase("fixed");
    }

    public static double getDeathPricePercentageCap() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_DEATH_PERCENTAGE_CAP);
    }

    public static boolean isDeathPricePercentageCapped() {
        return TownySettings.getDeathPricePercentageCap() > 0.0;
    }

    public static boolean isDeathPricePVPOnly() {
        return TownySettings.getBoolean(ConfigNodes.ECO_PRICE_DEATH_PVP_ONLY);
    }

    public static double getDeathPrice() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_DEATH);
    }

    public static double getDeathPriceTown() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_DEATH_TOWN);
    }

    public static double getDeathPriceNation() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_DEATH_NATION);
    }

    public static boolean isEcoClosedEconomyEnabled() {
        return TownySettings.getBoolean(ConfigNodes.ECO_CLOSED_ECONOMY_ENABLED);
    }

    public static boolean isJailingAttackingEnemies() {
        return TownySettings.getBoolean(ConfigNodes.JAIL_IS_JAILING_ATTACKING_ENEMIES);
    }

    public static boolean isJailingAttackingOutlaws() {
        return TownySettings.getBoolean(ConfigNodes.JAIL_IS_JAILING_ATTACKING_OUTLAWS);
    }

    public static boolean JailAllowsEnderPearls() {
        return TownySettings.getBoolean(ConfigNodes.JAIL_JAIL_ALLOWS_ENDER_PEARLS);
    }

    public static boolean JailDeniesTownLeave() {
        return TownySettings.getBoolean(ConfigNodes.JAIL_JAIL_DENIES_TOWN_LEAVE);
    }

    public static boolean isAllowingBail() {
        return TownySettings.getBoolean(ConfigNodes.JAIL_BAIL_IS_ALLOWING_BAIL);
    }

    public static double getBailAmount() {
        return TownySettings.getDouble(ConfigNodes.JAIL_BAIL_BAIL_AMOUNT);
    }

    public static double getBailAmountMayor() {
        return TownySettings.getDouble(ConfigNodes.JAIL_BAIL_BAIL_AMOUNT_MAYOR);
    }

    public static double getBailAmountKing() {
        return TownySettings.getDouble(ConfigNodes.JAIL_BAIL_BAIL_AMOUNT_KING);
    }

    public static double getWartimeTownBlockLossPrice() {
        return TownySettings.getDouble(ConfigNodes.WAR_EVENT_TOWN_BLOCK_LOSS_PRICE);
    }

    public static boolean isDevMode() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_DEV_MODE_ENABLE);
    }

    public static void setDevMode(boolean choice) {
        TownySettings.setProperty(ConfigNodes.PLUGIN_DEV_MODE_ENABLE.getRoot(), choice);
    }

    public static String getDevName() {
        return TownySettings.getString(ConfigNodes.PLUGIN_DEV_MODE_DEV_NAME);
    }

    public static boolean isDeclaringNeutral() {
        return TownySettings.getBoolean(ConfigNodes.WARTIME_NATION_CAN_BE_NEUTRAL);
    }

    public static void setDeclaringNeutral(boolean choice) {
        TownySettings.setProperty(ConfigNodes.WARTIME_NATION_CAN_BE_NEUTRAL.getRoot(), choice);
    }

    public static boolean isRemovingOnMonarchDeath() {
        return TownySettings.getBoolean(ConfigNodes.WAR_EVENT_REMOVE_ON_MONARCH_DEATH);
    }

    public static double getTownUpkeepCost(Town town) {
        double multiplier = town != null ? (TownySettings.isUpkeepByPlot() ? (double)town.getTownBlocks().size() : Double.valueOf(TownySettings.getTownLevel(town).get((Object)TownLevel.UPKEEP_MULTIPLIER).toString())) : 1.0;
        Double amount = 0.0;
        if (town.hasNation()) {
            double nationMultiplier = 1.0;
            try {
                nationMultiplier = Double.valueOf(TownySettings.getNationLevel(town.getNation()).get((Object)NationLevel.NATION_TOWN_UPKEEP_MULTIPLIER).toString());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
            }
            if (TownySettings.isUpkeepByPlot() && TownySettings.isTownLevelModifiersAffectingPlotBasedUpkeep()) {
                amount = TownySettings.getTownUpkeep() * multiplier * Double.valueOf(TownySettings.getTownLevel(town).get((Object)TownLevel.UPKEEP_MULTIPLIER).toString()) * nationMultiplier;
                if (TownySettings.getPlotBasedUpkeepMinimumAmount() > 0.0 && amount < TownySettings.getPlotBasedUpkeepMinimumAmount()) {
                    amount = TownySettings.getPlotBasedUpkeepMinimumAmount();
                }
                return amount;
            }
            return TownySettings.getTownUpkeep() * multiplier * nationMultiplier;
        }
        if (TownySettings.isUpkeepByPlot() && TownySettings.isTownLevelModifiersAffectingPlotBasedUpkeep()) {
            amount = TownySettings.getTownUpkeep() * multiplier * Double.valueOf(TownySettings.getTownLevel(town).get((Object)TownLevel.UPKEEP_MULTIPLIER).toString());
            if (TownySettings.getPlotBasedUpkeepMinimumAmount() > 0.0 && amount < TownySettings.getPlotBasedUpkeepMinimumAmount()) {
                amount = TownySettings.getPlotBasedUpkeepMinimumAmount();
            }
            return amount;
        }
        return TownySettings.getTownUpkeep() * multiplier;
    }

    public static double getTownUpkeep() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_TOWN_UPKEEP);
    }

    public static boolean isUpkeepByPlot() {
        return TownySettings.getBoolean(ConfigNodes.ECO_PRICE_TOWN_UPKEEP_PLOTBASED);
    }

    public static double getPlotBasedUpkeepMinimumAmount() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_TOWN_UPKEEP_PLOTBASED_MINIMUM_AMOUNT);
    }

    public static boolean isTownLevelModifiersAffectingPlotBasedUpkeep() {
        return TownySettings.getBoolean(ConfigNodes.ECO_PRICE_TOWN_UPKEEP_PLOTBASED_TOWNLEVEL_MODIFIER);
    }

    public static boolean isUpkeepPayingPlots() {
        return TownySettings.getBoolean(ConfigNodes.ECO_UPKEEP_PLOTPAYMENTS);
    }

    public static double getTownPenaltyUpkeepCost(Town town) {
        if (TownySettings.getUpkeepPenalty() > 0.0) {
            int claimed = town.getTownBlocks().size();
            int allowedClaims = TownySettings.getMaxTownBlocks(town);
            int overClaimed = claimed - allowedClaims;
            if (!town.isOverClaimed()) {
                return 0.0;
            }
            if (TownySettings.isUpkeepPenaltyByPlot()) {
                return TownySettings.getUpkeepPenalty() * (double)overClaimed;
            }
            return TownySettings.getUpkeepPenalty();
        }
        return 0.0;
    }

    public static double getUpkeepPenalty() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_TOWN_OVERCLAIMED_UPKEEP_PENALTY);
    }

    public static boolean isUpkeepPenaltyByPlot() {
        return TownySettings.getBoolean(ConfigNodes.ECO_PRICE_TOWN_OVERCLAIMED_UPKEEP_PENALTY_PLOTBASED);
    }

    public static double getNationUpkeep() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_NATION_UPKEEP);
    }

    public static double getNationUpkeepCost(Nation nation) {
        double multiplier;
        if (nation != null) {
            if (TownySettings.isNationUpkeepPerTown()) {
                if (TownySettings.isNationLevelModifierAffectingNationUpkeepPerTown()) {
                    return TownySettings.getNationUpkeep() * (double)nation.getTowns().size() * Double.valueOf(TownySettings.getNationLevel(nation).get((Object)NationLevel.UPKEEP_MULTIPLIER).toString());
                }
                return TownySettings.getNationUpkeep() * (double)nation.getTowns().size();
            }
            multiplier = Double.valueOf(TownySettings.getNationLevel(nation).get((Object)NationLevel.UPKEEP_MULTIPLIER).toString());
        } else {
            multiplier = 1.0;
        }
        return TownySettings.getNationUpkeep() * multiplier;
    }

    private static boolean isNationLevelModifierAffectingNationUpkeepPerTown() {
        return TownySettings.getBoolean(ConfigNodes.ECO_PRICE_NATION_UPKEEP_PERTOWN_NATIONLEVEL_MODIFIER);
    }

    private static boolean isNationUpkeepPerTown() {
        return TownySettings.getBoolean(ConfigNodes.ECO_PRICE_NATION_UPKEEP_PERTOWN);
    }

    public static boolean getNationDefaultPublic() {
        return TownySettings.getBoolean(ConfigNodes.GNATION_DEF_PUBLIC);
    }

    public static String getFlatFileBackupType() {
        return TownySettings.getString(ConfigNodes.PLUGIN_FLATFILE_BACKUP);
    }

    public static long getBackupLifeLength() {
        long t = TimeTools.getMillis(TownySettings.getString(ConfigNodes.PLUGIN_BACKUPS_ARE_DELETED_AFTER));
        long minT = TimeTools.getMillis("1d");
        if (t >= 0L && t < minT) {
            t = minT;
        }
        return t;
    }

    public static boolean isUsingTowny() {
        return TownySettings.getBoolean(ConfigNodes.NWS_WORLD_USING_TOWNY);
    }

    public static boolean isPvP() {
        return TownySettings.getBoolean(ConfigNodes.NWS_WORLD_PVP);
    }

    public static boolean isForcingPvP() {
        return TownySettings.getBoolean(ConfigNodes.NWS_FORCE_PVP_ON);
    }

    public static boolean isPlayerTramplingCropsDisabled() {
        return TownySettings.getBoolean(ConfigNodes.NWS_DISABLE_PLAYER_CROP_TRAMPLING);
    }

    public static boolean isCreatureTramplingCropsDisabled() {
        return TownySettings.getBoolean(ConfigNodes.NWS_DISABLE_CREATURE_CROP_TRAMPLING);
    }

    public static boolean isWorldMonstersOn() {
        return TownySettings.getBoolean(ConfigNodes.NWS_WORLD_MONSTERS_ON);
    }

    public static boolean isExplosions() {
        return TownySettings.getBoolean(ConfigNodes.NWS_WORLD_EXPLOSION);
    }

    public static boolean isForcingExplosions() {
        return TownySettings.getBoolean(ConfigNodes.NWS_FORCE_EXPLOSIONS_ON);
    }

    public static boolean isForcingMonsters() {
        return TownySettings.getBoolean(ConfigNodes.NWS_FORCE_TOWN_MONSTERS_ON);
    }

    public static boolean isFire() {
        return TownySettings.getBoolean(ConfigNodes.NWS_WORLD_FIRE);
    }

    public static boolean isForcingFire() {
        return TownySettings.getBoolean(ConfigNodes.NWS_FORCE_FIRE_ON);
    }

    public static boolean isUsingPlotManagementDelete() {
        return TownySettings.getBoolean(ConfigNodes.NWS_PLOT_MANAGEMENT_DELETE_ENABLE);
    }

    public static List<String> getPlotManagementDeleteIds() {
        return TownySettings.getStrArr(ConfigNodes.NWS_PLOT_MANAGEMENT_DELETE);
    }

    public static boolean isUsingPlotManagementMayorDelete() {
        return TownySettings.getBoolean(ConfigNodes.NWS_PLOT_MANAGEMENT_MAYOR_DELETE_ENABLE);
    }

    public static List<String> getPlotManagementMayorDelete() {
        return TownySettings.getStrArr(ConfigNodes.NWS_PLOT_MANAGEMENT_MAYOR_DELETE);
    }

    public static boolean isUsingPlotManagementRevert() {
        return TownySettings.getBoolean(ConfigNodes.NWS_PLOT_MANAGEMENT_REVERT_ENABLE);
    }

    public static long getPlotManagementSpeed() {
        return TownySettings.getSeconds(ConfigNodes.NWS_PLOT_MANAGEMENT_REVERT_TIME);
    }

    public static boolean isUsingPlotManagementWildRegen() {
        return TownySettings.getBoolean(ConfigNodes.NWS_PLOT_MANAGEMENT_WILD_MOB_REVERT_ENABLE);
    }

    public static long getPlotManagementWildRegenDelay() {
        return TownySettings.getSeconds(ConfigNodes.NWS_PLOT_MANAGEMENT_WILD_MOB_REVERT_TIME);
    }

    public static List<String> getPlotManagementIgnoreIds() {
        return TownySettings.getStrArr(ConfigNodes.NWS_PLOT_MANAGEMENT_REVERT_IGNORE);
    }

    public static boolean isTownRespawning() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_TOWN_RESPAWN);
    }

    public static boolean isTownRespawningInOtherWorlds() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_TOWN_RESPAWN_SAME_WORLD_ONLY);
    }

    public static int getMaxResidentsPerTown() {
        return TownySettings.getInt(ConfigNodes.GTOWN_MAX_RESIDENTS_PER_TOWN);
    }

    public static boolean isTownyUpdating(String currentVersion) {
        return !TownySettings.isTownyUpToDate(currentVersion);
    }

    public static boolean isTownyUpToDate(String currentVersion) {
        return currentVersion.equals(TownySettings.getLastRunVersion(currentVersion));
    }

    public static String getLastRunVersion(String currentVersion) {
        return TownySettings.getString(ConfigNodes.LAST_RUN_VERSION.getRoot(), currentVersion);
    }

    public static void setLastRunVersion(String currentVersion) {
        TownySettings.setProperty(ConfigNodes.LAST_RUN_VERSION.getRoot(), currentVersion);
        config.save();
    }

    public static int getMinDistanceFromTownHomeblocks() {
        return TownySettings.getInt(ConfigNodes.TOWN_MIN_DISTANCE_FROM_TOWN_HOMEBLOCK);
    }

    public static int getMinDistanceForOutpostsFromPlot() {
        return TownySettings.getInt(ConfigNodes.TOWN_MIN_DISTANCE_FOR_OUTPOST_FROM_PLOT);
    }

    public static int getMinDistanceFromTownPlotblocks() {
        return TownySettings.getInt(ConfigNodes.TOWN_MIN_PLOT_DISTANCE_FROM_TOWN_PLOT);
    }

    public static int getMaxDistanceBetweenHomeblocks() {
        return TownySettings.getInt(ConfigNodes.TOWN_MAX_DISTANCE_BETWEEN_HOMEBLOCKS);
    }

    public static int getMaxResidentPlots(Resident resident) {
        int maxPlots = TownyUniverse.getInstance().getPermissionSource().getGroupPermissionIntNode(resident.getName(), PermissionNodes.TOWNY_MAX_PLOTS.getNode());
        if (maxPlots == -1) {
            maxPlots = TownySettings.getInt(ConfigNodes.TOWN_MAX_PLOTS_PER_RESIDENT);
        }
        return maxPlots;
    }

    public static int getMaxResidentExtraPlots(Resident resident) {
        int extraPlots = TownyUniverse.getInstance().getPermissionSource().getPlayerPermissionIntNode(resident.getName(), PermissionNodes.TOWNY_EXTRA_PLOTS.getNode());
        if (extraPlots == -1) {
            extraPlots = 0;
        }
        return extraPlots;
    }

    public static int getMaxResidentOutposts(Resident resident) {
        int maxOutposts = TownyUniverse.getInstance().getPermissionSource().getGroupPermissionIntNode(resident.getName(), PermissionNodes.TOWNY_MAX_OUTPOSTS.getNode());
        return maxOutposts;
    }

    public static boolean getPermFlag_Resident_Friend_Build() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_FR_BUILD);
    }

    public static boolean getPermFlag_Resident_Friend_Destroy() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_FR_DESTROY);
    }

    public static boolean getPermFlag_Resident_Friend_ItemUse() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_FR_ITEM_USE);
    }

    public static boolean getPermFlag_Resident_Friend_Switch() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_FR_SWITCH);
    }

    public static boolean getPermFlag_Resident_Town_Build() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_TOWN_BUILD);
    }

    public static boolean getPermFlag_Resident_Town_Destroy() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_TOWN_DESTROY);
    }

    public static boolean getPermFlag_Resident_Town_ItemUse() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_TOWN_ITEM_USE);
    }

    public static boolean getPermFlag_Resident_Town_Switch() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_TOWN_SWITCH);
    }

    public static boolean getPermFlag_Resident_Ally_Build() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_ALLY_BUILD);
    }

    public static boolean getPermFlag_Resident_Ally_Destroy() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_ALLY_DESTROY);
    }

    public static boolean getPermFlag_Resident_Ally_ItemUse() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_ALLY_ITEM_USE);
    }

    public static boolean getPermFlag_Resident_Ally_Switch() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_ALLY_SWITCH);
    }

    public static boolean getPermFlag_Resident_Outsider_Build() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_OUTSIDER_BUILD);
    }

    public static boolean getPermFlag_Resident_Outsider_Destroy() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_OUTSIDER_DESTROY);
    }

    public static boolean getPermFlag_Resident_Outsider_ItemUse() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_OUTSIDER_ITEM_USE);
    }

    public static boolean getPermFlag_Resident_Outsider_Switch() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_OUTSIDER_SWITCH);
    }

    public static boolean getPermFlag_Town_Default_PVP() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_DEF_PVP);
    }

    public static boolean getPermFlag_Town_Default_FIRE() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_DEF_FIRE);
    }

    public static boolean getPermFlag_Town_Default_Explosion() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_DEF_EXPLOSION);
    }

    public static boolean getPermFlag_Town_Default_Mobs() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_DEF_MOBS);
    }

    public static boolean getPermFlag_Town_Resident_Build() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_RES_BUILD);
    }

    public static boolean getPermFlag_Town_Resident_Destroy() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_RES_DESTROY);
    }

    public static boolean getPermFlag_Town_Resident_ItemUse() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_RES_ITEM_USE);
    }

    public static boolean getPermFlag_Town_Resident_Switch() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_RES_SWITCH);
    }

    public static boolean getPermFlag_Town_Nation_Build() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_NATION_BUILD);
    }

    public static boolean getPermFlag_Town_Nation_Destroy() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_NATION_DESTROY);
    }

    public static boolean getPermFlag_Town_Nation_ItemUse() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_NATION_ITEM_USE);
    }

    public static boolean getPermFlag_Town_Nation_Switch() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_NATION_SWITCH);
    }

    public static boolean getPermFlag_Town_Ally_Build() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_ALLY_BUILD);
    }

    public static boolean getPermFlag_Town_Ally_Destroy() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_ALLY_DESTROY);
    }

    public static boolean getPermFlag_Town_Ally_ItemUse() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_ALLY_ITEM_USE);
    }

    public static boolean getPermFlag_Town_Ally_Switch() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_ALLY_SWITCH);
    }

    public static boolean getPermFlag_Town_Outsider_Build() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_OUTSIDER_BUILD);
    }

    public static boolean getPermFlag_Town_Outsider_Destroy() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_OUTSIDER_DESTROY);
    }

    public static boolean getPermFlag_Town_Outsider_ItemUse() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_OUTSIDER_ITEM_USE);
    }

    public static boolean getPermFlag_Town_Outsider_Switch() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_OUTSIDER_SWITCH);
    }

    public static boolean getDefaultResidentPermission(TownBlockOwner owner, TownyPermission.ActionType type) {
        if (owner instanceof Resident) {
            switch (type) {
                case BUILD: {
                    return TownySettings.getPermFlag_Resident_Friend_Build();
                }
                case DESTROY: {
                    return TownySettings.getPermFlag_Resident_Friend_Destroy();
                }
                case SWITCH: {
                    return TownySettings.getPermFlag_Resident_Friend_Switch();
                }
                case ITEM_USE: {
                    return TownySettings.getPermFlag_Resident_Friend_ItemUse();
                }
            }
            throw new UnsupportedOperationException();
        }
        if (owner instanceof Town) {
            switch (type) {
                case BUILD: {
                    return TownySettings.getPermFlag_Town_Resident_Build();
                }
                case DESTROY: {
                    return TownySettings.getPermFlag_Town_Resident_Destroy();
                }
                case SWITCH: {
                    return TownySettings.getPermFlag_Town_Resident_Switch();
                }
                case ITEM_USE: {
                    return TownySettings.getPermFlag_Town_Resident_ItemUse();
                }
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    public static boolean getDefaultNationPermission(TownBlockOwner owner, TownyPermission.ActionType type) {
        if (owner instanceof Resident) {
            switch (type) {
                case BUILD: {
                    return TownySettings.getPermFlag_Resident_Town_Build();
                }
                case DESTROY: {
                    return TownySettings.getPermFlag_Resident_Town_Destroy();
                }
                case SWITCH: {
                    return TownySettings.getPermFlag_Resident_Town_Switch();
                }
                case ITEM_USE: {
                    return TownySettings.getPermFlag_Resident_Town_ItemUse();
                }
            }
            throw new UnsupportedOperationException();
        }
        if (owner instanceof Town) {
            switch (type) {
                case BUILD: {
                    return TownySettings.getPermFlag_Town_Nation_Build();
                }
                case DESTROY: {
                    return TownySettings.getPermFlag_Town_Nation_Destroy();
                }
                case SWITCH: {
                    return TownySettings.getPermFlag_Town_Nation_Switch();
                }
                case ITEM_USE: {
                    return TownySettings.getPermFlag_Town_Nation_ItemUse();
                }
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    public static boolean getDefaultAllyPermission(TownBlockOwner owner, TownyPermission.ActionType type) {
        if (owner instanceof Resident) {
            switch (type) {
                case BUILD: {
                    return TownySettings.getPermFlag_Resident_Ally_Build();
                }
                case DESTROY: {
                    return TownySettings.getPermFlag_Resident_Ally_Destroy();
                }
                case SWITCH: {
                    return TownySettings.getPermFlag_Resident_Ally_Switch();
                }
                case ITEM_USE: {
                    return TownySettings.getPermFlag_Resident_Ally_ItemUse();
                }
            }
            throw new UnsupportedOperationException();
        }
        if (owner instanceof Town) {
            switch (type) {
                case BUILD: {
                    return TownySettings.getPermFlag_Town_Ally_Build();
                }
                case DESTROY: {
                    return TownySettings.getPermFlag_Town_Ally_Destroy();
                }
                case SWITCH: {
                    return TownySettings.getPermFlag_Town_Ally_Switch();
                }
                case ITEM_USE: {
                    return TownySettings.getPermFlag_Town_Ally_ItemUse();
                }
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    public static boolean getDefaultOutsiderPermission(TownBlockOwner owner, TownyPermission.ActionType type) {
        if (owner instanceof Resident) {
            switch (type) {
                case BUILD: {
                    return TownySettings.getPermFlag_Resident_Outsider_Build();
                }
                case DESTROY: {
                    return TownySettings.getPermFlag_Resident_Outsider_Destroy();
                }
                case SWITCH: {
                    return TownySettings.getPermFlag_Resident_Outsider_Switch();
                }
                case ITEM_USE: {
                    return TownySettings.getPermFlag_Resident_Outsider_ItemUse();
                }
            }
            throw new UnsupportedOperationException();
        }
        if (owner instanceof Town) {
            switch (type) {
                case BUILD: {
                    return TownySettings.getPermFlag_Town_Outsider_Build();
                }
                case DESTROY: {
                    return TownySettings.getPermFlag_Town_Outsider_Destroy();
                }
                case SWITCH: {
                    return TownySettings.getPermFlag_Town_Outsider_Switch();
                }
                case ITEM_USE: {
                    return TownySettings.getPermFlag_Town_Outsider_ItemUse();
                }
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    public static boolean getDefaultPermission(TownBlockOwner owner, TownyPermission.PermLevel level, TownyPermission.ActionType type) {
        switch (level) {
            case RESIDENT: {
                return TownySettings.getDefaultResidentPermission(owner, type);
            }
            case NATION: {
                return TownySettings.getDefaultNationPermission(owner, type);
            }
            case ALLY: {
                return TownySettings.getDefaultAllyPermission(owner, type);
            }
            case OUTSIDER: {
                return TownySettings.getDefaultOutsiderPermission(owner, type);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static boolean isLogging() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_LOGGING);
    }

    public static String getAcceptCommand() {
        return TownySettings.getString(ConfigNodes.INVITE_SYSTEM_ACCEPT_COMMAND);
    }

    public static String getDenyCommand() {
        return TownySettings.getString(ConfigNodes.INVITE_SYSTEM_DENY_COMMAND);
    }

    public static String getConfirmCommand() {
        return TownySettings.getString(ConfigNodes.INVITE_SYSTEM_CONFIRM_COMMAND);
    }

    public static String getCancelCommand() {
        return TownySettings.getString(ConfigNodes.INVITE_SYSTEM_CANCEL_COMMAND);
    }

    public static boolean getOutsidersPreventPVPToggle() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_OUTSIDERS_PREVENT_PVP_TOGGLE);
    }

    public static boolean isForcePvpNotAffectingHomeblocks() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_HOMEBLOCKS_PREVENT_FORCEPVP);
    }

    public static long getTownInviteCooldown() {
        return TownySettings.getSeconds(ConfigNodes.INVITE_SYSTEM_COOLDOWN_TIME);
    }

    public static boolean isAppendingToLog() {
        return !TownySettings.getBoolean(ConfigNodes.PLUGIN_RESET_LOG_ON_BOOT);
    }

    public static String getNameFilterRegex() {
        return TownySettings.getString(ConfigNodes.FILTERS_REGEX_NAME_FILTER_REGEX);
    }

    public static String getNameCheckRegex() {
        return TownySettings.getString(ConfigNodes.FILTERS_REGEX_NAME_CHECK_REGEX);
    }

    public static String getStringCheckRegex() {
        return TownySettings.getString(ConfigNodes.FILTERS_REGEX_STRING_CHECK_REGEX);
    }

    public static String getNameRemoveRegex() {
        return TownySettings.getString(ConfigNodes.FILTERS_REGEX_NAME_REMOVE_REGEX);
    }

    public static int getTeleportWarmupTime() {
        return TownySettings.getInt(ConfigNodes.GTOWN_SETTINGS_SPAWN_TIMER);
    }

    public static int getSpawnCooldownTime() {
        return TownySettings.getInt(ConfigNodes.GTOWN_SETTINGS_SPAWN_COOLDOWN_TIMER);
    }

    public static int getPVPCoolDownTime() {
        return TownySettings.getInt(ConfigNodes.GTOWN_SETTINGS_PVP_COOLDOWN_TIMER);
    }

    public static String getTownAccountPrefix() {
        return TownySettings.getString(ConfigNodes.ECO_TOWN_PREFIX);
    }

    public static String getNationAccountPrefix() {
        return TownySettings.getString(ConfigNodes.ECO_NATION_PREFIX);
    }

    public static double getTownBankCap() {
        return TownySettings.getDouble(ConfigNodes.ECO_BANK_CAP_TOWN);
    }

    public static double getNationBankCap() {
        return TownySettings.getDouble(ConfigNodes.ECO_BANK_CAP_NATION);
    }

    public static boolean getTownBankAllowWithdrawls() {
        return TownySettings.getBoolean(ConfigNodes.ECO_BANK_TOWN_ALLOW_WITHDRAWALS);
    }

    public static void SetTownBankAllowWithdrawls(boolean newSetting) {
        TownySettings.setProperty(ConfigNodes.ECO_BANK_TOWN_ALLOW_WITHDRAWALS.getRoot(), newSetting);
    }

    public static boolean geNationBankAllowWithdrawls() {
        return TownySettings.getBoolean(ConfigNodes.ECO_BANK_NATION_ALLOW_WITHDRAWALS);
    }

    public static boolean isBankActionDisallowedOutsideTown() {
        return TownySettings.getBoolean(ConfigNodes.ECO_BANK_DISALLOW_BANK_ACTIONS_OUTSIDE_TOWN);
    }

    public static boolean isBankActionLimitedToBankPlots() {
        return TownySettings.getBoolean(ConfigNodes.BANK_IS_LIMTED_TO_BANK_PLOTS);
    }

    public static void SetNationBankAllowWithdrawls(boolean newSetting) {
        TownySettings.setProperty(ConfigNodes.ECO_BANK_NATION_ALLOW_WITHDRAWALS.getRoot(), newSetting);
    }

    @Deprecated
    public static boolean isValidRegionName(String name) {
        return !NameValidation.isBlacklistName(name);
    }

    @Deprecated
    public static boolean isValidName(String name) {
        return NameValidation.isValidName(name);
    }

    @Deprecated
    public static String filterName(String input) {
        return NameValidation.filterName(input);
    }

    public static boolean isDisallowOneWayAlliance() {
        return TownySettings.getBoolean(ConfigNodes.WAR_DISALLOW_ONE_WAY_ALLIANCE);
    }

    public static int getNumResidentsJoinNation() {
        return TownySettings.getInt(ConfigNodes.GTOWN_SETTINGS_REQUIRED_NUMBER_RESIDENTS_JOIN_NATION);
    }

    public static int getNumResidentsCreateNation() {
        return TownySettings.getInt(ConfigNodes.GTOWN_SETTINGS_REQUIRED_NUMBER_RESIDENTS_CREATE_NATION);
    }

    public static boolean isRefundNationDisbandLowResidents() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_REFUND_DISBAND_LOW_RESIDENTS);
    }

    public static double getNationRequiresProximity() {
        return TownySettings.getDouble(ConfigNodes.GTOWN_SETTINGS_NATION_REQUIRES_PROXIMITY);
    }

    public static List<String> getFarmPlotBlocks() {
        return TownySettings.getStrArr(ConfigNodes.GTOWN_FARM_PLOT_ALLOW_BLOCKS);
    }

    public static List<String> getFarmAnimals() {
        return TownySettings.getStrArr(ConfigNodes.GTOWN_FARM_ANIMALS);
    }

    public static boolean getKeepInventoryInTowns() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_KEEP_INVENTORY_ON_DEATH_IN_TOWN);
    }

    public static boolean getKeepExperienceInTowns() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_KEEP_EXPERIENCE_ON_DEATH_IN_TOWN);
    }

    public static String getListPageMsg(int page, int total) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("LIST_PAGE"), String.valueOf(page), String.valueOf(total)))[0];
    }

    public static String getListNotEnoughPagesMsg(int max) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("LIST_ERR_NOT_ENOUGH_PAGES"), String.valueOf(max)))[0];
    }

    public static String[] getWarAPlayerHasNoTownMsg() {
        return TownySettings.parseString(String.format(TownySettings.getLangString("msg_war_a_player_has_no_town"), new Object[0]));
    }

    public static String[] getWarAPlayerHasNoNationMsg() {
        return TownySettings.parseString(String.format(TownySettings.getLangString("msg_war_a_player_has_no_nation"), new Object[0]));
    }

    public static String[] getWarAPlayerHasANeutralNationMsg() {
        return TownySettings.parseString(String.format(TownySettings.getLangString("msg_war_a_player_has_a_neutral_nation"), new Object[0]));
    }

    public static String[] getWarAPlayerHasBeenRemovedFromWarMsg() {
        return TownySettings.parseString(String.format(TownySettings.getLangString("msg_war_a_player_has_been_removed_from_war"), new Object[0]));
    }

    public static String[] getWarPlayerCannotBeJailedPlotFallenMsg() {
        return TownySettings.parseString(String.format(TownySettings.getLangString("msg_war_player_cant_be_jailed_plot_fallen"), new Object[0]));
    }

    public static String[] getWarAPlayerIsAnAllyMsg() {
        return TownySettings.parseString(String.format(TownySettings.getLangString("msg_war_a_player_is_an_ally"), new Object[0]));
    }

    public static boolean isNotificationUsingTitles() {
        return TownySettings.getBoolean(ConfigNodes.NOTIFICATION_USING_TITLES);
    }

    public static int getAmountOfResidentsForOutpost() {
        return TownySettings.getInt(ConfigNodes.GTOWN_SETTINGS_MINIMUM_AMOUNT_RESIDENTS_FOR_OUTPOSTS);
    }

    public static int getMaximumInvitesSentTown() {
        return TownySettings.getInt(ConfigNodes.INVITE_SYSTEM_MAXIMUM_INVITES_SENT_TOWN);
    }

    public static int getMaximumInvitesSentNation() {
        return TownySettings.getInt(ConfigNodes.INVITE_SYSTEM_MAXIMUM_INVITES_SENT_NATION);
    }

    public static int getMaximumRequestsSentNation() {
        return TownySettings.getInt(ConfigNodes.INVITE_SYSTEM_MAXIMUM_REQUESTS_SENT_NATION);
    }

    public static int getMaximumInvitesReceivedResident() {
        return TownySettings.getInt(ConfigNodes.INVITE_SYSTEM_MAXIMUM_INVITES_RECEIVED_PLAYER);
    }

    public static int getMaximumInvitesReceivedTown() {
        return TownySettings.getInt(ConfigNodes.INVITE_SYSTEM_MAXIMUM_INVITES_RECEIVED_TOWN);
    }

    public static int getMaximumRequestsReceivedNation() {
        return TownySettings.getInt(ConfigNodes.INVITE_SYSTEM_MAXIMUM_REQUESTS_RECEIVED_NATION);
    }

    public static boolean getNationZonesEnabled() {
        return TownySettings.getBoolean(ConfigNodes.GNATION_SETTINGS_NATIONZONE_ENABLE);
    }

    public static boolean getNationZonesCapitalsOnly() {
        return TownySettings.getBoolean(ConfigNodes.GNATION_SETTINGS_NATIONZONE_ONLY_CAPITALS);
    }

    public static boolean getNationZonesWarDisables() {
        return TownySettings.getBoolean(ConfigNodes.GNATION_SETTINGS_NATIONZONE_WAR_DISABLES);
    }

    public static boolean getNationZonesShowNotifications() {
        return TownySettings.getBoolean(ConfigNodes.GNATION_SETTINGS_NATIONZONE_SHOW_NOTIFICATIONS);
    }

    public static int getNationZonesCapitalBonusSize() {
        return TownySettings.getInt(ConfigNodes.GNATION_SETTINGS_NATIONZONE_CAPITAL_BONUS_SIZE);
    }

    public static boolean isShowingRegistrationMessage() {
        return TownySettings.getBoolean(ConfigNodes.RES_SETTING_IS_SHOWING_WELCOME_MESSAGE);
    }

    public static int getMaxTownsPerNation() {
        return TownySettings.getInt(ConfigNodes.GNATION_SETTINGS_MAX_TOWNS_PER_NATION);
    }

    public static double getSpawnTravelCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_TOWN_SPAWN_TRAVEL_PUBLIC);
    }

    public static boolean isAllySpawningRequiringPublicStatus() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_IS_ALLY_SPAWNING_REQUIRING_PUBLIC_STATUS);
    }

    public static String getNotificationTitlesTownTitle() {
        return TownySettings.getString(ConfigNodes.NOTIFICATION_TITLES_TOWN_TITLE);
    }

    public static String getNotificationTitlesTownSubtitle() {
        return TownySettings.getString(ConfigNodes.NOTIFICATION_TITLES_TOWN_SUBTITLE);
    }

    public static String getNotificationTitlesWildTitle() {
        return TownySettings.getString(ConfigNodes.NOTIFICATION_TITLES_WILDERNESS_TITLE);
    }

    public static String getNotificationTitlesWildSubtitle() {
        return TownySettings.getString(ConfigNodes.NOTIFICATION_TITLES_WILDERNESS_SUBTITLE);
    }

    public static double getTownRenameCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_TOWN_RENAME_COST);
    }

    public static double getNationRenameCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_NATION_RENAME_COST);
    }

    public static boolean isRemovingKillerBunny() {
        return TownySettings.getBoolean(ConfigNodes.PROT_MOB_REMOVE_TOWN_KILLER_BUNNY);
    }

    public static boolean isSkippingRemovalOfNamedMobs() {
        return TownySettings.getBoolean(ConfigNodes.PROT_MOB_REMOVE_SKIP_NAMED_MOBS);
    }

    public static List<String> getJailBlacklistedCommands() {
        return TownySettings.getStrArr(ConfigNodes.JAIL_BLACKLISTED_COMMANDS);
    }

    public static String getPAPIFormattingBoth() {
        return TownySettings.getString(ConfigNodes.FILTERS_PAPI_CHAT_FORMATTING_BOTH);
    }

    public static String getPAPIFormattingTown() {
        return TownySettings.getString(ConfigNodes.FILTERS_PAPI_CHAT_FORMATTING_TOWN);
    }

    public static String getPAPIFormattingNation() {
        return TownySettings.getString(ConfigNodes.FILTERS_PAPI_CHAT_FORMATTING_NATION);
    }

    public static String getPAPIFormattingNomad() {
        return TownySettings.getString(ConfigNodes.FILTERS_PAPI_CHAT_FORMATTING_RANKS_NOMAD);
    }

    public static String getPAPIFormattingResident() {
        return TownySettings.getString(ConfigNodes.FILTERS_PAPI_CHAT_FORMATTING_RANKS_RESIDENT);
    }

    public static String getPAPIFormattingMayor() {
        return TownySettings.getString(ConfigNodes.FILTERS_PAPI_CHAT_FORMATTING_RANKS_MAYOR);
    }

    public static String getPAPIFormattingKing() {
        return TownySettings.getString(ConfigNodes.FILTERS_PAPI_CHAT_FORMATTING_RANKS_KING);
    }

    public static double getPlotSetCommercialCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PLOT_TYPE_COSTS_COMMERCIAL);
    }

    public static double getPlotSetArenaCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PLOT_TYPE_COSTS_ARENA);
    }

    public static double getPlotSetEmbassyCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PLOT_TYPE_COSTS_EMBASSY);
    }

    public static double getPlotSetWildsCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PLOT_TYPE_COSTS_WILDS);
    }

    public static double getPlotSetInnCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PLOT_TYPE_COSTS_INN);
    }

    public static double getPlotSetJailCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PLOT_TYPE_COSTS_JAIL);
    }

    public static double getPlotSetFarmCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PLOT_TYPE_COSTS_FARM);
    }

    public static double getPlotSetBankCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PLOT_TYPE_COSTS_BANK);
    }

    public static int getMaxDistanceFromTownSpawnForInvite() {
        return TownySettings.getInt(ConfigNodes.INVITE_SYSTEM_MAX_DISTANCE_FROM_TOWN_SPAWN);
    }

    public static boolean getTownDisplaysXYZ() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_DISPLAY_XYZ_INSTEAD_OF_TOWNY_COORDS);
    }

    public static boolean isTownListRandom() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_DISPLAY_TOWN_LIST_RANDOMLY);
    }

    public static boolean isWarAllowed() {
        return TownySettings.getBoolean(ConfigNodes.NWS_WAR_ALLOWED);
    }

    public static int timeToWaitAfterFlag() {
        return TownySettings.getInt(ConfigNodes.WAR_ENEMY_TIME_TO_WAIT_AFTER_FLAGGED);
    }

    public static boolean isFlaggedInteractionTown() {
        return TownySettings.getBoolean(ConfigNodes.WAR_ENEMY_PREVENT_INTERACTION_WHILE_FLAGGED);
    }

    public static boolean isFlaggedInteractionNation() {
        return TownySettings.getBoolean(ConfigNodes.WAR_ENEMY_PREVENT_NATION_INTERACTION_WHILE_FLAGGED);
    }

    static {
        configTownLevel = Collections.synchronizedSortedMap(new TreeMap(Collections.reverseOrder()));
        configNationLevel = Collections.synchronizedSortedMap(new TreeMap(Collections.reverseOrder()));
    }

    public static enum NationLevel {
        NAME_PREFIX,
        NAME_POSTFIX,
        CAPITAL_PREFIX,
        CAPITAL_POSTFIX,
        KING_PREFIX,
        KING_POSTFIX,
        TOWN_BLOCK_LIMIT_BONUS,
        UPKEEP_MULTIPLIER,
        NATION_TOWN_UPKEEP_MULTIPLIER,
        NATIONZONES_SIZE,
        NATION_BONUS_OUTPOST_LIMIT;

    }

    public static enum TownLevel {
        NAME_PREFIX,
        NAME_POSTFIX,
        MAYOR_PREFIX,
        MAYOR_POSTFIX,
        TOWN_BLOCK_LIMIT,
        UPKEEP_MULTIPLIER,
        OUTPOST_LIMIT,
        TOWN_BLOCK_BUY_BONUS_LIMIT;

    }
}

