/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.tasks.CooldownTimerTask;
import com.palmergames.bukkit.towny.tasks.DailyTimerTask;
import com.palmergames.bukkit.towny.tasks.DrawSmokeTask;
import com.palmergames.bukkit.towny.tasks.HealthRegenTimerTask;
import com.palmergames.bukkit.towny.tasks.MobRemovalTimerTask;
import com.palmergames.bukkit.towny.tasks.RepeatingTimerTask;
import com.palmergames.bukkit.towny.tasks.TeleportWarmupTimerTask;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.TimeMgmt;
import com.palmergames.util.TimeTools;
import java.util.Calendar;
import java.util.TimeZone;

public class TownyTimerHandler {
    private static Towny plugin;
    private static int townyRepeatingTask;
    private static int dailyTask;
    private static int mobRemoveTask;
    private static int healthRegenTask;
    private static int teleportWarmupTask;
    private static int cooldownTimerTask;
    private static int drawSmokeTask;

    public static void initialize(Towny plugin) {
        TownyTimerHandler.plugin = plugin;
    }

    public static void newDay() {
        if (!TownyTimerHandler.isDailyTimerRunning()) {
            TownyTimerHandler.toggleDailyTimer(true);
        }
        if (TownySettings.isEconomyAsync()) {
            if (BukkitTools.scheduleAsyncDelayedTask(new DailyTimerTask(plugin), 0L) == -1) {
                TownyMessaging.sendErrorMsg("Could not schedule newDay.");
            }
        } else if (BukkitTools.scheduleSyncDelayedTask(new DailyTimerTask(plugin), 0L) == -1) {
            TownyMessaging.sendErrorMsg("Could not schedule newDay.");
        }
    }

    public static void toggleTownyRepeatingTimer(boolean on) {
        if (on && !TownyTimerHandler.isTownyRepeatingTaskRunning()) {
            townyRepeatingTask = BukkitTools.scheduleSyncRepeatingTask(new RepeatingTimerTask(plugin), 0L, TimeTools.convertToTicks(1L));
            if (townyRepeatingTask == -1) {
                TownyMessaging.sendErrorMsg("Could not schedule Towny Timer Task.");
            }
        } else if (!on && TownyTimerHandler.isTownyRepeatingTaskRunning()) {
            BukkitTools.getScheduler().cancelTask(townyRepeatingTask);
            townyRepeatingTask = -1;
        }
    }

    public static void toggleMobRemoval(boolean on) {
        if (on && !TownyTimerHandler.isMobRemovalRunning()) {
            mobRemoveTask = BukkitTools.scheduleSyncRepeatingTask(new MobRemovalTimerTask(plugin, BukkitTools.getServer()), 0L, TimeTools.convertToTicks(TownySettings.getMobRemovalSpeed()));
            if (mobRemoveTask == -1) {
                TownyMessaging.sendErrorMsg("Could not schedule mob removal loop.");
            }
        } else if (!on && TownyTimerHandler.isMobRemovalRunning()) {
            BukkitTools.getScheduler().cancelTask(mobRemoveTask);
            mobRemoveTask = -1;
        }
    }

    public static void toggleDailyTimer(boolean on) {
        if (on && !TownyTimerHandler.isDailyTimerRunning()) {
            long timeTillNextDay = TownyTimerHandler.townyTime();
            System.out.println("Time until a New Day: " + TimeMgmt.formatCountdownTime(timeTillNextDay));
            dailyTask = TownySettings.isEconomyAsync() ? BukkitTools.scheduleAsyncRepeatingTask(new DailyTimerTask(plugin), TimeTools.convertToTicks(timeTillNextDay), TimeTools.convertToTicks(TownySettings.getDayInterval())) : BukkitTools.scheduleSyncRepeatingTask(new DailyTimerTask(plugin), TimeTools.convertToTicks(timeTillNextDay), TimeTools.convertToTicks(TownySettings.getDayInterval()));
            if (dailyTask == -1) {
                TownyMessaging.sendErrorMsg("Could not schedule new day loop.");
            }
        } else if (!on && TownyTimerHandler.isDailyTimerRunning()) {
            BukkitTools.getScheduler().cancelTask(dailyTask);
            dailyTask = -1;
        }
    }

    public static void toggleHealthRegen(boolean on) {
        if (on && !TownyTimerHandler.isHealthRegenRunning()) {
            healthRegenTask = BukkitTools.scheduleSyncRepeatingTask(new HealthRegenTimerTask(plugin, BukkitTools.getServer()), 0L, TimeTools.convertToTicks(TownySettings.getHealthRegenSpeed()));
            if (healthRegenTask == -1) {
                TownyMessaging.sendErrorMsg("Could not schedule health regen loop.");
            }
        } else if (!on && TownyTimerHandler.isHealthRegenRunning()) {
            BukkitTools.getScheduler().cancelTask(healthRegenTask);
            healthRegenTask = -1;
        }
    }

    public static void toggleTeleportWarmup(boolean on) {
        if (on && !TownyTimerHandler.isTeleportWarmupRunning()) {
            teleportWarmupTask = BukkitTools.scheduleSyncRepeatingTask(new TeleportWarmupTimerTask(plugin), 0L, 20L);
            if (teleportWarmupTask == -1) {
                TownyMessaging.sendErrorMsg("Could not schedule teleport warmup loop.");
            }
        } else if (!on && TownyTimerHandler.isTeleportWarmupRunning()) {
            BukkitTools.getScheduler().cancelTask(teleportWarmupTask);
            teleportWarmupTask = -1;
        }
    }

    public static void toggleCooldownTimer(boolean on) {
        if (on && !TownyTimerHandler.isCooldownTimerRunning()) {
            cooldownTimerTask = BukkitTools.scheduleAsyncRepeatingTask(new CooldownTimerTask(plugin), 0L, 20L);
            if (cooldownTimerTask == -1) {
                TownyMessaging.sendErrorMsg("Could not schedule cooldown timer loop.");
            }
        } else if (!on && TownyTimerHandler.isCooldownTimerRunning()) {
            BukkitTools.getScheduler().cancelTask(cooldownTimerTask);
            cooldownTimerTask = -1;
        }
    }

    public static void toggleDrawSmokeTask(boolean on) {
        if (on && !TownyTimerHandler.isDrawSmokeTaskRunning()) {
            drawSmokeTask = BukkitTools.scheduleAsyncRepeatingTask(new DrawSmokeTask(plugin), 0L, 100L);
            if (drawSmokeTask == -1) {
                TownyMessaging.sendErrorMsg("Could not schedule draw smoke loop");
            }
        } else if (!on && TownyTimerHandler.isDrawSmokeTaskRunning()) {
            BukkitTools.getScheduler().cancelTask(drawSmokeTask);
            drawSmokeTask = -1;
        }
    }

    public static boolean isTownyRepeatingTaskRunning() {
        return townyRepeatingTask != -1;
    }

    public static boolean isMobRemovalRunning() {
        return mobRemoveTask != -1;
    }

    public static boolean isDailyTimerRunning() {
        return dailyTask != -1;
    }

    public static boolean isHealthRegenRunning() {
        return healthRegenTask != -1;
    }

    public static boolean isTeleportWarmupRunning() {
        return teleportWarmupTask != -1;
    }

    public static boolean isCooldownTimerRunning() {
        return cooldownTimerTask != -1;
    }

    public static boolean isDrawSmokeTaskRunning() {
        return drawSmokeTask != -1;
    }

    public static Long townyTime() {
        long secondsInDay = TownySettings.getDayInterval();
        Calendar now = Calendar.getInstance();
        TimeZone timeZone = now.getTimeZone();
        long timeMilli = System.currentTimeMillis();
        int timeOffset = timeZone.getOffset(timeMilli) / 1000;
        return (secondsInDay + (TownySettings.getNewDayTime() - timeMilli / 1000L % secondsInDay - (long)timeOffset)) % secondsInDay;
    }

    static {
        townyRepeatingTask = -1;
        dailyTask = -1;
        mobRemoveTask = -1;
        healthRegenTask = -1;
        teleportWarmupTask = -1;
        cooldownTimerTask = -1;
        drawSmokeTask = -1;
    }
}

