/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyLogger;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.db.TownyDataSource;
import com.palmergames.bukkit.towny.db.TownyFlatFileSource;
import com.palmergames.bukkit.towny.db.TownySQLSource;
import com.palmergames.bukkit.towny.exceptions.KeyAlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.permissions.TownyPermissionSource;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.tasks.OnPlayerLogin;
import com.palmergames.bukkit.towny.war.eventwar.War;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.FileMgmt;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class TownyUniverse {
    private static TownyUniverse instance;
    private final Towny towny;
    private final ConcurrentHashMap<String, Resident> residents = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Town> towns = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Nation> nations = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, TownyWorld> worlds = new ConcurrentHashMap();
    private final HashMap<String, CustomDataField> registeredMetadata = new HashMap();
    private final List<Resident> jailedResidents = new ArrayList<Resident>();
    private final String rootFolder;
    private TownyDataSource dataSource;
    private TownyPermissionSource permissionSource;
    private War warEvent;

    private TownyUniverse() {
        this.towny = Towny.getPlugin();
        this.rootFolder = this.towny.getDataFolder().getPath();
    }

    boolean loadSettings() {
        try {
            TownySettings.loadConfig(this.rootFolder + File.separator + "settings" + File.separator + "config.yml", this.towny.getVersion());
            TownySettings.loadLanguage(this.rootFolder + File.separator + "settings", "english.yml");
            TownyPerms.loadPerms(this.rootFolder + File.separator + "settings", "townyperms.yml");
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        if (TownySettings.getDebug()) {
            TownyLogger.getInstance().enableDebugLogger();
            TownyLogger.getInstance().updateLoggers();
        }
        String saveDbType = TownySettings.getSaveDatabase();
        String loadDbType = TownySettings.getLoadDatabase();
        Coord.setCellSize(TownySettings.getTownBlockSize());
        System.out.println("[Towny] Database: [Load] " + loadDbType + " [Save] " + saveDbType);
        this.clearAll();
        if (!this.loadDatabase(loadDbType)) {
            System.out.println("[Towny] Error: Failed to load!");
            return false;
        }
        try {
            this.dataSource.cleanupBackups();
            switch (saveDbType.toLowerCase()) {
                case "ff": 
                case "flatfile": {
                    this.dataSource = new TownyFlatFileSource(this.towny, this);
                    break;
                }
                case "h2": 
                case "sqlite": 
                case "mysql": {
                    this.dataSource = new TownySQLSource(this.towny, this, saveDbType.toLowerCase());
                    break;
                }
            }
            FileMgmt.checkOrCreateFolder(this.rootFolder + File.separator + "logs");
            try {
                this.dataSource.backup();
                if (loadDbType.equalsIgnoreCase("flatfile") || saveDbType.equalsIgnoreCase("flatfile")) {
                    this.dataSource.deleteUnusedResidents();
                }
            }
            catch (IOException e) {
                System.out.println("[Towny] Error: Could not create backup.");
                e.printStackTrace();
                return false;
            }
            if (loadDbType.equalsIgnoreCase(saveDbType)) {
                this.dataSource.saveAllWorlds();
            } else {
                this.dataSource.saveAll();
            }
        }
        catch (UnsupportedOperationException e) {
            System.out.println("[Towny] Error: Unsupported save format!");
            return false;
        }
        File f = new File(this.rootFolder, "outpostschecked.txt");
        if (!f.exists()) {
            for (Town town : this.dataSource.getTowns()) {
                TownySQLSource.validateTownOutposts(town);
            }
            this.towny.saveResource("outpostschecked.txt", false);
        }
        return true;
    }

    private boolean loadDatabase(String loadDbType) {
        switch (loadDbType.toLowerCase()) {
            case "ff": 
            case "flatfile": {
                this.dataSource = new TownyFlatFileSource(this.towny, this);
                break;
            }
            case "h2": 
            case "sqlite": 
            case "mysql": {
                this.dataSource = new TownySQLSource(this.towny, this, loadDbType.toLowerCase());
                break;
            }
            default: {
                return false;
            }
        }
        return this.dataSource.loadAll();
    }

    public void onLogin(Player player) {
        if (!player.isOnline()) {
            return;
        }
        player.getName();
        if (player.getName().contains(" ")) {
            player.kickPlayer("Invalid name!");
            return;
        }
        if (BukkitTools.scheduleSyncDelayedTask(new OnPlayerLogin(this.towny, player), 0L) == -1) {
            TownyMessaging.sendErrorMsg("Could not schedule OnLogin.");
        }
    }

    public void onLogout(Player player) {
        try {
            Resident resident = this.dataSource.getResident(player.getName());
            resident.setLastOnline(System.currentTimeMillis());
            this.dataSource.saveResident(resident);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
    }

    public void startWarEvent() {
        this.warEvent = new War(this.towny, TownySettings.getWarTimeWarningDelay());
    }

    public void endWarEvent() {
        if (this.warEvent != null && this.warEvent.isWarTime()) {
            this.warEvent.toggleEnd();
        }
    }

    public void addWarZone(WorldCoord worldCoord) {
        try {
            if (worldCoord.getTownyWorld().isWarAllowed()) {
                worldCoord.getTownyWorld().addWarZone(worldCoord);
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        this.towny.updateCache(worldCoord);
    }

    public void removeWarZone(WorldCoord worldCoord) {
        try {
            worldCoord.getTownyWorld().removeWarZone(worldCoord);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        this.towny.updateCache(worldCoord);
    }

    public TownyPermissionSource getPermissionSource() {
        return this.permissionSource;
    }

    public void setPermissionSource(TownyPermissionSource permissionSource) {
        this.permissionSource = permissionSource;
    }

    public War getWarEvent() {
        return this.warEvent;
    }

    public void setWarEvent(War warEvent) {
        this.warEvent = warEvent;
    }

    public String getRootFolder() {
        return this.rootFolder;
    }

    public ConcurrentHashMap<String, Nation> getNationsMap() {
        return this.nations;
    }

    public ConcurrentHashMap<String, Resident> getResidentMap() {
        return this.residents;
    }

    public List<Resident> getJailedResidentMap() {
        return this.jailedResidents;
    }

    public ConcurrentHashMap<String, Town> getTownsMap() {
        return this.towns;
    }

    public ConcurrentHashMap<String, TownyWorld> getWorldMap() {
        return this.worlds;
    }

    public TownyDataSource getDataSource() {
        return this.dataSource;
    }

    public List<String> getTreeString(int depth) {
        ArrayList<String> out = new ArrayList<String>();
        out.add(this.getTreeDepth(depth) + "Universe (1)");
        if (this.towny != null) {
            out.add(this.getTreeDepth(depth + 1) + "Server (" + BukkitTools.getServer().getName() + ")");
            out.add(this.getTreeDepth(depth + 2) + "Version: " + BukkitTools.getServer().getVersion());
            out.add(this.getTreeDepth(depth + 2) + "Worlds (" + BukkitTools.getWorlds().size() + "): " + Arrays.toString(BukkitTools.getWorlds().toArray(new World[0])));
        }
        out.add(this.getTreeDepth(depth + 1) + "Worlds (" + this.worlds.size() + "):");
        for (TownyWorld townyWorld : this.worlds.values()) {
            out.addAll(townyWorld.getTreeString(depth + 2));
        }
        out.add(this.getTreeDepth(depth + 1) + "Nations (" + this.nations.size() + "):");
        for (Nation nation : this.nations.values()) {
            out.addAll(nation.getTreeString(depth + 2));
        }
        List<Town> townsWithoutNation = this.dataSource.getTownsWithoutNation();
        out.add(this.getTreeDepth(depth + 1) + "Towns (" + townsWithoutNation.size() + "):");
        for (Town town : townsWithoutNation) {
            out.addAll(town.getTreeString(depth + 2));
        }
        List<Resident> list = this.dataSource.getResidentsWithoutTown();
        out.add(this.getTreeDepth(depth + 1) + "Residents (" + list.size() + "):");
        for (Resident resident : list) {
            out.addAll(resident.getTreeString(depth + 2));
        }
        return out;
    }

    private String getTreeDepth(int depth) {
        char[] fill = new char[depth * 4];
        Arrays.fill(fill, ' ');
        if (depth > 0) {
            fill[0] = 124;
            int offset = (depth - 1) * 4;
            fill[offset] = 43;
            fill[offset + 1] = 45;
            fill[offset + 2] = 45;
        }
        return new String(fill);
    }

    public boolean isTownBlockLocContainedInTownOutposts(List<Location> minecraftcoordinates, TownBlock tb) {
        if (minecraftcoordinates != null && tb != null) {
            for (Location minecraftcoordinate : minecraftcoordinates) {
                if (!Coord.parseCoord(minecraftcoordinate).equals(tb.getCoord())) continue;
                return true;
            }
        }
        return false;
    }

    public void addCustomCustomDataField(CustomDataField cdf) throws KeyAlreadyRegisteredException {
        if (this.getRegisteredMetadataMap().containsKey(cdf.getKey())) {
            throw new KeyAlreadyRegisteredException();
        }
        this.getRegisteredMetadataMap().put(cdf.getKey(), cdf);
    }

    public static TownyUniverse getInstance() {
        if (instance == null) {
            instance = new TownyUniverse();
        }
        return instance;
    }

    public void clearAll() {
        this.worlds.clear();
        this.nations.clear();
        this.towns.clear();
        this.residents.clear();
    }

    public HashMap<String, CustomDataField> getRegisteredMetadataMap() {
        return this.registeredMetadata;
    }
}

