/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.command.InviteCommand;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.confirmations.ConfirmationHandler;
import com.palmergames.bukkit.towny.confirmations.ConfirmationType;
import com.palmergames.bukkit.towny.event.NationInviteTownEvent;
import com.palmergames.bukkit.towny.event.NationPreAddTownEvent;
import com.palmergames.bukkit.towny.event.NationPreRenameEvent;
import com.palmergames.bukkit.towny.event.NationPreTransactionEvent;
import com.palmergames.bukkit.towny.event.NationRequestAllyNationEvent;
import com.palmergames.bukkit.towny.event.NationTransactionEvent;
import com.palmergames.bukkit.towny.event.NewNationEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.EmptyNationException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.invites.InviteHandler;
import com.palmergames.bukkit.towny.invites.exceptions.TooManyInvitesException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.SpawnType;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.Transaction;
import com.palmergames.bukkit.towny.object.TransactionType;
import com.palmergames.bukkit.towny.object.inviteobjects.NationAllyNationInvite;
import com.palmergames.bukkit.towny.object.inviteobjects.TownJoinNationInvite;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.utils.SpawnUtil;
import com.palmergames.bukkit.towny.war.flagwar.TownyWar;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.StringMgmt;
import java.io.InvalidObjectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import javax.naming.InvalidNameException;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class NationCommand
extends BaseCommand
implements CommandExecutor {
    private static Towny plugin;
    private static final List<String> nation_help;
    private static final List<String> king_help;
    private static final List<String> alliesstring;
    private static final List<String> invite;
    private static final Comparator<Nation> BY_NUM_RESIDENTS;
    private static final Comparator<Nation> BY_NAME;
    private static final Comparator<Nation> BY_BANK_BALANCE;
    private static final Comparator<Nation> BY_TOWNBLOCKS_CLAIMED;
    private static final Comparator<Nation> BY_NUM_TOWNS;
    private static final Comparator<Nation> BY_NUM_ONLINE;

    public NationCommand(Towny instance) {
        plugin = instance;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args == null) {
                for (String line : nation_help) {
                    player.sendMessage(line);
                }
                this.parseNationCommand(player, args);
            } else {
                this.parseNationCommand(player, args);
            }
        } else {
            try {
                this.parseNationCommandForConsole(sender, args);
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
        return true;
    }

    private void parseNationCommandForConsole(CommandSender sender, String[] split) throws TownyException {
        if (split.length == 0 || split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
            for (String line : nation_help) {
                sender.sendMessage(line);
            }
        } else if (split[0].equalsIgnoreCase("list")) {
            this.listNations(sender, split);
        } else {
            try {
                Nation nation = TownyUniverse.getInstance().getDataSource().getNation(split[0]);
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> TownyMessaging.sendMessage((Object)sender, TownyFormatter.getStatus(nation)));
            }
            catch (NotRegisteredException x) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_not_registered_1"), split[0]));
            }
        }
    }

    public void parseNationCommand(Player player, String[] split) {
        block105: {
            TownyUniverse townyUniverse = TownyUniverse.getInstance();
            String nationCom = "/nation";
            try {
                if (split.length == 0) {
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                        try {
                            Resident resident = townyUniverse.getDataSource().getResident(player.getName());
                            Town town = resident.getTown();
                            Nation nation = town.getNation();
                            TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(nation));
                        }
                        catch (NotRegisteredException x) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_dont_belong_nation"));
                        }
                    });
                    break block105;
                }
                if (split[0].equalsIgnoreCase("?")) {
                    for (String line : nation_help) {
                        player.sendMessage(line);
                    }
                    break block105;
                }
                if (split[0].equalsIgnoreCase("list")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_LIST.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.listNations((CommandSender)player, split);
                    break block105;
                }
                if (split[0].equalsIgnoreCase("townlist")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_TOWNLIST.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    Nation nation = null;
                    try {
                        nation = split.length == 1 ? townyUniverse.getDataSource().getResident(player.getName()).getTown().getNation() : townyUniverse.getDataSource().getNation(split[1]);
                    }
                    catch (Exception e) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_specify_name"));
                        return;
                    }
                    TownyMessaging.sendMessage((Object)player, ChatTools.formatTitle(TownyFormatter.getFormattedName(nation)));
                    TownyMessaging.sendMessage((Object)player, ChatTools.listArr(TownyFormatter.getFormattedNames(nation.getTowns().toArray(new Town[0])), String.format(TownySettings.getLangString("status_nation_towns"), nation.getTowns().size())));
                    break block105;
                }
                if (split[0].equalsIgnoreCase("allylist")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_ALLYLIST.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    Nation nation = null;
                    try {
                        nation = split.length == 1 ? townyUniverse.getDataSource().getResident(player.getName()).getTown().getNation() : townyUniverse.getDataSource().getNation(split[1]);
                    }
                    catch (Exception e) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_specify_name"));
                        return;
                    }
                    if (nation.getAllies().isEmpty()) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_nation_has_no_allies"));
                    } else {
                        TownyMessaging.sendMessage((Object)player, ChatTools.formatTitle(TownyFormatter.getFormattedName(nation)));
                        TownyMessaging.sendMessage((Object)player, ChatTools.listArr(TownyFormatter.getFormattedNames(nation.getAllies().toArray(new Nation[0])), String.format(TownySettings.getLangString("status_nation_allies"), nation.getAllies().size())));
                    }
                    break block105;
                }
                if (split[0].equalsIgnoreCase("enemylist")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_ENEMYLIST.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    Nation nation = null;
                    try {
                        nation = split.length == 1 ? townyUniverse.getDataSource().getResident(player.getName()).getTown().getNation() : townyUniverse.getDataSource().getNation(split[1]);
                    }
                    catch (Exception e) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_specify_name"));
                        return;
                    }
                    if (nation.getEnemies().isEmpty()) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_nation_has_no_enemies"));
                    } else {
                        TownyMessaging.sendMessage((Object)player, ChatTools.formatTitle(TownyFormatter.getFormattedName(nation)));
                        TownyMessaging.sendMessage((Object)player, ChatTools.listArr(TownyFormatter.getFormattedNames(nation.getEnemies().toArray(new Nation[0])), String.format(TownySettings.getLangString("status_nation_enemies"), nation.getEnemies().size())));
                    }
                    break block105;
                }
                if (split[0].equalsIgnoreCase("new")) {
                    Resident resident = townyUniverse.getDataSource().getResident(player.getName());
                    if (TownySettings.getNumResidentsCreateNation() > 0 && resident.getTown().getNumResidents() < TownySettings.getNumResidentsCreateNation()) {
                        TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_not_enough_residents_new_nation"), new Object[0]));
                        return;
                    }
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_NEW.getNode())) {
                        throw new TownyException(TownySettings.getNotPermToNewNationLine());
                    }
                    if (split.length == 1) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_specify_nation_name"));
                    } else if (split.length == 2) {
                        if (!resident.isMayor() && !resident.getTown().hasAssistant(resident)) {
                            throw new TownyException(TownySettings.getLangString("msg_peasant_right"));
                        }
                        this.newNation(player, split[1], resident.getTown().getName());
                    } else {
                        if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_ADMIN.getNode())) {
                            throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                        }
                        this.newNation(player, split[1], split[2]);
                    }
                    break block105;
                }
                if (split[0].equalsIgnoreCase("join")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_JOIN.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.parseNationJoin(player, StringMgmt.remFirstArg(split));
                    break block105;
                }
                if (split[0].equalsIgnoreCase("merge")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_MERGE.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    if (split.length == 1) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_specify_nation_name"));
                    } else if (split.length == 2) {
                        Resident resident = townyUniverse.getDataSource().getResident(player.getName());
                        if (!resident.isKing()) {
                            throw new TownyException(TownySettings.getLangString("msg_err_merging_for_kings_only"));
                        }
                        this.mergeNation(player, split[1]);
                    }
                    break block105;
                }
                if (split[0].equalsIgnoreCase("withdraw")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_WITHDRAW.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    if (TownySettings.isBankActionLimitedToBankPlots()) {
                        Nation pNation;
                        if (TownyAPI.getInstance().isWilderness(player.getLocation())) {
                            throw new TownyException(TownySettings.getLangString("msg_err_unable_to_use_bank_outside_bank_plot"));
                        }
                        TownBlock tb = TownyAPI.getInstance().getTownBlock(player.getLocation());
                        Nation tbNation = tb.getTown().getNation();
                        if (tbNation != (pNation = townyUniverse.getDataSource().getResident(player.getName()).getTown().getNation()) || !tb.getTown().isCapital()) {
                            throw new TownyException(TownySettings.getLangString("msg_err_unable_to_use_bank_outside_bank_plot"));
                        }
                        boolean goodPlot = false;
                        if (tb.getType().equals((Object)TownBlockType.BANK) || tb.isHomeBlock()) {
                            goodPlot = true;
                        }
                        if (!goodPlot) {
                            throw new TownyException(TownySettings.getLangString("msg_err_unable_to_use_bank_outside_bank_plot"));
                        }
                    }
                    if (TownySettings.isBankActionDisallowedOutsideTown()) {
                        if (TownyAPI.getInstance().isWilderness(player.getLocation())) {
                            throw new TownyException(TownySettings.getLangString("msg_err_unable_to_use_bank_outside_nation_capital"));
                        }
                        Coord coord = Coord.parseCoord(plugin.getCache(player).getLastLocation());
                        Town town = townyUniverse.getDataSource().getWorld(player.getLocation().getWorld().getName()).getTownBlock(coord).getTown();
                        if (!town.isCapital()) {
                            throw new TownyException(TownySettings.getLangString("msg_err_unable_to_use_bank_outside_nation_capital"));
                        }
                        Nation nation = town.getNation();
                        if (!townyUniverse.getDataSource().getResident(player.getName()).getTown().getNation().equals(nation)) {
                            throw new TownyException(TownySettings.getLangString("msg_err_unable_to_use_bank_outside_nation_capital"));
                        }
                    }
                    if (split.length == 2) {
                        try {
                            this.nationWithdraw(player, Integer.parseInt(split[1].trim()));
                        }
                        catch (NumberFormatException e) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_int"));
                        }
                    } else {
                        TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_must_specify_amnt"), nationCom));
                    }
                    break block105;
                }
                if (split[0].equalsIgnoreCase("leave")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_LEAVE.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.nationLeave(player);
                    break block105;
                }
                if (split[0].equalsIgnoreCase("spawn")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SPAWN.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    String[] newSplit = StringMgmt.remFirstArg(split);
                    NationCommand.nationSpawn(player, newSplit);
                    break block105;
                }
                if (split[0].equalsIgnoreCase("deposit")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_DEPOSIT.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    if (TownySettings.isBankActionLimitedToBankPlots()) {
                        Nation pNation;
                        if (TownyAPI.getInstance().isWilderness(player.getLocation())) {
                            throw new TownyException(TownySettings.getLangString("msg_err_unable_to_use_bank_outside_bank_plot"));
                        }
                        TownBlock tb = TownyAPI.getInstance().getTownBlock(player.getLocation());
                        Nation tbNation = tb.getTown().getNation();
                        if (tbNation != (pNation = townyUniverse.getDataSource().getResident(player.getName()).getTown().getNation()) || !tb.getTown().isCapital()) {
                            throw new TownyException(TownySettings.getLangString("msg_err_unable_to_use_bank_outside_bank_plot"));
                        }
                        boolean goodPlot = false;
                        if (tb.getType().equals((Object)TownBlockType.BANK) || tb.isHomeBlock()) {
                            goodPlot = true;
                        }
                        if (!goodPlot) {
                            throw new TownyException(TownySettings.getLangString("msg_err_unable_to_use_bank_outside_bank_plot"));
                        }
                    }
                    if (TownySettings.isBankActionDisallowedOutsideTown()) {
                        if (TownyAPI.getInstance().isWilderness(player.getLocation())) {
                            throw new TownyException(TownySettings.getLangString("msg_err_unable_to_use_bank_outside_nation_capital"));
                        }
                        Coord coord = Coord.parseCoord(plugin.getCache(player).getLastLocation());
                        Town town = townyUniverse.getDataSource().getWorld(player.getLocation().getWorld().getName()).getTownBlock(coord).getTown();
                        if (!town.isCapital()) {
                            throw new TownyException(TownySettings.getLangString("msg_err_unable_to_use_bank_outside_nation_capital"));
                        }
                        Nation nation = town.getNation();
                        if (!townyUniverse.getDataSource().getResident(player.getName()).getTown().getNation().equals(nation)) {
                            throw new TownyException(TownySettings.getLangString("msg_err_unable_to_use_bank_outside_nation_capital"));
                        }
                    }
                    if (split.length == 1) {
                        TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_must_specify_amnt"), nationCom + " deposit"));
                        return;
                    }
                    if (split.length == 2) {
                        try {
                            this.nationDeposit(player, Integer.parseInt(split[1].trim()));
                        }
                        catch (NumberFormatException e) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_int"));
                        }
                    }
                    if (split.length != 3) break block105;
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_DEPOSIT_OTHER.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    Town town = TownyAPI.getInstance().getDataSource().getTown(split[2]);
                    Nation nation = townyUniverse.getDataSource().getResident(player.getName()).getTown().getNation();
                    if (town != null) {
                        if (!town.hasNation()) {
                            throw new TownyException(String.format(TownySettings.getLangString("msg_err_not_same_nation"), town.getName()));
                        }
                        if (!town.getNation().equals(nation)) {
                            throw new TownyException(String.format(TownySettings.getLangString("msg_err_not_same_nation"), town.getName()));
                        }
                        try {
                            TownCommand.townDeposit(player, town, Integer.parseInt(split[1].trim()));
                        }
                        catch (NumberFormatException e) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_int"));
                        }
                        break block105;
                    }
                    throw new NotRegisteredException();
                }
                String[] newSplit = StringMgmt.remFirstArg(split);
                if (split[0].equalsIgnoreCase("rank")) {
                    this.nationRank(player, newSplit);
                    break block105;
                }
                if (split[0].equalsIgnoreCase("king")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_KING.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.nationKing(player, newSplit);
                    break block105;
                }
                if (split[0].equalsIgnoreCase("add")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_INVITE_ADD.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.nationAdd(player, newSplit);
                    break block105;
                }
                if (split[0].equalsIgnoreCase("invite") || split[0].equalsIgnoreCase("invites")) {
                    this.parseInviteCommand(player, newSplit);
                    break block105;
                }
                if (split[0].equalsIgnoreCase("kick")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_KICK.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.nationKick(player, newSplit);
                    break block105;
                }
                if (split[0].equalsIgnoreCase("set")) {
                    NationCommand.nationSet(player, newSplit, false, null);
                    break block105;
                }
                if (split[0].equalsIgnoreCase("toggle")) {
                    NationCommand.nationToggle(player, newSplit, false, null);
                    break block105;
                }
                if (split[0].equalsIgnoreCase("ally")) {
                    this.nationAlly(player, newSplit);
                    break block105;
                }
                if (split[0].equalsIgnoreCase("enemy")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_ENEMY.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.nationEnemy(player, newSplit);
                    break block105;
                }
                if (split[0].equalsIgnoreCase("delete")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_DELETE.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.nationDelete(player, newSplit);
                    break block105;
                }
                if (split[0].equalsIgnoreCase("online")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_ONLINE.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.parseNationOnlineCommand(player, newSplit);
                    break block105;
                }
                if (split[0].equalsIgnoreCase("say")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SAY.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    try {
                        Nation nation = townyUniverse.getDataSource().getResident(player.getName()).getTown().getNation();
                        StringBuilder builder = new StringBuilder();
                        for (String s : newSplit) {
                            builder.append(s + " ");
                        }
                        String message = builder.toString();
                        TownyMessaging.sendPrefixedNationMessage(nation, message);
                    }
                    catch (Exception nation) {}
                    break block105;
                }
                try {
                    Nation nation = townyUniverse.getDataSource().getNation(split[0]);
                    Resident resident = townyUniverse.getDataSource().getResident(player.getName());
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_OTHERNATION.getNode()) && (resident.hasTown() && resident.getTown().hasNation() && resident.getTown().getNation() != nation || !resident.hasTown())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(nation)));
                }
                catch (NotRegisteredException x) {
                    TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_not_registered_1"), split[0]));
                }
            }
            catch (Exception x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            }
        }
    }

    private void parseNationJoin(Player player, String[] args) {
        try {
            if (args.length < 1) {
                throw new Exception(String.format("Usage: /nation join [nation]", new Object[0]));
            }
            String nationName = args[0];
            TownyUniverse townyUniverse = TownyUniverse.getInstance();
            Resident resident = townyUniverse.getDataSource().getResident(player.getName());
            Town town = resident.getTown();
            Nation nation = townyUniverse.getDataSource().getNation(nationName);
            if (town.hasNation()) {
                throw new Exception(TownySettings.getLangString("msg_err_already_in_a_nation"));
            }
            if (!nation.isOpen()) {
                throw new Exception(String.format(TownySettings.getLangString("msg_err_nation_not_open"), nation.getFormattedName()));
            }
            if (TownySettings.getNumResidentsJoinNation() > 0 && town.getNumResidents() < TownySettings.getNumResidentsJoinNation()) {
                throw new Exception(String.format(TownySettings.getLangString("msg_err_not_enough_residents_join_nation"), town.getName()));
            }
            if (TownySettings.getMaxTownsPerNation() > 0 && nation.getTowns().size() >= TownySettings.getMaxTownsPerNation()) {
                throw new Exception(String.format(TownySettings.getLangString("msg_err_nation_over_town_limit"), TownySettings.getMaxTownsPerNation()));
            }
            if (TownySettings.getNationRequiresProximity() > 0.0) {
                Coord capitalCoord = nation.getCapital().getHomeBlock().getCoord();
                Coord townCoord = town.getHomeBlock().getCoord();
                if (!nation.getCapital().getHomeBlock().getWorld().getName().equals(town.getHomeBlock().getWorld().getName())) {
                    throw new Exception(TownySettings.getLangString("msg_err_nation_homeblock_in_another_world"));
                }
                double distance = Math.sqrt(Math.pow(capitalCoord.getX() - townCoord.getX(), 2.0) + Math.pow(capitalCoord.getZ() - townCoord.getZ(), 2.0));
                if (distance > TownySettings.getNationRequiresProximity()) {
                    throw new Exception(String.format(TownySettings.getLangString("msg_err_town_not_close_enough_to_nation"), town.getName()));
                }
            }
            NationPreAddTownEvent preEvent = new NationPreAddTownEvent(nation, town);
            Bukkit.getPluginManager().callEvent((Event)preEvent);
            if (preEvent.isCancelled()) {
                TownyMessaging.sendErrorMsg((Object)player, preEvent.getCancelMessage());
                return;
            }
            ArrayList<Town> towns = new ArrayList<Town>();
            towns.add(town);
            NationCommand.nationAdd(nation, towns);
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
        }
    }

    private void parseInviteCommand(Player player, String[] newSplit) throws TownyException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        Resident resident = townyUniverse.getDataSource().getResident(player.getName());
        String sent = TownySettings.getLangString("nation_sent_invites").replace("%a", Integer.toString(InviteHandler.getSentInvitesAmount(resident.getTown().getNation()))).replace("%m", Integer.toString(InviteHandler.getSentInvitesMaxAmount(resident.getTown().getNation())));
        if (newSplit.length == 0) {
            if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_INVITE_SEE_HOME.getNode())) {
                throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
            }
            ArrayList<String> messages = new ArrayList<String>();
            for (String msg : invite) {
                messages.add(Colors.strip(msg));
            }
            messages.add(sent);
            String[] msgs = messages.toArray(new String[0]);
            player.sendMessage(msgs);
            return;
        }
        if (newSplit.length >= 1) {
            if (newSplit[0].equalsIgnoreCase("help") || newSplit[0].equalsIgnoreCase("?")) {
                for (String msg : invite) {
                    player.sendMessage(Colors.strip(msg));
                }
                return;
            }
            if (newSplit[0].equalsIgnoreCase("sent")) {
                if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_INVITE_LIST_SENT.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                List<Invite> sentinvites = resident.getTown().getNation().getSentInvites();
                int page = 1;
                if (newSplit.length >= 2) {
                    try {
                        page = Integer.parseInt(newSplit[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                InviteCommand.sendInviteList(player, sentinvites, page, true);
                player.sendMessage(sent);
                return;
            }
            if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_INVITE_ADD.getNode())) {
                throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
            }
            this.nationAdd(player, newSplit);
        }
    }

    private void parseNationOnlineCommand(Player player, String[] split) throws TownyException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (split.length > 0) {
            try {
                Nation nation = townyUniverse.getDataSource().getNation(split[0]);
                List<Resident> onlineResidents = TownCommand.getOnlineResidentsViewable(player, nation);
                if (onlineResidents.size() > 0) {
                    TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedOnlineResidents(TownySettings.getLangString("msg_nation_online"), nation, player));
                }
                TownyMessaging.sendMessage((Object)player, ChatTools.color(TownySettings.getLangString("default_towny_prefix") + "\u00a7f" + "0 " + TownySettings.getLangString("res_list") + " " + TownySettings.getLangString("msg_nation_online") + ": " + nation));
            }
            catch (NotRegisteredException e) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_not_registered_1"), split[0]));
            }
        } else {
            try {
                Resident resident = townyUniverse.getDataSource().getResident(player.getName());
                Town town = resident.getTown();
                Nation nation = town.getNation();
                TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedOnlineResidents(TownySettings.getLangString("msg_nation_online"), nation, player));
            }
            catch (NotRegisteredException x) {
                TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_dont_belong_nation"));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void nationRank(Player player, String[] split) throws TownyException {
        Resident target;
        if (split.length == 0) {
            player.sendMessage(ChatTools.formatTitle("/nation rank"));
            player.sendMessage(ChatTools.formatCommand("", "/nation rank", "add/remove [resident] rank", ""));
            return;
        }
        Town town = null;
        Town targetTown = null;
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (split.length < 3) {
            TownyMessaging.sendErrorMsg((Object)player, "Eg: /town rank add/remove [resident] [rank]");
            return;
        }
        try {
            Resident resident = townyUniverse.getDataSource().getResident(player.getName());
            target = townyUniverse.getDataSource().getResident(split[1]);
            town = resident.getTown();
            targetTown = target.getTown();
            if (town.getNation() != targetTown.getNation()) {
                throw new TownyException("This resident is not a member of your Town!");
            }
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        String rank = split[2];
        if (!TownyPerms.getNationRanks().contains(rank)) {
            TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_unknown_rank_available_ranks"), rank, StringMgmt.join(TownyPerms.getNationRanks(), ",")));
            return;
        }
        if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_RANK.getNode(rank.toLowerCase()))) {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_no_permission_to_give_rank"));
            return;
        }
        if (split[0].equalsIgnoreCase("add")) {
            try {
                if (!target.addNationRank(rank)) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_resident_not_part_of_any_town"));
                    return;
                }
                if (BukkitTools.isOnline(target.getName())) {
                    TownyMessaging.sendMsg(target, String.format(TownySettings.getLangString("msg_you_have_been_given_rank"), "Nation", rank));
                    plugin.deleteCache(TownyAPI.getInstance().getPlayer(target));
                }
                TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_you_have_given_rank"), "Nation", rank, target.getName()));
            }
            catch (AlreadyRegisteredException e) {
                TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_resident_already_has_rank"), target.getName(), "Nation"));
                return;
            }
        }
        if (!split[0].equalsIgnoreCase("remove")) {
            TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_property"), split[0]));
            return;
        }
        try {
            if (target.removeNationRank(rank)) {
                if (BukkitTools.isOnline(target.getName())) {
                    TownyMessaging.sendMsg(target, String.format(TownySettings.getLangString("msg_you_have_had_rank_taken"), "Nation", rank));
                    plugin.deleteCache(TownyAPI.getInstance().getPlayer(target));
                }
                TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_you_have_taken_rank_from"), "Nation", rank, target.getName()));
            }
        }
        catch (NotRegisteredException e) {
            TownyMessaging.sendMsg((Object)player, String.format("msg_resident_doesnt_have_rank", target.getName(), "Nation"));
            return;
        }
        townyUniverse.getDataSource().saveResident(target);
    }

    private void nationWithdraw(Player player, int amount) {
        try {
            if (!TownySettings.geNationBankAllowWithdrawls()) {
                throw new TownyException(TownySettings.getLangString("msg_err_withdraw_disabled"));
            }
            if (amount < 0) {
                throw new TownyException(TownySettings.getLangString("msg_err_negative_money"));
            }
            Resident resident = TownyUniverse.getInstance().getDataSource().getResident(player.getName());
            Nation nation = resident.getTown().getNation();
            boolean underAttack = false;
            for (Town town : nation.getTowns()) {
                if (!TownyWar.isUnderAttack(town) && System.currentTimeMillis() - TownyWar.lastFlagged(town) >= (long)TownySettings.timeToWaitAfterFlag()) continue;
                underAttack = true;
                break;
            }
            if (underAttack && TownySettings.isFlaggedInteractionNation()) {
                throw new TownyException(TownySettings.getLangString("msg_war_flag_deny_nation_under_attack"));
            }
            Transaction transaction = new Transaction(TransactionType.WITHDRAW, player, amount);
            NationPreTransactionEvent preEvent = new NationPreTransactionEvent(nation, transaction);
            BukkitTools.getPluginManager().callEvent((Event)preEvent);
            if (preEvent.isCancelled()) {
                TownyMessaging.sendErrorMsg((Object)player, preEvent.getCancelMessage());
                return;
            }
            nation.withdrawFromBank(resident, amount);
            TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_xx_withdrew_xx"), resident.getName(), amount, "nation"));
            BukkitTools.getPluginManager().callEvent((Event)new NationTransactionEvent(nation, transaction));
        }
        catch (EconomyException | TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
        }
    }

    private void nationDeposit(Player player, int amount) {
        try {
            Resident resident = TownyUniverse.getInstance().getDataSource().getResident(player.getName());
            Nation nation = resident.getTown().getNation();
            double bankcap = TownySettings.getNationBankCap();
            if (bankcap > 0.0 && (double)amount + nation.getHoldingBalance() > bankcap) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_deposit_capped"), bankcap));
            }
            if (amount < 0) {
                throw new TownyException(TownySettings.getLangString("msg_err_negative_money"));
            }
            Transaction transaction = new Transaction(TransactionType.DEPOSIT, player, amount);
            NationPreTransactionEvent preEvent = new NationPreTransactionEvent(nation, transaction);
            BukkitTools.getPluginManager().callEvent((Event)preEvent);
            if (preEvent.isCancelled()) {
                TownyMessaging.sendErrorMsg(preEvent.getCancelMessage());
                return;
            }
            if (!resident.payTo(amount, nation, "Nation Deposit")) {
                throw new TownyException(TownySettings.getLangString("msg_insuf_funds"));
            }
            TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_xx_deposited_xx"), resident.getName(), amount, "nation"));
            BukkitTools.getPluginManager().callEvent((Event)new NationTransactionEvent(nation, transaction));
        }
        catch (EconomyException | TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void listNations(CommandSender sender, String[] split) {
        if (split.length == 2 && split[1].equals("?")) {
            sender.sendMessage(ChatTools.formatTitle("/nation list"));
            sender.sendMessage(ChatTools.formatCommand("", "/nation list", "{page #}", ""));
            sender.sendMessage(ChatTools.formatCommand("", "/nation list", "{page #} by residents", ""));
            sender.sendMessage(ChatTools.formatCommand("", "/nation list", "{page #} by towns", ""));
            sender.sendMessage(ChatTools.formatCommand("", "/nation list", "{page #} by open", ""));
            sender.sendMessage(ChatTools.formatCommand("", "/nation list", "{page #} by balance", ""));
            sender.sendMessage(ChatTools.formatCommand("", "/nation list", "{page #} by name", ""));
            sender.sendMessage(ChatTools.formatCommand("", "/nation list", "{page #} by townblocks", ""));
            sender.sendMessage(ChatTools.formatCommand("", "/nation list", "{page #} by online", ""));
            return;
        }
        List<Nation> nationsToSort = TownyUniverse.getInstance().getDataSource().getNations();
        int page = 1;
        boolean pageSet = false;
        boolean comparatorSet = false;
        Comparator<Nation> comparator = BY_NUM_RESIDENTS;
        int total = (int)Math.ceil((double)nationsToSort.size() / 10.0);
        for (int i = 1; i < split.length; ++i) {
            if (split[i].equalsIgnoreCase("by")) {
                if (comparatorSet) {
                    TownyMessaging.sendErrorMsg((Object)sender, TownySettings.getLangString("msg_error_multiple_comparators_nation"));
                    return;
                }
                if (++i >= split.length) {
                    TownyMessaging.sendErrorMsg((Object)sender, TownySettings.getLangString("msg_error_missing_comparator"));
                    return;
                }
                comparatorSet = true;
                if (split[i].equalsIgnoreCase("residents")) {
                    comparator = BY_NUM_RESIDENTS;
                } else if (split[i].equalsIgnoreCase("balance")) {
                    comparator = BY_BANK_BALANCE;
                } else if (split[i].equalsIgnoreCase("towns")) {
                    comparator = BY_NUM_TOWNS;
                } else if (split[i].equalsIgnoreCase("name")) {
                    comparator = BY_NAME;
                } else if (split[i].equalsIgnoreCase("townblocks")) {
                    comparator = BY_TOWNBLOCKS_CLAIMED;
                } else {
                    if (!split[i].equalsIgnoreCase("online")) {
                        TownyMessaging.sendErrorMsg((Object)sender, TownySettings.getLangString("msg_error_invalid_comparator_nation"));
                        return;
                    }
                    comparator = BY_NUM_ONLINE;
                }
                comparatorSet = true;
                continue;
            }
            if (pageSet) {
                TownyMessaging.sendErrorMsg((Object)sender, TownySettings.getLangString("msg_error_too_many_pages"));
                return;
            }
            try {
                page = Integer.parseInt(split[1]);
                if (page < 0) {
                    TownyMessaging.sendErrorMsg((Object)sender, TownySettings.getLangString("msg_err_negative"));
                    return;
                }
                if (page == 0) {
                    TownyMessaging.sendErrorMsg((Object)sender, TownySettings.getLangString("msg_error_must_be_int"));
                    return;
                }
                pageSet = true;
                continue;
            }
            catch (NumberFormatException e) {
                TownyMessaging.sendErrorMsg((Object)sender, TownySettings.getLangString("msg_error_must_be_int"));
                return;
            }
        }
        if (page > total) {
            TownyMessaging.sendErrorMsg((Object)sender, TownySettings.getListNotEnoughPagesMsg(total));
            return;
        }
        try {
            Collections.sort(nationsToSort, comparator);
        }
        catch (RuntimeException e) {
            TownyMessaging.sendErrorMsg((Object)sender, TownySettings.getLangString("msg_error_comparator_failed"));
            return;
        }
        int iMax = page * 10;
        if (page * 10 > nationsToSort.size()) {
            iMax = nationsToSort.size();
        }
        ArrayList<String> nationsordered = new ArrayList<String>();
        int i = (page - 1) * 10;
        while (true) {
            if (i >= iMax) {
                sender.sendMessage(ChatTools.formatList(TownySettings.getLangString("nation_plu"), "\u00a76" + TownySettings.getLangString("nation_name") + "\u00a78" + " - " + "\u00a7b" + TownySettings.getLangString("number_of_residents") + "\u00a78" + " - " + "\u00a7b" + TownySettings.getLangString("number_of_towns"), nationsordered, TownySettings.getListPageMsg(page, total)));
                return;
            }
            Nation nation = nationsToSort.get(i);
            String output = "\u00a76" + StringMgmt.remUnderscore(nation.getName()) + "\u00a78" + " - " + "\u00a7b" + "(" + nation.getNumResidents() + ")" + "\u00a78" + " - " + "\u00a7b" + "(" + nation.getNumTowns() + ")";
            nationsordered.add(output);
            ++i;
        }
    }

    public void newNation(Player player, String name, String capitalName) {
        TownyUniverse universe = TownyUniverse.getInstance();
        try {
            String filteredName;
            Town town = universe.getDataSource().getTown(capitalName);
            if (town.hasNation()) {
                throw new TownyException(TownySettings.getLangString("msg_err_already_nation"));
            }
            try {
                filteredName = NameValidation.checkAndFilterName(name);
            }
            catch (InvalidNameException e) {
                filteredName = null;
            }
            if (filteredName == null || universe.getDataSource().hasNation(filteredName)) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_invalid_name"), name));
            }
            if (TownySettings.isUsingEconomy() && !town.pay(TownySettings.getNewNationPrice(), "New Nation Cost")) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_no_funds_new_nation2"), TownySettings.getNewNationPrice()));
            }
            this.newNation(name, town);
            TownyMessaging.sendGlobalMessage(TownySettings.getNewNationMsg(player.getName(), StringMgmt.remUnderscore(name)));
        }
        catch (EconomyException | TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
        }
    }

    public Nation newNation(String name, Town town) throws AlreadyRegisteredException, NotRegisteredException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        townyUniverse.getDataSource().newNation(name);
        Nation nation = townyUniverse.getDataSource().getNation(name);
        nation.addTown(town);
        nation.setCapital(town);
        nation.setUuid(UUID.randomUUID());
        nation.setRegistered(System.currentTimeMillis());
        if (TownySettings.isUsingEconomy()) {
            try {
                nation.setBalance(0.0, "Deleting Nation");
            }
            catch (EconomyException e) {
                e.printStackTrace();
            }
        }
        townyUniverse.getDataSource().saveTown(town);
        townyUniverse.getDataSource().saveNation(nation);
        townyUniverse.getDataSource().saveNationList();
        BukkitTools.getPluginManager().callEvent((Event)new NewNationEvent(nation));
        return nation;
    }

    public void mergeNation(Player player, String name) throws TownyException {
        TownyUniverse universe = TownyUniverse.getInstance();
        Nation nation = null;
        Nation remainingNation = null;
        try {
            nation = universe.getDataSource().getNation(name);
            remainingNation = universe.getDataSource().getResident(player.getName()).getTown().getNation();
        }
        catch (NotRegisteredException e) {
            throw new TownyException(String.format(TownySettings.getLangString("msg_err_invalid_name"), name));
        }
        if (remainingNation.getName().equalsIgnoreCase(name)) {
            throw new TownyException(String.format(TownySettings.getLangString("msg_err_invalid_name"), name));
        }
        if (nation != null) {
            Resident king = nation.getKing();
            if (!BukkitTools.isOnline(king.getName())) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_king_of_that_nation_is_not_online"), name, king.getName()));
            }
            TownyMessaging.sendMessage((Object)BukkitTools.getPlayer(king.getName()), String.format(TownySettings.getLangString("msg_would_you_merge_your_nation_into_other_nation"), nation, remainingNation, remainingNation));
            ConfirmationHandler.addConfirmation(king, ConfirmationType.NATIONMERGE, remainingNation);
            TownyMessaging.sendConfirmationMessage(BukkitTools.getPlayer(king.getName()), null, null, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void nationLeave(Player player) {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        Town town = null;
        Nation nation = null;
        try {
            Resident resident = townyUniverse.getDataSource().getResident(player.getName());
            town = resident.getTown();
            nation = town.getNation();
            if (TownyWar.isUnderAttack(town) && TownySettings.isFlaggedInteractionTown()) {
                throw new TownyException(TownySettings.getLangString("msg_war_flag_deny_town_under_attack"));
            }
            if (System.currentTimeMillis() - TownyWar.lastFlagged(town) < (long)TownySettings.timeToWaitAfterFlag()) {
                throw new TownyException(TownySettings.getLangString("msg_war_flag_deny_recently_attacked"));
            }
            nation.removeTown(town);
            ArrayList<Resident> titleRemove = new ArrayList<Resident>(town.getResidents());
            for (Resident res : titleRemove) {
                if (res.hasTitle() || res.hasSurname()) {
                    res.setTitle("");
                    res.setSurname("");
                }
                res.updatePermsForNationRemoval();
                townyUniverse.getDataSource().saveResident(res);
            }
            townyUniverse.getDataSource().saveNation(nation);
            townyUniverse.getDataSource().saveNationList();
            plugin.resetCache();
            TownyMessaging.sendNationMessage(nation, ChatTools.color(String.format(TownySettings.getLangString("msg_nation_town_left"), StringMgmt.remUnderscore(town.getName()))));
            TownyMessaging.sendTownMessage(town, ChatTools.color(String.format(TownySettings.getLangString("msg_town_left_nation"), StringMgmt.remUnderscore(nation.getName()))));
            townyUniverse.getDataSource().saveTown(town);
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            townyUniverse.getDataSource().saveTown(town);
            return;
        }
        catch (EmptyNationException en) {
            townyUniverse.getDataSource().removeNation(en.getNation());
            townyUniverse.getDataSource().saveNationList();
            TownyMessaging.sendGlobalMessage(ChatTools.color(String.format(TownySettings.getLangString("msg_del_nation"), en.getNation().getName())));
            townyUniverse.getDataSource().saveTown(town);
            {
                catch (Throwable throwable) {
                    townyUniverse.getDataSource().saveTown(town);
                    throw throwable;
                }
            }
        }
    }

    public void nationDelete(Player player, String[] split) {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (split.length == 0) {
            try {
                Resident resident = townyUniverse.getDataSource().getResident(player.getName());
                ConfirmationHandler.addConfirmation(resident, ConfirmationType.NATIONDELETE, null);
                TownyMessaging.sendConfirmationMessage(player, null, null, null, null);
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
                return;
            }
        }
        try {
            if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_NATION_DELETE.getNode())) {
                throw new TownyException(TownySettings.getLangString("msg_err_admin_only_delete_nation"));
            }
            Nation nation = townyUniverse.getDataSource().getNation(split[0]);
            townyUniverse.getDataSource().removeNation(nation);
            TownyMessaging.sendGlobalMessage(TownySettings.getDelNationMsg(nation));
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
    }

    public void nationKing(Player player, String[] split) {
        if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
            for (String line : king_help) {
                player.sendMessage(line);
            }
        }
    }

    public void nationAdd(Player player, String[] names) throws TownyException {
        Nation nation;
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (names.length < 1) {
            TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation add [names]");
            return;
        }
        try {
            Resident resident = townyUniverse.getDataSource().getResident(player.getName());
            nation = resident.getTown().getNation();
            if (TownySettings.getMaxTownsPerNation() > 0 && nation.getTowns().size() >= TownySettings.getMaxTownsPerNation()) {
                TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_nation_over_town_limit"), TownySettings.getMaxTownsPerNation()));
                return;
            }
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        ArrayList<String> reslist = new ArrayList<String>(Arrays.asList(names));
        ArrayList<String> newreslist = new ArrayList<String>();
        ArrayList<String> removeinvites = new ArrayList<String>();
        for (String townname : reslist) {
            if (townname.startsWith("-")) {
                removeinvites.add(townname.substring(1));
                continue;
            }
            newreslist.add(townname);
        }
        names = newreslist.toArray(new String[0]);
        String[] namestoremove = removeinvites.toArray(new String[0]);
        if (namestoremove.length >= 1) {
            NationCommand.nationRevokeInviteTown(player, nation, townyUniverse.getDataSource().getTowns(namestoremove));
        }
        if (names.length >= 1) {
            NationCommand.nationAdd(player, nation, townyUniverse.getDataSource().getTowns(names));
        }
    }

    private static void nationRevokeInviteTown(Object sender, Nation nation, List<Town> towns) {
        block2: for (Town town : towns) {
            if (!InviteHandler.inviteIsActive(nation, town)) continue;
            for (Invite invite : town.getReceivedInvites()) {
                if (!invite.getSender().equals(nation)) continue;
                try {
                    InviteHandler.declineInvite(invite, true);
                    TownyMessaging.sendMessage(sender, TownySettings.getLangString("nation_revoke_invite_successful"));
                    continue block2;
                }
                catch (InvalidObjectException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void nationAdd(Player player, Nation nation, List<Town> invited) throws TownyException {
        StringBuilder msg;
        ArrayList<Town> remove = new ArrayList<Town>();
        for (Town town : invited) {
            try {
                if (TownySettings.getNumResidentsJoinNation() > 0 && town.getNumResidents() < TownySettings.getNumResidentsJoinNation()) {
                    remove.add(town);
                    TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_not_enough_residents_join_nation"), town.getName()));
                    continue;
                }
                if (TownySettings.getNationRequiresProximity() > 0.0) {
                    Coord capitalCoord = nation.getCapital().getHomeBlock().getCoord();
                    Coord townCoord = town.getHomeBlock().getCoord();
                    if (!nation.getCapital().getHomeBlock().getWorld().getName().equals(town.getHomeBlock().getWorld().getName())) {
                        remove.add(town);
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_nation_homeblock_in_another_world"));
                        continue;
                    }
                    double distance = Math.sqrt(Math.pow(capitalCoord.getX() - townCoord.getX(), 2.0) + Math.pow(capitalCoord.getZ() - townCoord.getZ(), 2.0));
                    if (distance > TownySettings.getNationRequiresProximity()) {
                        TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_town_not_close_enough_to_nation"), town.getName()));
                        remove.add(town);
                        continue;
                    }
                }
                NationPreAddTownEvent preEvent = new NationPreAddTownEvent(nation, town);
                Bukkit.getPluginManager().callEvent((Event)preEvent);
                if (preEvent.isCancelled()) {
                    TownyMessaging.sendErrorMsg((Object)player, preEvent.getCancelMessage());
                    return;
                }
                NationCommand.nationInviteTown(player, nation, town);
            }
            catch (AlreadyRegisteredException e) {
                remove.add(town);
            }
        }
        for (Town town : remove) {
            invited.remove(town);
        }
        if (invited.size() > 0) {
            msg = new StringBuilder();
            for (Town town : invited) {
                msg.append(town.getName()).append(", ");
            }
        } else {
            throw new TownyException(TownySettings.getLangString("msg_invalid_name"));
        }
        msg = new StringBuilder(msg.substring(0, msg.length() - 2));
        msg = new StringBuilder(String.format(TownySettings.getLangString("msg_invited_join_nation"), player.getName(), msg.toString()));
        TownyMessaging.sendNationMessage(nation, ChatTools.color(msg.toString()));
    }

    private static void nationInviteTown(Player player, Nation nation, Town town) throws TownyException {
        TownJoinNationInvite invite = new TownJoinNationInvite(player.getName(), nation, town);
        try {
            if (InviteHandler.inviteIsActive(invite)) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_town_already_invited"), town.getName()));
            }
            town.newReceivedInvite(invite);
            nation.newSentInvite(invite);
            InviteHandler.addInvite(invite);
            TownyMessaging.sendRequestMessage(town.getMayor(), invite);
            Bukkit.getPluginManager().callEvent((Event)new NationInviteTownEvent(invite));
        }
        catch (TooManyInvitesException e) {
            town.deleteReceivedInvite(invite);
            nation.deleteSentInvite(invite);
            throw new TownyException(e.getMessage());
        }
    }

    public static void nationAdd(Nation nation, List<Town> towns) throws AlreadyRegisteredException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        for (Town town : towns) {
            if (town.hasNation()) continue;
            nation.addTown(town);
            townyUniverse.getDataSource().saveTown(town);
            TownyMessaging.sendNationMessagePrefixed(nation, String.format(TownySettings.getLangString("msg_join_nation"), town.getName()));
        }
        plugin.resetCache();
        townyUniverse.getDataSource().saveNation(nation);
    }

    public void nationKick(Player player, String[] names) {
        Nation nation;
        Resident resident;
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (names.length < 1) {
            TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation kick [names]");
            return;
        }
        try {
            resident = townyUniverse.getDataSource().getResident(player.getName());
            nation = resident.getTown().getNation();
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        this.nationKick(player, resident, nation, townyUniverse.getDataSource().getTowns(names));
    }

    public void nationKick(Player player, Resident resident, Nation nation, List<Town> kicking) {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        ArrayList<Town> remove = new ArrayList<Town>();
        for (Town town : kicking) {
            if (town.isCapital()) {
                remove.add(town);
                continue;
            }
            try {
                nation.removeTown(town);
                ArrayList<Resident> titleRemove = new ArrayList<Resident>(town.getResidents());
                for (Resident res : titleRemove) {
                    if (res.hasTitle() || res.hasSurname()) {
                        res.setTitle("");
                        res.setSurname("");
                    }
                    res.updatePermsForNationRemoval();
                    townyUniverse.getDataSource().saveResident(res);
                }
                townyUniverse.getDataSource().saveTown(town);
            }
            catch (NotRegisteredException e) {
                remove.add(town);
            }
            catch (EmptyNationException e) {}
        }
        for (Town town : remove) {
            kicking.remove(town);
        }
        if (kicking.size() > 0) {
            StringBuilder msg = new StringBuilder();
            for (Town town : kicking) {
                msg.append(town.getName()).append(", ");
                TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_nation_kicked_by"), player.getName()));
            }
            msg = new StringBuilder(msg.substring(0, msg.length() - 2));
            msg = new StringBuilder(String.format(TownySettings.getLangString("msg_nation_kicked"), player.getName(), msg.toString()));
            TownyMessaging.sendNationMessage(nation, ChatTools.color(msg.toString()));
            townyUniverse.getDataSource().saveNation(nation);
            plugin.resetCache();
        } else {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
        }
    }

    private void nationAlly(Player player, String[] split) throws TownyException {
        Nation nation;
        Resident resident;
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (split.length <= 0) {
            TownyMessaging.sendMessage((Object)player, alliesstring);
            return;
        }
        try {
            resident = townyUniverse.getDataSource().getResident(player.getName());
            nation = resident.getTown().getNation();
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        ArrayList<Nation> list = new ArrayList<Nation>();
        ArrayList<Nation> remlist = new ArrayList<Nation>();
        String[] names = StringMgmt.remFirstArg(split);
        if (split[0].equalsIgnoreCase("add")) {
            if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_ALLY_ADD.getNode())) {
                throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
            }
            for (String name : names) {
                Nation ally;
                try {
                    ally = townyUniverse.getDataSource().getNation(name);
                    if (nation.equals(ally)) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_own_nation_disallow"));
                        return;
                    }
                    list.add(ally);
                }
                catch (NotRegisteredException e) {
                    if (name.startsWith("-") && TownySettings.isDisallowOneWayAlliance()) {
                        try {
                            ally = townyUniverse.getDataSource().getNation(name.substring(1));
                            if (nation.equals(ally)) {
                                TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_own_nation_disallow"));
                                return;
                            }
                            remlist.add(ally);
                            continue;
                        }
                        catch (NotRegisteredException x) {
                            TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_name"), name));
                            return;
                        }
                    }
                    TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_name"), name));
                    return;
                }
            }
            if (!list.isEmpty()) {
                if (TownySettings.isDisallowOneWayAlliance()) {
                    this.nationAlly(resident, nation, list, true);
                } else {
                    this.nationlegacyAlly(resident, nation, list, true);
                }
            }
            if (!remlist.isEmpty()) {
                this.nationRemoveAllyRequest(player, nation, remlist);
            }
            return;
        }
        if (split[0].equalsIgnoreCase("remove")) {
            if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_ALLY_REMOVE.getNode())) {
                throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
            }
            for (String name : names) {
                try {
                    Nation ally = townyUniverse.getDataSource().getNation(name);
                    if (nation.equals(ally)) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_own_nation_disallow"));
                        return;
                    }
                    list.add(ally);
                }
                catch (NotRegisteredException e) {
                    // empty catch block
                }
            }
            if (!list.isEmpty()) {
                if (TownySettings.isDisallowOneWayAlliance()) {
                    this.nationAlly(resident, nation, list, false);
                } else {
                    this.nationlegacyAlly(resident, nation, list, false);
                }
            }
            return;
        }
        if (!TownySettings.isDisallowOneWayAlliance()) {
            TownyMessaging.sendMessage((Object)player, alliesstring);
            return;
        }
        if (TownySettings.isDisallowOneWayAlliance()) {
            Nation sendernation;
            List<Invite> invites;
            String received = TownySettings.getLangString("nation_received_requests").replace("%a", Integer.toString(InviteHandler.getReceivedInvitesAmount(resident.getTown().getNation()))).replace("%m", Integer.toString(InviteHandler.getReceivedInvitesMaxAmount(resident.getTown().getNation())));
            String sent = TownySettings.getLangString("nation_sent_ally_requests").replace("%a", Integer.toString(InviteHandler.getSentAllyRequestsAmount(resident.getTown().getNation()))).replace("%m", Integer.toString(InviteHandler.getSentAllyRequestsMaxAmount(resident.getTown().getNation())));
            if (split[0].equalsIgnoreCase("sent")) {
                if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_ALLY_LIST_SENT.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                List<Invite> sentinvites = resident.getTown().getNation().getSentAllyInvites();
                int page = 1;
                if (split.length >= 2) {
                    try {
                        page = Integer.parseInt(split[2]);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                InviteCommand.sendInviteList(player, sentinvites, page, true);
                player.sendMessage(sent);
                return;
            }
            if (split[0].equalsIgnoreCase("received")) {
                if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_ALLY_LIST_RECEIVED.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                List<Invite> receivedinvites = resident.getTown().getNation().getReceivedInvites();
                int page = 1;
                if (split.length >= 2) {
                    try {
                        page = Integer.parseInt(split[2]);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                InviteCommand.sendInviteList(player, receivedinvites, page, true);
                player.sendMessage(received);
                return;
            }
            if (split[0].equalsIgnoreCase("accept")) {
                if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_ALLY_ACCEPT.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                invites = nation.getReceivedInvites();
                if (invites.size() == 0) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_nation_no_requests"));
                    return;
                }
                if (split.length >= 2) {
                    try {
                        sendernation = townyUniverse.getDataSource().getNation(split[1]);
                    }
                    catch (NotRegisteredException e) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
                        return;
                    }
                } else {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_nation_specify_invite"));
                    InviteCommand.sendInviteList(player, invites, 1, false);
                    return;
                }
                Invite toAccept = null;
                for (Invite invite : InviteHandler.getActiveInvites()) {
                    if (!invite.getSender().equals(sendernation) || !invite.getReceiver().equals(nation)) continue;
                    toAccept = invite;
                    break;
                }
                if (toAccept != null) {
                    try {
                        InviteHandler.acceptInvite(toAccept);
                        return;
                    }
                    catch (InvalidObjectException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (split[0].equalsIgnoreCase("deny")) {
                if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_ALLY_DENY.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                invites = nation.getReceivedInvites();
                if (invites.size() == 0) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_nation_no_requests"));
                    return;
                }
                if (split.length >= 2) {
                    try {
                        sendernation = townyUniverse.getDataSource().getNation(split[1]);
                    }
                    catch (NotRegisteredException e) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
                        return;
                    }
                } else {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_nation_specify_invite"));
                    InviteCommand.sendInviteList(player, invites, 1, false);
                    return;
                }
                Invite toDecline = null;
                for (Invite invite : InviteHandler.getActiveInvites()) {
                    if (!invite.getSender().equals(sendernation) || !invite.getReceiver().equals(nation)) continue;
                    toDecline = invite;
                    break;
                }
                if (toDecline != null) {
                    try {
                        InviteHandler.declineInvite(toDecline, false);
                        TownyMessaging.sendMessage((Object)player, TownySettings.getLangString("successful_deny_request"));
                    }
                    catch (InvalidObjectException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                TownyMessaging.sendMessage((Object)player, alliesstring);
                return;
            }
        }
    }

    private void nationRemoveAllyRequest(Object sender, Nation nation, ArrayList<Nation> remlist) {
        block2: for (Nation invited : remlist) {
            if (!InviteHandler.inviteIsActive(nation, invited)) continue;
            for (Invite invite : invited.getReceivedInvites()) {
                if (!invite.getSender().equals(nation)) continue;
                try {
                    InviteHandler.declineInvite(invite, true);
                    TownyMessaging.sendMessage(sender, TownySettings.getLangString("town_revoke_invite_successful"));
                    continue block2;
                }
                catch (InvalidObjectException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void nationCreateAllyRequest(String sender, Nation nation, Nation receiver) throws TownyException {
        NationAllyNationInvite invite = new NationAllyNationInvite(sender, nation, receiver);
        try {
            if (InviteHandler.inviteIsActive(invite)) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_player_already_invited"), receiver.getName()));
            }
            receiver.newReceivedInvite(invite);
            nation.newSentAllyInvite(invite);
            InviteHandler.addInvite(invite);
            TownyMessaging.sendRequestMessage(receiver.getCapital().getMayor(), invite);
            Bukkit.getPluginManager().callEvent((Event)new NationRequestAllyNationEvent(invite));
        }
        catch (TooManyInvitesException e) {
            receiver.deleteReceivedInvite(invite);
            nation.deleteSentAllyInvite(invite);
            throw new TownyException(e.getMessage());
        }
    }

    public void nationlegacyAlly(Resident resident, Nation nation, List<Nation> allies, boolean add) {
        Player player = BukkitTools.getPlayer(resident.getName());
        ArrayList<Nation> remove = new ArrayList<Nation>();
        for (Nation targetNation : allies) {
            try {
                if (add && !nation.getAllies().contains(targetNation)) {
                    if (!targetNation.hasEnemy(nation)) {
                        try {
                            nation.addAlly(targetNation);
                        }
                        catch (AlreadyRegisteredException e) {
                            e.printStackTrace();
                        }
                        TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_allied_nations"), resident.getName(), targetNation.getName()));
                        TownyMessaging.sendNationMessage(targetNation, String.format(TownySettings.getLangString("msg_added_ally"), nation.getName()));
                        continue;
                    }
                    remove.add(targetNation);
                    TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_unable_ally_enemy"), targetNation.getName()));
                    continue;
                }
                if (!nation.getAllies().contains(targetNation)) continue;
                nation.removeAlly(targetNation);
                TownyMessaging.sendNationMessage(targetNation, String.format(TownySettings.getLangString("msg_removed_ally"), nation.getName()));
                TownyMessaging.sendMessage((Object)player, TownySettings.getLangString("msg_ally_removed_successfully"));
                if (!targetNation.hasAlly(nation)) continue;
                this.nationlegacyAlly(resident, targetNation, Arrays.asList(nation), false);
            }
            catch (NotRegisteredException e) {
                remove.add(targetNation);
            }
        }
        for (Nation newAlly : remove) {
            allies.remove(newAlly);
        }
        if (allies.size() > 0) {
            TownyUniverse.getInstance().getDataSource().saveNations();
            plugin.resetCache();
        } else {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
        }
    }

    public void nationAlly(Resident resident, Nation nation, List<Nation> allies, boolean add) throws TownyException {
        Player player = BukkitTools.getPlayer(resident.getName());
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        ArrayList<Nation> remove = new ArrayList<Nation>();
        for (Nation targetNation : allies) {
            if (add) {
                if (targetNation.hasEnemy(nation)) continue;
                if (!targetNation.getCapital().getMayor().isNPC()) {
                    for (Nation newAlly : allies) {
                        this.nationCreateAllyRequest(player.getName(), nation, targetNation);
                        TownyMessaging.sendNationMessage(nation, ChatTools.color(String.format(TownySettings.getLangString("msg_ally_req_sent"), newAlly.getName())));
                    }
                    continue;
                }
                if (townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN.getNode())) {
                    try {
                        targetNation.addAlly(nation);
                        nation.addAlly(targetNation);
                    }
                    catch (AlreadyRegisteredException e) {
                        e.printStackTrace();
                    }
                    TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_allied_nations"), resident.getName(), targetNation.getName()));
                    TownyMessaging.sendNationMessage(targetNation, String.format(TownySettings.getLangString("msg_added_ally"), nation.getName()));
                    continue;
                }
                TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_unable_ally_npc"), nation.getName()));
                continue;
            }
            if (!nation.getAllies().contains(targetNation)) continue;
            try {
                nation.removeAlly(targetNation);
                TownyMessaging.sendNationMessage(targetNation, String.format(TownySettings.getLangString("msg_removed_ally"), nation.getName()));
                TownyMessaging.sendMessage((Object)player, TownySettings.getLangString("msg_ally_removed_successfully"));
            }
            catch (NotRegisteredException e) {
                remove.add(targetNation);
            }
            if (!targetNation.hasAlly(nation)) continue;
            try {
                targetNation.removeAlly(nation);
            }
            catch (NotRegisteredException notRegisteredException) {
            }
        }
        for (Nation newAlly : remove) {
            allies.remove(newAlly);
        }
        if (allies.size() > 0) {
            townyUniverse.getDataSource().saveNations();
            plugin.resetCache();
        } else {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
        }
    }

    public void nationEnemy(Player player, String[] split) throws TownyException {
        Nation nation;
        Resident resident;
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (split.length < 2) {
            TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation enemy [add/remove] [name]");
            return;
        }
        try {
            resident = townyUniverse.getDataSource().getResident(player.getName());
            nation = resident.getTown().getNation();
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        ArrayList<Nation> list = new ArrayList<Nation>();
        String test = split[0];
        String[] newSplit = StringMgmt.remFirstArg(split);
        if ((test.equalsIgnoreCase("remove") || test.equalsIgnoreCase("add")) && newSplit.length > 0) {
            for (String name : newSplit) {
                try {
                    Nation enemy = townyUniverse.getDataSource().getNation(name);
                    if (nation.equals(enemy)) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_own_nation_disallow"));
                        continue;
                    }
                    list.add(enemy);
                }
                catch (NotRegisteredException e) {
                    throw new TownyException(String.format(TownySettings.getLangString("msg_err_no_nation_with_that_name"), name));
                }
            }
            if (!list.isEmpty()) {
                this.nationEnemy(resident, nation, list, test.equalsIgnoreCase("add"));
            }
        } else {
            TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_property"), "[add/remove]"));
        }
    }

    public void nationEnemy(Resident resident, Nation nation, List<Nation> enemies, boolean add) {
        ArrayList<Nation> remove = new ArrayList<Nation>();
        for (Nation targetNation : enemies) {
            try {
                if (add && !nation.getEnemies().contains(targetNation)) {
                    nation.addEnemy(targetNation);
                    TownyMessaging.sendNationMessage(targetNation, String.format(TownySettings.getLangString("msg_added_enemy"), nation.getName()));
                    if (!targetNation.hasAlly(nation)) continue;
                    this.nationlegacyAlly(resident, targetNation, Arrays.asList(nation), false);
                    continue;
                }
                if (!nation.getEnemies().contains(targetNation)) continue;
                nation.removeEnemy(targetNation);
                TownyMessaging.sendNationMessage(targetNation, String.format(TownySettings.getLangString("msg_removed_enemy"), nation.getName()));
            }
            catch (AlreadyRegisteredException | NotRegisteredException e) {
                remove.add(targetNation);
            }
        }
        for (Nation newEnemy : remove) {
            enemies.remove(newEnemy);
        }
        if (enemies.size() > 0) {
            String msg = "";
            for (Nation newEnemy : enemies) {
                msg = msg + newEnemy.getName() + ", ";
            }
            msg = msg.substring(0, msg.length() - 2);
            msg = add ? String.format(TownySettings.getLangString("msg_enemy_nations"), resident.getName(), msg) : String.format(TownySettings.getLangString("msg_enemy_to_neutral"), resident.getName(), msg);
            TownyMessaging.sendNationMessage(nation, ChatTools.color(msg));
            TownyUniverse.getInstance().getDataSource().saveNations();
            plugin.resetCache();
        } else {
            TownyMessaging.sendErrorMsg((Object)resident, TownySettings.getLangString("msg_invalid_name"));
        }
    }

    public static void nationSet(Player player, String[] split, boolean admin, Nation nation) throws TownyException, InvalidNameException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (split.length == 0) {
            player.sendMessage(ChatTools.formatTitle("/nation set"));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "king " + TownySettings.getLangString("res_2"), ""));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "capital [town]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "taxes [$]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "name [name]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "title/surname [resident] [text]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "tag [upto 4 letters] or clear", ""));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "board [message ... ]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "spawn", ""));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "spawncost [$]", ""));
        } else {
            block90: {
                Resident resident;
                try {
                    if (!admin) {
                        resident = townyUniverse.getDataSource().getResident(player.getName());
                        nation = resident.getTown().getNation();
                    } else {
                        resident = nation.getKing();
                    }
                }
                catch (TownyException x) {
                    TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
                    return;
                }
                if (split[0].equalsIgnoreCase("king")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SET_KING.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set king Dumbo");
                    } else {
                        try {
                            Resident newKing = townyUniverse.getDataSource().getResident(split[1]);
                            String oldKingsName = nation.getCapital().getMayor().getName();
                            if (TownySettings.getNumResidentsCreateNation() > 0 && newKing.getTown().getNumResidents() < TownySettings.getNumResidentsCreateNation()) {
                                TownyMessaging.sendMessage((Object)player, String.format(TownySettings.getLangString("msg_not_enough_residents_capital"), newKing.getTown().getName()));
                                return;
                            }
                            nation.setKing(newKing);
                            plugin.deleteCache(oldKingsName);
                            plugin.deleteCache(newKing.getName());
                            TownyMessaging.sendNationMessage(nation, TownySettings.getNewKingMsg(newKing.getName(), nation.getName()));
                        }
                        catch (TownyException e) {
                            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                        }
                    }
                } else if (split[0].equalsIgnoreCase("capital")) {
                    try {
                        Town newCapital = townyUniverse.getDataSource().getTown(split[1]);
                        if (TownySettings.getNumResidentsCreateNation() > 0 && newCapital.getNumResidents() < TownySettings.getNumResidentsCreateNation()) {
                            TownyMessaging.sendMessage((Object)player, String.format(TownySettings.getLangString("msg_not_enough_residents_capital"), newCapital.getName()));
                            return;
                        }
                        if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SET_CAPITOL.getNode())) {
                            throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                        }
                        if (split.length < 2) {
                            TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set capital {town name}");
                            break block90;
                        }
                        nation.setCapital(newCapital);
                        plugin.resetCache();
                        TownyMessaging.sendNationMessage(nation, TownySettings.getNewKingMsg(newCapital.getMayor().getName(), nation.getName()));
                    }
                    catch (TownyException e) {
                        TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                    }
                } else if (split[0].equalsIgnoreCase("spawn")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SET_SPAWN.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    try {
                        nation.setNationSpawn(player.getLocation());
                        TownyMessaging.sendMsg((Object)player, TownySettings.getLangString("msg_set_nation_spawn"));
                    }
                    catch (TownyException e) {
                        TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                    }
                } else if (split[0].equalsIgnoreCase("taxes")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SET_TAXES.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set taxes 70");
                    } else {
                        int amount = Integer.parseInt(split[1].trim());
                        if (amount < 0) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative_money"));
                            return;
                        }
                        try {
                            nation.setTaxes(amount);
                            TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_town_set_nation_tax"), player.getName(), split[1]));
                        }
                        catch (NumberFormatException e) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_int"));
                        }
                    }
                } else if (split[0].equalsIgnoreCase("spawncost")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SET_SPAWNCOST.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set spawncost 70");
                    } else {
                        try {
                            double amount = Double.parseDouble(split[1]);
                            if (amount < 0.0) {
                                TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative_money"));
                                return;
                            }
                            if (TownySettings.getSpawnTravelCost() < amount) {
                                TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_cannot_set_spawn_cost_more_than"), TownySettings.getSpawnTravelCost()));
                                return;
                            }
                            nation.setSpawnCost(amount);
                            TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_spawn_cost_set_to"), player.getName(), TownySettings.getLangString("nation_sing"), split[1]));
                        }
                        catch (NumberFormatException e) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_num"));
                            return;
                        }
                    }
                } else if (split[0].equalsIgnoreCase("name")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SET_NAME.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set name Plutoria");
                    } else {
                        if (TownySettings.getNationRenameCost() > 0.0) {
                            try {
                                if (TownySettings.isUsingEconomy() && !nation.pay(TownySettings.getNationRenameCost(), String.format("Nation renamed to: %s", split[1]))) {
                                    throw new TownyException(String.format(TownySettings.getLangString("msg_err_no_money"), TownyEconomyHandler.getFormattedBalance(TownySettings.getNationRenameCost())));
                                }
                            }
                            catch (EconomyException e) {
                                throw new TownyException("Economy Error");
                            }
                        }
                        if (!NameValidation.isBlacklistName(split[1])) {
                            NationCommand.nationRename(player, nation, split[1]);
                        } else {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
                        }
                    }
                } else if (split[0].equalsIgnoreCase("tag")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SET_TAG.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set tag PLT");
                    } else if (split[1].equalsIgnoreCase("clear")) {
                        try {
                            nation.setTag(" ");
                            TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_reset_nation_tag"), player.getName()));
                        }
                        catch (TownyException e) {
                            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                        }
                    } else {
                        nation.setTag(NameValidation.checkAndFilterName(split[1]));
                    }
                    TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_set_nation_tag"), player.getName(), nation.getTag()));
                } else if (split[0].equalsIgnoreCase("title")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SET_TITLE.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set title bilbo Jester ");
                    } else {
                        resident = townyUniverse.getDataSource().getResident(split[1]);
                    }
                    if (resident.hasNation()) {
                        if (resident.getTown().getNation() != townyUniverse.getDataSource().getResident(player.getName()).getTown().getNation()) {
                            TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_not_same_nation"), resident.getName()));
                            return;
                        }
                    } else {
                        TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_not_same_nation"), resident.getName()));
                        return;
                    }
                    if (StringMgmt.join(split = StringMgmt.remArgs(split, 2)).length() > TownySettings.getMaxTitleLength()) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_input_too_long"));
                        return;
                    }
                    String title = StringMgmt.join(NameValidation.checkAndFilterArray(split));
                    resident.setTitle(title + " ");
                    townyUniverse.getDataSource().saveResident(resident);
                    if (resident.hasTitle()) {
                        TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_set_title"), resident.getName(), resident.getTitle()));
                    } else {
                        TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_clear_title_surname"), "Title", resident.getName()));
                    }
                } else if (split[0].equalsIgnoreCase("surname")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SET_SURNAME.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set surname bilbo the dwarf ");
                    } else {
                        resident = townyUniverse.getDataSource().getResident(split[1]);
                    }
                    if (resident.hasNation()) {
                        if (resident.getTown().getNation() != townyUniverse.getDataSource().getResident(player.getName()).getTown().getNation()) {
                            TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_not_same_nation"), resident.getName()));
                            return;
                        }
                    } else {
                        TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_not_same_nation"), resident.getName()));
                        return;
                    }
                    if (StringMgmt.join(split = StringMgmt.remArgs(split, 2)).length() > TownySettings.getMaxTitleLength()) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_input_too_long"));
                        return;
                    }
                    String surname = StringMgmt.join(NameValidation.checkAndFilterArray(split));
                    resident.setSurname(" " + surname);
                    townyUniverse.getDataSource().saveResident(resident);
                    if (resident.hasSurname()) {
                        TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_set_surname"), resident.getName(), resident.getSurname()));
                    } else {
                        TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_clear_title_surname"), "Surname", resident.getName()));
                    }
                } else if (split[0].equalsIgnoreCase("board")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SET_BOARD.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set board " + TownySettings.getLangString("town_help_9"));
                        return;
                    }
                    String line = StringMgmt.join(StringMgmt.remFirstArg(split), " ");
                    if (!NameValidation.isValidString(line)) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_invalid_string_nationboard_not_set"));
                        return;
                    }
                    nation.setNationBoard(line);
                    TownyMessaging.sendNationBoard(player, nation);
                } else {
                    TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_property"), split[0]));
                    return;
                }
            }
            townyUniverse.getDataSource().saveNation(nation);
            townyUniverse.getDataSource().saveNationList();
        }
    }

    public static void nationToggle(Player player, String[] split, boolean admin, Nation nation) throws TownyException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (split.length == 0) {
            player.sendMessage(ChatTools.formatTitle("/nation toggle"));
            player.sendMessage(ChatTools.formatCommand("", "/nation toggle", "peaceful", ""));
            player.sendMessage(ChatTools.formatCommand("", "/nation toggle", "public", ""));
            player.sendMessage(ChatTools.formatCommand("", "/nation toggle", "open", ""));
        } else {
            try {
                if (!admin) {
                    Resident resident = townyUniverse.getDataSource().getResident(player.getName());
                    nation = resident.getTown().getNation();
                } else {
                    Resident resident = nation.getKing();
                }
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
                return;
            }
            if (split[0].equalsIgnoreCase("peaceful") || split[0].equalsIgnoreCase("neutral")) {
                if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_TOGGLE_NEUTRAL.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                try {
                    boolean choice = !nation.isNeutral();
                    double cost = TownySettings.getNationNeutralityCost();
                    if (choice && TownySettings.isUsingEconomy() && !nation.pay(cost, "Peaceful Nation Cost")) {
                        throw new TownyException(TownySettings.getLangString("msg_nation_cant_peaceful"));
                    }
                    nation.setNeutral(choice);
                    if (TownySettings.isUsingEconomy() && cost > 0.0) {
                        TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_you_paid"), TownyEconomyHandler.getFormattedBalance(cost)));
                    } else {
                        TownyMessaging.sendMsg((Object)player, TownySettings.getLangString("msg_nation_set_peaceful"));
                    }
                    TownyMessaging.sendNationMessage(nation, TownySettings.getLangString("msg_nation_peaceful") + (nation.isNeutral() ? "\u00a72" : "\u00a74 not") + " peaceful.");
                }
                catch (TownyException e) {
                    try {
                        nation.setNeutral(false);
                    }
                    catch (TownyException e1) {
                        e1.printStackTrace();
                    }
                    TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                }
                catch (Exception e) {
                    TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                }
            } else if (split[0].equalsIgnoreCase("public")) {
                if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_TOGGLE_PUBLIC.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                nation.setPublic(!nation.isPublic());
                TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_nation_changed_public"), nation.isPublic() ? TownySettings.getLangString("enabled") : TownySettings.getLangString("disabled")));
            } else if (split[0].equalsIgnoreCase("open")) {
                if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_TOGGLE_PUBLIC.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                nation.setOpen(!nation.isOpen());
                TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_nation_changed_open"), nation.isOpen() ? TownySettings.getLangString("enabled") : TownySettings.getLangString("disabled")));
            } else {
                TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_property"), "nation"));
                return;
            }
            townyUniverse.getDataSource().saveNation(nation);
        }
    }

    public static void nationRename(Player player, Nation nation, String newName) {
        NationPreRenameEvent event = new NationPreRenameEvent(nation, newName);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_rename_cancelled"));
            return;
        }
        try {
            TownyUniverse.getInstance().getDataSource().renameNation(nation, newName);
            TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_nation_set_name"), player.getName(), nation.getName()));
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
        }
    }

    public static void nationSpawn(Player player, String[] split) throws TownyException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        try {
            Resident resident = townyUniverse.getDataSource().getResident(player.getName());
            if (split.length == 0) {
                if (!resident.hasTown()) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_dont_belong_nation"));
                    return;
                }
                if (!resident.getTown().hasNation()) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_dont_belong_nation"));
                    return;
                }
                Nation nation = resident.getTown().getNation();
                String notAffordMSG = TownySettings.getLangString("msg_err_cant_afford_tp");
                SpawnUtil.sendToTownySpawn(player, split, nation, notAffordMSG, false, SpawnType.NATION);
            } else {
                Nation nation = townyUniverse.getDataSource().getNation(split[0]);
                String notAffordMSG = String.format(TownySettings.getLangString("msg_err_cant_afford_tp_nation"), nation.getName());
                SpawnUtil.sendToTownySpawn(player, split, nation, notAffordMSG, false, SpawnType.NATION);
            }
        }
        catch (NotRegisteredException e) {
            throw new TownyException(String.format(TownySettings.getLangString("msg_err_not_registered_1"), split[0]));
        }
    }

    static {
        nation_help = new ArrayList<String>();
        king_help = new ArrayList<String>();
        alliesstring = new ArrayList<String>();
        invite = new ArrayList<String>();
        BY_NUM_RESIDENTS = (n1, n2) -> n2.getNumResidents() - n1.getNumResidents();
        BY_NAME = (n1, n2) -> n1.getName().compareTo(n2.getName());
        BY_BANK_BALANCE = (n1, n2) -> {
            try {
                return Double.compare(n2.getHoldingBalance(), n1.getHoldingBalance());
            }
            catch (EconomyException e) {
                throw new RuntimeException("Failed to get balance. Aborting.");
            }
        };
        BY_TOWNBLOCKS_CLAIMED = (n1, n2) -> Double.compare(n2.getNumTownblocks(), n1.getNumTownblocks());
        BY_NUM_TOWNS = (n1, n2) -> n2.getTowns().size() - n1.getTowns().size();
        BY_NUM_ONLINE = (n1, n2) -> TownyAPI.getInstance().getOnlinePlayers((Nation)n2).size() - TownyAPI.getInstance().getOnlinePlayers((Nation)n1).size();
        nation_help.add(ChatTools.formatTitle("/nation"));
        nation_help.add(ChatTools.formatCommand("", "/nation", "", TownySettings.getLangString("nation_help_1")));
        nation_help.add(ChatTools.formatCommand("", "/nation", TownySettings.getLangString("nation_help_2"), TownySettings.getLangString("nation_help_3")));
        nation_help.add(ChatTools.formatCommand("", "/nation", "list", TownySettings.getLangString("nation_help_4")));
        nation_help.add(ChatTools.formatCommand("", "/nation", "townlist (nation)", ""));
        nation_help.add(ChatTools.formatCommand("", "/nation", "allylist (nation)", ""));
        nation_help.add(ChatTools.formatCommand("", "/nation", "enemylist (nation)", ""));
        nation_help.add(ChatTools.formatCommand("", "/nation", "online", TownySettings.getLangString("nation_help_9")));
        nation_help.add(ChatTools.formatCommand("", "/nation", "spawn", TownySettings.getLangString("nation_help_10")));
        nation_help.add(ChatTools.formatCommand("", "/nation", "join (nation)", "Used to join open nations."));
        nation_help.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing"), "/nation", "deposit [$]", ""));
        nation_help.add(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/nation", "leave", TownySettings.getLangString("nation_help_5")));
        nation_help.add(ChatTools.formatCommand(TownySettings.getLangString("king_sing"), "/nation", "king ?", TownySettings.getLangString("nation_help_7")));
        nation_help.add(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/nation", "new " + TownySettings.getLangString("nation_help_2") + " [capital]", TownySettings.getLangString("nation_help_8")));
        nation_help.add(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/nation", "delete " + TownySettings.getLangString("nation_help_2"), ""));
        nation_help.add(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/nation", "say", "[message]"));
        king_help.add(ChatTools.formatTitle(TownySettings.getLangString("king_help_1")));
        king_help.add(ChatTools.formatCommand(TownySettings.getLangString("king_sing"), "/nation", "withdraw [$]", ""));
        king_help.add(ChatTools.formatCommand(TownySettings.getLangString("king_sing"), "/nation", "[add/kick] [town] .. [town]", ""));
        king_help.add(ChatTools.formatCommand(TownySettings.getLangString("king_sing"), "/nation", "rank [add/remove] " + TownySettings.getLangString("res_2"), "[Rank]"));
        king_help.add(ChatTools.formatCommand(TownySettings.getLangString("king_sing"), "/nation", "set [] .. []", ""));
        king_help.add(ChatTools.formatCommand(TownySettings.getLangString("king_sing"), "/nation", "toggle [] .. []", ""));
        king_help.add(ChatTools.formatCommand(TownySettings.getLangString("king_sing"), "/nation", "ally [] .. [] " + TownySettings.getLangString("nation_help_2"), TownySettings.getLangString("king_help_2")));
        king_help.add(ChatTools.formatCommand(TownySettings.getLangString("king_sing"), "/nation", "enemy [add/remove] " + TownySettings.getLangString("nation_help_2"), TownySettings.getLangString("king_help_3")));
        king_help.add(ChatTools.formatCommand(TownySettings.getLangString("king_sing"), "/nation", "delete", ""));
        king_help.add(ChatTools.formatCommand(TownySettings.getLangString("king_sing"), "/nation", "merge {nation}", ""));
        king_help.add(ChatTools.formatCommand(TownySettings.getLangString("king_sing"), "/nation", "say", "[message]"));
        alliesstring.add(ChatTools.formatTitle("/nation invite"));
        alliesstring.add(ChatTools.formatCommand("", "/nation", "ally add [nation]", TownySettings.getLangString("nation_ally_help_1")));
        if (TownySettings.isDisallowOneWayAlliance()) {
            alliesstring.add(ChatTools.formatCommand("", "/nation", "ally add -[nation]", TownySettings.getLangString("nation_ally_help_7")));
        }
        alliesstring.add(ChatTools.formatCommand("", "/nation", "ally remove [nation]", TownySettings.getLangString("nation_ally_help_2")));
        if (TownySettings.isDisallowOneWayAlliance()) {
            alliesstring.add(ChatTools.formatCommand("", "/nation", "ally sent", TownySettings.getLangString("nation_ally_help_3")));
            alliesstring.add(ChatTools.formatCommand("", "/nation", "ally received", TownySettings.getLangString("nation_ally_help_4")));
            alliesstring.add(ChatTools.formatCommand("", "/nation", "ally accept [nation]", TownySettings.getLangString("nation_ally_help_5")));
            alliesstring.add(ChatTools.formatCommand("", "/nation", "ally deny [nation]", TownySettings.getLangString("nation_ally_help_6")));
        }
        invite.add(ChatTools.formatTitle("/town invite"));
        invite.add(ChatTools.formatCommand("", "/nation", "invite [town]", TownySettings.getLangString("nation_invite_help_1")));
        invite.add(ChatTools.formatCommand("", "/nation", "invite -[town]", TownySettings.getLangString("nation_invite_help_2")));
        invite.add(ChatTools.formatCommand("", "/nation", "invite sent", TownySettings.getLangString("nation_invite_help_3")));
    }
}

