/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.event.PlotClearEvent;
import com.palmergames.bukkit.towny.event.PlotPreClearEvent;
import com.palmergames.bukkit.towny.event.TownBlockSettingsChangedEvent;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.tasks.CooldownTimerTask;
import com.palmergames.bukkit.towny.tasks.PlotClaim;
import com.palmergames.bukkit.towny.utils.AreaSelectionUtil;
import com.palmergames.bukkit.towny.utils.OutpostUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PlotCommand
extends BaseCommand
implements CommandExecutor {
    private static Towny plugin;
    public static final List<String> output;

    public PlotCommand(Towny instance) {
        plugin = instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            try {
                if (!TownyUniverse.getInstance().getDataSource().getWorld(player.getWorld().getName()).isUsingTowny()) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_set_use_towny_off"));
                    return false;
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
            if (args == null) {
                for (String line : output) {
                    player.sendMessage(line);
                }
                return true;
            }
            try {
                return this.parsePlotCommand(player, args);
            }
            catch (TownyException x) {
                x.getMessage();
                return true;
            }
        }
        for (String line : output) {
            sender.sendMessage(Colors.strip(line));
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean parsePlotCommand(Player player, String[] split) throws TownyException {
        String world;
        Resident resident;
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
            for (String line : output) {
                player.sendMessage(line);
            }
            return true;
        }
        try {
            resident = townyUniverse.getDataSource().getResident(player.getName());
            world = player.getWorld().getName();
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return true;
        }
        try {
            if (split[0].equalsIgnoreCase("claim")) {
                if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_CLAIM.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                if (TownyAPI.getInstance().isWarTime()) {
                    throw new TownyException(TownySettings.getLangString("msg_war_cannot_do"));
                }
                List<WorldCoord> selection = AreaSelectionUtil.selectWorldCoordArea(resident, new WorldCoord(world, Coord.parseCoord((Entity)player)), StringMgmt.remFirstArg(split));
                if (selection.size() > 0) {
                    double cost = 0.0;
                    for (WorldCoord worldCoord : new ArrayList<WorldCoord>(selection)) {
                        try {
                            double price = worldCoord.getTownBlock().getPlotPrice();
                            if (price > -1.0) {
                                cost += worldCoord.getTownBlock().getPlotPrice();
                                continue;
                            }
                            if (worldCoord.getTownBlock().getTown().isMayor(resident)) continue;
                            selection.remove(worldCoord);
                        }
                        catch (NotRegisteredException e) {
                            selection.remove(worldCoord);
                        }
                    }
                    int maxPlots = TownySettings.getMaxResidentPlots(resident);
                    int extraPlots = TownySettings.getMaxResidentExtraPlots(resident);
                    if (maxPlots != -1) {
                        maxPlots += extraPlots;
                    }
                    if (maxPlots >= 0 && resident.getTownBlocks().size() + selection.size() > maxPlots) {
                        throw new TownyException(String.format(TownySettings.getLangString("msg_max_plot_own"), maxPlots));
                    }
                    if (TownySettings.isUsingEconomy() && !resident.canPayFromHoldings(cost)) {
                        throw new TownyException(String.format(TownySettings.getLangString("msg_no_funds_claim"), selection.size(), TownyEconomyHandler.getFormattedBalance(cost)));
                    }
                    new PlotClaim(plugin, player, resident, selection, true, false).start();
                    return true;
                }
                player.sendMessage(TownySettings.getLangString("msg_err_empty_area_selection"));
                return true;
            }
            if (split[0].equalsIgnoreCase("evict")) {
                if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_EVICT.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                if (TownyAPI.getInstance().isWarTime()) {
                    throw new TownyException(TownySettings.getLangString("msg_war_cannot_do"));
                }
                if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYOR.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                TownBlock townBlock = new WorldCoord(world, Coord.parseCoord((Entity)player)).getTownBlock();
                Town town = townBlock.getTown();
                if (townBlock.getResident() == null) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_no_one_to_evict"));
                    return true;
                }
                Resident owner = townBlock.getResident();
                if (!town.equals(resident.getTown())) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_not_part_town"));
                    return false;
                }
                townBlock.setResident(null);
                townBlock.setPlotPrice(-1.0);
                townBlock.setType(townBlock.getType());
                townyUniverse.getDataSource().saveResident(owner);
                townyUniverse.getDataSource().saveTownBlock(townBlock);
                player.sendMessage(TownySettings.getLangString("msg_plot_evict"));
                return true;
            }
            if (split[0].equalsIgnoreCase("unclaim")) {
                if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_UNCLAIM.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                if (TownyAPI.getInstance().isWarTime()) {
                    throw new TownyException(TownySettings.getLangString("msg_war_cannot_do"));
                }
                if (split.length == 2 && split[1].equalsIgnoreCase("all")) {
                    new PlotClaim(plugin, player, resident, null, false, false).start();
                    return true;
                }
                List<WorldCoord> selection = AreaSelectionUtil.selectWorldCoordArea(resident, new WorldCoord(world, Coord.parseCoord((Entity)player)), StringMgmt.remFirstArg(split));
                if ((selection = AreaSelectionUtil.filterOwnedBlocks(resident, selection)).size() > 0) {
                    new PlotClaim(plugin, player, resident, selection, false, false).start();
                    return true;
                }
                player.sendMessage(TownySettings.getLangString("msg_err_empty_area_selection"));
                return true;
            }
            if (split[0].equalsIgnoreCase("notforsale") || split[0].equalsIgnoreCase("nfs")) {
                if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_NOTFORSALE.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                List<WorldCoord> selection = AreaSelectionUtil.selectWorldCoordArea(resident, new WorldCoord(world, Coord.parseCoord((Entity)player)), StringMgmt.remFirstArg(split));
                TownBlock townBlock = new WorldCoord(world, Coord.parseCoord((Entity)player)).getTownBlock();
                if (townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_ADMIN.getNode())) {
                    for (WorldCoord worldCoord : selection) {
                        this.setPlotForSale(resident, worldCoord, -1.0);
                    }
                    return true;
                }
                selection = !townBlock.getType().equals((Object)TownBlockType.EMBASSY) ? AreaSelectionUtil.filterOwnedBlocks(resident.getTown(), selection) : AreaSelectionUtil.filterOwnedBlocks(resident, selection);
                for (WorldCoord worldCoord : selection) {
                    this.setPlotForSale(resident, worldCoord, -1.0);
                }
                if (!selection.isEmpty()) return true;
                throw new TownyException(TownySettings.getLangString("msg_area_not_own"));
            }
            if (split[0].equalsIgnoreCase("forsale") || split[0].equalsIgnoreCase("fs")) {
                if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_FORSALE.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                WorldCoord pos = new WorldCoord(world, Coord.parseCoord((Entity)player));
                double plotPrice = pos.getTownBlock().getTown().getPlotTypePrice(pos.getTownBlock().getType());
                if (split.length > 1) {
                    List<Object> selection;
                    int areaSelectPivot = AreaSelectionUtil.getAreaSelectPivot(split);
                    if (areaSelectPivot >= 0) {
                        selection = AreaSelectionUtil.selectWorldCoordArea(resident, new WorldCoord(world, Coord.parseCoord((Entity)player)), StringMgmt.subArray(split, areaSelectPivot + 1, split.length));
                        selection = AreaSelectionUtil.filterOwnedBlocks(resident.getTown(), selection);
                        if (selection.size() == 0) {
                            player.sendMessage(TownySettings.getLangString("msg_err_empty_area_selection"));
                            return true;
                        }
                    } else {
                        selection = new ArrayList<WorldCoord>();
                        selection.add(pos);
                    }
                    if (areaSelectPivot != 1) {
                        try {
                            plotPrice = Double.parseDouble(split[1]);
                            if (plotPrice < 0.0) {
                                TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative_money"));
                                return true;
                            }
                        }
                        catch (NumberFormatException e) {
                            player.sendMessage(String.format(TownySettings.getLangString("msg_error_must_be_num"), new Object[0]));
                            return true;
                        }
                    }
                    for (WorldCoord worldCoord : selection) {
                        this.setPlotForSale(resident, worldCoord, plotPrice);
                    }
                    return true;
                }
                this.setPlotForSale(resident, pos, plotPrice);
                return true;
            }
            if (split[0].equalsIgnoreCase("perm") || split[0].equalsIgnoreCase("info")) {
                if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_PERM.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                if (split.length > 1 && split[1].equalsIgnoreCase("hud")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_PERM_HUD.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    plugin.getHUDManager().togglePermHUD(player);
                    return true;
                }
                TownBlock townBlock = new WorldCoord(world, Coord.parseCoord((Entity)player)).getTownBlock();
                TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(townBlock));
                return true;
            }
            if (split[0].equalsIgnoreCase("toggle")) {
                TownBlock townBlock = new WorldCoord(world, Coord.parseCoord((Entity)player)).getTownBlock();
                this.plotTestOwner(resident, townBlock);
                this.plotToggle(player, new WorldCoord(world, Coord.parseCoord((Entity)player)).getTownBlock(), StringMgmt.remFirstArg(split));
                return true;
            }
            if (split[0].equalsIgnoreCase("set")) {
                if ((split = StringMgmt.remFirstArg(split)).length == 0 || split[0].equalsIgnoreCase("?")) {
                    player.sendMessage(ChatTools.formatTitle("/... set"));
                    player.sendMessage(ChatTools.formatCommand("", "set", "[plottype]", "Ex: Inn, Wilds, Farm, Embassy etc"));
                    player.sendMessage(ChatTools.formatCommand("", "set", "outpost", "Costs " + TownyEconomyHandler.getFormattedBalance(TownySettings.getOutpostCost())));
                    player.sendMessage(ChatTools.formatCommand("", "set", "reset", "Removes a plot type"));
                    player.sendMessage(ChatTools.formatCommand("", "set", "[name]", "Names a plot"));
                    player.sendMessage(ChatTools.formatCommand("Level", "[resident/ally/outsider]", "", ""));
                    player.sendMessage(ChatTools.formatCommand("Type", "[build/destroy/switch/itemuse]", "", ""));
                    player.sendMessage(ChatTools.formatCommand("", "set perm", "[on/off]", "Toggle all permissions"));
                    player.sendMessage(ChatTools.formatCommand("", "set perm", "[level/type] [on/off]", ""));
                    player.sendMessage(ChatTools.formatCommand("", "set perm", "[level] [type] [on/off]", ""));
                    player.sendMessage(ChatTools.formatCommand("", "set perm", "reset", ""));
                    player.sendMessage(ChatTools.formatCommand("Eg", "/plot set perm", "ally off", ""));
                    player.sendMessage(ChatTools.formatCommand("Eg", "/plot set perm", "friend build on", ""));
                    player.sendMessage(String.format(TownySettings.getLangString("plot_perms"), "'friend'", "'resident'"));
                    player.sendMessage(TownySettings.getLangString("plot_perms_1"));
                    return true;
                }
                if (split.length > 0) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_SET.getNode(split[0].toLowerCase()))) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    if (split[0].equalsIgnoreCase("perm")) {
                        TownBlock townBlock = new WorldCoord(world, Coord.parseCoord((Entity)player)).getTownBlock();
                        TownBlockOwner owner = this.plotTestOwner(resident, townBlock);
                        this.toggleTest(player, townBlock, StringMgmt.join(StringMgmt.remFirstArg(split), ""));
                        PlotCommand.setTownBlockPermissions(player, owner, townBlock, StringMgmt.remFirstArg(split));
                        return true;
                    }
                    if (split[0].equalsIgnoreCase("name")) {
                        TownBlock townBlock = new WorldCoord(world, Coord.parseCoord((Entity)player)).getTownBlock();
                        this.plotTestOwner(resident, townBlock);
                        if (split.length == 1) {
                            townBlock.setName("");
                            TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_plot_name_removed"), new Object[0]));
                            townyUniverse.getDataSource().saveTownBlock(townBlock);
                            return true;
                        }
                        if (!NameValidation.isBlacklistName(split[1])) {
                            townBlock.setName(StringMgmt.join(StringMgmt.remFirstArg(split), ""));
                            townyUniverse.getDataSource().saveTownBlock(townBlock);
                            TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_plot_name_set_to"), townBlock.getName()));
                            return true;
                        } else {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
                        }
                        return true;
                    }
                    if (split[0].equalsIgnoreCase("outpost") && TownySettings.isAllowingOutposts()) {
                        if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_CLAIM_OUTPOST.getNode())) {
                            throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                        }
                        TownBlock townBlock = new WorldCoord(world, Coord.parseCoord((Entity)player)).getTownBlock();
                        this.plotTestOwner(resident, townBlock);
                        Town town = townBlock.getTown();
                        TownyWorld townyWorld = townBlock.getWorld();
                        boolean isAdmin = townyUniverse.getPermissionSource().isTownyAdmin(player);
                        Coord key = Coord.parseCoord(plugin.getCache(player).getLastLocation());
                        if (!OutpostUtil.OutpostTests(town, resident, townyWorld, key, isAdmin, true)) return true;
                        if (TownySettings.isUsingEconomy() && !town.pay(TownySettings.getOutpostCost(), String.format("Plot Set Outpost", new Object[0]))) {
                            throw new TownyException(TownySettings.getLangString("msg_err_cannot_afford_to_set_outpost"));
                        }
                        TownyMessaging.sendMessage((Object)player, String.format(TownySettings.getLangString("msg_plot_set_cost"), TownyEconomyHandler.getFormattedBalance(TownySettings.getOutpostCost()), TownySettings.getLangString("outpost")));
                        townBlock.setOutpost(true);
                        town.addOutpostSpawn(player.getLocation());
                        townyUniverse.getDataSource().saveTown(town);
                        townyUniverse.getDataSource().saveTownBlock(townBlock);
                        return true;
                    }
                    WorldCoord worldCoord = new WorldCoord(world, Coord.parseCoord((Entity)player));
                    this.setPlotType(resident, worldCoord, split[0]);
                    player.sendMessage(String.format(TownySettings.getLangString("msg_plot_set_type"), split[0]));
                    return true;
                }
                player.sendMessage(ChatTools.formatCommand("", "/plot set", "name", ""));
                player.sendMessage(ChatTools.formatCommand("", "/plot set", "reset", ""));
                player.sendMessage(ChatTools.formatCommand("", "/plot set", "shop|embassy|arena|wilds|spleef|inn|jail|farm|bank", ""));
                player.sendMessage(ChatTools.formatCommand("", "/plot set perm", "?", ""));
                return true;
            }
            if (!split[0].equalsIgnoreCase("clear")) throw new TownyException(String.format(TownySettings.getLangString("msg_err_invalid_property"), split[0]));
            if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_CLEAR.getNode())) {
                throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
            }
            TownBlock townBlock = new WorldCoord(world, Coord.parseCoord((Entity)player)).getTownBlock();
            if (townBlock != null) {
                if (townBlock.hasResident()) {
                    if (!townBlock.isOwner(resident)) {
                        player.sendMessage(TownySettings.getLangString("msg_area_not_own"));
                        return true;
                    }
                } else if (!townBlock.getTown().equals(resident.getTown())) {
                    player.sendMessage(TownySettings.getLangString("msg_area_not_own"));
                    return true;
                }
                PlotPreClearEvent preEvent = new PlotPreClearEvent(townBlock);
                BukkitTools.getPluginManager().callEvent((Event)preEvent);
                if (preEvent.isCancelled()) {
                    player.sendMessage(preEvent.getCancelMessage());
                    return false;
                }
                for (String material : townyUniverse.getDataSource().getWorld(world).getPlotManagementMayorDelete()) {
                    if (Material.matchMaterial((String)material) == null) throw new TownyException(String.format(TownySettings.getLangString("msg_err_invalid_property"), material));
                    TownyRegenAPI.deleteTownBlockMaterial(townBlock, Material.getMaterial((String)material));
                    player.sendMessage(String.format(TownySettings.getLangString("msg_clear_plot_material"), material));
                }
                BukkitTools.getPluginManager().callEvent((Event)new PlotClearEvent(townBlock));
                return true;
            }
            player.sendMessage(TownySettings.getLangString("msg_err_empty_area_selection"));
            return true;
        }
        catch (EconomyException | TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static void setTownBlockPermissions(Player player, TownBlockOwner townBlockOwner, TownBlock townBlock, String[] split) {
        townyUniverse = TownyUniverse.getInstance();
        if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
            player.sendMessage(ChatTools.formatTitle("/... set perm"));
            if (townBlockOwner instanceof Town) {
                player.sendMessage(ChatTools.formatCommand("Level", "[resident/nation/ally/outsider]", "", ""));
            }
            if (townBlockOwner instanceof Resident) {
                player.sendMessage(ChatTools.formatCommand("Level", "[friend/town/ally/outsider]", "", ""));
            }
            player.sendMessage(ChatTools.formatCommand("Type", "[build/destroy/switch/itemuse]", "", ""));
            player.sendMessage(ChatTools.formatCommand("", "set perm", "[on/off]", "Toggle all permissions"));
            player.sendMessage(ChatTools.formatCommand("", "set perm", "[level/type] [on/off]", ""));
            player.sendMessage(ChatTools.formatCommand("", "set perm", "[level] [type] [on/off]", ""));
            player.sendMessage(ChatTools.formatCommand("", "set perm", "reset", ""));
            player.sendMessage(ChatTools.formatCommand("Eg", "/plot set perm", "friend build on", ""));
        } else {
            perm = townBlock.getPermissions();
            if (split.length == 1) {
                if (split[0].equalsIgnoreCase("reset")) {
                    townBlock.setType(townBlock.getType());
                    townyUniverse.getDataSource().saveTownBlock(townBlock);
                    if (townBlockOwner instanceof Town) {
                        TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_set_perms_reset"), new Object[]{"Town owned"}));
                    } else {
                        TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_set_perms_reset"), new Object[]{"your"}));
                    }
                    PlotCommand.plugin.resetCache();
                    return;
                }
                try {
                    b = PlotCommand.plugin.parseOnOff(split[0]);
                    for (String element : new String[]{"residentBuild", "residentDestroy", "residentSwitch", "residentItemUse", "outsiderBuild", "outsiderDestroy", "outsiderSwitch", "outsiderItemUse", "allyBuild", "allyDestroy", "allySwitch", "allyItemUse", "nationBuild", "nationDestroy", "nationSwitch", "nationItemUse"}) {
                        perm.set(element, b);
                    }
                }
                catch (Exception e) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_plot_set_perm_syntax_error"));
                    return;
                }
            }
            if (split.length == 2) {
                if (!(split[0].equalsIgnoreCase("resident") || split[0].equalsIgnoreCase("friend") || split[0].equalsIgnoreCase("town") || split[0].equalsIgnoreCase("nation") || split[0].equalsIgnoreCase("ally") || split[0].equalsIgnoreCase("outsider") || split[0].equalsIgnoreCase("build") || split[0].equalsIgnoreCase("destroy") || split[0].equalsIgnoreCase("switch") || split[0].equalsIgnoreCase("itemuse"))) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_plot_set_perm_syntax_error"));
                    return;
                }
                try {
                    b = PlotCommand.plugin.parseOnOff(split[1]);
                    if (split[0].equalsIgnoreCase("friend")) {
                        perm.residentBuild = b;
                        perm.residentDestroy = b;
                        perm.residentSwitch = b;
                        perm.residentItemUse = b;
                    }
                    if (split[0].equalsIgnoreCase("town")) {
                        perm.nationBuild = b;
                        perm.nationDestroy = b;
                        perm.nationSwitch = b;
                        perm.nationItemUse = b;
                    }
                    if (split[0].equalsIgnoreCase("nation")) {
                        perm.nationBuild = b;
                        perm.nationDestroy = b;
                        perm.nationSwitch = b;
                        perm.nationItemUse = b;
                    }
                    if (split[0].equalsIgnoreCase("outsider")) {
                        perm.outsiderBuild = b;
                        perm.outsiderDestroy = b;
                        perm.outsiderSwitch = b;
                        perm.outsiderItemUse = b;
                    }
                    if (split[0].equalsIgnoreCase("ally")) {
                        perm.allyBuild = b;
                        perm.allyDestroy = b;
                        perm.allySwitch = b;
                        perm.allyItemUse = b;
                    }
                    if (split[0].equalsIgnoreCase("build")) {
                        perm.residentBuild = b;
                        perm.outsiderBuild = b;
                        perm.allyBuild = b;
                        perm.nationBuild = b;
                    }
                    if (split[0].equalsIgnoreCase("destroy")) {
                        perm.residentDestroy = b;
                        perm.outsiderDestroy = b;
                        perm.allyDestroy = b;
                        perm.nationDestroy = b;
                    }
                    if (split[0].equalsIgnoreCase("switch")) {
                        perm.residentSwitch = b;
                        perm.outsiderSwitch = b;
                        perm.allySwitch = b;
                        perm.nationSwitch = b;
                    }
                    if (!split[0].equalsIgnoreCase("itemuse")) ** GOTO lbl116
                    perm.residentItemUse = b;
                    perm.outsiderItemUse = b;
                    perm.allyItemUse = b;
                    perm.nationItemUse = b;
                }
                catch (Exception e) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_plot_set_perm_syntax_error"));
                    return;
                }
            } else if (split.length == 3) {
                if (!((split[0].equalsIgnoreCase("resident") || split[0].equalsIgnoreCase("friend") || split[0].equalsIgnoreCase("ally") || split[0].equalsIgnoreCase("town") || split[0].equalsIgnoreCase("nation") || split[0].equalsIgnoreCase("outsider")) && (split[1].equalsIgnoreCase("build") || split[1].equalsIgnoreCase("destroy") || split[1].equalsIgnoreCase("switch") || split[1].equalsIgnoreCase("itemuse")))) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_plot_set_perm_syntax_error"));
                    return;
                }
                if (split[0].equalsIgnoreCase("friend")) {
                    split[0] = "resident";
                }
                if (split[0].equalsIgnoreCase("town")) {
                    split[0] = "nation";
                }
                try {
                    b = PlotCommand.plugin.parseOnOff(split[2]);
                    s = "";
                    s = split[0] + split[1];
                    perm.set(s, b);
                }
                catch (Exception e) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_plot_set_perm_syntax_error"));
                    return;
                }
            }
lbl116:
            // 14 sources

            townBlock.setChanged(true);
            townyUniverse.getDataSource().saveTownBlock(townBlock);
            TownyMessaging.sendMsg((Object)player, TownySettings.getLangString("msg_set_perms"));
            TownyMessaging.sendMessage((Object)player, "\u00a72 Perm: " + (townBlockOwner instanceof Resident != false ? perm.getColourString().replace("n", "t") : perm.getColourString().replace("f", "r")));
            TownyMessaging.sendMessage((Object)player, "\u00a72 Perm: " + (townBlockOwner instanceof Resident != false ? perm.getColourString2().replace("n", "t") : perm.getColourString2().replace("f", "r")));
            TownyMessaging.sendMessage((Object)player, "\u00a72PvP: " + (perm.pvp != false ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Explosions: " + (perm.explosion != false ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Firespread: " + (perm.fire != false ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Mob Spawns: " + (perm.mobs != false ? "\u00a74ON" : "\u00a7aOFF"));
            event = new TownBlockSettingsChangedEvent(townBlock);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            PlotCommand.plugin.resetCache();
        }
    }

    public void setPlotType(Resident resident, WorldCoord worldCoord, String type) throws TownyException, EconomyException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (resident.hasTown()) {
            try {
                TownBlock townBlock = worldCoord.getTownBlock();
                this.plotTestOwner(resident, townBlock);
                townBlock.setType(type, resident);
                Town town = resident.getTown();
                if (townBlock.isJail()) {
                    Player p = TownyAPI.getInstance().getPlayer(resident);
                    if (p == null) {
                        throw new NotRegisteredException();
                    }
                    town.addJailSpawn(p.getLocation());
                }
                townyUniverse.getDataSource().saveTownBlock(townBlock);
            }
            catch (NotRegisteredException e) {
                throw new TownyException(TownySettings.getLangString("msg_err_not_part_town"));
            }
        } else if (!resident.hasTown()) {
            TownBlock townBlock = worldCoord.getTownBlock();
            this.plotTestOwner(resident, townBlock);
            townBlock.setType(type, resident);
            Town town = resident.getTown();
            if (townBlock.isJail()) {
                Player p = TownyAPI.getInstance().getPlayer(resident);
                if (p == null) {
                    throw new TownyException("Player could not be found.");
                }
                town.addJailSpawn(p.getLocation());
            }
            townyUniverse.getDataSource().saveTownBlock(townBlock);
        } else {
            throw new TownyException(TownySettings.getLangString("msg_err_must_belong_town"));
        }
    }

    public void setPlotForSale(Resident resident, WorldCoord worldCoord, double forSale) throws TownyException {
        if (resident.hasTown()) {
            try {
                TownBlock townBlock = worldCoord.getTownBlock();
                this.plotTestOwner(resident, townBlock);
                if (forSale > TownySettings.getMaxPlotPrice()) {
                    townBlock.setPlotPrice(TownySettings.getMaxPlotPrice());
                } else {
                    townBlock.setPlotPrice(forSale);
                }
                if (forSale != -1.0) {
                    TownyMessaging.sendTownMessage(townBlock.getTown(), TownySettings.getPlotForSaleMsg(resident.getName(), worldCoord));
                    if (townBlock.getTown() != resident.getTown()) {
                        TownyMessaging.sendMessage((Object)resident, TownySettings.getPlotForSaleMsg(resident.getName(), worldCoord));
                    }
                } else {
                    Player p = TownyAPI.getInstance().getPlayer(resident);
                    if (p == null) {
                        throw new TownyException("Player could not be found.");
                    }
                    p.sendMessage(TownySettings.getLangString("msg_plot_set_to_nfs"));
                }
                TownyUniverse.getInstance().getDataSource().saveTownBlock(townBlock);
            }
            catch (NotRegisteredException e) {
                throw new TownyException(TownySettings.getLangString("msg_err_not_part_town"));
            }
        } else {
            throw new TownyException(TownySettings.getLangString("msg_err_must_belong_town"));
        }
    }

    public void plotToggle(Player player, TownBlock townBlock, String[] split) {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (split.length == 0) {
            player.sendMessage(ChatTools.formatTitle("/res toggle"));
            player.sendMessage(ChatTools.formatCommand("", "/res toggle", "pvp", ""));
            player.sendMessage(ChatTools.formatCommand("", "/res toggle", "explosion", ""));
            player.sendMessage(ChatTools.formatCommand("", "/res toggle", "fire", ""));
            player.sendMessage(ChatTools.formatCommand("", "/res toggle", "mobs", ""));
        } else {
            try {
                if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_TOGGLE.getNode(split[0].toLowerCase()))) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                if (split[0].equalsIgnoreCase("pvp")) {
                    this.toggleTest(player, townBlock, StringMgmt.join(split, " "));
                    if (TownySettings.getPVPCoolDownTime() > 0) {
                        if (CooldownTimerTask.hasCooldown(townBlock.getTown().getName(), CooldownTimerTask.CooldownType.PVP)) {
                            throw new TownyException(String.format(TownySettings.getLangString("msg_err_cannot_toggle_pvp_x_seconds_remaining"), CooldownTimerTask.getCooldownRemaining(townBlock.getTown().getName(), CooldownTimerTask.CooldownType.PVP)));
                        }
                        if (CooldownTimerTask.hasCooldown(townBlock.getWorldCoord().toString(), CooldownTimerTask.CooldownType.PVP)) {
                            throw new TownyException(String.format(TownySettings.getLangString("msg_err_cannot_toggle_pvp_x_seconds_remaining"), CooldownTimerTask.getCooldownRemaining(townBlock.getWorldCoord().toString(), CooldownTimerTask.CooldownType.PVP)));
                        }
                    }
                    boolean bl = townBlock.getPermissions().pvp = !townBlock.getPermissions().pvp;
                    if (TownySettings.getPVPCoolDownTime() > 0) {
                        CooldownTimerTask.addCooldownTimer(townBlock.getWorldCoord().toString(), CooldownTimerTask.CooldownType.PVP);
                    }
                    TownyMessaging.sendMessage((Object)player, String.format(TownySettings.getLangString("msg_changed_pvp"), "Plot", townBlock.getPermissions().pvp ? TownySettings.getLangString("enabled") : TownySettings.getLangString("disabled")));
                } else if (split[0].equalsIgnoreCase("explosion")) {
                    this.toggleTest(player, townBlock, StringMgmt.join(split, " "));
                    townBlock.getPermissions().explosion = !townBlock.getPermissions().explosion;
                    TownyMessaging.sendMessage((Object)player, String.format(TownySettings.getLangString("msg_changed_expl"), "the Plot", townBlock.getPermissions().explosion ? TownySettings.getLangString("enabled") : TownySettings.getLangString("disabled")));
                } else if (split[0].equalsIgnoreCase("fire")) {
                    this.toggleTest(player, townBlock, StringMgmt.join(split, " "));
                    townBlock.getPermissions().fire = !townBlock.getPermissions().fire;
                    TownyMessaging.sendMessage((Object)player, String.format(TownySettings.getLangString("msg_changed_fire"), "the Plot", townBlock.getPermissions().fire ? TownySettings.getLangString("enabled") : TownySettings.getLangString("disabled")));
                } else if (split[0].equalsIgnoreCase("mobs")) {
                    this.toggleTest(player, townBlock, StringMgmt.join(split, " "));
                    townBlock.getPermissions().mobs = !townBlock.getPermissions().mobs;
                    TownyMessaging.sendMessage((Object)player, String.format(TownySettings.getLangString("msg_changed_mobs"), "the Plot", townBlock.getPermissions().mobs ? TownySettings.getLangString("enabled") : TownySettings.getLangString("disabled")));
                } else {
                    TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_property"), "plot"));
                    return;
                }
                townBlock.setChanged(true);
                TownBlockSettingsChangedEvent event = new TownBlockSettingsChangedEvent(townBlock);
                Bukkit.getServer().getPluginManager().callEvent((Event)event);
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
            }
            townyUniverse.getDataSource().saveTownBlock(townBlock);
        }
    }

    private void toggleTest(Player player, TownBlock townBlock, String split) throws TownyException {
        Town town = townBlock.getTown();
        if ((split = split.toLowerCase()).contains("mobs") && town.getWorld().isForceTownMobs()) {
            throw new TownyException(TownySettings.getLangString("msg_world_mobs"));
        }
        if (split.contains("fire") && town.getWorld().isForceFire()) {
            throw new TownyException(TownySettings.getLangString("msg_world_fire"));
        }
        if (split.contains("explosion") && town.getWorld().isForceExpl()) {
            throw new TownyException(TownySettings.getLangString("msg_world_expl"));
        }
        if (split.contains("pvp") && town.getWorld().isForcePVP()) {
            throw new TownyException(TownySettings.getLangString("msg_world_pvp"));
        }
        if ((split.contains("pvp") || split.trim().equalsIgnoreCase("off")) && townBlock.getType().equals((Object)TownBlockType.ARENA)) {
            throw new TownyException(TownySettings.getLangString("msg_plot_pvp"));
        }
    }

    public TownBlockOwner plotTestOwner(Resident resident, TownBlock townBlock) throws TownyException {
        boolean isSameTown;
        Player player = BukkitTools.getPlayer(resident.getName());
        boolean isAdmin = TownyUniverse.getInstance().getPermissionSource().isTownyAdmin(player);
        if (townBlock.hasResident()) {
            boolean isSameTown2;
            Resident owner = townBlock.getResident();
            if (!owner.hasTown() && player.hasPermission(PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYOR.getNode()) && townBlock.getTown() == resident.getTown()) {
                return owner;
            }
            boolean bl = isSameTown2 = resident.hasTown() && resident.getTown() == owner.getTown();
            if (resident == owner || isSameTown2 && player.hasPermission(PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYOR.getNode()) || townBlock.getTown() == resident.getTown() && player.hasPermission(PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYOR.getNode()) || isAdmin) {
                return owner;
            }
            throw new TownyException(TownySettings.getLangString("msg_area_not_own"));
        }
        Town owner = townBlock.getTown();
        boolean bl = isSameTown = resident.hasTown() && resident.getTown() == owner;
        if (isSameTown && !BukkitTools.getPlayer(resident.getName()).hasPermission(PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYOR.getNode())) {
            throw new TownyException(TownySettings.getLangString("msg_not_mayor_ass"));
        }
        if (!isSameTown && !isAdmin) {
            throw new TownyException(TownySettings.getLangString("msg_err_not_part_town"));
        }
        return owner;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        LinkedList<String> output = new LinkedList<String>();
        String lastArg = "";
        if (args.length > 0) {
            lastArg = args[args.length - 1].toLowerCase();
        }
        if (!lastArg.equalsIgnoreCase("")) {
            for (Resident resident : TownyUniverse.getInstance().getDataSource().getResidents()) {
                if (!resident.getName().toLowerCase().startsWith(lastArg)) continue;
                output.add(resident.getName());
            }
        }
        return output;
    }

    static {
        output = new ArrayList<String>();
        output.add(ChatTools.formatTitle("/plot"));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing"), "/plot claim", "", TownySettings.getLangString("msg_block_claim")));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing"), "/plot claim", "[rect/circle] [radius]", ""));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing"), "/plot perm", "[hud]", ""));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing") + "/" + TownySettings.getLangString("mayor_sing"), "/plot notforsale", "", TownySettings.getLangString("msg_plot_nfs")));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing") + "/" + TownySettings.getLangString("mayor_sing"), "/plot notforsale", "[rect/circle] [radius]", ""));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing") + "/" + TownySettings.getLangString("mayor_sing"), "/plot forsale [$]", "", TownySettings.getLangString("msg_plot_fs")));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing") + "/" + TownySettings.getLangString("mayor_sing"), "/plot forsale [$]", "within [rect/circle] [radius]", ""));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing") + "/" + TownySettings.getLangString("mayor_sing"), "/plot evict", "", ""));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing") + "/" + TownySettings.getLangString("mayor_sing"), "/plot clear", "", ""));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing") + "/" + TownySettings.getLangString("mayor_sing"), "/plot set ...", "", TownySettings.getLangString("msg_plot_fs")));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing"), "/plot toggle", "[pvp/fire/explosion/mobs]", ""));
        output.add(TownySettings.getLangString("msg_nfs_abr"));
    }
}

