/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.SpawnType;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.tasks.CooldownTimerTask;
import com.palmergames.bukkit.towny.utils.SpawnUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ResidentCommand
extends BaseCommand
implements CommandExecutor {
    private static Towny plugin;
    private static final List<String> output;

    public ResidentCommand(Towny instance) {
        plugin = instance;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args == null) {
                for (String line : output) {
                    player.sendMessage(line);
                }
                this.parseResidentCommand(player, args);
            } else {
                this.parseResidentCommand(player, args);
            }
        } else {
            try {
                this.parseResidentCommandForConsole(sender, args);
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
        return true;
    }

    private void parseResidentCommandForConsole(CommandSender sender, String[] split) throws TownyException {
        if (split.length == 0 || split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
            for (String line : output) {
                sender.sendMessage(line);
            }
        } else if (split[0].equalsIgnoreCase("list")) {
            this.listResidents(sender);
        } else {
            try {
                Resident resident = TownyUniverse.getInstance().getDataSource().getResident(split[0]);
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                    Player player = null;
                    TownyMessaging.sendMessage((Object)sender, TownyFormatter.getStatus(resident, player));
                });
            }
            catch (NotRegisteredException x) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_not_registered_1"), split[0]));
            }
        }
    }

    public void parseResidentCommand(Player player, String[] split) {
        block31: {
            TownyUniverse townyUniverse = TownyUniverse.getInstance();
            try {
                if (split.length == 0) {
                    try {
                        Resident resident = townyUniverse.getDataSource().getResident(player.getName());
                        TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(resident, player));
                        break block31;
                    }
                    catch (NotRegisteredException x) {
                        throw new TownyException(TownySettings.getLangString("msg_err_not_registered"));
                    }
                }
                if (split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
                    for (String line : output) {
                        player.sendMessage(line);
                    }
                    break block31;
                }
                if (split[0].equalsIgnoreCase("list")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_RESIDENT_LIST.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.listResidents(player);
                    break block31;
                }
                if (split[0].equalsIgnoreCase("tax")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_RESIDENT_TAX.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    try {
                        Resident resident = townyUniverse.getDataSource().getResident(player.getName());
                        TownyMessaging.sendMessage((Object)player, TownyFormatter.getTaxStatus(resident));
                        break block31;
                    }
                    catch (NotRegisteredException x) {
                        throw new TownyException(TownySettings.getLangString("msg_err_not_registered"));
                    }
                }
                if (split[0].equalsIgnoreCase("jail")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_RESIDENT_JAIL.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    if (!TownySettings.isAllowingBail()) {
                        TownyMessaging.sendErrorMsg((Object)player, "\u00a74" + TownySettings.getLangString("msg_err_bail_not_enabled"));
                        return;
                    }
                    if (split.length == 1) {
                        player.sendMessage(ChatTools.formatTitle("/resident jail"));
                        player.sendMessage(ChatTools.formatCommand("", "/resident", "jail paybail", ""));
                        player.sendMessage("\u00a7b" + TownySettings.getLangString("msg_resident_bail_amount") + "\u00a72" + TownyEconomyHandler.getFormattedBalance(TownySettings.getBailAmount()));
                        player.sendMessage("\u00a7b" + TownySettings.getLangString("msg_mayor_bail_amount") + "\u00a72" + TownyEconomyHandler.getFormattedBalance(TownySettings.getBailAmountMayor()));
                        player.sendMessage("\u00a7b" + TownySettings.getLangString("msg_king_bail_amount") + "\u00a72" + TownyEconomyHandler.getFormattedBalance(TownySettings.getBailAmountKing()));
                        return;
                    }
                    if (!townyUniverse.getDataSource().getResident(player.getName()).isJailed()) {
                        return;
                    }
                    if (split[1].equalsIgnoreCase("paybail")) {
                        Resident resident = townyUniverse.getDataSource().getResident(player.getName());
                        if (resident.canPayFromHoldings(TownySettings.getBailAmount())) {
                            Town JailTown = townyUniverse.getDataSource().getTown(resident.getJailTown());
                            resident.payTo(TownySettings.getBailAmount(), JailTown, "Bail");
                            resident.setJailed(false);
                            resident.setJailSpawn(0);
                            resident.setJailTown("");
                            TownyMessaging.sendGlobalMessage("\u00a74" + player.getName() + TownySettings.getLangString("msg_has_paid_bail"));
                            player.teleport(resident.getTown().getSpawn());
                            townyUniverse.getDataSource().saveResident(resident);
                        } else {
                            TownyMessaging.sendErrorMsg((Object)player, "\u00a74" + TownySettings.getLangString("msg_err_unable_to_pay_bail"));
                        }
                    } else {
                        player.sendMessage(ChatTools.formatTitle("/resident jail"));
                        player.sendMessage(ChatTools.formatCommand("", "/resident", "jail paybail", ""));
                        player.sendMessage("\u00a7b" + TownySettings.getLangString("msg_resident_bail_amount") + "\u00a72" + TownyEconomyHandler.getFormattedBalance(TownySettings.getBailAmount()));
                        player.sendMessage("\u00a7b" + TownySettings.getLangString("msg_mayor_bail_amount") + "\u00a72" + TownyEconomyHandler.getFormattedBalance(TownySettings.getBailAmountMayor()));
                        player.sendMessage("\u00a7b" + TownySettings.getLangString("msg_king_bail_amount") + "\u00a72" + TownyEconomyHandler.getFormattedBalance(TownySettings.getBailAmountKing()));
                    }
                    break block31;
                }
                if (split[0].equalsIgnoreCase("set")) {
                    String[] newSplit = StringMgmt.remFirstArg(split);
                    this.residentSet(player, newSplit);
                    break block31;
                }
                if (split[0].equalsIgnoreCase("toggle")) {
                    String[] newSplit = StringMgmt.remFirstArg(split);
                    this.residentToggle(player, newSplit);
                    break block31;
                }
                if (split[0].equalsIgnoreCase("friend")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_RESIDENT_FRIEND.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    String[] newSplit = StringMgmt.remFirstArg(split);
                    ResidentCommand.residentFriend(player, newSplit, false, null);
                    break block31;
                }
                if (split[0].equalsIgnoreCase("spawn")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_RESIDENT_SPAWN.getNode())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    Resident resident = townyUniverse.getDataSource().getResident(player.getName());
                    SpawnUtil.sendToTownySpawn(player, split, resident, TownySettings.getLangString("msg_err_cant_afford_tp"), false, SpawnType.RESIDENT);
                    break block31;
                }
                try {
                    Resident resident = townyUniverse.getDataSource().getResident(split[0]);
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_RESIDENT_OTHERRESIDENT.getNode()) && !resident.getName().equals(player.getName())) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(resident, player)));
                }
                catch (NotRegisteredException x) {
                    throw new TownyException(String.format(TownySettings.getLangString("msg_err_not_registered_1"), split[0]));
                }
            }
            catch (Exception x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            }
        }
    }

    private void residentToggle(Player player, String[] newSplit) throws TownyException {
        Resident resident;
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        try {
            resident = townyUniverse.getDataSource().getResident(player.getName());
        }
        catch (NotRegisteredException e) {
            throw new TownyException(String.format(TownySettings.getLangString("msg_err_not_registered"), player.getName()));
        }
        if (newSplit.length == 0) {
            player.sendMessage(ChatTools.formatTitle("/res toggle"));
            player.sendMessage(ChatTools.formatCommand("", "/res toggle", "pvp", ""));
            player.sendMessage(ChatTools.formatCommand("", "/res toggle", "fire", ""));
            player.sendMessage(ChatTools.formatCommand("", "/res toggle", "mobs", ""));
            player.sendMessage(ChatTools.formatCommand("", "/res toggle", "plotborder", ""));
            player.sendMessage(ChatTools.formatCommand("", "/res toggle", "constantplotborder", ""));
            player.sendMessage(ChatTools.formatCommand("", "/res toggle", "ignoreplots", ""));
            player.sendMessage(ChatTools.formatCommand("", "/res toggle", "townclaim", ""));
            player.sendMessage(ChatTools.formatCommand("", "/res toggle", "map", ""));
            player.sendMessage(ChatTools.formatCommand("", "/res toggle", "spy", ""));
            TownyMessaging.sendMsg(resident, "Modes set: " + StringMgmt.join(resident.getModes(), ","));
            return;
        }
        if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_RESIDENT_TOGGLE.getNode(newSplit[0].toLowerCase()))) {
            throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
        }
        TownyPermission perm = resident.getPermissions();
        if (newSplit[0].equalsIgnoreCase("spy")) {
            if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_CHAT_SPY.getNode(newSplit[0].toLowerCase()))) {
                throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
            }
            resident.toggleMode(newSplit, true);
            return;
        }
        if (newSplit[0].equalsIgnoreCase("pvp")) {
            if (TownySettings.getPVPCoolDownTime() > 0 && resident.hasTown()) {
                if (CooldownTimerTask.hasCooldown(resident.getTown().getName(), CooldownTimerTask.CooldownType.PVP)) {
                    throw new TownyException(String.format(TownySettings.getLangString("msg_err_cannot_toggle_pvp_x_seconds_remaining"), CooldownTimerTask.getCooldownRemaining(resident.getTown().getName(), CooldownTimerTask.CooldownType.PVP)));
                }
                if (CooldownTimerTask.hasCooldown(resident.getName(), CooldownTimerTask.CooldownType.PVP)) {
                    throw new TownyException(String.format(TownySettings.getLangString("msg_err_cannot_toggle_pvp_x_seconds_remaining"), CooldownTimerTask.getCooldownRemaining(resident.getName(), CooldownTimerTask.CooldownType.PVP)));
                }
            }
            boolean bl = perm.pvp = !perm.pvp;
            if (TownySettings.getPVPCoolDownTime() > 0) {
                CooldownTimerTask.addCooldownTimer(resident.getName(), CooldownTimerTask.CooldownType.PVP);
            }
        } else if (newSplit[0].equalsIgnoreCase("fire")) {
            perm.fire = !perm.fire;
        } else if (newSplit[0].equalsIgnoreCase("explosion")) {
            perm.explosion = !perm.explosion;
        } else if (newSplit[0].equalsIgnoreCase("mobs")) {
            perm.mobs = !perm.mobs;
        } else {
            resident.toggleMode(newSplit, true);
            return;
        }
        this.notifyPerms(player, perm);
        townyUniverse.getDataSource().saveResident(resident);
    }

    private void notifyPerms(Player player, TownyPermission perm) {
        TownyMessaging.sendMsg((Object)player, TownySettings.getLangString("msg_set_perms"));
        TownyMessaging.sendMessage((Object)player, "\u00a72PvP: " + (perm.pvp ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Explosions: " + (perm.explosion ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Firespread: " + (perm.fire ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Mob Spawns: " + (perm.mobs ? "\u00a74ON" : "\u00a7aOFF"));
    }

    public void listResidents(Player player) {
        player.sendMessage(ChatTools.formatTitle(TownySettings.getLangString("res_list")));
        ArrayList<String> formatedList = new ArrayList<String>();
        for (Resident resident : TownyAPI.getInstance().getActiveResidents()) {
            if (!player.canSee(BukkitTools.getPlayerExact(resident.getName()))) continue;
            String colour = resident.isKing() ? "\u00a76" : (resident.isMayor() ? "\u00a7b" : "\u00a7f");
            formatedList.add(colour + resident.getName() + "\u00a7f");
        }
        for (String line : ChatTools.list(formatedList)) {
            player.sendMessage(line);
        }
    }

    public void listResidents(CommandSender sender) {
        sender.sendMessage(ChatTools.formatTitle(TownySettings.getLangString("res_list")));
        ArrayList<String> formatedList = new ArrayList<String>();
        for (Resident resident : TownyAPI.getInstance().getActiveResidents()) {
            String colour = resident.isKing() ? "\u00a76" : (resident.isMayor() ? "\u00a7b" : "\u00a7f");
            formatedList.add(colour + resident.getName() + "\u00a7f");
        }
        for (String line : ChatTools.list(formatedList)) {
            sender.sendMessage(line);
        }
    }

    public void residentSet(Player player, String[] split) throws TownyException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (split.length == 0) {
            player.sendMessage(ChatTools.formatCommand("", "/resident set", "perm ...", "'/resident set perm' " + TownySettings.getLangString("res_5")));
            player.sendMessage(ChatTools.formatCommand("", "/resident set", "mode ...", "'/resident set mode' " + TownySettings.getLangString("res_5")));
        } else {
            Resident resident;
            try {
                resident = townyUniverse.getDataSource().getResident(player.getName());
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
                return;
            }
            if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_RESIDENT_SET.getNode(split[0].toLowerCase()))) {
                throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
            }
            if (split[0].equalsIgnoreCase("perm")) {
                String[] newSplit = StringMgmt.remFirstArg(split);
                TownCommand.setTownBlockPermissions(player, resident, resident.getPermissions(), newSplit, true);
            } else if (split[0].equalsIgnoreCase("mode")) {
                String[] newSplit = StringMgmt.remFirstArg(split);
                this.setMode(player, newSplit);
            } else {
                TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_property"), "town"));
                return;
            }
            townyUniverse.getDataSource().saveResident(resident);
        }
    }

    private void setMode(Player player, String[] split) {
        if (split.length == 0) {
            player.sendMessage(ChatTools.formatCommand("", "/resident set mode", "clear", ""));
            player.sendMessage(ChatTools.formatCommand("", "/resident set mode", "[mode] ...[mode]", ""));
            player.sendMessage(ChatTools.formatCommand("Mode", "map", "", TownySettings.getLangString("mode_1")));
            player.sendMessage(ChatTools.formatCommand("Mode", "townclaim", "", TownySettings.getLangString("mode_2")));
            player.sendMessage(ChatTools.formatCommand("Mode", "townunclaim", "", TownySettings.getLangString("mode_3")));
            player.sendMessage(ChatTools.formatCommand("Mode", "tc", "", TownySettings.getLangString("mode_4")));
            player.sendMessage(ChatTools.formatCommand("Mode", "nc", "", TownySettings.getLangString("mode_5")));
            player.sendMessage(ChatTools.formatCommand("Mode", "ignoreplots", "", ""));
            player.sendMessage(ChatTools.formatCommand("Mode", "constantplotborder", "", ""));
            player.sendMessage(ChatTools.formatCommand("Mode", "plotborder", "", ""));
            player.sendMessage(ChatTools.formatCommand("Eg", "/resident set mode", "map townclaim town nation general", ""));
            return;
        }
        if (split[0].equalsIgnoreCase("reset") || split[0].equalsIgnoreCase("clear")) {
            plugin.removePlayerMode(player);
            return;
        }
        List<String> list = Arrays.asList(split);
        if (list.contains("spy") && !TownyUniverse.getInstance().getPermissionSource().has(player, PermissionNodes.TOWNY_CHAT_SPY.getNode())) {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_command_disable"));
            return;
        }
        plugin.setPlayerMode(player, split, true);
    }

    public static void residentFriend(Player player, String[] split, boolean admin, Resident resident) {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (split.length == 0) {
            player.sendMessage(ChatTools.formatCommand("", "/resident friend", "add " + TownySettings.getLangString("res_2"), ""));
            player.sendMessage(ChatTools.formatCommand("", "/resident friend", "remove " + TownySettings.getLangString("res_2"), ""));
            player.sendMessage(ChatTools.formatCommand("", "/resident friend", "list", ""));
            player.sendMessage(ChatTools.formatCommand("", "/resident friend", "clear", ""));
        } else {
            try {
                if (!admin) {
                    resident = townyUniverse.getDataSource().getResident(player.getName());
                }
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
                return;
            }
            if (split[0].equalsIgnoreCase("add")) {
                String[] names = StringMgmt.remFirstArg(split);
                ResidentCommand.residentFriendAdd(player, resident, townyUniverse.getDataSource().getResidents(player, names));
            } else if (split[0].equalsIgnoreCase("remove")) {
                String[] names = StringMgmt.remFirstArg(split);
                ResidentCommand.residentFriendRemove(player, resident, townyUniverse.getDataSource().getResidents(player, names));
            } else if (split[0].equalsIgnoreCase("list")) {
                ResidentCommand.residentFriendList(player, resident);
            } else if (split[0].equalsIgnoreCase("clearlist") || split[0].equalsIgnoreCase("clear")) {
                ResidentCommand.residentFriendRemove(player, resident, resident.getFriends());
            }
        }
    }

    private static void residentFriendList(Player player, Resident resident) {
        player.sendMessage(ChatTools.formatTitle(TownySettings.getLangString("friend_list")));
        ArrayList<String> formatedList = new ArrayList<String>();
        for (Resident friends : resident.getFriends()) {
            String colour = friends.isKing() ? "\u00a76" : (friends.isMayor() ? "\u00a7b" : "\u00a7f");
            formatedList.add(colour + friends.getName() + "\u00a7f");
        }
        for (String line : ChatTools.list(formatedList)) {
            player.sendMessage(line);
        }
    }

    public static void residentFriendAdd(Player player, Resident resident, List<Resident> invited) {
        ArrayList<Resident> remove = new ArrayList<Resident>();
        for (Resident newFriend : invited) {
            try {
                resident.addFriend(newFriend);
                plugin.deleteCache(newFriend.getName());
            }
            catch (AlreadyRegisteredException e) {
                remove.add(newFriend);
            }
        }
        for (Resident newFriend : remove) {
            invited.remove(newFriend);
        }
        if (invited.size() > 0) {
            StringBuilder msg = new StringBuilder(TownySettings.getLangString("res_friend_added"));
            for (Resident newFriend : invited) {
                msg.append(newFriend.getName()).append(", ");
                Player p = BukkitTools.getPlayer(newFriend.getName());
                if (p == null) continue;
                TownyMessaging.sendMsg((Object)p, String.format(TownySettings.getLangString("msg_friend_add"), player.getName()));
            }
            msg = new StringBuilder(msg.substring(0, msg.length() - 2));
            msg.append(TownySettings.getLangString("msg_to_list"));
            TownyMessaging.sendMsg((Object)player, msg.toString());
            TownyUniverse.getInstance().getDataSource().saveResident(resident);
        } else {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
        }
    }

    public static void residentFriendRemove(Player player, Resident resident, List<Resident> kicking) {
        ArrayList<Resident> remove = new ArrayList<Resident>();
        ArrayList<Resident> toKick = new ArrayList<Resident>(kicking);
        for (Resident friend : toKick) {
            try {
                resident.removeFriend(friend);
                plugin.deleteCache(friend.getName());
            }
            catch (NotRegisteredException e) {
                remove.add(friend);
            }
        }
        if (remove.size() > 0) {
            for (Resident friend : remove) {
                toKick.remove(friend);
            }
        }
        if (toKick.size() > 0) {
            StringBuilder msg = new StringBuilder(TownySettings.getLangString("msg_removed"));
            for (Resident member : toKick) {
                msg.append(member.getName()).append(", ");
                Player p = BukkitTools.getPlayer(member.getName());
                if (p == null) continue;
                TownyMessaging.sendMsg((Object)p, String.format(TownySettings.getLangString("msg_friend_remove"), player.getName()));
            }
            msg = new StringBuilder(msg.substring(0, msg.length() - 2));
            msg.append(TownySettings.getLangString("msg_from_list"));
            TownyMessaging.sendMsg((Object)player, msg.toString());
            TownyUniverse.getInstance().getDataSource().saveResident(resident);
        } else {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
        }
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        LinkedList<String> output = new LinkedList<String>();
        String lastArg = "";
        if (args.length > 0) {
            lastArg = args[args.length - 1].toLowerCase();
        }
        if (!lastArg.equalsIgnoreCase("")) {
            for (Resident resident : TownyUniverse.getInstance().getDataSource().getResidents()) {
                if (!resident.getName().toLowerCase().startsWith(lastArg)) continue;
                output.add(resident.getName());
            }
        }
        return output;
    }

    static {
        output = new ArrayList<String>();
        output.add(ChatTools.formatTitle("/resident"));
        output.add(ChatTools.formatCommand("", "/resident", "", TownySettings.getLangString("res_1")));
        output.add(ChatTools.formatCommand("", "/resident", TownySettings.getLangString("res_2"), TownySettings.getLangString("res_3")));
        output.add(ChatTools.formatCommand("", "/resident", "list", TownySettings.getLangString("res_4")));
        output.add(ChatTools.formatCommand("", "/resident", "tax", ""));
        output.add(ChatTools.formatCommand("", "/resident", "jail", ""));
        output.add(ChatTools.formatCommand("", "/resident", "toggle", "[mode]...[mode]"));
        output.add(ChatTools.formatCommand("", "/resident", "set [] .. []", "'/resident set' " + TownySettings.getLangString("res_5")));
        output.add(ChatTools.formatCommand("", "/resident", "friend [add/remove] " + TownySettings.getLangString("res_2"), TownySettings.getLangString("res_6")));
        output.add(ChatTools.formatCommand("", "/resident", "friend [add+/remove+] " + TownySettings.getLangString("res_2") + " ", TownySettings.getLangString("res_7")));
        output.add(ChatTools.formatCommand("", "/resident", "spawn", ""));
    }
}

