/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyAsciiMap;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownyEconomyObject;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.war.eventwar.War;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.util.KeyValue;
import com.palmergames.util.KeyValueTable;
import com.palmergames.util.StringMgmt;
import com.palmergames.util.TimeMgmt;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TownyCommand
extends BaseCommand
implements CommandExecutor {
    private static Towny plugin;
    private static final List<String> towny_general_help;
    private static final List<String> towny_help;
    private static final List<String> towny_top;
    private static final List<String> towny_war;
    private static String towny_version;

    public TownyCommand(Towny instance) {
        plugin = instance;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        block7: {
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block6: {
                                    towny_version = "\u00a72Towny version: \u00a7a" + plugin.getVersion();
                                    towny_war.add(ChatTools.formatTitle("/towny war"));
                                    towny_war.add(ChatTools.formatCommand("", "/towny war", "stats", ""));
                                    towny_war.add(ChatTools.formatCommand("", "/towny war", "scores", ""));
                                    towny_war.add(ChatTools.formatCommand("", "/towny war", "participants [page #]", ""));
                                    towny_war.add(ChatTools.formatCommand("", "/towny war", "hud", ""));
                                    if (!(sender instanceof Player)) break block6;
                                    Player player = (Player)sender;
                                    this.parseTownyCommand(player, args);
                                    break block7;
                                }
                                if (args.length != 0) break block8;
                                for (String line : towny_general_help) {
                                    sender.sendMessage(Colors.strip(line));
                                }
                                break block7;
                            }
                            if (!args[0].equalsIgnoreCase("tree")) break block9;
                            for (String line : TownyUniverse.getInstance().getTreeString(0)) {
                                sender.sendMessage(line);
                            }
                            break block7;
                        }
                        if (!args[0].equalsIgnoreCase("time")) break block10;
                        TownyMessaging.sendMsg(TownySettings.getLangString("msg_time_until_a_new_day") + TimeMgmt.formatCountdownTime(TownyTimerHandler.townyTime()));
                        break block7;
                    }
                    if (!args[0].equalsIgnoreCase("version") && !args[0].equalsIgnoreCase("v")) break block11;
                    sender.sendMessage(Colors.strip(towny_version));
                    break block7;
                }
                if (!args[0].equalsIgnoreCase("war")) break block12;
                boolean war = this.TownyWar(StringMgmt.remFirstArg(args), null);
                if (war) {
                    for (String line : towny_war) {
                        sender.sendMessage(Colors.strip(line));
                    }
                } else {
                    sender.sendMessage("The world isn't currently at war.");
                }
                towny_war.clear();
                break block7;
            }
            if (!args[0].equalsIgnoreCase("universe")) break block7;
            for (String line : this.getUniverseStats()) {
                sender.sendMessage(Colors.strip(line));
            }
        }
        return true;
    }

    private void parseTownyCommand(Player player, String[] split) {
        block44: {
            TownyUniverse townyUniverse = TownyUniverse.getInstance();
            if (split.length == 0) {
                for (String line : towny_general_help) {
                    player.sendMessage(line);
                }
                return;
            }
            if (split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
                for (String line : towny_help) {
                    player.sendMessage(Colors.strip(line));
                }
                return;
            }
            try {
                if (split[0].equalsIgnoreCase("map")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNY_MAP.getNode(split[0].toLowerCase()))) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    if (split.length > 1 && split[1].equalsIgnoreCase("big")) {
                        TownyAsciiMap.generateAndSend(plugin, player, 18);
                    } else {
                        TownyCommand.showMap(player);
                    }
                    break block44;
                }
                if (split[0].equalsIgnoreCase("prices")) {
                    Town town = null;
                    if (split.length > 1) {
                        try {
                            town = townyUniverse.getDataSource().getTown(split[1]);
                        }
                        catch (NotRegisteredException x) {
                            this.sendErrorMsg((CommandSender)player, x.getMessage());
                            return;
                        }
                    }
                    if (split.length == 1) {
                        try {
                            Resident resident = townyUniverse.getDataSource().getResident(player.getName());
                            town = resident.getTown();
                        }
                        catch (NotRegisteredException resident) {
                            // empty catch block
                        }
                    }
                    for (String line : this.getTownyPrices(town)) {
                        player.sendMessage(line);
                    }
                    break block44;
                }
                if (split[0].equalsIgnoreCase("top")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNY_TOP.getNode(split[0].toLowerCase()))) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.TopCommand(player, StringMgmt.remFirstArg(split));
                } else if (split[0].equalsIgnoreCase("tree")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNY_TREE.getNode(split[0].toLowerCase()))) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    this.consoleUseOnly(player);
                } else if (split[0].equalsIgnoreCase("time")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNY_TIME.getNode(split[0].toLowerCase()))) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    TownyMessaging.sendMsg((Object)player, TownySettings.getLangString("msg_time_until_a_new_day") + TimeMgmt.formatCountdownTime(TownyTimerHandler.townyTime()));
                } else if (split[0].equalsIgnoreCase("universe")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNY_UNIVERSE.getNode(split[0].toLowerCase()))) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    for (String line : this.getUniverseStats()) {
                        player.sendMessage(line);
                    }
                } else if (split[0].equalsIgnoreCase("version") || split[0].equalsIgnoreCase("v")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNY_VERSION.getNode(split[0].toLowerCase()))) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    player.sendMessage(towny_version);
                } else if (split[0].equalsIgnoreCase("war")) {
                    if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNY_WAR.getNode(split[0].toLowerCase()))) {
                        throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    boolean war = this.TownyWar(StringMgmt.remFirstArg(split), player);
                    if (war) {
                        for (String line : towny_war) {
                            player.sendMessage(Colors.strip(line));
                        }
                    } else {
                        this.sendErrorMsg((CommandSender)player, "The world isn't currently at war.");
                    }
                    towny_war.clear();
                } else if (split[0].equalsIgnoreCase("spy")) {
                    if (townyUniverse.getPermissionSource().has(player, PermissionNodes.TOWNY_CHAT_SPY.getNode())) {
                        Resident resident = townyUniverse.getDataSource().getResident(player.getName());
                        resident.toggleMode(split, true);
                    } else {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_command_disable"));
                    }
                } else {
                    this.sendErrorMsg((CommandSender)player, "Invalid sub command.");
                }
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
            }
        }
    }

    private boolean TownyWar(String[] args, Player p) {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (TownyAPI.getInstance().isWarTime() && args.length > 0) {
            towny_war.clear();
            if (args[0].equalsIgnoreCase("stats")) {
                towny_war.addAll(townyUniverse.getWarEvent().getStats());
            } else if (args[0].equalsIgnoreCase("scores")) {
                towny_war.addAll(townyUniverse.getWarEvent().getScores(-1));
            } else {
                if (args[0].equalsIgnoreCase("participants")) {
                    try {
                        this.parseWarParticipants(p, args);
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        // empty catch block
                    }
                    return true;
                }
                if (args[0].equalsIgnoreCase("hud") && p == null) {
                    towny_war.add("No hud for console!");
                } else if (args[0].equalsIgnoreCase("hud") && p != null) {
                    if (townyUniverse.getPermissionSource().has(p, PermissionNodes.TOWNY_COMMAND_TOWNY_WAR_HUD.getNode())) {
                        plugin.getHUDManager().toggleWarHUD(p);
                    } else {
                        TownyMessaging.sendErrorMsg((Object)p, TownySettings.getLangString("msg_err_command_disable"));
                    }
                }
            }
        }
        return TownyAPI.getInstance().isWarTime();
    }

    private void parseWarParticipants(Player player, String[] split) throws NotRegisteredException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        List<Town> townsToSort = War.warringTowns;
        List<Nation> nationsToSort = War.warringNations;
        int page = 1;
        ArrayList<String> output = new ArrayList<String>();
        for (Nation nations : nationsToSort) {
            String nationLine = "\u00a76-" + nations.getName();
            if (townyUniverse.getDataSource().getResident(player.getName()).hasNation()) {
                if (townyUniverse.getDataSource().getResident(player.getName()).getTown().getNation().hasEnemy(nations)) {
                    nationLine = nationLine + "\u00a74 (Enemy)";
                } else if (townyUniverse.getDataSource().getResident(player.getName()).getTown().getNation().hasAlly(nations)) {
                    nationLine = nationLine + "\u00a72 (Ally)";
                }
            }
            output.add(nationLine);
            for (Town towns : townsToSort) {
                if (!towns.getNation().equals(nations)) continue;
                String townLine = "\u00a73  -" + towns.getName();
                if (towns.isCapital()) {
                    townLine = townLine + "\u00a7b (Capital)";
                }
                output.add(townLine);
            }
        }
        int total = (int)Math.ceil((double)output.size() / 10.0);
        if (split.length > 1) {
            try {
                page = Integer.parseInt(split[1]);
                if (page < 0) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative"));
                    return;
                }
                if (page == 0) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_int"));
                    return;
                }
            }
            catch (NumberFormatException e) {
                TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_int"));
                return;
            }
        }
        if (page > total) {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getListNotEnoughPagesMsg(total));
            return;
        }
        int iMax = page * 10;
        if (page * 10 > output.size()) {
            iMax = output.size();
        }
        ArrayList<String> warparticipantsformatted = new ArrayList<String>();
        for (int i = (page - 1) * 10; i < iMax; ++i) {
            String line = (String)output.get(i);
            warparticipantsformatted.add(line);
        }
        player.sendMessage(ChatTools.formatList("War Participants", "\u00a76Nation Name\u00a78 - \u00a73Town Names", warparticipantsformatted, TownySettings.getListPageMsg(page, total)));
        output.clear();
    }

    private void TopCommand(Player player, String[] args) {
        ArrayList<TownBlockOwner> list;
        TownyUniverse universe = TownyUniverse.getInstance();
        if (args.length == 0 || args[0].equalsIgnoreCase("?")) {
            towny_top.add(ChatTools.formatTitle("/towny top"));
            towny_top.add(ChatTools.formatCommand("", "/towny top", "residents [all/town/nation]", ""));
            towny_top.add(ChatTools.formatCommand("", "/towny top", "land [all/resident/town]", ""));
        } else if (args[0].equalsIgnoreCase("residents")) {
            if (args.length == 1 || args[1].equalsIgnoreCase("all")) {
                list = new ArrayList<Town>(universe.getDataSource().getTowns());
                list.addAll(universe.getDataSource().getNations());
                towny_top.add(ChatTools.formatTitle("Most Residents"));
                towny_top.addAll(this.getMostResidents(list, 10));
            } else if (args[1].equalsIgnoreCase("town")) {
                towny_top.add(ChatTools.formatTitle("Most Residents in a Town"));
                towny_top.addAll(this.getMostResidents(new ArrayList<ResidentList>(universe.getDataSource().getTowns()), 10));
            } else if (args[1].equalsIgnoreCase("nation")) {
                towny_top.add(ChatTools.formatTitle("Most Residents in a Nation"));
                towny_top.addAll(this.getMostResidents(new ArrayList<ResidentList>(universe.getDataSource().getNations()), 10));
            } else {
                this.sendErrorMsg((CommandSender)player, "Invalid sub command.");
            }
        } else if (args[0].equalsIgnoreCase("land")) {
            if (args.length == 1 || args[1].equalsIgnoreCase("all")) {
                list = new ArrayList<Resident>(universe.getDataSource().getResidents());
                list.addAll(universe.getDataSource().getTowns());
                towny_top.add(ChatTools.formatTitle("Most Land Owned"));
                towny_top.addAll(this.getMostLand(list, 10));
            } else if (args[1].equalsIgnoreCase("resident")) {
                towny_top.add(ChatTools.formatTitle("Most Land Owned by Resident"));
                towny_top.addAll(this.getMostLand(new ArrayList<TownBlockOwner>(universe.getDataSource().getResidents()), 10));
            } else if (args[1].equalsIgnoreCase("town")) {
                towny_top.add(ChatTools.formatTitle("Most Land Owned by Town"));
                towny_top.addAll(this.getMostLand(new ArrayList<TownBlockOwner>(universe.getDataSource().getTowns()), 10));
            } else {
                this.sendErrorMsg((CommandSender)player, "Invalid sub command.");
            }
        } else {
            this.sendErrorMsg((CommandSender)player, "Invalid sub command.");
        }
        for (String line : towny_top) {
            player.sendMessage(line);
        }
        towny_top.clear();
    }

    public List<String> getUniverseStats() {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        ArrayList<String> output = new ArrayList<String>();
        output.add("\u00a70-\u00a74###\u00a70---\u00a74###\u00a70-");
        output.add("\u00a74#\u00a7c###\u00a74#\u00a70-\u00a74#\u00a7c###\u00a74#\u00a70   \u00a76[\u00a7eTowny " + plugin.getVersion() + "\u00a76]");
        output.add("\u00a74#\u00a7c####\u00a74#\u00a7c####\u00a74#   \u00a73By: \u00a7bChris H (Shade)/ElgarL/LlmDl");
        output.add("\u00a70-\u00a74#\u00a7c#######\u00a74#\u00a70-");
        output.add("\u00a70--\u00a74##\u00a7c###\u00a74##\u00a70--   \u00a73Residents: \u00a7b" + townyUniverse.getDataSource().getResidents().size() + "\u00a78" + " | \u00a73Towns: \u00a7b" + townyUniverse.getDataSource().getTowns().size() + "\u00a78" + " | \u00a73Nations: \u00a7b" + townyUniverse.getDataSource().getNations().size());
        output.add("\u00a70----\u00a74#\u00a7c#\u00a74#\u00a70----   \u00a73Worlds: \u00a7b" + townyUniverse.getDataSource().getWorlds().size() + "\u00a78" + " | \u00a73TownBlocks: \u00a7b" + townyUniverse.getDataSource().getAllTownBlocks().size());
        output.add("\u00a70-----\u00a74#\u00a70----- ");
        Plugin test = Bukkit.getServer().getPluginManager().getPlugin("TownyChat");
        if (test != null) {
            output.add("\u00a70-----------   \u00a76[\u00a7eTownyChat " + BukkitTools.getPluginManager().getPlugin("TownyChat").getDescription().getVersion() + "\u00a76]");
        }
        return output;
    }

    public static void showMap(Player player) {
        TownyAsciiMap.generateAndSend(plugin, player, 7);
    }

    public List<String> getTownyPrices(Town town) {
        ArrayList<String> output = new ArrayList<String>();
        Nation nation = null;
        if (town != null && town.hasNation()) {
            try {
                nation = town.getNation();
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
            }
        }
        output.add(ChatTools.formatTitle("Prices"));
        output.add("\u00a7e[New] \u00a72Town: \u00a7a" + TownyEconomyHandler.getFormattedBalance(TownySettings.getNewTownPrice()) + "\u00a78" + " | " + "\u00a72" + "Nation: " + "\u00a7a" + TownyEconomyHandler.getFormattedBalance(TownySettings.getNewNationPrice()));
        if (town != null) {
            output.add("\u00a7e[Upkeep] \u00a72Town: \u00a7a" + TownyEconomyHandler.getFormattedBalance(TownySettings.getTownUpkeepCost(town)) + "\u00a78" + " | " + "\u00a72" + "Nation: " + "\u00a7a" + TownyEconomyHandler.getFormattedBalance(TownySettings.getNationUpkeepCost(nation)));
            if (town.isOverClaimed() && TownySettings.getUpkeepPenalty() > 0.0) {
                output.add("\u00a7e[Overclaimed Upkeep] \u00a72Town: \u00a7a" + TownyEconomyHandler.getFormattedBalance(TownySettings.getTownPenaltyUpkeepCost(town)));
            }
            output.add("\u00a7e[Claiming] \u00a72TownBlock: \u00a7a" + TownyEconomyHandler.getFormattedBalance(town.getTownBlockCost()) + "\u00a78" + (Double.valueOf(TownySettings.getClaimPriceIncreaseValue()).equals(1.0) ? "" : " | \u00a72Increase per TownBlock: \u00a7a+" + new DecimalFormat("##.##%").format(TownySettings.getClaimPriceIncreaseValue() - 1.0)));
            output.add("\u00a7e[Claiming] \u00a72Outposts: \u00a7a" + TownyEconomyHandler.getFormattedBalance(TownySettings.getOutpostCost()));
        }
        if (town == null) {
            output.add("\u00a7e[Upkeep] \u00a72Town: \u00a7a" + TownyEconomyHandler.getFormattedBalance(TownySettings.getTownUpkeep()) + "\u00a78" + " | " + "\u00a72" + "Nation: " + "\u00a7a" + TownyEconomyHandler.getFormattedBalance(TownySettings.getNationUpkeep()));
        }
        output.add("\u00a78Town upkeep is based on \u00a7a the " + (TownySettings.isUpkeepByPlot() ? " number of plots" : " town level (num residents)."));
        if (TownySettings.getUpkeepPenalty() > 0.0) {
            output.add("\u00a78Overclaimed upkeep is based on \u00a7a" + (TownySettings.isUpkeepPenaltyByPlot() ? "the number of plots overclaimed * " + TownySettings.getUpkeepPenalty() : "a flat cost of " + TownySettings.getUpkeepPenalty()));
        }
        if (town != null) {
            output.add("\u00a7eTown [" + TownyFormatter.getFormattedName(town) + "]");
            output.add("\u00a7c    [Price] \u00a72Plot: \u00a7a" + TownyEconomyHandler.getFormattedBalance(town.getPlotPrice()) + "\u00a78" + " | " + "\u00a72" + "Outpost: " + "\u00a7a" + TownyEconomyHandler.getFormattedBalance(TownySettings.getOutpostCost()));
            output.add("\u00a7c             \u00a72Shop: \u00a7a" + TownyEconomyHandler.getFormattedBalance(town.getCommercialPlotPrice()) + "\u00a78" + " | " + "\u00a72" + "Embassy: " + "\u00a7a" + TownyEconomyHandler.getFormattedBalance(town.getEmbassyPlotPrice()));
            output.add("\u00a7c    [Taxes] \u00a72Resident: \u00a7a" + (town.isTaxPercentage() ? town.getTaxes() + "%" : TownyEconomyHandler.getFormattedBalance(town.getTaxes())) + "\u00a78" + " | " + "\u00a72" + "Plot: " + "\u00a7a" + TownyEconomyHandler.getFormattedBalance(town.getPlotTax()));
            output.add("\u00a7c              \u00a72Shop: \u00a7a" + TownyEconomyHandler.getFormattedBalance(town.getCommercialPlotTax()) + "\u00a78" + " | " + "\u00a72" + "Embassy: " + "\u00a7a" + TownyEconomyHandler.getFormattedBalance(town.getEmbassyPlotTax()));
            output.add("\u00a7c    [Setting Plots] \u00a72Shop: \u00a7a" + TownyEconomyHandler.getFormattedBalance(TownySettings.getPlotSetCommercialCost()) + "\u00a78" + " | " + "\u00a72" + "Embassy: " + "\u00a7a" + TownyEconomyHandler.getFormattedBalance(TownySettings.getPlotSetEmbassyCost()) + "\u00a78" + " | " + "\u00a72" + "Wilds: " + "\u00a7a" + TownyEconomyHandler.getFormattedBalance(TownySettings.getPlotSetWildsCost()));
            output.add("\u00a7c                      \u00a72Inn: \u00a7a" + TownyEconomyHandler.getFormattedBalance(TownySettings.getPlotSetInnCost()) + "\u00a78" + " | " + "\u00a72" + "Jail: " + "\u00a7a" + TownyEconomyHandler.getFormattedBalance(TownySettings.getPlotSetJailCost()) + "\u00a78" + " | " + "\u00a72" + "Farm: " + "\u00a7a" + TownyEconomyHandler.getFormattedBalance(TownySettings.getPlotSetFarmCost()));
            output.add("\u00a7c                      \u00a72Bank: \u00a7a" + TownyEconomyHandler.getFormattedBalance(TownySettings.getPlotSetBankCost()));
            if (nation != null) {
                output.add("\u00a7eNation [" + TownyFormatter.getFormattedName(nation) + "]");
                output.add("\u00a7c    [Taxes] \u00a72Town: \u00a7a" + nation.getTaxes() + "\u00a78" + " | " + "\u00a72" + "Peace: " + "\u00a7a" + TownyEconomyHandler.getFormattedBalance(TownySettings.getNationNeutralityCost()));
            }
        }
        return output;
    }

    public List<String> getTopBankBalance(List<TownyEconomyObject> list, int maxListing) throws EconomyException {
        ArrayList<String> output = new ArrayList<String>();
        KeyValueTable<TownyEconomyObject, Double> kvTable = new KeyValueTable<TownyEconomyObject, Double>();
        for (TownyEconomyObject obj : list) {
            kvTable.put(obj, obj.getHoldingBalance());
        }
        kvTable.sortByValue();
        kvTable.reverse();
        int n = 0;
        for (KeyValue kv : kvTable.getKeyValues()) {
            if (maxListing != -1 && ++n > maxListing) break;
            TownyEconomyObject town = (TownyEconomyObject)kv.key;
            output.add(String.format("\u00a77%-20s \u00a76|\u00a73 %s", TownyFormatter.getFormattedName(town), TownyEconomyHandler.getFormattedBalance((Double)kv.value)));
        }
        return output;
    }

    public List<String> getMostResidents(List<ResidentList> list, int maxListing) {
        ArrayList<String> output = new ArrayList<String>();
        KeyValueTable<ResidentList, Integer> kvTable = new KeyValueTable<ResidentList, Integer>();
        for (ResidentList obj : list) {
            kvTable.put(obj, obj.getResidents().size());
        }
        kvTable.sortByValue();
        kvTable.reverse();
        int n = 0;
        for (KeyValue kv : kvTable.getKeyValues()) {
            if (maxListing != -1 && ++n > maxListing) break;
            ResidentList residentList = (ResidentList)kv.key;
            output.add(String.format("\u00a73%30s \u00a76|\u00a77 %10d", TownyFormatter.getFormattedName((TownyObject)((Object)residentList)), kv.value));
        }
        return output;
    }

    public List<String> getMostLand(List<TownBlockOwner> list, int maxListing) {
        ArrayList<String> output = new ArrayList<String>();
        KeyValueTable<TownBlockOwner, Integer> kvTable = new KeyValueTable<TownBlockOwner, Integer>();
        for (TownBlockOwner obj : list) {
            kvTable.put(obj, obj.getTownBlocks().size());
        }
        kvTable.sortByValue();
        kvTable.reverse();
        int n = 0;
        for (KeyValue kv : kvTable.getKeyValues()) {
            if (maxListing != -1 && ++n > maxListing) break;
            TownBlockOwner town = (TownBlockOwner)kv.key;
            output.add(String.format("\u00a73%30s \u00a76|\u00a77 %10d", TownyFormatter.getFormattedName(town), kv.value));
        }
        return output;
    }

    public void consoleUseOnly(Player player) {
        TownyMessaging.sendErrorMsg((Object)player, "This command was designed for use in the console only.");
    }

    public void inGameUseOnly(CommandSender sender) {
        sender.sendMessage("[Towny] InputError: This command was designed for use in game only.");
    }

    public boolean sendErrorMsg(CommandSender sender, String msg) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            TownyMessaging.sendErrorMsg((Object)player, msg);
        } else {
            sender.sendMessage("[Towny] ConsoleError: " + msg);
        }
        return false;
    }

    static {
        towny_general_help = new ArrayList<String>();
        towny_help = new ArrayList<String>();
        towny_top = new ArrayList<String>();
        towny_war = new ArrayList<String>();
        towny_general_help.add(ChatTools.formatTitle(TownySettings.getLangString("help_0")));
        towny_general_help.add(TownySettings.getLangString("help_1"));
        towny_general_help.add(ChatTools.formatCommand("", "/resident", "?", "") + ", " + ChatTools.formatCommand("", "/town", "?", "") + ", " + ChatTools.formatCommand("", "/nation", "?", "") + ", " + ChatTools.formatCommand("", "/plot", "?", "") + ", " + ChatTools.formatCommand("", "/towny", "?", ""));
        towny_general_help.add(ChatTools.formatCommand("", "/tc", "[msg]", TownySettings.getLangString("help_2")) + ", " + ChatTools.formatCommand("", "/nc", "[msg]", TownySettings.getLangString("help_3")).trim());
        towny_general_help.add(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/townyadmin", "?", ""));
        towny_help.add(ChatTools.formatTitle("/towny"));
        towny_help.add(ChatTools.formatCommand("", "/towny", "", "General help for Towny"));
        towny_help.add(ChatTools.formatCommand("", "/towny", "map", "Displays a map of the nearby townblocks"));
        towny_help.add(ChatTools.formatCommand("", "/towny", "prices", "Display the prices used with Economy"));
        towny_help.add(ChatTools.formatCommand("", "/towny", "top", "Display highscores"));
        towny_help.add(ChatTools.formatCommand("", "/towny", "time", "Display time until a new day"));
        towny_help.add(ChatTools.formatCommand("", "/towny", "universe", "Displays stats"));
        towny_help.add(ChatTools.formatCommand("", "/towny", "v", "Displays the version of Towny"));
        towny_help.add(ChatTools.formatCommand("", "/towny", "war", "'/towny war' for more info"));
    }
}

