/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.confirmations;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.confirmations.ConfirmationType;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.tasks.ResidentPurge;
import com.palmergames.bukkit.towny.tasks.TownClaim;
import com.palmergames.util.TimeTools;
import java.util.HashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ConfirmationHandler {
    private static Towny plugin;
    private static HashMap<Resident, Town> towndeleteconfirmations;
    private static HashMap<Resident, Town> townunclaimallconfirmations;
    private static HashMap<Resident, Nation> nationdeleteconfirmations;
    private static HashMap<Resident, String> townypurgeconfirmations;
    private static HashMap<Resident, Nation> nationmergeconfirmations;
    public static ConfirmationType consoleConfirmationType;
    private static Object consoleExtra;

    public static void initialize(Towny plugin) {
        ConfirmationHandler.plugin = plugin;
    }

    public static void addConfirmation(final Resident r, final ConfirmationType type, Object extra) throws TownyException {
        if (type == ConfirmationType.TOWNDELETE) {
            r.setConfirmationType(type);
            towndeleteconfirmations.put(r, r.getTown());
            new BukkitRunnable(){

                public void run() {
                    ConfirmationHandler.removeConfirmation(r, type, false);
                }
            }.runTaskLater((Plugin)plugin, 400L);
        }
        if (type == ConfirmationType.PURGE) {
            r.setConfirmationType(type);
            townypurgeconfirmations.put(r, (String)extra);
            new BukkitRunnable(){

                public void run() {
                    ConfirmationHandler.removeConfirmation(r, type, false);
                }
            }.runTaskLater((Plugin)plugin, 400L);
        }
        if (type == ConfirmationType.UNCLAIMALL) {
            r.setConfirmationType(type);
            townunclaimallconfirmations.put(r, r.getTown());
            new BukkitRunnable(){

                public void run() {
                    ConfirmationHandler.removeConfirmation(r, type, false);
                }
            }.runTaskLater((Plugin)plugin, 400L);
        }
        if (type == ConfirmationType.NATIONDELETE) {
            r.setConfirmationType(type);
            nationdeleteconfirmations.put(r, r.getTown().getNation());
            new BukkitRunnable(){

                public void run() {
                    ConfirmationHandler.removeConfirmation(r, type, false);
                }
            }.runTaskLater((Plugin)plugin, 400L);
        }
        if (type == ConfirmationType.NATIONMERGE) {
            r.setConfirmationType(type);
            nationmergeconfirmations.put(r, (Nation)extra);
            new BukkitRunnable(){

                public void run() {
                    ConfirmationHandler.removeConfirmation(r, type, false);
                }
            }.runTaskLater((Plugin)plugin, 400L);
        }
    }

    public static void removeConfirmation(Resident r, ConfirmationType type, boolean successful) {
        boolean sendmessage = false;
        if (type == ConfirmationType.TOWNDELETE) {
            if (towndeleteconfirmations.containsKey(r) && !successful) {
                sendmessage = true;
            }
            towndeleteconfirmations.remove(r);
            r.setConfirmationType(null);
        }
        if (type == ConfirmationType.PURGE) {
            if (townypurgeconfirmations.containsKey(r) && !successful) {
                sendmessage = true;
            }
            townypurgeconfirmations.remove(r);
            r.setConfirmationType(null);
        }
        if (type == ConfirmationType.UNCLAIMALL) {
            if (townunclaimallconfirmations.containsKey(r) && !successful) {
                sendmessage = true;
            }
            townunclaimallconfirmations.remove(r);
            r.setConfirmationType(null);
        }
        if (type == ConfirmationType.NATIONDELETE) {
            if (nationdeleteconfirmations.containsKey(r) && !successful) {
                sendmessage = true;
            }
            nationdeleteconfirmations.remove(r);
            r.setConfirmationType(null);
        }
        if (type == ConfirmationType.NATIONMERGE) {
            if (nationmergeconfirmations.containsKey(r) && !successful) {
                sendmessage = true;
            }
            nationmergeconfirmations.remove(r);
            r.setConfirmationType(null);
        }
        if (sendmessage) {
            TownyMessaging.sendMsg(r, TownySettings.getLangString("successful_cancel"));
        }
    }

    public static void handleConfirmation(Resident r, ConfirmationType type) throws TownyException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (type == ConfirmationType.TOWNDELETE && towndeleteconfirmations.containsKey(r) && towndeleteconfirmations.get(r).equals(r.getTown())) {
            TownyMessaging.sendGlobalMessage(TownySettings.getDelTownMsg(towndeleteconfirmations.get(r)));
            townyUniverse.getDataSource().removeTown(towndeleteconfirmations.get(r));
            ConfirmationHandler.removeConfirmation(r, type, true);
            return;
        }
        if (type == ConfirmationType.PURGE && townypurgeconfirmations.containsKey(r)) {
            Player player = TownyAPI.getInstance().getPlayer(r);
            if (player == null) {
                throw new TownyException("Player could not be found!");
            }
            if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_PURGE.getNode())) {
                throw new TownyException(TownySettings.getLangString("msg_err_admin_only"));
            }
            int days = 1;
            boolean townless = false;
            if (townypurgeconfirmations.get(r).startsWith("townless")) {
                townless = true;
                days = Integer.parseInt(townypurgeconfirmations.get(r).substring(8));
            } else {
                days = Integer.parseInt(townypurgeconfirmations.get(r));
            }
            new ResidentPurge(plugin, (CommandSender)player, TimeTools.getMillis(days + "d"), townless).start();
            ConfirmationHandler.removeConfirmation(r, type, true);
        }
        if (type == ConfirmationType.UNCLAIMALL && townunclaimallconfirmations.containsKey(r) && townunclaimallconfirmations.get(r).equals(r.getTown())) {
            TownClaim.townUnclaimAll(plugin, townunclaimallconfirmations.get(r));
            ConfirmationHandler.removeConfirmation(r, type, true);
            return;
        }
        if (type == ConfirmationType.NATIONDELETE && nationdeleteconfirmations.containsKey(r) && nationdeleteconfirmations.get(r).equals(r.getTown().getNation())) {
            townyUniverse.getDataSource().removeNation(nationdeleteconfirmations.get(r));
            TownyMessaging.sendGlobalMessage(TownySettings.getDelNationMsg(nationdeleteconfirmations.get(r)));
            ConfirmationHandler.removeConfirmation(r, type, true);
        }
        if (type == ConfirmationType.NATIONMERGE && nationmergeconfirmations.containsKey(r)) {
            Nation succumbingNation = r.getTown().getNation();
            Nation prevailingNation = nationmergeconfirmations.get(r);
            townyUniverse.getDataSource().mergeNation(succumbingNation, prevailingNation);
            TownyMessaging.sendGlobalMessage(String.format(TownySettings.getLangString("nation1_has_merged_with_nation2"), succumbingNation, prevailingNation));
            ConfirmationHandler.removeConfirmation(r, type, true);
        }
    }

    public static void addConfirmation(final ConfirmationType type, Object extra) {
        if (consoleConfirmationType.equals((Object)ConfirmationType.NULL)) {
            if (type == ConfirmationType.TOWNDELETE) {
                consoleExtra = extra;
                consoleConfirmationType = type;
                new BukkitRunnable(){

                    public void run() {
                        ConfirmationHandler.removeConfirmation(type, false);
                    }
                }.runTaskLater((Plugin)plugin, 400L);
            }
            if (type == ConfirmationType.PURGE) {
                consoleExtra = extra;
                consoleConfirmationType = type;
                new BukkitRunnable(){

                    public void run() {
                        ConfirmationHandler.removeConfirmation(type, false);
                    }
                }.runTaskLater((Plugin)plugin, 400L);
            }
            if (type == ConfirmationType.NATIONDELETE) {
                consoleExtra = extra;
                consoleConfirmationType = type;
                new BukkitRunnable(){

                    public void run() {
                        ConfirmationHandler.removeConfirmation(type, false);
                    }
                }.runTaskLater((Plugin)plugin, 400L);
            }
        } else {
            TownyMessaging.sendMsg("Unable to start a new confirmation, one already exists of type: " + consoleConfirmationType.toString());
        }
    }

    public static void removeConfirmation(ConfirmationType type, boolean successful) {
        boolean sendmessage = false;
        if (type == ConfirmationType.PURGE) {
            if (!consoleConfirmationType.equals((Object)ConfirmationType.NULL) && !successful) {
                sendmessage = true;
            }
            consoleConfirmationType = ConfirmationType.NULL;
        }
        if (type == ConfirmationType.TOWNDELETE) {
            if (!consoleConfirmationType.equals((Object)ConfirmationType.NULL) && !successful) {
                sendmessage = true;
            }
            consoleConfirmationType = ConfirmationType.NULL;
        }
        if (type == ConfirmationType.NATIONDELETE) {
            if (!consoleConfirmationType.equals((Object)ConfirmationType.NULL) && !successful) {
                sendmessage = true;
            }
            consoleConfirmationType = ConfirmationType.NULL;
        }
        if (sendmessage) {
            TownyMessaging.sendMsg(TownySettings.getLangString("successful_cancel"));
        }
    }

    public static void handleConfirmation(ConfirmationType type) throws TownyException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (type == ConfirmationType.TOWNDELETE) {
            Town town = (Town)consoleExtra;
            TownyMessaging.sendGlobalMessage(TownySettings.getDelTownMsg(town));
            townyUniverse.getDataSource().removeTown(town);
            ConfirmationHandler.removeConfirmation(type, true);
            consoleExtra = null;
            return;
        }
        if (type == ConfirmationType.PURGE) {
            int days = 1;
            boolean townless = false;
            if (((String)consoleExtra).startsWith("townless")) {
                townless = true;
                days = Integer.parseInt(((String)consoleExtra).substring(8));
            } else {
                days = Integer.parseInt((String)consoleExtra);
            }
            new ResidentPurge(plugin, null, TimeTools.getMillis(days + "d"), townless).start();
            ConfirmationHandler.removeConfirmation(type, true);
            consoleExtra = null;
        }
        if (type == ConfirmationType.NATIONDELETE) {
            Nation nation = (Nation)consoleExtra;
            TownyMessaging.sendGlobalMessage(TownySettings.getDelNationMsg(nation));
            townyUniverse.getDataSource().removeNation(nation);
            ConfirmationHandler.removeConfirmation(type, true);
            consoleExtra = null;
            return;
        }
    }

    static {
        towndeleteconfirmations = new HashMap();
        townunclaimallconfirmations = new HashMap();
        nationdeleteconfirmations = new HashMap();
        townypurgeconfirmations = new HashMap();
        nationmergeconfirmations = new HashMap();
        consoleConfirmationType = ConfirmationType.NULL;
        consoleExtra = null;
    }
}

