/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.db;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class SQL_Schema {
    private static final String tb_prefix = TownySettings.getSQLTablePrefix().toUpperCase();

    private static String getWORLDS() {
        return "CREATE TABLE IF NOT EXISTS " + tb_prefix + "WORLDS (`name` VARCHAR(32) NOT NULL,PRIMARY KEY (`name`))";
    }

    private static List<String> getWorldColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("`towns` mediumtext NOT NULL");
        columns.add("`claimable` bool NOT NULL DEFAULT '0'");
        columns.add("`pvp` bool NOT NULL DEFAULT '0'");
        columns.add("`forcepvp` bool NOT NULL DEFAULT '0'");
        columns.add("`forcetownmobs` bool NOT NULL DEFAULT '0'");
        columns.add("`worldmobs` bool NOT NULL DEFAULT '0'");
        columns.add("`firespread` bool NOT NULL DEFAULT '0'");
        columns.add("`forcefirespread` bool NOT NULL DEFAULT '0'");
        columns.add("`explosions` bool NOT NULL DEFAULT '0'");
        columns.add("`forceexplosions` bool NOT NULL DEFAULT '0'");
        columns.add("`endermanprotect` bool NOT NULL DEFAULT '0'");
        columns.add("`disableplayertrample` bool NOT NULL DEFAULT '0'");
        columns.add("`disablecreaturetrample` bool NOT NULL DEFAULT '0'");
        columns.add("`unclaimedZoneBuild` bool NOT NULL DEFAULT '0'");
        columns.add("`unclaimedZoneDestroy` bool NOT NULL DEFAULT '0'");
        columns.add("`unclaimedZoneSwitch` bool NOT NULL DEFAULT '0'");
        columns.add("`unclaimedZoneItemUse` bool NOT NULL DEFAULT '0'");
        columns.add("`unclaimedZoneName` mediumtext NOT NULL");
        columns.add("`unclaimedZoneIgnoreIds` mediumtext NOT NULL");
        columns.add("`usingPlotManagementDelete` bool NOT NULL DEFAULT '0'");
        columns.add("`plotManagementDeleteIds` mediumtext NOT NULL");
        columns.add("`usingPlotManagementMayorDelete` bool NOT NULL DEFAULT '0'");
        columns.add("`plotManagementMayorDelete` mediumtext NOT NULL");
        columns.add("`usingPlotManagementRevert` bool NOT NULL DEFAULT '0'");
        columns.add("`plotManagementRevertSpeed` long NOT NULL");
        columns.add("`plotManagementIgnoreIds` mediumtext NOT NULL");
        columns.add("`usingPlotManagementWildRegen` bool NOT NULL DEFAULT '0'");
        columns.add("`plotManagementWildRegenEntities` mediumtext NOT NULL");
        columns.add("`plotManagementWildRegenSpeed` long NOT NULL");
        columns.add("`usingTowny` bool NOT NULL DEFAULT '0'");
        columns.add("`warAllowed` bool NOT NULL DEFAULT '0'");
        return columns;
    }

    private static String getNATIONS() {
        return "CREATE TABLE IF NOT EXISTS " + tb_prefix + "NATIONS (`name` VARCHAR(32) NOT NULL,PRIMARY KEY (`name`))";
    }

    private static List<String> getNationColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("`towns` mediumtext NOT NULL");
        columns.add("`capital` mediumtext NOT NULL");
        columns.add("`assistants` mediumtext NOT NULL");
        columns.add("`tag` mediumtext NOT NULL");
        columns.add("`allies` mediumtext NOT NULL");
        columns.add("`enemies` mediumtext NOT NULL");
        columns.add("`taxes` float NOT NULL");
        columns.add("`spawnCost` float NOT NULL");
        columns.add("`neutral` bool NOT NULL DEFAULT '0'");
        columns.add("`uuid` VARCHAR(36) DEFAULT NULL");
        columns.add("`registered` BIGINT DEFAULT NULL");
        columns.add("`nationBoard` mediumtext DEFAULT NULL");
        columns.add("`nationSpawn` mediumtext DEFAULT NULL");
        columns.add("`isPublic` bool NOT NULL DEFAULT '1'");
        columns.add("`isOpen` bool NOT NULL DEFAULT '1'");
        return columns;
    }

    private static String getTOWNS() {
        return "CREATE TABLE IF NOT EXISTS " + tb_prefix + "TOWNS (`name` VARCHAR(32) NOT NULL,PRIMARY KEY (`name`))";
    }

    private static List<String> getTownColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("`residents` mediumtext");
        columns.add("`mayor` mediumtext");
        columns.add("`nation` mediumtext NOT NULL");
        columns.add("`assistants` text DEFAULT NULL");
        columns.add("`townBoard` mediumtext DEFAULT NULL");
        columns.add("`tag` mediumtext DEFAULT NULL");
        columns.add("`protectionStatus` mediumtext DEFAULT NULL");
        columns.add("`bonus` int(11) DEFAULT 0");
        columns.add("`purchased` int(11)  DEFAULT 0");
        columns.add("`taxpercent` bool NOT NULL DEFAULT '0'");
        columns.add("`taxes` float DEFAULT 0");
        columns.add("`hasUpkeep` bool NOT NULL DEFAULT '0'");
        columns.add("`plotPrice` float DEFAULT NULL");
        columns.add("`plotTax` float DEFAULT NULL");
        columns.add("`commercialPlotPrice` float DEFAULT NULL");
        columns.add("`commercialPlotTax` float NOT NULL");
        columns.add("`embassyPlotPrice` float NOT NULL");
        columns.add("`embassyPlotTax` float NOT NULL");
        columns.add("`open` bool NOT NULL DEFAULT '0'");
        columns.add("`public` bool NOT NULL DEFAULT '0'");
        columns.add("`admindisabledpvp` bool NOT NULL DEFAULT '0'");
        columns.add("`adminenabledpvp` bool NOT NULL DEFAULT '0'");
        columns.add("`homeblock` mediumtext NOT NULL");
        columns.add("`spawn` mediumtext NOT NULL");
        columns.add("`outpostSpawns` mediumtext DEFAULT NULL");
        columns.add("`jailSpawns` mediumtext DEFAULT NULL");
        columns.add("`outlaws` mediumtext DEFAULT NULL");
        columns.add("`uuid` VARCHAR(36) DEFAULT NULL");
        columns.add("`registered` BIGINT DEFAULT NULL");
        columns.add("`spawnCost` float NOT NULL");
        columns.add("`metadata` text DEFAULT NULL");
        return columns;
    }

    private static String getRESIDENTS() {
        return "CREATE TABLE IF NOT EXISTS " + tb_prefix + "RESIDENTS ( `name` VARCHAR(16) NOT NULL,PRIMARY KEY (`name`))";
    }

    private static List<String> getResidentColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("`town` mediumtext");
        columns.add("`town-ranks` mediumtext");
        columns.add("`nation-ranks` mediumtext");
        columns.add("`lastOnline` BIGINT NOT NULL");
        columns.add("`registered` BIGINT NOT NULL");
        columns.add("`isNPC` bool NOT NULL DEFAULT '0'");
        columns.add("`isJailed` bool NOT NULL DEFAULT '0'");
        columns.add("`JailSpawn` mediumint");
        columns.add("`JailDays` mediumint");
        columns.add("`JailTown` mediumtext");
        columns.add("`title` mediumtext");
        columns.add("`surname` mediumtext");
        columns.add("`protectionStatus` mediumtext");
        columns.add("`friends` mediumtext");
        return columns;
    }

    private static String getTOWNBLOCKS() {
        return "CREATE TABLE IF NOT EXISTS " + tb_prefix + "TOWNBLOCKS (`world` VARCHAR(32) NOT NULL,`x` mediumint NOT NULL,`z` mediumint NOT NULL,PRIMARY KEY (`world`,`x`,`z`))";
    }

    private static List<String> getTownBlockColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("`name` mediumtext");
        columns.add("`price` float DEFAULT '-1'");
        columns.add("`town` mediumtext");
        columns.add("`resident` mediumtext");
        columns.add("`type` TINYINT NOT  NULL DEFAULT '0'");
        columns.add("`outpost` bool NOT NULL DEFAULT '0'");
        columns.add("`permissions` mediumtext NOT NULL");
        columns.add("`locked` bool NOT NULL DEFAULT '0'");
        columns.add("`changed` bool NOT NULL DEFAULT '0'");
        columns.add("`metadata` text DEFAULT NULL");
        return columns;
    }

    public static void initTables(Connection cntx, String db_name) {
        String world_create = SQL_Schema.getWORLDS();
        try {
            Statement s = cntx.createStatement();
            s.executeUpdate(world_create);
            TownyMessaging.sendDebugMsg("Table WORLDS is ok!");
        }
        catch (SQLException ee) {
            TownyMessaging.sendErrorMsg("Error Creating table WORLDS : " + ee.getMessage());
        }
        List<String> worldColumns = SQL_Schema.getWorldColumns();
        for (String column : worldColumns) {
            try {
                String world_update = "ALTER TABLE `" + db_name + "`.`" + tb_prefix + "WORLDS` ADD COLUMN " + column;
                PreparedStatement ps = cntx.prepareStatement(world_update);
                ps.executeUpdate();
            }
            catch (SQLException ee) {
                if (ee.getErrorCode() == 1060) continue;
                TownyMessaging.sendErrorMsg("Error updating table WORLDS :" + ee.getMessage());
            }
        }
        TownyMessaging.sendDebugMsg("Table WORLDS is updated!");
        TownyMessaging.sendDebugMsg("Checking done!");
        String nation_create = SQL_Schema.getNATIONS();
        try {
            Statement s = cntx.createStatement();
            s.executeUpdate(nation_create);
            TownyMessaging.sendDebugMsg("Table NATIONS is ok!");
        }
        catch (SQLException ee) {
            TownyMessaging.sendErrorMsg("Error Creating table NATIONS : " + ee.getMessage());
        }
        List<String> nationColumns = SQL_Schema.getNationColumns();
        for (String column : nationColumns) {
            try {
                String nation_update = "ALTER TABLE `" + db_name + "`.`" + tb_prefix + "NATIONS` ADD COLUMN " + column;
                PreparedStatement ps = cntx.prepareStatement(nation_update);
                ps.executeUpdate();
            }
            catch (SQLException ee) {
                if (ee.getErrorCode() == 1060) continue;
                TownyMessaging.sendErrorMsg("Error updating table NATIONS :" + ee.getMessage());
            }
        }
        TownyMessaging.sendDebugMsg("Table NATIONS is updated!");
        String town_create = SQL_Schema.getTOWNS();
        try {
            Statement s = cntx.createStatement();
            s.executeUpdate(town_create);
            TownyMessaging.sendDebugMsg("Table TOWNS is ok!");
        }
        catch (SQLException ee) {
            TownyMessaging.sendErrorMsg("Creating table TOWNS :" + ee.getMessage());
        }
        List<String> townColumns = SQL_Schema.getTownColumns();
        for (String column : townColumns) {
            try {
                String town_update = "ALTER TABLE `" + db_name + "`.`" + tb_prefix + "TOWNS` ADD COLUMN " + column;
                PreparedStatement ps = cntx.prepareStatement(town_update);
                ps.executeUpdate();
            }
            catch (SQLException ee) {
                if (ee.getErrorCode() == 1060) continue;
                TownyMessaging.sendErrorMsg("Error updating table TOWNS :" + ee.getMessage());
            }
        }
        TownyMessaging.sendDebugMsg("Table TOWNS is updated!");
        String resident_create = SQL_Schema.getRESIDENTS();
        try {
            Statement s = cntx.createStatement();
            s.executeUpdate(resident_create);
            TownyMessaging.sendDebugMsg("Table RESIDENTS is ok!");
        }
        catch (SQLException ee) {
            TownyMessaging.sendErrorMsg("Error Creating table RESIDENTS :" + ee.getMessage());
        }
        List<String> residentColumns = SQL_Schema.getResidentColumns();
        for (String column : residentColumns) {
            try {
                String resident_update = "ALTER TABLE `" + db_name + "`.`" + tb_prefix + "RESIDENTS` ADD COLUMN " + column;
                PreparedStatement ps = cntx.prepareStatement(resident_update);
                ps.executeUpdate();
            }
            catch (SQLException ee) {
                if (ee.getErrorCode() == 1060) continue;
                TownyMessaging.sendErrorMsg("Error updating table RESIDENTS :" + ee.getMessage());
            }
        }
        TownyMessaging.sendDebugMsg("Table RESIDENTS is updated!");
        String townblock_create = SQL_Schema.getTOWNBLOCKS();
        try {
            Statement s = cntx.createStatement();
            s.executeUpdate(townblock_create);
            TownyMessaging.sendDebugMsg("Table TOWNBLOCKS is ok!");
        }
        catch (SQLException ee) {
            TownyMessaging.sendErrorMsg("Error Creating table TOWNBLOCKS : " + ee.getMessage());
        }
        List<String> townBlockColumns = SQL_Schema.getTownBlockColumns();
        for (String column : townBlockColumns) {
            try {
                String townblocks_update = "ALTER TABLE `" + db_name + "`.`" + tb_prefix + "TOWNBLOCKS` ADD COLUMN " + column;
                PreparedStatement ps = cntx.prepareStatement(townblocks_update);
                ps.executeUpdate();
            }
            catch (SQLException ee) {
                if (ee.getErrorCode() == 1060) continue;
                TownyMessaging.sendErrorMsg("Error updating table TOWNBLOCKS :" + ee.getMessage());
            }
        }
        TownyMessaging.sendDebugMsg("Table TOWNBLOCKS is updated!");
    }

    @Deprecated
    public static void cleanup(Connection cntx, String db_name) {
    }
}

