/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.db;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.db.TownyDataSource;
import com.palmergames.bukkit.towny.event.DeleteNationEvent;
import com.palmergames.bukkit.towny.event.DeletePlayerEvent;
import com.palmergames.bukkit.towny.event.DeleteTownEvent;
import com.palmergames.bukkit.towny.event.PreDeleteNationEvent;
import com.palmergames.bukkit.towny.event.PreDeleteTownEvent;
import com.palmergames.bukkit.towny.event.RenameNationEvent;
import com.palmergames.bukkit.towny.event.RenameResidentEvent;
import com.palmergames.bukkit.towny.event.RenameTownEvent;
import com.palmergames.bukkit.towny.event.TownUnclaimEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.EmptyNationException;
import com.palmergames.bukkit.towny.exceptions.EmptyTownException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.war.eventwar.WarSpoils;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.NameValidation;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.naming.InvalidNameException;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public abstract class TownyDatabaseHandler
extends TownyDataSource {
    final String rootFolderPath;
    final String dataFolderPath;
    final String settingsFolderPath;
    final String logFolderPath;
    final String backupFolderPath;

    public TownyDatabaseHandler(Towny plugin, TownyUniverse universe) {
        super(plugin, universe);
        this.rootFolderPath = universe.getRootFolder();
        this.dataFolderPath = this.rootFolderPath + File.separator + "data";
        this.settingsFolderPath = this.rootFolderPath + File.separator + "settings";
        this.logFolderPath = this.rootFolderPath + File.separator + "logs";
        this.backupFolderPath = this.rootFolderPath + File.separator + "backup";
    }

    @Override
    public boolean hasResident(String name) {
        try {
            return TownySettings.isFakeResident(name) || this.universe.getResidentMap().containsKey(NameValidation.checkAndFilterPlayerName(name).toLowerCase());
        }
        catch (InvalidNameException e) {
            return false;
        }
    }

    @Override
    public boolean hasTown(String name) {
        return this.universe.getTownsMap().containsKey(name.toLowerCase());
    }

    @Override
    public boolean hasNation(String name) {
        return this.universe.getNationsMap().containsKey(name.toLowerCase());
    }

    @Override
    public List<Resident> getResidents(Player player, String[] names) {
        ArrayList<Resident> invited = new ArrayList<Resident>();
        for (String name : names) {
            try {
                Resident target = this.getResident(name);
                invited.add(target);
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            }
        }
        return invited;
    }

    @Override
    public List<Resident> getResidents(String[] names) {
        ArrayList<Resident> matches = new ArrayList<Resident>();
        for (String name : names) {
            try {
                matches.add(this.getResident(name));
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        return matches;
    }

    @Override
    public List<Resident> getResidents() {
        return new ArrayList<Resident>(this.universe.getResidentMap().values());
    }

    @Override
    public Resident getResident(String name) throws NotRegisteredException {
        try {
            name = NameValidation.checkAndFilterPlayerName(name).toLowerCase();
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        if (!this.hasResident(name)) {
            throw new NotRegisteredException(String.format("The resident '%s' is not registered.", name));
        }
        if (TownySettings.isFakeResident(name)) {
            Resident resident = new Resident(name);
            resident.setNPC(true);
            return resident;
        }
        return this.universe.getResidentMap().get(name);
    }

    @Override
    public List<Town> getTowns(String[] names) {
        ArrayList<Town> matches = new ArrayList<Town>();
        for (String name : names) {
            try {
                matches.add(this.getTown(name));
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        return matches;
    }

    @Override
    public List<Town> getTowns() {
        return new ArrayList<Town>(this.universe.getTownsMap().values());
    }

    @Override
    public Town getTown(String name) throws NotRegisteredException {
        try {
            name = NameValidation.checkAndFilterName(name).toLowerCase();
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        if (!this.hasTown(name)) {
            throw new NotRegisteredException(String.format("The town '%s' is not registered.", name));
        }
        return this.universe.getTownsMap().get(name);
    }

    @Override
    public Town getTown(UUID uuid) throws NotRegisteredException {
        String name = null;
        for (Town town : this.getTowns()) {
            if (!uuid.equals(town.getUuid())) continue;
            name = town.getName();
        }
        if (name == null) {
            throw new NotRegisteredException(String.format("The town with uuid '%s' is not registered.", uuid));
        }
        try {
            name = NameValidation.checkAndFilterName(name).toLowerCase();
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        return this.universe.getTownsMap().get(name);
    }

    @Override
    public List<Nation> getNations(String[] names) {
        ArrayList<Nation> matches = new ArrayList<Nation>();
        for (String name : names) {
            try {
                matches.add(this.getNation(name));
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        return matches;
    }

    @Override
    public List<Nation> getNations() {
        return new ArrayList<Nation>(this.universe.getNationsMap().values());
    }

    @Override
    public Nation getNation(String name) throws NotRegisteredException {
        try {
            name = NameValidation.checkAndFilterName(name).toLowerCase();
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        if (!this.hasNation(name)) {
            throw new NotRegisteredException(String.format("The nation '%s' is not registered.", name));
        }
        return this.universe.getNationsMap().get(name.toLowerCase());
    }

    @Override
    public Nation getNation(UUID uuid) throws NotRegisteredException {
        String name = null;
        for (Nation nation : this.getNations()) {
            if (!uuid.equals(nation.getUuid())) continue;
            name = nation.getName();
        }
        if (name == null) {
            throw new NotRegisteredException(String.format("The town with uuid '%s' is not registered.", uuid));
        }
        try {
            name = NameValidation.checkAndFilterName(name).toLowerCase();
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        return this.universe.getNationsMap().get(name);
    }

    @Override
    public TownyWorld getWorld(String name) throws NotRegisteredException {
        TownyWorld world = this.universe.getWorldMap().get(name.toLowerCase());
        if (world == null) {
            throw new NotRegisteredException("World not registered!");
        }
        return world;
    }

    @Override
    public List<TownyWorld> getWorlds() {
        return new ArrayList<TownyWorld>(this.universe.getWorldMap().values());
    }

    @Override
    public TownyWorld getTownWorld(String townName) {
        for (TownyWorld world : this.universe.getWorldMap().values()) {
            if (!world.hasTown(townName)) continue;
            return world;
        }
        return null;
    }

    @Override
    public void removeResident(Resident resident) {
        Town town = null;
        if (resident.hasTown()) {
            try {
                town = resident.getTown();
            }
            catch (NotRegisteredException e1) {
                e1.printStackTrace();
            }
        }
        try {
            if (town != null) {
                town.removeResident(resident);
                if (town.hasNation()) {
                    this.saveNation(town.getNation());
                }
                this.saveTown(town);
            }
            resident.clear();
        }
        catch (EmptyTownException e) {
            this.removeTown(town);
        }
        catch (NotRegisteredException e) {
            e.printStackTrace();
        }
        try {
            for (Town townOutlaw : this.getTowns()) {
                if (!townOutlaw.hasOutlaw(resident)) continue;
                townOutlaw.removeOutlaw(resident);
                this.saveTown(townOutlaw);
            }
        }
        catch (NotRegisteredException e) {
            e.printStackTrace();
        }
        BukkitTools.getPluginManager().callEvent((Event)new DeletePlayerEvent(resident.getName()));
    }

    public void removeOneOfManyTownBlocks(TownBlock townBlock, Town town) {
        PlotBlockData plotData;
        Resident resident = null;
        try {
            resident = townBlock.getResident();
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        TownyWorld world = townBlock.getWorld();
        WorldCoord coord = townBlock.getWorldCoord();
        if (world.isUsingPlotManagementDelete()) {
            TownyRegenAPI.addDeleteTownBlockIdQueue(coord);
        }
        if (world.isUsingPlotManagementRevert() && (plotData = TownyRegenAPI.getPlotChunkSnapshot(townBlock)) != null && !plotData.getBlockList().isEmpty()) {
            TownyRegenAPI.addPlotChunk(plotData, true);
        }
        this.deleteTownBlock(townBlock);
        townBlock.clear();
        if (resident != null) {
            this.saveResident(resident);
        }
        world.removeTownBlock(townBlock);
        BukkitTools.getPluginManager().callEvent((Event)new TownUnclaimEvent(town, coord));
    }

    @Override
    public void removeTownBlock(TownBlock townBlock) {
        PlotBlockData plotData;
        Resident resident = null;
        Town town = null;
        try {
            resident = townBlock.getResident();
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        try {
            town = townBlock.getTown();
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        TownyWorld world = townBlock.getWorld();
        world.removeTownBlock(townBlock);
        this.saveWorld(world);
        this.deleteTownBlock(townBlock);
        this.saveTownBlockList();
        if (resident != null) {
            this.saveResident(resident);
        }
        if (townBlock.getWorld().isUsingPlotManagementDelete()) {
            TownyRegenAPI.addDeleteTownBlockIdQueue(townBlock.getWorldCoord());
        }
        if (townBlock.getWorld().isUsingPlotManagementRevert() && (plotData = TownyRegenAPI.getPlotChunkSnapshot(townBlock)) != null && !plotData.getBlockList().isEmpty()) {
            TownyRegenAPI.addPlotChunk(plotData, true);
        }
        BukkitTools.getPluginManager().callEvent((Event)new TownUnclaimEvent(town, townBlock.getWorldCoord()));
    }

    @Override
    public void removeTownBlocks(Town town) {
        for (TownBlock townBlock : new ArrayList<TownBlock>(town.getTownBlocks())) {
            this.removeTownBlock(townBlock);
        }
    }

    public void removeManyTownBlocks(Town town) {
        for (TownBlock townBlock : new ArrayList<TownBlock>(town.getTownBlocks())) {
            this.removeOneOfManyTownBlocks(townBlock, town);
        }
        this.saveTownBlockList();
    }

    @Override
    public List<TownBlock> getAllTownBlocks() {
        ArrayList<TownBlock> townBlocks = new ArrayList<TownBlock>();
        for (TownyWorld world : this.getWorlds()) {
            townBlocks.addAll(world.getTownBlocks());
        }
        return townBlocks;
    }

    @Override
    public void newResident(String name) throws AlreadyRegisteredException, NotRegisteredException {
        String filteredName;
        try {
            filteredName = NameValidation.checkAndFilterPlayerName(name);
        }
        catch (InvalidNameException e) {
            throw new NotRegisteredException(e.getMessage());
        }
        if (this.universe.getResidentMap().containsKey(filteredName.toLowerCase())) {
            throw new AlreadyRegisteredException("A resident with the name " + filteredName + " is already in use.");
        }
        this.universe.getResidentMap().put(filteredName.toLowerCase(), new Resident(filteredName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newTown(String name) throws AlreadyRegisteredException, NotRegisteredException {
        this.lock.lock();
        try {
            String filteredName;
            try {
                filteredName = NameValidation.checkAndFilterName(name);
            }
            catch (InvalidNameException e) {
                throw new NotRegisteredException(e.getMessage());
            }
            if (this.universe.getTownsMap().containsKey(filteredName.toLowerCase())) {
                throw new AlreadyRegisteredException("The town " + filteredName + " is already in use.");
            }
            this.universe.getTownsMap().put(filteredName.toLowerCase(), new Town(filteredName));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newNation(String name) throws AlreadyRegisteredException, NotRegisteredException {
        this.lock.lock();
        try {
            String filteredName;
            try {
                filteredName = NameValidation.checkAndFilterName(name);
            }
            catch (InvalidNameException e) {
                throw new NotRegisteredException(e.getMessage());
            }
            if (this.universe.getNationsMap().containsKey(filteredName.toLowerCase())) {
                throw new AlreadyRegisteredException("The nation " + filteredName + " is already in use.");
            }
            this.universe.getNationsMap().put(filteredName.toLowerCase(), new Nation(filteredName));
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void newWorld(String name) throws AlreadyRegisteredException {
        if (this.universe.getWorldMap().containsKey(name.toLowerCase())) {
            throw new AlreadyRegisteredException("The world " + name + " is already in use.");
        }
        this.universe.getWorldMap().put(name.toLowerCase(), new TownyWorld(name));
    }

    @Override
    public void removeResidentList(Resident resident) {
        String name = resident.getName();
        ArrayList<Resident> toSave = new ArrayList<Resident>();
        for (Resident toCheck : new ArrayList<Resident>(this.universe.getResidentMap().values())) {
            TownyMessaging.sendDebugMsg("Checking friends of: " + toCheck.getName());
            if (!toCheck.hasFriend(resident)) continue;
            try {
                TownyMessaging.sendDebugMsg("       - Removing Friend: " + resident.getName());
                toCheck.removeFriend(resident);
                toSave.add(toCheck);
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
            }
        }
        for (Resident toCheck : toSave) {
            this.saveResident(toCheck);
        }
        try {
            resident.clear();
        }
        catch (EmptyTownException ex) {
            this.removeTown(ex.getTown());
        }
        this.deleteResident(resident);
        this.universe.getResidentMap().remove(name.toLowerCase());
        if (TownySettings.isUsingEconomy() && TownySettings.isDeleteEcoAccount()) {
            resident.removeAccount();
        }
        this.plugin.deleteCache(name);
        this.saveResidentList();
    }

    @Override
    public void removeTown(Town town) {
        PreDeleteTownEvent preEvent = new PreDeleteTownEvent(town);
        BukkitTools.getPluginManager().callEvent((Event)preEvent);
        if (preEvent.isCancelled()) {
            return;
        }
        this.removeTownBlocks(town);
        ArrayList<Resident> toSave = new ArrayList<Resident>(town.getResidents());
        TownyWorld townyWorld = town.getWorld();
        try {
            if (town.hasNation()) {
                Nation nation = town.getNation();
                if (nation.hasTown(town)) {
                    nation.removeTown(town);
                    this.saveNation(nation);
                }
                town.setNation(null);
            }
            town.clear();
        }
        catch (EmptyNationException e) {
            this.removeNation(e.getNation());
            TownyMessaging.sendGlobalMessage(String.format(TownySettings.getLangString("msg_del_nation"), e.getNation()));
        }
        catch (NotRegisteredException e) {
            e.printStackTrace();
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            // empty catch block
        }
        for (Resident resident : toSave) {
            resident.clearModes();
            this.removeResident(resident);
            this.saveResident(resident);
        }
        for (Resident jailedRes : TownyUniverse.getInstance().getJailedResidentMap()) {
            if (!jailedRes.hasJailTown(town.getName())) continue;
            jailedRes.setJailed(jailedRes, 0, town);
            this.saveResident(jailedRes);
        }
        if (TownyEconomyHandler.isActive()) {
            try {
                town.payTo(town.getHoldingBalance(), new WarSpoils(), "Remove Town");
                town.removeAccount();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.universe.getTownsMap().remove(town.getName().toLowerCase());
        this.plugin.resetCache();
        this.deleteTown(town);
        this.saveTownList();
        try {
            townyWorld.removeTown(town);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        this.saveWorld(townyWorld);
        BukkitTools.getPluginManager().callEvent((Event)new DeleteTownEvent(town.getName()));
    }

    @Override
    public void removeNation(Nation nation) {
        PreDeleteNationEvent preEvent = new PreDeleteNationEvent(nation.getName());
        BukkitTools.getPluginManager().callEvent((Event)preEvent);
        if (preEvent.isCancelled()) {
            return;
        }
        ArrayList<Nation> toSaveNation = new ArrayList<Nation>();
        for (Nation toCheck : new ArrayList<Nation>(this.universe.getNationsMap().values())) {
            if (!toCheck.hasAlly(nation) && !toCheck.hasEnemy(nation)) continue;
            try {
                if (toCheck.hasAlly(nation)) {
                    toCheck.removeAlly(nation);
                } else {
                    toCheck.removeEnemy(nation);
                }
                toSaveNation.add(toCheck);
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
            }
        }
        for (Nation toCheck : toSaveNation) {
            this.saveNation(toCheck);
        }
        if (TownyEconomyHandler.isActive()) {
            try {
                nation.payTo(nation.getHoldingBalance(), new WarSpoils(), "Remove Nation");
                nation.removeAccount();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.deleteNation(nation);
        ArrayList<Town> toSave = new ArrayList<Town>(nation.getTowns());
        nation.clear();
        this.universe.getNationsMap().remove(nation.getName().toLowerCase());
        for (Town town : toSave) {
            ArrayList<Resident> titleRemove = new ArrayList<Resident>(town.getResidents());
            for (Resident res : titleRemove) {
                if (!res.hasTitle() && !res.hasSurname()) continue;
                res.setTitle("");
                res.setSurname("");
                this.saveResident(res);
            }
            this.saveTown(town);
        }
        this.plugin.resetCache();
        this.saveNationList();
        BukkitTools.getPluginManager().callEvent((Event)new DeleteNationEvent(nation.getName()));
    }

    @Override
    public void removeWorld(TownyWorld world) throws UnsupportedOperationException {
        this.deleteWorld(world);
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getResidentKeys() {
        return this.universe.getResidentMap().keySet();
    }

    @Override
    public Set<String> getTownsKeys() {
        return this.universe.getTownsMap().keySet();
    }

    @Override
    public Set<String> getNationsKeys() {
        return this.universe.getNationsMap().keySet();
    }

    @Override
    public List<Town> getTownsWithoutNation() {
        ArrayList<Town> townFilter = new ArrayList<Town>();
        for (Town town : this.getTowns()) {
            if (town.hasNation()) continue;
            townFilter.add(town);
        }
        return townFilter;
    }

    @Override
    public List<Resident> getResidentsWithoutTown() {
        ArrayList<Resident> residentFilter = new ArrayList<Resident>();
        for (Resident resident : this.universe.getResidentMap().values()) {
            if (resident.hasTown()) continue;
            residentFilter.add(resident);
        }
        return residentFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameTown(Town town, String newName) throws AlreadyRegisteredException, NotRegisteredException {
        String oldName;
        this.lock.lock();
        try {
            String filteredName;
            try {
                filteredName = NameValidation.checkAndFilterName(newName);
            }
            catch (InvalidNameException e) {
                throw new NotRegisteredException(e.getMessage());
            }
            if (this.hasTown(filteredName)) {
                throw new AlreadyRegisteredException("The town " + filteredName + " is already in use.");
            }
            ArrayList<Resident> toSave = new ArrayList<Resident>(town.getResidents());
            boolean isCapital = false;
            Nation nation = null;
            double townBalance = 0.0;
            oldName = town.getName();
            if (TownySettings.isUsingEconomy()) {
                try {
                    townBalance = town.getHoldingBalance();
                    if (TownySettings.isEcoClosedEconomyEnabled()) {
                        town.pay(townBalance, "Town Rename");
                    }
                    town.removeAccount();
                }
                catch (EconomyException economyException) {
                    // empty catch block
                }
            }
            UUID oldUUID = town.getUuid();
            long oldregistration = town.getRegistered();
            if (town.hasNation()) {
                nation = town.getNation();
                isCapital = town.isCapital();
            }
            this.deleteTown(town);
            this.universe.getTownsMap().remove(town.getName().toLowerCase());
            town.setName(filteredName);
            this.universe.getTownsMap().put(filteredName.toLowerCase(), town);
            if (isCapital) {
                nation.setCapital(town);
            }
            town.setUuid(oldUUID);
            town.setRegistered(oldregistration);
            if (TownySettings.isUsingEconomy()) {
                try {
                    town.setBalance(townBalance, "Rename Town - Transfer to new account");
                }
                catch (EconomyException e) {
                    e.printStackTrace();
                }
            }
            for (Resident resident : toSave) {
                this.saveResident(resident);
            }
            for (Resident toCheck : this.getResidents()) {
                if (!toCheck.hasJailTown(oldName)) continue;
                toCheck.setJailTown(newName);
                this.saveResident(toCheck);
            }
            for (TownBlock townBlock : town.getTownBlocks()) {
                this.saveTownBlock(townBlock);
            }
            this.saveTown(town);
            this.saveTownList();
            this.saveWorld(town.getWorld());
            if (nation != null) {
                this.saveNation(nation);
            }
        }
        finally {
            this.lock.unlock();
        }
        BukkitTools.getPluginManager().callEvent((Event)new RenameTownEvent(oldName, town));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameNation(Nation nation, String newName) throws AlreadyRegisteredException, NotRegisteredException {
        String oldName;
        this.lock.lock();
        try {
            String filteredName;
            try {
                filteredName = NameValidation.checkAndFilterName(newName);
            }
            catch (InvalidNameException e) {
                throw new NotRegisteredException(e.getMessage());
            }
            if (this.hasNation(filteredName)) {
                throw new AlreadyRegisteredException("The nation " + filteredName + " is already in use.");
            }
            ArrayList<Town> toSave = new ArrayList<Town>(nation.getTowns());
            double nationBalance = 0.0;
            if (TownySettings.isUsingEconomy()) {
                try {
                    nationBalance = nation.getHoldingBalance();
                    if (TownySettings.isEcoClosedEconomyEnabled()) {
                        nation.pay(nationBalance, "Nation Rename");
                    }
                    nation.removeAccount();
                }
                catch (EconomyException economyException) {
                    // empty catch block
                }
            }
            UUID oldUUID = nation.getUuid();
            long oldregistration = nation.getRegistered();
            this.deleteNation(nation);
            oldName = nation.getName();
            this.universe.getNationsMap().remove(oldName.toLowerCase());
            nation.setName(filteredName);
            this.universe.getNationsMap().put(filteredName.toLowerCase(), nation);
            if (TownyEconomyHandler.isActive()) {
                try {
                    nation.setBalance(nationBalance, "Rename Nation - Transfer to new account");
                }
                catch (EconomyException e) {
                    e.printStackTrace();
                }
            }
            nation.setUuid(oldUUID);
            nation.setRegistered(oldregistration);
            for (Town town : toSave) {
                this.saveTown(town);
            }
            this.saveNation(nation);
            this.saveNationList();
            Nation oldNation = new Nation(oldName);
            ArrayList<Nation> toSaveNation = new ArrayList<Nation>(this.getNations());
            for (Nation toCheck : toSaveNation) {
                if (toCheck.hasAlly(oldNation) || toCheck.hasEnemy(oldNation)) {
                    try {
                        if (toCheck.hasAlly(oldNation)) {
                            toCheck.removeAlly(oldNation);
                            toCheck.addAlly(nation);
                            continue;
                        }
                        toCheck.removeEnemy(oldNation);
                        toCheck.addEnemy(nation);
                    }
                    catch (NotRegisteredException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                toSave.remove(toCheck);
            }
            for (Nation toCheck : toSaveNation) {
                this.saveNation(toCheck);
            }
        }
        finally {
            this.lock.unlock();
        }
        BukkitTools.getPluginManager().callEvent((Event)new RenameNationEvent(oldName, nation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renamePlayer(Resident resident, String newName) throws AlreadyRegisteredException, NotRegisteredException {
        this.lock.lock();
        String oldName = resident.getName();
        try {
            double balance = 0.0;
            Town town = null;
            if (TownyEconomyHandler.getVersion().startsWith("iConomy 5") && TownySettings.isUsingEconomy()) {
                try {
                    balance = resident.getHoldingBalance();
                    resident.removeAccount();
                }
                catch (EconomyException economyException) {
                    // empty catch block
                }
            }
            List<Resident> friends = resident.getFriends();
            List<String> nationRanks = resident.getNationRanks();
            TownyPermission permissions = resident.getPermissions();
            String surname = resident.getSurname();
            String title = resident.getTitle();
            if (resident.hasTown()) {
                town = resident.getTown();
            }
            List<TownBlock> townBlocks = resident.getTownBlocks();
            List<String> townRanks = resident.getTownRanks();
            long registered = resident.getRegistered();
            long lastOnline = resident.getLastOnline();
            boolean isMayor = resident.isMayor();
            boolean isJailed = resident.isJailed();
            int JailSpawn = resident.getJailSpawn();
            if (resident.isJailed()) {
                try {
                    this.universe.getJailedResidentMap().remove(this.universe.getDataSource().getResident(oldName));
                    this.universe.getJailedResidentMap().add(this.universe.getDataSource().getResident(newName));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.deleteResident(resident);
            this.universe.getResidentMap().remove(oldName.toLowerCase());
            resident.setName(newName);
            this.universe.getResidentMap().put(newName.toLowerCase(), resident);
            if (TownyEconomyHandler.getVersion().startsWith("iConomy 5") && TownySettings.isUsingEconomy()) {
                try {
                    resident.setBalance(balance, "Rename Player - Transfer to new account");
                }
                catch (EconomyException e) {
                    e.printStackTrace();
                }
            }
            resident.setFriends(friends);
            resident.setNationRanks(nationRanks);
            resident.setPermissions(permissions.toString());
            resident.setSurname(surname);
            resident.setTitle(title);
            resident.setTown(town);
            resident.setTownblocks(townBlocks);
            resident.setTownRanks(townRanks);
            resident.setRegistered(registered);
            resident.setLastOnline(lastOnline);
            if (isMayor) {
                try {
                    town.setMayor(resident);
                }
                catch (TownyException e) {
                    // empty catch block
                }
            }
            resident.setJailed(isJailed);
            resident.setJailSpawn(JailSpawn);
            this.saveResidentList();
            this.saveResident(resident);
            if (town != null) {
                this.saveTown(town);
            }
            for (TownBlock tb : townBlocks) {
                this.saveTownBlock(tb);
            }
            Resident oldResident = new Resident(oldName);
            ArrayList<Resident> toSaveResident = new ArrayList<Resident>(this.getResidents());
            for (Resident toCheck : toSaveResident) {
                if (!toCheck.hasFriend(oldResident)) continue;
                try {
                    toCheck.removeFriend(oldResident);
                    toCheck.addFriend(resident);
                }
                catch (NotRegisteredException e) {
                    e.printStackTrace();
                }
            }
            for (Resident toCheck : toSaveResident) {
                this.saveResident(toCheck);
            }
            ArrayList<Town> toSaveTown = new ArrayList<Town>(this.getTowns());
            for (Town toCheckTown : toSaveTown) {
                if (!toCheckTown.hasOutlaw(oldResident)) continue;
                try {
                    toCheckTown.removeOutlaw(oldResident);
                    toCheckTown.addOutlaw(resident);
                }
                catch (NotRegisteredException e) {
                    e.printStackTrace();
                }
            }
            for (Town toCheckTown : toSaveTown) {
                this.saveTown(toCheckTown);
            }
        }
        finally {
            this.lock.unlock();
        }
        BukkitTools.getPluginManager().callEvent((Event)new RenameResidentEvent(oldName, resident));
    }

    @Override
    public void mergeNation(Nation succumbingNation, Nation prevailingNation) throws NotRegisteredException, AlreadyRegisteredException {
        this.lock.lock();
        ArrayList<Town> towns = new ArrayList<Town>(succumbingNation.getTowns());
        Town lastTown = null;
        try {
            succumbingNation.payTo(succumbingNation.getHoldingBalance(), prevailingNation, "Nation merge bank accounts.");
            Iterator iterator = towns.iterator();
            while (iterator.hasNext()) {
                Town town;
                lastTown = town = (Town)iterator.next();
                for (Resident res : town.getResidents()) {
                    if (res.hasTitle() || res.hasSurname()) {
                        res.setTitle("");
                        res.setSurname("");
                    }
                    res.updatePermsForNationRemoval();
                    this.saveResident(res);
                }
                succumbingNation.removeTown(town);
                prevailingNation.addTown(town);
                this.saveTown(town);
            }
        }
        catch (EconomyException economyException) {
        }
        catch (EmptyNationException en) {
            prevailingNation.addTown(lastTown);
            this.saveTown(lastTown);
            String name = en.getNation().getName();
            this.universe.getDataSource().removeNation(en.getNation());
            this.saveNation(prevailingNation);
            this.universe.getDataSource().saveNationList();
            TownyMessaging.sendGlobalMessage(ChatTools.color(String.format(TownySettings.getLangString("msg_del_nation"), name)));
            this.lock.unlock();
        }
    }
}

