/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.db;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.db.FlatFile_Task;
import com.palmergames.bukkit.towny.db.TownyDatabaseHandler;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.FileMgmt;
import com.palmergames.util.StringMgmt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.naming.InvalidNameException;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public final class TownyFlatFileSource
extends TownyDatabaseHandler {
    private final Queue<FlatFile_Task> queryQueue = new ConcurrentLinkedQueue<FlatFile_Task>();
    private final BukkitTask task;
    private final String newLine = System.getProperty("line.separator");

    public TownyFlatFileSource(Towny plugin, TownyUniverse universe) {
        super(plugin, universe);
        if (!FileMgmt.checkOrCreateFolders(this.rootFolderPath, this.dataFolderPath, this.dataFolderPath + File.separator + "residents", this.dataFolderPath + File.separator + "towns", this.dataFolderPath + File.separator + "towns" + File.separator + "deleted", this.dataFolderPath + File.separator + "nations", this.dataFolderPath + File.separator + "nations" + File.separator + "deleted", this.dataFolderPath + File.separator + "worlds", this.dataFolderPath + File.separator + "worlds" + File.separator + "deleted", this.dataFolderPath + File.separator + "plot-block-data", this.dataFolderPath + File.separator + "townblocks") || !FileMgmt.checkOrCreateFiles(this.dataFolderPath + File.separator + "townblocks.txt", this.dataFolderPath + File.separator + "residents.txt", this.dataFolderPath + File.separator + "towns.txt", this.dataFolderPath + File.separator + "nations.txt", this.dataFolderPath + File.separator + "worlds.txt", this.dataFolderPath + File.separator + "regen.txt", this.dataFolderPath + File.separator + "snapshot_queue.txt")) {
            TownyMessaging.sendErrorMsg("Could not create flatfile default files and folders.");
        }
        this.task = BukkitTools.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, () -> {
            while (!this.queryQueue.isEmpty()) {
                FlatFile_Task query = this.queryQueue.poll();
                try {
                    FileMgmt.listToFile(query.list, query.path);
                }
                catch (NullPointerException ex) {
                    TownyMessaging.sendErrorMsg("Null Error saving to file - " + query.path);
                }
            }
        }, 5L, 5L);
    }

    @Override
    public void cancelTask() {
        this.task.cancel();
    }

    @Override
    public synchronized boolean backup() throws IOException {
        String backupType = TownySettings.getFlatFileBackupType();
        long t = System.currentTimeMillis();
        String newBackupFolder = this.backupFolderPath + File.separator + new SimpleDateFormat("yyyy-MM-dd HH-mm").format(t) + " - " + t;
        FileMgmt.checkOrCreateFolders(this.rootFolderPath, this.rootFolderPath + File.separator + "backup");
        switch (backupType.toLowerCase()) {
            case "folder": {
                FileMgmt.checkOrCreateFolder(newBackupFolder);
                FileMgmt.copyDirectory(new File(this.dataFolderPath), new File(newBackupFolder));
                FileMgmt.copyDirectory(new File(this.logFolderPath), new File(newBackupFolder));
                FileMgmt.copyDirectory(new File(this.settingsFolderPath), new File(newBackupFolder));
                return true;
            }
            case "zip": {
                FileMgmt.zipDirectories(new File(newBackupFolder + ".zip"), new File(this.dataFolderPath), new File(this.logFolderPath), new File(this.settingsFolderPath));
                return true;
            }
        }
        return false;
    }

    @Override
    public void cleanupBackups() {
        long deleteAfter = TownySettings.getBackupLifeLength();
        if (deleteAfter >= 0L) {
            FileMgmt.deleteOldBackups(new File(this.universe.getRootFolder() + File.separator + "backup"), deleteAfter);
        }
    }

    @Override
    public synchronized void deleteUnusedResidents() {
        String path = this.dataFolderPath + File.separator + "residents";
        Set<String> names = this.getResidentKeys();
        FileMgmt.deleteUnusedFiles(new File(path), names);
        path = this.dataFolderPath + File.separator + "towns";
        names = this.getTownsKeys();
        FileMgmt.deleteUnusedFiles(new File(path), names);
        path = this.dataFolderPath + File.separator + "nations";
        names = this.getNationsKeys();
        FileMgmt.deleteUnusedFiles(new File(path), names);
    }

    public String getResidentFilename(Resident resident) {
        return this.dataFolderPath + File.separator + "residents" + File.separator + resident.getName() + ".txt";
    }

    public String getTownFilename(Town town) {
        return this.dataFolderPath + File.separator + "towns" + File.separator + town.getName() + ".txt";
    }

    public String getNationFilename(Nation nation) {
        return this.dataFolderPath + File.separator + "nations" + File.separator + nation.getName() + ".txt";
    }

    public String getWorldFilename(TownyWorld world) {
        return this.dataFolderPath + File.separator + "worlds" + File.separator + world.getName() + ".txt";
    }

    public String getPlotFilename(PlotBlockData plotChunk) {
        return this.dataFolderPath + File.separator + "plot-block-data" + File.separator + plotChunk.getWorldName() + File.separator + plotChunk.getX() + "_" + plotChunk.getZ() + "_" + plotChunk.getSize() + ".data";
    }

    public String getPlotFilename(TownBlock townBlock) {
        return this.dataFolderPath + File.separator + "plot-block-data" + File.separator + townBlock.getWorld().getName() + File.separator + townBlock.getX() + "_" + townBlock.getZ() + "_" + TownySettings.getTownBlockSize() + ".data";
    }

    public String getTownBlockFilename(TownBlock townBlock) {
        return this.dataFolderPath + File.separator + "townblocks" + File.separator + townBlock.getWorld().getName() + File.separator + townBlock.getX() + "_" + townBlock.getZ() + "_" + TownySettings.getTownBlockSize() + ".data";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadTownBlockList() {
        TownyMessaging.sendDebugMsg("Loading TownBlock List");
        String line = null;
        try (BufferedReader fin = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.dataFolderPath + File.separator + "townblocks.txt"), StandardCharsets.UTF_8));){
            while ((line = fin.readLine()) != null) {
                TownyWorld world;
                String[] tokens;
                if (line.equals("") || (tokens = line.split(",")).length < 3) continue;
                try {
                    world = this.getWorld(tokens[0]);
                }
                catch (NotRegisteredException ex) {
                    this.newWorld(tokens[0]);
                    world = this.getWorld(tokens[0]);
                }
                int x = Integer.parseInt(tokens[1]);
                int z = Integer.parseInt(tokens[2]);
                try {
                    world.newTownBlock(x, z);
                }
                catch (AlreadyRegisteredException alreadyRegisteredException) {
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("Error Loading Townblock List at " + line + ", in towny\\data\\townblocks.txt");
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean loadResidentList() {
        boolean bl;
        TownyMessaging.sendDebugMsg("Loading Resident List");
        String line = null;
        BufferedReader fin = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.dataFolderPath + File.separator + "residents.txt"), StandardCharsets.UTF_8));
        try {
            while ((line = fin.readLine()) != null) {
                if (line.equals("")) continue;
                this.newResident(line);
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fin.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (AlreadyRegisteredException e) {
                TownyMessaging.sendErrorMsg("Error Loading Resident List at " + line + ", resident is possibly listed twice.");
                e.printStackTrace();
                return false;
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg("Error Loading Resident List at " + line + ", in towny\\data\\residents.txt");
                e.printStackTrace();
                return false;
            }
        }
        fin.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadTownList() {
        BufferedReader fin;
        TownyMessaging.sendDebugMsg("Loading Town List");
        String line = null;
        try {
            fin = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.dataFolderPath + File.separator + "towns.txt"), StandardCharsets.UTF_8));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        try {
            while ((line = fin.readLine()) != null) {
                if (line.equals("")) continue;
                this.newTown(line);
            }
            boolean e = true;
            return e;
        }
        catch (AlreadyRegisteredException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("Error Loading Town List at " + line + ", in towny\\data\\towns.txt");
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadNationList() {
        BufferedReader fin;
        TownyMessaging.sendDebugMsg("Loading Nation List");
        String line = null;
        try {
            fin = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.dataFolderPath + File.separator + "nations.txt"), StandardCharsets.UTF_8));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        try {
            while ((line = fin.readLine()) != null) {
                if (line.equals("")) continue;
                this.newNation(line);
            }
            boolean e = true;
            return e;
        }
        catch (AlreadyRegisteredException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("Error Loading Nation List at " + line + ", in towny\\data\\nations.txt");
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                fin.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public boolean loadWorldList() {
        boolean bl;
        if (this.plugin != null) {
            TownyMessaging.sendDebugMsg("Loading Server World List");
            for (World world : this.plugin.getServer().getWorlds()) {
                try {
                    this.newWorld(world.getName());
                }
                catch (AlreadyRegisteredException alreadyRegisteredException) {}
            }
        }
        TownyMessaging.sendDebugMsg("Loading World List");
        String line = null;
        BufferedReader fin = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.dataFolderPath + File.separator + "worlds.txt"), StandardCharsets.UTF_8));
        try {
            while ((line = fin.readLine()) != null) {
                if (line.equals("")) continue;
                this.newWorld(line);
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fin.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (AlreadyRegisteredException e) {
                return true;
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg("Error Loading World List at " + line + ", in towny\\data\\worlds.txt");
                e.printStackTrace();
                return false;
            }
        }
        fin.close();
        return bl;
    }

    @Override
    public boolean loadRegenList() {
        boolean bl;
        TownyMessaging.sendDebugMsg("Loading Regen List");
        String line = null;
        BufferedReader fin = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.dataFolderPath + File.separator + "regen.txt"), StandardCharsets.UTF_8));
        try {
            while ((line = fin.readLine()) != null) {
                String[] split;
                PlotBlockData plotData;
                if (line.equals("") || (plotData = this.loadPlotData((split = line.split(","))[0], Integer.parseInt(split[1]), Integer.parseInt(split[2]))) == null) continue;
                TownyRegenAPI.addPlotChunk(plotData, false);
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fin.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg("Error Loading Regen List at " + line + ", in towny\\data\\regen.txt");
                e.printStackTrace();
                return false;
            }
        }
        fin.close();
        return bl;
    }

    @Override
    public boolean loadSnapshotList() {
        boolean bl;
        TownyMessaging.sendDebugMsg("Loading Snapshot Queue");
        String line = null;
        BufferedReader fin = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.dataFolderPath + File.separator + "snapshot_queue.txt"), StandardCharsets.UTF_8));
        try {
            while ((line = fin.readLine()) != null) {
                if (line.equals("")) continue;
                String[] split = line.split(",");
                WorldCoord worldCoord = new WorldCoord(split[0], Integer.parseInt(split[1]), Integer.parseInt(split[2]));
                TownyRegenAPI.addWorldCoord(worldCoord);
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fin.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg("Error Loading Snapshot Queue List at " + line + ", in towny\\data\\snapshot_queue.txt");
                e.printStackTrace();
                return false;
            }
        }
        fin.close();
        return bl;
    }

    @Override
    public boolean loadResident(Resident resident) {
        String line = null;
        String path = this.getResidentFilename(resident);
        File fileResident = new File(path);
        if (fileResident.exists() && fileResident.isFile()) {
            try {
                HashMap<String, String> keys = new HashMap<String, String>();
                Properties properties = new Properties();
                properties.load(new InputStreamReader((InputStream)new FileInputStream(fileResident), StandardCharsets.UTF_8));
                for (String key : properties.stringPropertyNames()) {
                    String value = properties.getProperty(key);
                    keys.put(key, String.valueOf(value));
                }
                resident.setLastOnline(Long.parseLong((String)keys.get("lastOnline")));
                line = (String)keys.get("registered");
                if (line != null) {
                    resident.setRegistered(Long.parseLong(line));
                } else {
                    resident.setRegistered(resident.getLastOnline());
                }
                line = (String)keys.get("isNPC");
                if (line != null) {
                    resident.setNPC(Boolean.parseBoolean(line));
                }
                if ((line = (String)keys.get("isJailed")) != null) {
                    resident.setJailed(Boolean.parseBoolean(line));
                }
                if ((line = (String)keys.get("JailSpawn")) != null) {
                    resident.setJailSpawn(Integer.valueOf(line));
                }
                if ((line = (String)keys.get("JailDays")) != null) {
                    resident.setJailDays(Integer.valueOf(line));
                }
                if ((line = (String)keys.get("JailTown")) != null) {
                    resident.setJailTown(line);
                }
                if ((line = (String)keys.get("title")) != null) {
                    resident.setTitle(line);
                }
                if ((line = (String)keys.get("surname")) != null) {
                    resident.setSurname(line);
                }
                if ((line = (String)keys.get("town")) != null) {
                    resident.setTown(this.getTown(line));
                }
                if ((line = (String)keys.get("town-ranks")) != null) {
                    resident.setTownRanks(new ArrayList<String>(Arrays.asList(line.split(","))));
                }
                if ((line = (String)keys.get("nation-ranks")) != null) {
                    resident.setNationRanks(new ArrayList<String>(Arrays.asList(line.split(","))));
                }
                if ((line = (String)keys.get("friends")) != null) {
                    String[] tokens;
                    for (String token : tokens = line.split(",")) {
                        Resident friend;
                        if (token.isEmpty() || (friend = this.getResident(token)) == null) continue;
                        resident.addFriend(friend);
                    }
                }
                if ((line = (String)keys.get("protectionStatus")) != null) {
                    resident.setPermissions(line);
                }
                if ((line = (String)keys.get("townBlocks")) != null) {
                    this.utilLoadTownBlocks(line, null, resident);
                }
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg("Loading Error: Exception while reading resident file " + resident.getName() + " at line: " + line + ", in towny\\data\\residents\\" + resident.getName() + ".txt");
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadTown(Town town) {
        String line = null;
        String path = this.getTownFilename(town);
        File fileTown = new File(path);
        if (fileTown.exists() && fileTown.isFile()) {
            try {
                Location loc;
                double z;
                double y;
                double x;
                TownyWorld world;
                String[] tokens;
                HashMap<String, String> keys = new HashMap<String, String>();
                Properties properties = new Properties();
                properties.load(new InputStreamReader((InputStream)new FileInputStream(fileTown), StandardCharsets.UTF_8));
                for (String key : properties.stringPropertyNames()) {
                    String value = properties.getProperty(key);
                    keys.put(key, String.valueOf(value));
                }
                line = (String)keys.get("residents");
                if (line != null) {
                    for (String token : tokens = line.split(",")) {
                        if (token.isEmpty()) continue;
                        TownyMessaging.sendDebugMsg("Town Fetching Resident: " + token);
                        try {
                            Resident resident = this.getResident(token);
                            if (resident == null) continue;
                            try {
                                town.addResident(resident);
                            }
                            catch (AlreadyRegisteredException e) {
                                TownyMessaging.sendErrorMsg("Loading Error: " + resident.getName() + " is already a member of a town (" + resident.getTown().getName() + ").");
                            }
                        }
                        catch (NotRegisteredException e) {
                            TownyMessaging.sendErrorMsg("Loading Error: Exception while reading a resident in the town file of " + town.getName() + ".txt. The resident " + token + " does not exist, removing them from town... (Will require manual editing of the town file if they are the mayor)");
                        }
                    }
                }
                if ((line = (String)keys.get("outlaws")) != null) {
                    for (String token : tokens = line.split(",")) {
                        if (token.isEmpty()) continue;
                        TownyMessaging.sendDebugMsg("Town Fetching Outlaw: " + token);
                        try {
                            Resident outlaw = this.getResident(token);
                            if (outlaw == null) continue;
                            town.addOutlaw(outlaw);
                        }
                        catch (NotRegisteredException e) {
                            TownyMessaging.sendErrorMsg("Loading Error: Exception while reading an outlaw of town file " + town.getName() + ".txt. The outlaw " + token + " does not exist, removing from list...");
                        }
                    }
                }
                if ((line = (String)keys.get("mayor")) != null) {
                    town.setMayor(this.getResident(line));
                }
                town.setTownBoard((String)keys.get("townBoard"));
                line = (String)keys.get("tag");
                if (line != null) {
                    try {
                        town.setTag(line);
                    }
                    catch (TownyException e) {
                        town.setTag("");
                    }
                }
                if ((line = (String)keys.get("protectionStatus")) != null) {
                    town.setPermissions(line);
                }
                if ((line = (String)keys.get("bonusBlocks")) != null) {
                    try {
                        town.setBonusBlocks(Integer.parseInt(line));
                    }
                    catch (Exception e) {
                        town.setBonusBlocks(0);
                    }
                }
                if ((line = (String)keys.get("purchasedBlocks")) != null) {
                    try {
                        town.setPurchasedBlocks(Integer.parseInt(line));
                    }
                    catch (Exception e) {
                        town.setPurchasedBlocks(0);
                    }
                }
                if ((line = (String)keys.get("plotPrice")) != null) {
                    try {
                        town.setPlotPrice(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        town.setPlotPrice(0.0);
                    }
                }
                if ((line = (String)keys.get("hasUpkeep")) != null) {
                    try {
                        town.setHasUpkeep(Boolean.parseBoolean(line));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("taxpercent")) != null) {
                    try {
                        town.setTaxPercentage(Boolean.parseBoolean(line));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("taxes")) != null) {
                    try {
                        town.setTaxes(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        town.setTaxes(0.0);
                    }
                }
                if ((line = (String)keys.get("plotTax")) != null) {
                    try {
                        town.setPlotTax(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        town.setPlotTax(0.0);
                    }
                }
                if ((line = (String)keys.get("commercialPlotPrice")) != null) {
                    try {
                        town.setCommercialPlotPrice(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        town.setCommercialPlotPrice(0.0);
                    }
                }
                if ((line = (String)keys.get("commercialPlotTax")) != null) {
                    try {
                        town.setCommercialPlotTax(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        town.setCommercialPlotTax(0.0);
                    }
                }
                if ((line = (String)keys.get("embassyPlotPrice")) != null) {
                    try {
                        town.setEmbassyPlotPrice(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        town.setEmbassyPlotPrice(0.0);
                    }
                }
                if ((line = (String)keys.get("embassyPlotTax")) != null) {
                    try {
                        town.setEmbassyPlotTax(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        town.setEmbassyPlotTax(0.0);
                    }
                }
                if ((line = (String)keys.get("spawnCost")) != null) {
                    try {
                        town.setSpawnCost(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        town.setSpawnCost(TownySettings.getSpawnTravelCost());
                    }
                }
                if ((line = (String)keys.get("adminDisabledPvP")) != null) {
                    try {
                        town.setAdminDisabledPVP(Boolean.parseBoolean(line));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("adminEnabledPvP")) != null) {
                    try {
                        town.setAdminEnabledPVP(Boolean.parseBoolean(line));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("open")) != null) {
                    try {
                        town.setOpen(Boolean.parseBoolean(line));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("public")) != null) {
                    try {
                        town.setPublic(Boolean.parseBoolean(line));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("townBlocks")) != null) {
                    this.utilLoadTownBlocks(line, town, null);
                }
                if ((line = (String)keys.get("homeBlock")) != null && (tokens = line.split(",")).length == 3) {
                    try {
                        world = this.getWorld(tokens[0]);
                        try {
                            int x2 = Integer.parseInt(tokens[1]);
                            int z2 = Integer.parseInt(tokens[2]);
                            TownBlock homeBlock = world.getTownBlock(x2, z2);
                            town.forceSetHomeBlock(homeBlock);
                        }
                        catch (NumberFormatException e) {
                            TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " homeBlock tried to load invalid location.");
                        }
                        catch (NotRegisteredException e) {
                            TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " homeBlock tried to load invalid TownBlock.");
                        }
                        catch (TownyException e) {
                            TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " does not have a home block.");
                        }
                    }
                    catch (NotRegisteredException e) {
                        TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " homeBlock tried to load invalid world.");
                    }
                }
                if ((line = (String)keys.get("spawn")) != null && (tokens = line.split(",")).length >= 4) {
                    try {
                        world = this.plugin.getServerWorld(tokens[0]);
                        double x3 = Double.parseDouble(tokens[1]);
                        double y2 = Double.parseDouble(tokens[2]);
                        double z3 = Double.parseDouble(tokens[3]);
                        Location loc2 = new Location((World)world, x3, y2, z3);
                        if (tokens.length == 6) {
                            loc2.setPitch(Float.parseFloat(tokens[4]));
                            loc2.setYaw(Float.parseFloat(tokens[5]));
                        }
                        town.forceSetSpawn(loc2);
                    }
                    catch (NotRegisteredException | NullPointerException | NumberFormatException world2) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("outpostspawns")) != null) {
                    String[] outposts;
                    for (String spawn : outposts = line.split(";")) {
                        tokens = spawn.split(",");
                        if (tokens.length < 4) continue;
                        try {
                            World world3 = this.plugin.getServerWorld(tokens[0]);
                            x = Double.parseDouble(tokens[1]);
                            y = Double.parseDouble(tokens[2]);
                            z = Double.parseDouble(tokens[3]);
                            loc = new Location(world3, x, y, z);
                            if (tokens.length == 6) {
                                loc.setPitch(Float.parseFloat(tokens[4]));
                                loc.setYaw(Float.parseFloat(tokens[5]));
                            }
                            town.forceAddOutpostSpawn(loc);
                        }
                        catch (NotRegisteredException | NullPointerException | NumberFormatException world3) {
                            // empty catch block
                        }
                    }
                }
                if ((line = (String)keys.get("jailspawns")) != null) {
                    String[] jails;
                    for (String spawn : jails = line.split(";")) {
                        tokens = spawn.split(",");
                        if (tokens.length < 4) continue;
                        try {
                            World world4 = this.plugin.getServerWorld(tokens[0]);
                            x = Double.parseDouble(tokens[1]);
                            y = Double.parseDouble(tokens[2]);
                            z = Double.parseDouble(tokens[3]);
                            loc = new Location(world4, x, y, z);
                            if (tokens.length == 6) {
                                loc.setPitch(Float.parseFloat(tokens[4]));
                                loc.setYaw(Float.parseFloat(tokens[5]));
                            }
                            town.forceAddJailSpawn(loc);
                        }
                        catch (NotRegisteredException | NullPointerException | NumberFormatException exception) {
                            // empty catch block
                        }
                    }
                }
                if ((line = (String)keys.get("uuid")) != null) {
                    try {
                        town.setUuid(UUID.fromString(line));
                    }
                    catch (IllegalArgumentException ee) {
                        town.setUuid(UUID.randomUUID());
                    }
                }
                if ((line = (String)keys.get("registered")) != null) {
                    try {
                        town.setRegistered(Long.valueOf(line));
                    }
                    catch (Exception ee) {
                        town.setRegistered(0L);
                    }
                }
                if ((line = (String)keys.get("metadata")) != null && !line.isEmpty()) {
                    town.setMetadata(line.trim());
                }
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg("Loading Error: Exception while reading town file " + town.getName() + " at line: " + line + ", in towny\\data\\towns\\" + town.getName() + ".txt");
                boolean bl = false;
                return bl;
            }
            finally {
                this.saveTown(town);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean loadNation(Nation nation) {
        String line = "";
        String path = this.getNationFilename(nation);
        File fileNation = new File(path);
        if (fileNation.exists() && fileNation.isFile()) {
            try {
                String[] tokens;
                HashMap<String, String> keys = new HashMap<String, String>();
                Properties properties = new Properties();
                properties.load(new InputStreamReader((InputStream)new FileInputStream(fileNation), StandardCharsets.UTF_8));
                for (String key : properties.stringPropertyNames()) {
                    String value = properties.getProperty(key);
                    keys.put(key, String.valueOf(value));
                }
                line = (String)keys.get("towns");
                if (line != null) {
                    for (String token : tokens = line.split(",")) {
                        if (token.isEmpty()) continue;
                        try {
                            TownyMessaging.sendDebugMsg("Nation Fetching Town: " + token);
                            Town town = this.getTown(token);
                            if (town == null) continue;
                            nation.addTown(town);
                        }
                        catch (NotRegisteredException e) {
                            TownyMessaging.sendErrorMsg("Loading Error: Exception while reading a town in the nation file of " + nation.getName() + ".txt. The town " + token + " does not exist, removing it from nation... (Will require editing of the nation file if it is the capital)");
                        }
                    }
                }
                if ((line = (String)keys.get("capital")) != null) {
                    nation.setCapital(this.getTown(line));
                }
                if ((line = (String)keys.get("nationBoard")) != null) {
                    try {
                        nation.setNationBoard(line);
                    }
                    catch (Exception e) {
                        nation.setNationBoard("");
                    }
                }
                if ((line = (String)keys.get("tag")) != null) {
                    try {
                        nation.setTag(line);
                    }
                    catch (TownyException e) {
                        nation.setTag("");
                    }
                }
                if ((line = (String)keys.get("allies")) != null) {
                    for (String token : tokens = line.split(",")) {
                        Nation friend;
                        if (token.isEmpty() || (friend = this.getNation(token)) == null) continue;
                        nation.addAlly(friend);
                    }
                }
                if ((line = (String)keys.get("enemies")) != null) {
                    for (String token : tokens = line.split(",")) {
                        Nation enemy;
                        if (token.isEmpty() || (enemy = this.getNation(token)) == null) continue;
                        nation.addEnemy(enemy);
                    }
                }
                if ((line = (String)keys.get("taxes")) != null) {
                    try {
                        nation.setTaxes(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        nation.setTaxes(0.0);
                    }
                }
                if ((line = (String)keys.get("spawnCost")) != null) {
                    try {
                        nation.setSpawnCost(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        nation.setSpawnCost(TownySettings.getSpawnTravelCost());
                    }
                }
                if ((line = (String)keys.get("neutral")) != null) {
                    try {
                        nation.setNeutral(Boolean.parseBoolean(line));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("uuid")) != null) {
                    try {
                        nation.setUuid(UUID.fromString(line));
                    }
                    catch (IllegalArgumentException ee) {
                        nation.setUuid(UUID.randomUUID());
                    }
                }
                if ((line = (String)keys.get("registered")) != null) {
                    try {
                        nation.setRegistered(Long.valueOf(line));
                    }
                    catch (Exception ee) {
                        nation.setRegistered(0L);
                    }
                }
                if ((line = (String)keys.get("nationSpawn")) != null && (tokens = line.split(",")).length >= 4) {
                    try {
                        World world = this.plugin.getServerWorld(tokens[0]);
                        double x = Double.parseDouble(tokens[1]);
                        double y = Double.parseDouble(tokens[2]);
                        double z = Double.parseDouble(tokens[3]);
                        Location loc = new Location(world, x, y, z);
                        if (tokens.length == 6) {
                            loc.setPitch(Float.parseFloat(tokens[4]));
                            loc.setYaw(Float.parseFloat(tokens[5]));
                        }
                        nation.forceSetNationSpawn(loc);
                    }
                    catch (NotRegisteredException | NullPointerException | NumberFormatException exception) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("isPublic")) != null) {
                    try {
                        nation.setPublic(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("isOpen")) != null) {
                    try {
                        nation.setOpen(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg("Loading Error: Exception while reading nation file " + nation.getName() + " at line: " + line + ", in towny\\data\\nations\\" + nation.getName() + ".txt");
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean loadWorld(TownyWorld world) {
        File fileWorld;
        String line = "";
        String path = this.getWorldFilename(world);
        if (!FileMgmt.checkOrCreateFile(path)) {
            TownyMessaging.sendErrorMsg("Loading Error: Exception while reading file " + path);
        }
        if ((fileWorld = new File(path)).exists() && fileWorld.isFile()) {
            try {
                ArrayList<String> mats2;
                HashMap<String, String> keys = new HashMap<String, String>();
                Properties properties = new Properties();
                properties.load(new InputStreamReader((InputStream)new FileInputStream(fileWorld), StandardCharsets.UTF_8));
                for (String key : properties.stringPropertyNames()) {
                    String value = properties.getProperty(key);
                    keys.put(key, String.valueOf(value));
                }
                line = (String)keys.get("towns");
                if (line != null) {
                    String[] tokens;
                    for (String token : tokens = line.split(",")) {
                        if (token.isEmpty()) continue;
                        TownyMessaging.sendDebugMsg("World Fetching Town: " + token);
                        Town town = this.getTown(token);
                        if (town == null) continue;
                        town.setWorld(world);
                    }
                }
                if ((line = (String)keys.get("claimable")) != null) {
                    try {
                        world.setClaimable(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("pvp")) != null) {
                    try {
                        world.setPVP(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("forcepvp")) != null) {
                    try {
                        world.setForcePVP(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("forcetownmobs")) != null) {
                    try {
                        world.setForceTownMobs(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("worldmobs")) != null) {
                    try {
                        world.setWorldMobs(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("firespread")) != null) {
                    try {
                        world.setFire(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("forcefirespread")) != null) {
                    try {
                        world.setForceFire(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("explosions")) != null) {
                    try {
                        world.setExpl(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("forceexplosions")) != null) {
                    try {
                        world.setForceExpl(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("endermanprotect")) != null) {
                    try {
                        world.setEndermanProtect(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("disableplayertrample")) != null) {
                    try {
                        world.setDisablePlayerTrample(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("disablecreaturetrample")) != null) {
                    try {
                        world.setDisableCreatureTrample(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("unclaimedZoneBuild")) != null) {
                    try {
                        world.setUnclaimedZoneBuild(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("unclaimedZoneDestroy")) != null) {
                    try {
                        world.setUnclaimedZoneDestroy(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("unclaimedZoneSwitch")) != null) {
                    try {
                        world.setUnclaimedZoneSwitch(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("unclaimedZoneItemUse")) != null) {
                    try {
                        world.setUnclaimedZoneItemUse(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("unclaimedZoneName")) != null) {
                    try {
                        world.setUnclaimedZoneName(line);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("unclaimedZoneIgnoreIds")) != null) {
                    try {
                        mats2 = new ArrayList<String>();
                        for (String s : line.split(",")) {
                            if (s.isEmpty()) continue;
                            mats2.add(s);
                        }
                        world.setUnclaimedZoneIgnore(mats2);
                    }
                    catch (Exception mats2) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("usingPlotManagementDelete")) != null) {
                    try {
                        world.setUsingPlotManagementDelete(Boolean.parseBoolean(line));
                    }
                    catch (Exception mats2) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("plotManagementDeleteIds")) != null) {
                    try {
                        mats2 = new ArrayList();
                        for (String s : line.split(",")) {
                            if (s.isEmpty()) continue;
                            mats2.add(s);
                        }
                        world.setPlotManagementDeleteIds(mats2);
                    }
                    catch (Exception mats3) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("usingPlotManagementMayorDelete")) != null) {
                    try {
                        world.setUsingPlotManagementMayorDelete(Boolean.parseBoolean(line));
                    }
                    catch (Exception mats3) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("plotManagementMayorDelete")) != null) {
                    try {
                        ArrayList<String> materials = new ArrayList<String>();
                        for (String s : line.split(",")) {
                            if (s.isEmpty()) continue;
                            try {
                                materials.add(s.toUpperCase().trim());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        world.setPlotManagementMayorDelete(materials);
                    }
                    catch (Exception materials) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("usingPlotManagementRevert")) != null) {
                    try {
                        world.setUsingPlotManagementRevert(Boolean.parseBoolean(line));
                    }
                    catch (Exception materials) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("plotManagementIgnoreIds")) != null) {
                    try {
                        mats2 = new ArrayList();
                        for (String s : line.split(",")) {
                            if (s.isEmpty()) continue;
                            mats2.add(s);
                        }
                        world.setPlotManagementIgnoreIds(mats2);
                    }
                    catch (Exception mats4) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("usingPlotManagementWildRegen")) != null) {
                    try {
                        world.setUsingPlotManagementWildRevert(Boolean.parseBoolean(line));
                    }
                    catch (Exception mats4) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("PlotManagementWildRegenEntities")) != null) {
                    try {
                        ArrayList<String> entities = new ArrayList<String>();
                        for (String s : line.split(",")) {
                            if (s.isEmpty()) continue;
                            try {
                                entities.add(s.trim());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        world.setPlotManagementWildRevertEntities(entities);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("usingPlotManagementWildRegenDelay")) != null) {
                    try {
                        world.setPlotManagementWildRevertDelay(Long.parseLong(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("usingTowny")) != null) {
                    try {
                        world.setUsingTowny(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = (String)keys.get("warAllowed")) != null) {
                    try {
                        world.setWarAllowed(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg("Loading Error: Exception while reading world file " + path + " at line: " + line + ", in towny\\data\\worlds\\" + world.getName() + ".txt");
                return false;
            }
            return true;
        }
        TownyMessaging.sendErrorMsg("Loading Error: File error while reading " + world.getName() + " at line: " + line + ", in towny\\data\\worlds\\" + world.getName() + ".txt");
        return false;
    }

    @Override
    public boolean loadTownBlocks() {
        String line = "";
        for (TownBlock townBlock : this.getAllTownBlocks()) {
            String path = this.getTownBlockFilename(townBlock);
            File fileTownBlock = new File(path);
            if (fileTownBlock.exists() && fileTownBlock.isFile()) {
                String test = null;
                try {
                    HashMap<String, String> keys = new HashMap<String, String>();
                    Properties properties = new Properties();
                    properties.load(new InputStreamReader((InputStream)new FileInputStream(fileTownBlock), StandardCharsets.UTF_8));
                    for (String key : properties.stringPropertyNames()) {
                        String value = properties.getProperty(key);
                        keys.put(key, String.valueOf(value));
                    }
                    line = (String)keys.get("name");
                    if (line != null) {
                        try {
                            townBlock.setName(line.trim());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ((line = (String)keys.get("price")) != null) {
                        try {
                            townBlock.setPlotPrice(Double.parseDouble(line.trim()));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ((line = (String)keys.get("town")) != null) {
                        try {
                            Town town = this.getTown(line.trim());
                            townBlock.setTown(town);
                        }
                        catch (Exception town) {
                            // empty catch block
                        }
                    }
                    if ((line = (String)keys.get("resident")) != null && !line.isEmpty()) {
                        try {
                            Resident res = this.getResident(line.trim());
                            townBlock.setResident(res);
                        }
                        catch (Exception res) {
                            // empty catch block
                        }
                    }
                    if ((line = (String)keys.get("type")) != null) {
                        try {
                            townBlock.setType(Integer.parseInt(line));
                        }
                        catch (Exception res) {
                            // empty catch block
                        }
                    }
                    if ((line = (String)keys.get("outpost")) != null) {
                        try {
                            townBlock.setOutpost(Boolean.parseBoolean(line));
                        }
                        catch (Exception res) {
                            // empty catch block
                        }
                    }
                    if ((line = (String)keys.get("permissions")) != null && !line.isEmpty()) {
                        try {
                            townBlock.setPermissions(line.trim());
                        }
                        catch (Exception res) {
                            // empty catch block
                        }
                    }
                    if ((line = (String)keys.get("changed")) != null) {
                        try {
                            townBlock.setChanged(Boolean.parseBoolean(line.trim()));
                        }
                        catch (Exception res) {
                            // empty catch block
                        }
                    }
                    if ((line = (String)keys.get("locked")) != null) {
                        try {
                            townBlock.setLocked(Boolean.parseBoolean(line.trim()));
                        }
                        catch (Exception res) {
                            // empty catch block
                        }
                    }
                    test = "town";
                    line = (String)keys.get("town");
                    if (line.isEmpty()) {
                        TownyMessaging.sendDebugMsg("TownBlock file missing Town, deleting " + path);
                        this.deleteTownBlock(townBlock);
                        TownyMessaging.sendDebugMsg("Missing file: " + path + " deleting entry in townblocks.txt");
                        TownyWorld world = townBlock.getWorld();
                        world.removeTownBlock(townBlock);
                    }
                    test = "metadata";
                    line = (String)keys.get("metadata");
                    if (line == null || line.isEmpty()) continue;
                    townBlock.setMetadata(line.trim());
                    continue;
                }
                catch (Exception e) {
                    if (test == "town") {
                        TownyMessaging.sendDebugMsg("TownBlock file missing Town, deleting " + path);
                        this.deleteTownBlock(townBlock);
                        TownyMessaging.sendDebugMsg("Missing file: " + path + " deleting entry in townblocks.txt");
                        TownyWorld world = townBlock.getWorld();
                        world.removeTownBlock(townBlock);
                        continue;
                    }
                    TownyMessaging.sendErrorMsg("Loading Error: Exception while reading TownBlock file " + path + " at line: " + line);
                    return false;
                }
            }
            TownyMessaging.sendDebugMsg("Missing file: " + path + " deleting entry in townblocks.txt");
            TownyWorld world = townBlock.getWorld();
            world.removeTownBlock(townBlock);
        }
        this.saveTownBlockList();
        return true;
    }

    @Override
    public boolean saveTownBlockList() {
        ArrayList<String> list = new ArrayList<String>();
        for (TownBlock townBlock : this.getAllTownBlocks()) {
            list.add(townBlock.getWorld().getName() + "," + townBlock.getX() + "," + townBlock.getZ());
        }
        this.queryQueue.add(new FlatFile_Task(list, this.dataFolderPath + File.separator + "townblocks.txt"));
        return true;
    }

    @Override
    public boolean saveResidentList() {
        ArrayList<String> list = new ArrayList<String>();
        for (Resident resident : this.getResidents()) {
            try {
                list.add(NameValidation.checkAndFilterPlayerName(resident.getName()));
            }
            catch (InvalidNameException e) {
                TownyMessaging.sendErrorMsg("Saving Error: Exception while saving town list file:" + resident.getName());
            }
        }
        this.queryQueue.add(new FlatFile_Task(list, this.dataFolderPath + File.separator + "residents.txt"));
        return true;
    }

    @Override
    public boolean saveTownList() {
        ArrayList<String> list = new ArrayList<String>();
        for (Town town : this.getTowns()) {
            list.add(town.getName());
        }
        this.queryQueue.add(new FlatFile_Task(list, this.dataFolderPath + File.separator + "towns.txt"));
        return true;
    }

    @Override
    public boolean saveNationList() {
        ArrayList<String> list = new ArrayList<String>();
        for (Nation nation : this.getNations()) {
            list.add(nation.getName());
        }
        this.queryQueue.add(new FlatFile_Task(list, this.dataFolderPath + File.separator + "nations.txt"));
        return true;
    }

    @Override
    public boolean saveWorldList() {
        ArrayList<String> list = new ArrayList<String>();
        for (TownyWorld world : this.getWorlds()) {
            list.add(world.getName());
        }
        this.queryQueue.add(new FlatFile_Task(list, this.dataFolderPath + File.separator + "worlds.txt"));
        return true;
    }

    @Override
    public boolean saveResident(Resident resident) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("lastOnline=" + resident.getLastOnline());
        list.add("registered=" + resident.getRegistered());
        list.add("isNPC=" + resident.isNPC());
        list.add("isJailed=" + resident.isJailed());
        list.add("JailSpawn=" + resident.getJailSpawn());
        list.add("JailDays=" + resident.getJailDays());
        list.add("JailTown=" + resident.getJailTown());
        list.add("title=" + resident.getTitle());
        list.add("surname=" + resident.getSurname());
        if (resident.hasTown()) {
            try {
                list.add("town=" + resident.getTown().getName());
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
            list.add("town-ranks=" + StringMgmt.join(resident.getTownRanks(), ","));
            list.add("nation-ranks=" + StringMgmt.join(resident.getNationRanks(), ","));
        }
        list.add("friends=" + StringMgmt.join(resident.getFriends(), ","));
        list.add("");
        list.add("protectionStatus=" + resident.getPermissions().toString());
        this.queryQueue.add(new FlatFile_Task(list, this.getResidentFilename(resident)));
        return true;
    }

    @Override
    public boolean saveTown(Town town) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("name=" + town.getName());
        list.add("residents=" + StringMgmt.join(town.getResidents(), ","));
        if (town.hasMayor()) {
            list.add("mayor=" + town.getMayor().getName());
        }
        if (town.hasNation()) {
            try {
                list.add("nation=" + town.getNation().getName());
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        list.add("assistants=" + StringMgmt.join(town.getAssistants(), ","));
        list.add(this.newLine);
        list.add("townBoard=" + town.getTownBoard());
        list.add("tag=" + town.getTag());
        list.add("protectionStatus=" + town.getPermissions().toString());
        list.add("bonusBlocks=" + town.getBonusBlocks());
        list.add("purchasedBlocks=" + town.getPurchasedBlocks());
        list.add("taxpercent=" + town.isTaxPercentage());
        list.add("taxes=" + town.getTaxes());
        list.add("plotPrice=" + town.getPlotPrice());
        list.add("plotTax=" + town.getPlotTax());
        list.add("commercialPlotPrice=" + town.getCommercialPlotPrice());
        list.add("commercialPlotTax=" + town.getCommercialPlotTax());
        list.add("embassyPlotPrice=" + town.getEmbassyPlotPrice());
        list.add("embassyPlotTax=" + town.getEmbassyPlotTax());
        list.add("spawnCost=" + town.getSpawnCost());
        list.add("hasUpkeep=" + town.hasUpkeep());
        list.add("open=" + town.isOpen());
        list.add("adminDisabledPvP=" + town.isAdminDisabledPVP());
        list.add("adminEnabledPvP=" + town.isAdminEnabledPVP());
        list.add("public=" + town.isPublic());
        if (town.hasValidUUID()) {
            list.add("uuid=" + town.getUuid());
        } else {
            list.add("uuid=" + UUID.randomUUID());
        }
        list.add("registered=" + town.getRegistered());
        if (town.hasHomeBlock()) {
            try {
                list.add("homeBlock=" + town.getHomeBlock().getWorld().getName() + "," + town.getHomeBlock().getX() + "," + town.getHomeBlock().getZ());
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
        if (town.hasSpawn()) {
            try {
                list.add("spawn=" + town.getSpawn().getWorld().getName() + "," + town.getSpawn().getX() + "," + town.getSpawn().getY() + "," + town.getSpawn().getZ() + "," + town.getSpawn().getPitch() + "," + town.getSpawn().getYaw());
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
        StringBuilder outpostArray = new StringBuilder("outpostspawns=");
        if (town.hasOutpostSpawn()) {
            for (Location location : new ArrayList<Location>(town.getAllOutpostSpawns())) {
                outpostArray.append(location.getWorld().getName()).append(",").append(location.getX()).append(",").append(location.getY()).append(",").append(location.getZ()).append(",").append(location.getPitch()).append(",").append(location.getYaw()).append(";");
            }
        }
        list.add(outpostArray.toString());
        StringBuilder jailArray = new StringBuilder("jailspawns=");
        if (town.hasJailSpawn()) {
            for (Location spawn : new ArrayList<Location>(town.getAllJailSpawns())) {
                jailArray.append(spawn.getWorld().getName()).append(",").append(spawn.getX()).append(",").append(spawn.getY()).append(",").append(spawn.getZ()).append(",").append(spawn.getPitch()).append(",").append(spawn.getYaw()).append(";");
            }
        }
        list.add(jailArray.toString());
        list.add("outlaws=" + StringMgmt.join(town.getOutlaws(), ","));
        StringBuilder stringBuilder = new StringBuilder();
        if (town.hasMeta()) {
            HashSet<CustomDataField> tdata = town.getMetadata();
            for (CustomDataField cdf : tdata) {
                stringBuilder.append(cdf.toString()).append(";");
            }
        }
        list.add("metadata=" + stringBuilder.toString());
        this.queryQueue.add(new FlatFile_Task(list, this.getTownFilename(town)));
        return true;
    }

    @Override
    public boolean saveNation(Nation nation) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("towns=" + StringMgmt.join(nation.getTowns(), ","));
        if (nation.hasCapital()) {
            list.add("capital=" + nation.getCapital().getName());
        }
        list.add("nationBoard=" + nation.getNationBoard());
        if (nation.hasTag()) {
            list.add("tag=" + nation.getTag());
        }
        list.add("assistants=" + StringMgmt.join(nation.getAssistants(), ","));
        list.add("allies=" + StringMgmt.join(nation.getAllies(), ","));
        list.add("enemies=" + StringMgmt.join(nation.getEnemies(), ","));
        list.add("taxes=" + nation.getTaxes());
        list.add("spawnCost=" + nation.getSpawnCost());
        list.add("neutral=" + nation.isNeutral());
        if (nation.hasValidUUID()) {
            list.add("uuid=" + nation.getUuid());
        } else {
            list.add("uuid=" + UUID.randomUUID());
        }
        list.add("registered=" + nation.getRegistered());
        if (nation.hasNationSpawn()) {
            try {
                list.add("nationSpawn=" + nation.getNationSpawn().getWorld().getName() + "," + nation.getNationSpawn().getX() + "," + nation.getNationSpawn().getY() + "," + nation.getNationSpawn().getZ() + "," + nation.getNationSpawn().getPitch() + "," + nation.getNationSpawn().getYaw());
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
        list.add("isPublic=" + nation.isPublic());
        list.add("isOpen=" + nation.isOpen());
        this.queryQueue.add(new FlatFile_Task(list, this.getNationFilename(nation)));
        return true;
    }

    @Override
    public boolean saveWorld(TownyWorld world) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("towns=" + StringMgmt.join(world.getTowns(), ","));
        list.add("");
        list.add("pvp=" + world.isPVP());
        list.add("forcepvp=" + world.isForcePVP());
        list.add("# Can players found towns and claim plots in this world?");
        list.add("claimable=" + world.isClaimable());
        list.add("worldmobs=" + world.hasWorldMobs());
        list.add("forcetownmobs=" + world.isForceTownMobs());
        list.add("firespread=" + world.isFire());
        list.add("forcefirespread=" + world.isForceFire());
        list.add("explosions=" + world.isExpl());
        list.add("forceexplosions=" + world.isForceExpl());
        list.add("endermanprotect=" + world.isEndermanProtect());
        list.add("disableplayertrample=" + world.isDisablePlayerTrample());
        list.add("disablecreaturetrample=" + world.isDisableCreatureTrample());
        list.add(this.newLine);
        list.add("# Unclaimed Zone settings.");
        if (world.getUnclaimedZoneBuild() != null) {
            list.add("unclaimedZoneBuild=" + world.getUnclaimedZoneBuild());
        }
        if (world.getUnclaimedZoneDestroy() != null) {
            list.add("unclaimedZoneDestroy=" + world.getUnclaimedZoneDestroy());
        }
        if (world.getUnclaimedZoneSwitch() != null) {
            list.add("unclaimedZoneSwitch=" + world.getUnclaimedZoneSwitch());
        }
        if (world.getUnclaimedZoneItemUse() != null) {
            list.add("unclaimedZoneItemUse=" + world.getUnclaimedZoneItemUse());
        }
        if (world.getUnclaimedZoneName() != null) {
            list.add("unclaimedZoneName=" + world.getUnclaimedZoneName());
        }
        list.add("");
        list.add("# The following settings are only used if you are not using any permissions provider plugin");
        if (world.getUnclaimedZoneIgnoreMaterials() != null) {
            list.add("unclaimedZoneIgnoreIds=" + StringMgmt.join(world.getUnclaimedZoneIgnoreMaterials(), ","));
        }
        list.add(this.newLine);
        list.add("# The following settings control what blocks are deleted upon a townblock being unclaimed");
        list.add("usingPlotManagementDelete=" + world.isUsingPlotManagementDelete());
        if (world.getPlotManagementDeleteIds() != null) {
            list.add("plotManagementDeleteIds=" + StringMgmt.join(world.getPlotManagementDeleteIds(), ","));
        }
        list.add(this.newLine);
        list.add("# The following settings control what blocks are deleted upon a mayor issuing a '/plot clear' command");
        list.add("usingPlotManagementMayorDelete=" + world.isUsingPlotManagementMayorDelete());
        if (world.getPlotManagementMayorDelete() != null) {
            list.add("plotManagementMayorDelete=" + StringMgmt.join(world.getPlotManagementMayorDelete(), ","));
        }
        list.add(this.newLine + "# If enabled when a town claims a townblock a snapshot will be taken at the time it is claimed.");
        list.add("# When the townblock is unclaimded its blocks will begin to revert to the original snapshot.");
        list.add("usingPlotManagementRevert=" + world.isUsingPlotManagementRevert());
        list.add("# Any block Id's listed here will not be respawned. Instead it will revert to air.");
        if (world.getPlotManagementIgnoreIds() != null) {
            list.add("plotManagementIgnoreIds=" + StringMgmt.join(world.getPlotManagementIgnoreIds(), ","));
        }
        list.add("");
        list.add("# If enabled any damage caused by explosions will repair itself.");
        list.add("usingPlotManagementWildRegen=" + world.isUsingPlotManagementWildRevert());
        if (world.getPlotManagementWildRevertEntities() != null) {
            list.add("PlotManagementWildRegenEntities=" + StringMgmt.join(world.getPlotManagementWildRevertEntities(), ","));
        }
        list.add("usingPlotManagementWildRegenDelay=" + world.getPlotManagementWildRevertDelay());
        list.add("");
        list.add("# This setting is used to enable or disable Towny in this world.");
        list.add("usingTowny=" + world.isUsingTowny());
        list.add("");
        list.add("# This setting is used to enable or disable Event war in this world.");
        list.add("warAllowed=" + world.isWarAllowed());
        this.queryQueue.add(new FlatFile_Task(list, this.getWorldFilename(world)));
        return true;
    }

    @Override
    public boolean saveAllTownBlocks() {
        for (TownyWorld world : this.getWorlds()) {
            for (TownBlock townBlock : world.getTownBlocks()) {
                this.saveTownBlock(townBlock);
            }
        }
        return true;
    }

    @Override
    public boolean saveTownBlock(TownBlock townBlock) {
        FileMgmt.checkOrCreateFolder(this.dataFolderPath + File.separator + "townblocks" + File.separator + townBlock.getWorld().getName());
        ArrayList<String> list = new ArrayList<String>();
        list.add("name=" + townBlock.getName());
        list.add("price=" + townBlock.getPlotPrice());
        try {
            list.add("town=" + townBlock.getTown().getName());
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        if (townBlock.hasResident()) {
            try {
                list.add("resident=" + townBlock.getResident().getName());
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        list.add("type=" + townBlock.getType().getId());
        list.add("outpost=" + townBlock.isOutpost());
        if (townBlock.isChanged()) {
            list.add("permissions=" + townBlock.getPermissions().toString());
        }
        list.add("changed=" + townBlock.isChanged());
        list.add("locked=" + townBlock.isLocked());
        StringBuilder md = new StringBuilder();
        if (townBlock.hasMeta()) {
            HashSet<CustomDataField> tdata = townBlock.getMetadata();
            for (CustomDataField cdf : tdata) {
                md.append(cdf.toString()).append(";");
            }
        }
        list.add("metadata=" + md.toString());
        this.queryQueue.add(new FlatFile_Task(list, this.getTownBlockFilename(townBlock)));
        return true;
    }

    @Override
    public boolean saveRegenList() {
        try (BufferedWriter fout = new BufferedWriter(new FileWriter(this.dataFolderPath + File.separator + "regen.txt"));){
            for (PlotBlockData plot : new ArrayList<PlotBlockData>(TownyRegenAPI.getPlotChunks().values())) {
                fout.write(plot.getWorldName() + "," + plot.getX() + "," + plot.getZ() + this.newLine);
            }
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("Saving Error: Exception while saving regen file");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean saveSnapshotList() {
        try (BufferedWriter fout = new BufferedWriter(new FileWriter(this.dataFolderPath + File.separator + "snapshot_queue.txt"));){
            while (TownyRegenAPI.hasWorldCoords()) {
                WorldCoord worldCoord = TownyRegenAPI.getWorldCoord();
                fout.write(worldCoord.getWorldName() + "," + worldCoord.getX() + "," + worldCoord.getZ() + this.newLine);
            }
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("Saving Error: Exception while saving snapshot_queue file");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Deprecated
    public void utilLoadTownBlocks(String line, Town town, Resident resident) {
        String[] worlds;
        for (String w : worlds = line.split("\\|")) {
            String[] split = w.split(":");
            if (split.length != 2) {
                TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " BlockList does not have a World or data.");
                continue;
            }
            try {
                TownyWorld world = this.getWorld(split[0]);
                for (String s : split[1].split(";")) {
                    String[] tokens;
                    String blockTypeData = null;
                    int indexOfType = s.indexOf("[");
                    if (indexOfType != -1) {
                        int endIndexOfType = s.indexOf("]");
                        if (endIndexOfType != -1) {
                            blockTypeData = s.substring(indexOfType + 1, endIndexOfType);
                        }
                        s = s.substring(endIndexOfType + 1);
                    }
                    if ((tokens = s.split(",")).length < 2) continue;
                    try {
                        int x = Integer.parseInt(tokens[0]);
                        int z = Integer.parseInt(tokens[1]);
                        try {
                            world.newTownBlock(x, z);
                        }
                        catch (AlreadyRegisteredException alreadyRegisteredException) {
                            // empty catch block
                        }
                        TownBlock townblock = world.getTownBlock(x, z);
                        if (town != null) {
                            townblock.setTown(town);
                        }
                        if (resident != null && townblock.hasTown()) {
                            townblock.setResident(resident);
                        }
                        if (blockTypeData != null) {
                            this.utilLoadTownBlockTypeData(townblock, blockTypeData);
                        }
                        if (tokens.length < 3) continue;
                        if (tokens[2].equals("true")) {
                            townblock.setPlotPrice(town.getPlotPrice());
                            continue;
                        }
                        townblock.setPlotPrice(Double.parseDouble(tokens[2]));
                    }
                    catch (NotRegisteredException | NumberFormatException exception) {
                        // empty catch block
                    }
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
    }

    @Deprecated
    public void utilLoadTownBlockTypeData(TownBlock townBlock, String data) {
        String[] tokens = data.split(",");
        if (tokens.length >= 1) {
            townBlock.setType(Integer.valueOf(tokens[0]));
        }
        if (tokens.length >= 2) {
            townBlock.setOutpost(tokens[1].equalsIgnoreCase("1"));
        }
    }

    @Deprecated
    public String utilSaveTownBlocks(List<TownBlock> townBlocks) {
        HashMap worlds = new HashMap();
        StringBuilder out = new StringBuilder();
        for (TownBlock townBlock : townBlocks) {
            TownyWorld world = townBlock.getWorld();
            if (!worlds.containsKey(world)) {
                worlds.put(world, new ArrayList());
            }
            ((ArrayList)worlds.get(world)).add(townBlock);
        }
        for (TownyWorld world : worlds.keySet()) {
            out.append(world.getName()).append(":");
            for (TownBlock townBlock : (ArrayList)worlds.get(world)) {
                out.append("[").append(townBlock.getType().getId());
                out.append(",").append(townBlock.isOutpost() ? "1" : "0");
                out.append("]").append(townBlock.getX()).append(",").append(townBlock.getZ()).append(",").append(townBlock.getPlotPrice()).append(";");
            }
            out.append("|");
        }
        return out.toString();
    }

    @Override
    public boolean savePlotData(PlotBlockData plotChunk) {
        FileMgmt.checkOrCreateFolder(this.dataFolderPath + File.separator + "plot-block-data" + File.separator + plotChunk.getWorldName());
        String path = this.getPlotFilename(plotChunk);
        try (DataOutputStream fout = new DataOutputStream(new FileOutputStream(path));){
            switch (plotChunk.getVersion()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    fout.write("VER".getBytes(StandardCharsets.UTF_8));
                    fout.write(plotChunk.getVersion());
                    break;
                }
            }
            fout.writeInt(plotChunk.getHeight());
            for (String block : new ArrayList<String>(plotChunk.getBlockList())) {
                fout.writeUTF(block);
            }
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("Saving Error: Exception while saving PlotBlockData file (" + path + ")");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public PlotBlockData loadPlotData(String worldName, int x, int z) {
        try {
            TownyWorld world = this.getWorld(worldName);
            TownBlock townBlock = new TownBlock(x, z, world);
            return this.loadPlotData(townBlock);
        }
        catch (NotRegisteredException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public PlotBlockData loadPlotData(TownBlock townBlock) {
        String fileName = this.getPlotFilename(townBlock);
        if (this.isFile(fileName)) {
            PlotBlockData plotBlockData = new PlotBlockData(townBlock);
            ArrayList<String> blockArr = new ArrayList<String>();
            int version = 0;
            try (DataInputStream fin2 = new DataInputStream(new FileInputStream(fileName));){
                fin2.mark(3);
                byte[] key = new byte[3];
                fin2.read(key, 0, 3);
                String test = new String(key);
                if (elements.fromString(test) == elements.VER) {
                    version = fin2.read();
                    plotBlockData.setVersion(version);
                    plotBlockData.setHeight(fin2.readInt());
                } else {
                    plotBlockData.setVersion(version);
                    fin2.reset();
                    plotBlockData.setHeight(fin2.readInt());
                    blockArr.add(fin2.readUTF());
                    blockArr.add(fin2.readUTF());
                }
                switch (version) {
                    default: {
                        String value;
                        while ((value = fin2.readUTF()) != null) {
                            blockArr.add(value);
                        }
                        break;
                    }
                    case 2: {
                        int temp = 0;
                        while ((temp = fin2.readInt()) >= 0) {
                            blockArr.add(temp + "");
                        }
                        break;
                    }
                }
            }
            catch (EOFException fin2) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            plotBlockData.setBlockList(blockArr);
            plotBlockData.resetBlockListRestored();
            return plotBlockData;
        }
        return null;
    }

    @Override
    public void deletePlotData(PlotBlockData plotChunk) {
        File file = new File(this.getPlotFilename(plotChunk));
        if (file.exists()) {
            file.delete();
        }
    }

    private boolean isFile(String fileName) {
        File file = new File(fileName);
        return file.exists() && file.isFile();
    }

    @Override
    public void deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
    }

    @Override
    public void deleteResident(Resident resident) {
        File file = new File(this.getResidentFilename(resident));
        if (file.exists()) {
            file.delete();
        }
    }

    @Override
    public void deleteTown(Town town) {
        File file = new File(this.getTownFilename(town));
        if (file.exists()) {
            FileMgmt.moveFile(file, "deleted");
        }
    }

    @Override
    public void deleteNation(Nation nation) {
        File file = new File(this.getNationFilename(nation));
        if (file.exists()) {
            FileMgmt.moveFile(file, "deleted");
        }
    }

    @Override
    public void deleteWorld(TownyWorld world) {
        File file = new File(this.getWorldFilename(world));
        if (file.exists()) {
            FileMgmt.moveFile(file, "deleted");
        }
    }

    @Override
    public void deleteTownBlock(TownBlock townBlock) {
        File file = new File(this.getTownBlockFilename(townBlock));
        if (file.exists()) {
            file.deleteOnExit();
        }
    }

    private static enum elements {
        VER,
        novalue;


        public static elements fromString(String Str) {
            try {
                return elements.valueOf(Str);
            }
            catch (Exception ex) {
                return novalue;
            }
        }
    }
}

