/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.event;

import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.Transaction;
import com.palmergames.bukkit.util.BukkitTools;
import org.bukkit.Bukkit;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class TownPreTransactionEvent
extends Event
implements Cancellable {
    private Town town;
    private static final HandlerList handlers = new HandlerList();
    private Transaction transaction;
    private String cancelMessage = "Sorry this event was cancelled.";
    private boolean isCancelled = false;

    public TownPreTransactionEvent(Town town, Transaction transaction) {
        super(!Bukkit.getServer().isPrimaryThread());
        this.town = town;
        this.transaction = transaction;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public Town getTown() {
        return this.town;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.isCancelled = cancelled;
    }

    public String getCancelMessage() {
        return this.cancelMessage;
    }

    public void setCancelMessage(String cancelMessage) {
        this.cancelMessage = cancelMessage;
    }

    public int getNewBalance() {
        try {
            switch (this.transaction.getType()) {
                case DEPOSIT: {
                    return (int)(this.town.getHoldingBalance() + (double)this.transaction.getAmount());
                }
                case WITHDRAW: {
                    return (int)(this.town.getHoldingBalance() - (double)this.transaction.getAmount());
                }
            }
        }
        catch (EconomyException e) {
            BukkitTools.getServer().getLogger().warning(e.getMessage());
        }
        return 0;
    }
}

