/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.huds;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.PlayerChangePlotEvent;
import com.palmergames.bukkit.towny.event.TownBlockSettingsChangedEvent;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.huds.PermHUD;
import com.palmergames.bukkit.towny.huds.WarHUD;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.war.eventwar.PlotAttackedEvent;
import com.palmergames.bukkit.towny.war.eventwar.TownScoredEvent;
import com.palmergames.bukkit.towny.war.eventwar.War;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

public class HUDManager
implements Listener {
    ArrayList<Player> warUsers = new ArrayList();
    ArrayList<Player> permUsers = new ArrayList();

    public HUDManager(Towny plugin) {
    }

    public void toggleWarHUD(Player p) {
        if (!this.warUsers.contains(p)) {
            this.toggleAllOff(p);
            this.warUsers.add(p);
            WarHUD.toggleOn(p, TownyUniverse.getInstance().getWarEvent());
        } else {
            this.toggleAllOff(p);
        }
    }

    public void togglePermHUD(Player p) {
        if (!this.permUsers.contains(p)) {
            this.toggleAllOff(p);
            this.permUsers.add(p);
            PermHUD.toggleOn(p);
        } else {
            this.toggleAllOff(p);
        }
    }

    public void toggleAllWarHUD() {
        for (Player p : this.warUsers) {
            HUDManager.toggleOff(p);
        }
        this.warUsers.clear();
    }

    public void toggleAllOff(Player p) {
        this.warUsers.remove(p);
        this.permUsers.remove(p);
        if (p.isOnline()) {
            HUDManager.toggleOff(p);
        }
    }

    public void toggleAllOffForQuit(Player p) {
        this.warUsers.remove(p);
        this.permUsers.remove(p);
    }

    public static void toggleOff(Player p) {
        p.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.toggleAllOffForQuit(event.getPlayer());
    }

    @EventHandler
    public void onPlayerMovePlotsEvent(PlayerChangePlotEvent event) throws NotRegisteredException {
        Player p = event.getPlayer();
        if (this.warUsers.contains(p)) {
            WarHUD.updateLocation(p, event.getTo());
            WarHUD.updateAttackable(p, event.getTo(), TownyUniverse.getInstance().getWarEvent());
            WarHUD.updateHealth(p, event.getTo(), TownyUniverse.getInstance().getWarEvent());
        } else if (this.permUsers.contains(p)) {
            if (event.getTo().getTownyWorld().isUsingTowny()) {
                PermHUD.updatePerms(p, event.getTo());
            } else {
                HUDManager.toggleOff(p);
            }
        }
    }

    @EventHandler
    public void onPlotAttacked(PlotAttackedEvent event) {
        boolean home = event.getTownBlock().isHomeBlock();
        for (Player p : event.getPlayers()) {
            if (!this.warUsers.contains(p)) continue;
            WarHUD.updateHealth(p, event.getHP(), home);
        }
    }

    @EventHandler
    public void onTownScored(TownScoredEvent event) {
        War warEvent = TownyUniverse.getInstance().getWarEvent();
        for (Resident r : event.getTown().getResidents()) {
            Player player = BukkitTools.getPlayer(r.getName());
            if (player == null || !this.warUsers.contains(player)) continue;
            WarHUD.updateScore(player, event.getScore());
        }
        String[] top = warEvent.getTopThree();
        for (Player p : this.warUsers) {
            WarHUD.updateTopScores(p, top);
        }
    }

    @EventHandler
    public void onTownBlockSettingsChanged(TownBlockSettingsChangedEvent e) {
        block8: {
            block9: {
                block7: {
                    if (e.getTownyWorld() == null) break block7;
                    for (Player p : this.permUsers) {
                        PermHUD.updatePerms(p);
                    }
                    break block8;
                }
                if (e.getTown() == null) break block9;
                for (Player p : this.permUsers) {
                    try {
                        if (new WorldCoord(p.getWorld().getName(), Coord.parseCoord((Entity)p)).getTownBlock().getTown() != e.getTown()) continue;
                        PermHUD.updatePerms(p);
                    }
                    catch (Exception exception) {}
                }
                break block8;
            }
            if (e.getTownBlock() == null) break block8;
            for (Player p : this.permUsers) {
                try {
                    if (new WorldCoord(p.getWorld().getName(), Coord.parseCoord((Entity)p)).getTownBlock() != e.getTownBlock()) continue;
                    PermHUD.updatePerms(p);
                }
                catch (Exception exception) {}
            }
        }
    }

    public static String check(String check) {
        return check.length() > 16 ? check.substring(0, 16) : check;
    }
}

