/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.invites;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.invites.TownyAllySender;
import com.palmergames.bukkit.towny.invites.TownyInviteReceiver;
import com.palmergames.bukkit.towny.invites.TownyInviteSender;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import java.io.InvalidObjectException;
import java.util.ArrayList;
import java.util.List;

public class InviteHandler {
    private static Towny plugin;
    private static List<Invite> activeInvites;

    public static void initialize(Towny plugin) {
        InviteHandler.plugin = plugin;
    }

    public static void acceptInvite(Invite invite) throws InvalidObjectException, TownyException {
        if (activeInvites.contains(invite)) {
            invite.accept();
            activeInvites.remove(invite);
            return;
        }
        throw new InvalidObjectException("Invite not valid!");
    }

    public static void declineInvite(Invite invite, boolean fromSender) throws InvalidObjectException {
        if (activeInvites.contains(invite)) {
            invite.decline(fromSender);
            activeInvites.remove(invite);
            return;
        }
        throw new InvalidObjectException("Invite not valid!");
    }

    public static void addInvite(Invite invite) {
        activeInvites.add(invite);
    }

    public static List<Invite> getActiveInvites() {
        return activeInvites;
    }

    public static boolean inviteIsActive(Invite invite) {
        for (Invite activeInvite : activeInvites) {
            if (!activeInvite.getReceiver().equals(invite.getReceiver()) || !activeInvite.getSender().equals(invite.getSender())) continue;
            return true;
        }
        return false;
    }

    public static boolean inviteIsActive(TownyInviteSender sender, TownyInviteReceiver receiver) {
        for (Invite activeInvite : activeInvites) {
            if (!activeInvite.getReceiver().equals(receiver) || !activeInvite.getSender().equals(sender)) continue;
            return true;
        }
        return false;
    }

    public static int getReceivedInvitesAmount(TownyInviteReceiver receiver) {
        List<Invite> invites = receiver.getReceivedInvites();
        return invites.size();
    }

    public static int getSentInvitesAmount(TownyInviteSender sender) {
        List<Invite> invites = sender.getSentInvites();
        return invites.size();
    }

    public static int getSentAllyRequestsAmount(TownyAllySender sender) {
        List<Invite> invites = sender.getSentAllyInvites();
        return invites.size();
    }

    public static int getSentAllyRequestsMaxAmount(TownyAllySender sender) {
        int amount = 0;
        if (sender instanceof Nation) {
            amount = TownySettings.getMaximumRequestsSentNation() == 0 ? 100 : TownySettings.getMaximumRequestsSentNation();
        }
        return amount;
    }

    public static int getReceivedInvitesMaxAmount(TownyInviteReceiver receiver) {
        int amount = 0;
        if (receiver instanceof Resident) {
            amount = TownySettings.getMaximumInvitesReceivedResident() == 0 ? 100 : TownySettings.getMaximumInvitesReceivedResident();
        }
        if (receiver instanceof Town) {
            amount = TownySettings.getMaximumInvitesReceivedTown() == 0 ? 100 : TownySettings.getMaximumInvitesReceivedTown();
        }
        if (receiver instanceof Nation) {
            amount = TownySettings.getMaximumRequestsReceivedNation() == 0 ? 100 : TownySettings.getMaximumRequestsReceivedNation();
        }
        return amount;
    }

    public static int getSentInvitesMaxAmount(TownyInviteSender sender) {
        int amount = 0;
        if (sender instanceof Town) {
            amount = TownySettings.getMaximumInvitesSentTown() == 0 ? 100 : TownySettings.getMaximumInvitesSentTown();
        }
        if (sender instanceof Nation) {
            amount = TownySettings.getMaximumInvitesSentNation() == 0 ? 100 : TownySettings.getMaximumInvitesSentNation();
        }
        return amount;
    }

    static {
        activeInvites = new ArrayList<Invite>();
    }
}

