/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.ChunkNotification;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.command.TownyCommand;
import com.palmergames.bukkit.towny.event.PlayerChangePlotEvent;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.CellBorder;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.utils.BorderUtil;
import com.palmergames.bukkit.util.DrawSmokeTaskFactory;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class TownyCustomListener
implements Listener {
    private final Towny plugin;

    public TownyCustomListener(Towny instance) {
        this.plugin = instance;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerChangePlotEvent(PlayerChangePlotEvent event) {
        Player player = event.getPlayer();
        WorldCoord from = event.getFrom();
        WorldCoord to = event.getTo();
        if (this.plugin.hasPlayerMode(player, "townclaim")) {
            TownCommand.parseTownClaimCommand(player, new String[0]);
        }
        if (this.plugin.hasPlayerMode(player, "townunclaim")) {
            TownCommand.parseTownUnclaimCommand(player, new String[0]);
        }
        if (this.plugin.hasPlayerMode(player, "map")) {
            TownyCommand.showMap(player);
        }
        try {
            Resident resident;
            ChunkNotification chunkNotifier;
            String msg;
            if (to.getTownyWorld().isUsingTowny() && TownySettings.getShowTownNotifications() && (msg = (chunkNotifier = new ChunkNotification(from, to)).getNotificationString(resident = TownyUniverse.getInstance().getDataSource().getResident(player.getName()))) != null) {
                if (!Towny.isSpigot) {
                    player.sendMessage(msg);
                } else {
                    player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)msg));
                }
            }
        }
        catch (NotRegisteredException resident) {
            // empty catch block
        }
        if (this.plugin.hasPlayerMode(player, "plotborder")) {
            CellBorder cellBorder = BorderUtil.getPlotBorder(to);
            cellBorder.runBorderedOnSurface(1, 2, DrawSmokeTaskFactory.sendToPlayer(player));
        }
    }
}

