/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.regen.block.BlockLocation;
import com.palmergames.bukkit.towny.tasks.MobRemovalTimerTask;
import com.palmergames.bukkit.towny.tasks.ProtectionRegenTask;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import com.palmergames.bukkit.towny.war.eventwar.War;
import com.palmergames.bukkit.towny.war.flagwar.TownyWarConfig;
import com.palmergames.bukkit.util.ArraySort;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.ShulkerBox;
import org.bukkit.block.data.type.PistonHead;
import org.bukkit.entity.Animals;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Creature;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PigZapEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.material.Attachable;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;

public class TownyEntityListener
implements Listener {
    private final Towny plugin;

    public TownyEntityListener(Towny instance) {
        this.plugin = instance;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        Entity attacker = event.getDamager();
        Entity defender = event.getEntity();
        if (!TownyAPI.getInstance().isWarTime()) {
            if (CombatUtil.preventDamageCall(this.plugin, attacker, defender)) {
                if (attacker instanceof Projectile && !attacker.getType().equals((Object)EntityType.TRIDENT)) {
                    attacker.remove();
                }
                event.setCancelled(true);
            }
        } else {
            try {
                if (attacker instanceof Projectile) {
                    ProjectileSource shooter = ((Projectile)attacker).getShooter();
                    if (shooter instanceof Entity) {
                        attacker = (Entity)shooter;
                    } else {
                        BlockProjectileSource bShooter = (BlockProjectileSource)((Projectile)attacker).getShooter();
                        if (TownyAPI.getInstance().getTownBlock(bShooter.getBlock().getLocation()) != null) {
                            Town bTown = TownyAPI.getInstance().getTownBlock(bShooter.getBlock().getLocation()).getTown();
                            if (!bTown.hasNation() && TownySettings.isWarTimeTownsNeutral()) {
                                event.setCancelled(true);
                                return;
                            }
                            if (bTown.getNation().isNeutral()) {
                                event.setCancelled(true);
                                return;
                            }
                            if (!War.isWarringTown(bTown)) {
                                event.setCancelled(true);
                                return;
                            }
                        }
                    }
                }
                if (!(attacker instanceof Player) || !(defender instanceof Player)) {
                    return;
                }
                TownyUniverse universe = TownyUniverse.getInstance();
                if (!universe.getDataSource().getResident(attacker.getName()).hasTown() || !universe.getDataSource().getResident(defender.getName()).hasTown()) {
                    TownyMessaging.sendMessage((Object)attacker, TownySettings.getWarAPlayerHasNoTownMsg());
                    event.setCancelled(true);
                    return;
                }
                try {
                    Town attackerTown = universe.getDataSource().getResident(attacker.getName()).getTown();
                    Town defenderTown = universe.getDataSource().getResident(defender.getName()).getTown();
                    if (!(attackerTown.hasNation() && defenderTown.hasNation() || !TownySettings.isWarTimeTownsNeutral())) {
                        TownyMessaging.sendMessage((Object)attacker, TownySettings.getWarAPlayerHasNoNationMsg());
                        event.setCancelled(true);
                        return;
                    }
                    if (attackerTown.getNation().isNeutral() || defenderTown.getNation().isNeutral()) {
                        TownyMessaging.sendMessage((Object)attacker, TownySettings.getWarAPlayerHasANeutralNationMsg());
                        event.setCancelled(true);
                        return;
                    }
                    if (!War.isWarringTown(defenderTown) || !War.isWarringTown(attackerTown)) {
                        TownyMessaging.sendMessage((Object)attacker, TownySettings.getWarAPlayerHasBeenRemovedFromWarMsg());
                        event.setCancelled(true);
                        return;
                    }
                    if ((attackerTown.getNation().hasAlly(defenderTown.getNation()) || defenderTown.getNation().hasAlly(attackerTown.getNation())) && !TownySettings.getFriendlyFire()) {
                        TownyMessaging.sendMessage((Object)attacker, TownySettings.getWarAPlayerIsAnAllyMsg());
                        event.setCancelled(true);
                        return;
                    }
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
                if (CombatUtil.preventFriendlyFire((Player)attacker, (Player)defender)) {
                    if (attacker instanceof Projectile) {
                        attacker.remove();
                    }
                    event.setCancelled(true);
                }
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        if (this.plugin.isError()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity instanceof Monster) {
            Location loc = entity.getLocation();
            try {
                TownyWorld townyWorld = TownyUniverse.getInstance().getDataSource().getWorld(loc.getWorld().getName());
                if (townyWorld.isUsingTowny() && townyWorld.getTownBlock(Coord.parseCoord(loc)).getType() == TownBlockType.ARENA) {
                    event.getDrops().clear();
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityTargetLivingEntity(EntityTargetLivingEntityEvent event) {
        if (this.plugin.isError()) {
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        if (event.getTarget() instanceof Player && event.getReason().equals((Object)EntityTargetEvent.TargetReason.TEMPT)) {
            Location loc = event.getEntity().getLocation();
            if (TownyAPI.getInstance().isWilderness(loc)) {
                return;
            }
            if (!TownyAPI.getInstance().getTownBlock(loc).hasResident()) {
                return;
            }
            Player target = (Player)event.getTarget();
            if (!PlayerCacheUtil.getCachePermission(target, loc, Material.DIRT, TownyPermission.ActionType.DESTROY)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamageByEntityEvent(EntityDamageByEntityEvent event) {
        if (this.plugin.isError()) {
            return;
        }
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        TownyWorld townyWorld = null;
        Entity entity = event.getEntity();
        String damager = event.getDamager().getType().name();
        try {
            townyWorld = townyUniverse.getDataSource().getWorld(entity.getWorld().getName());
        }
        catch (NotRegisteredException e) {
            e.printStackTrace();
        }
        if (TownyAPI.getInstance().isWarTime() && !TownyWarConfig.isAllowingExplosionsInWarZone() && entity instanceof Player && damager.equals("PRIMED_TNT")) {
            event.setCancelled(true);
        }
        TownyMessaging.sendDebugMsg("EntityDamageByEntityEvent : entity = " + entity);
        TownyMessaging.sendDebugMsg("EntityDamageByEntityEvent : damager = " + damager);
        if (entity instanceof ArmorStand || entity instanceof ItemFrame || entity instanceof Animals || entity instanceof EnderCrystal || entity instanceof Villager) {
            if (damager.equals("PRIMED_TNT") || damager.equals("MINECART_TNT") || damager.equals("WITHER_SKULL") || damager.equals("FIREBALL") || damager.equals("SMALL_FIREBALL") || damager.equals("LARGE_FIREBALL") || damager.equals("WITHER") || damager.equals("CREEPER") || damager.equals("FIREWORK")) {
                if (!this.locationCanExplode(townyWorld, entity.getLocation())) {
                    event.setCancelled(true);
                    return;
                }
                return;
            }
            if (damager.equals("LIGHTNING")) {
                if (!this.locationCanExplode(townyWorld, entity.getLocation())) {
                    event.setDamage(0.0);
                    event.setCancelled(true);
                    return;
                }
                return;
            }
            if (event.getDamager() instanceof Projectile) {
                try {
                    townyWorld = townyUniverse.getDataSource().getWorld(entity.getWorld().getName());
                }
                catch (NotRegisteredException e) {
                    e.printStackTrace();
                }
                Entity remover = event.getDamager();
                remover = ((Projectile)remover).getShooter();
                if (remover instanceof Monster) {
                    event.setCancelled(true);
                } else if (remover instanceof Player) {
                    Player player = (Player)remover;
                    Coord coord = Coord.parseCoord(entity);
                    try {
                        TownBlock townBlock = townyWorld.getTownBlock(coord);
                    }
                    catch (NotRegisteredException ex) {
                        return;
                    }
                    boolean bDestroy = PlayerCacheUtil.getCachePermission(player, entity.getLocation(), Material.ARMOR_STAND, TownyPermission.ActionType.DESTROY);
                    if (bDestroy) {
                        return;
                    }
                    event.setCancelled(true);
                }
            }
            if (event.getDamager() instanceof Player) {
                Player player = (Player)event.getDamager();
                boolean bDestroy = false;
                if (entity instanceof EnderCrystal) {
                    bDestroy = PlayerCacheUtil.getCachePermission(player, entity.getLocation(), Material.GRASS, TownyPermission.ActionType.DESTROY);
                    if (bDestroy) {
                        return;
                    }
                    event.setCancelled(true);
                }
            }
        }
        if (damager.equals("FIREWORK") && (!this.locationCanExplode(townyWorld, entity.getLocation()) || CombatUtil.preventPvP(townyWorld, TownyAPI.getInstance().getTownBlock(entity.getLocation())))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onLingeringPotionSplashEvent(LingeringPotionSplashEvent event) {
        ThrownPotion potion = event.getEntity();
        Location loc = potion.getLocation();
        TownyWorld townyWorld = null;
        try {
            townyWorld = TownyUniverse.getInstance().getDataSource().getWorld(loc.getWorld().getName());
        }
        catch (NotRegisteredException e) {
            return;
        }
        float radius = event.getAreaEffectCloud().getRadius();
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (double x = loc.getX() - (double)radius; x < loc.getX() + (double)radius; x += 1.0) {
            for (double z = loc.getZ() - (double)radius; z < loc.getZ() + (double)radius; z += 1.0) {
                Location loc2 = new Location(potion.getWorld(), x, loc.getY(), z);
                Block b = loc2.getBlock();
                if (!b.getType().equals((Object)Material.AIR)) continue;
                blocks.add(b);
            }
        }
        List effects = (List)potion.getEffects();
        boolean detrimental = false;
        List<String> prots = TownySettings.getPotionTypes();
        for (PotionEffect effect : effects) {
            if (!prots.contains(effect.getType().getName())) continue;
            detrimental = true;
        }
        ProjectileSource source = potion.getShooter();
        if (!(source instanceof Entity)) {
            return;
        }
        for (Block block : blocks) {
            Coord coord = Coord.parseCoord(block.getLocation());
            if (!townyWorld.hasTownBlock(coord)) continue;
            TownBlock townBlock = null;
            try {
                townBlock = townyWorld.getTownBlock(coord);
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
            }
            if (TownyAPI.getInstance().isWarTime() || !CombatUtil.preventPvP(townyWorld, townBlock) || !detrimental) continue;
            event.setCancelled(true);
            break;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPotionSplashEvent(PotionSplashEvent event) {
        List affectedEntities = (List)event.getAffectedEntities();
        ThrownPotion potion = event.getPotion();
        List effects = (List)potion.getEffects();
        boolean detrimental = false;
        List<String> prots = TownySettings.getPotionTypes();
        for (PotionEffect effect : effects) {
            if (!prots.contains(effect.getType().getName())) continue;
            detrimental = true;
        }
        ProjectileSource source = potion.getShooter();
        if (!(source instanceof Entity)) {
            return;
        }
        Entity attacker = (Entity)source;
        if (!TownyAPI.getInstance().isWarTime()) {
            for (LivingEntity defender : affectedEntities) {
                if (attacker == defender || !CombatUtil.preventDamageCall(this.plugin, attacker, (Entity)defender) || !detrimental) continue;
                event.setIntensity(defender, -1.0);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent event) throws NotRegisteredException {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (event.getEntity() != null) {
            LivingEntity livingEntity = event.getEntity();
            Location loc = event.getLocation();
            Coord coord = Coord.parseCoord(loc);
            TownyWorld townyWorld = null;
            try {
                townyWorld = TownyUniverse.getInstance().getDataSource().getWorld(loc.getWorld().getName());
            }
            catch (NotRegisteredException e) {
                return;
            }
            if (townyWorld.isUsingTowny()) {
                if (!townyWorld.hasWorldMobs() && MobRemovalTimerTask.isRemovingWorldEntity(livingEntity)) {
                    if (this.plugin.isCitizens2()) {
                        if (!CitizensAPI.getNPCRegistry().isNPC((Entity)livingEntity)) {
                            event.setCancelled(true);
                        }
                    } else {
                        event.setCancelled(true);
                    }
                }
                if (livingEntity instanceof Villager && !((Villager)livingEntity).isAdult() && TownySettings.isRemovingVillagerBabiesWorld()) {
                    event.setCancelled(true);
                }
            }
            if (!townyWorld.hasTownBlock(coord)) {
                return;
            }
            TownBlock townBlock = townyWorld.getTownBlock(coord);
            try {
                if (townyWorld.isUsingTowny() && !townyWorld.isForceTownMobs() && !townBlock.getTown().hasMobs() && !townBlock.getPermissions().mobs && MobRemovalTimerTask.isRemovingTownEntity(livingEntity)) {
                    if (this.plugin.isCitizens2()) {
                        if (!CitizensAPI.getNPCRegistry().isNPC((Entity)livingEntity)) {
                            event.setCancelled(true);
                        }
                    } else {
                        event.setCancelled(true);
                    }
                }
                if (livingEntity instanceof Villager && !((Villager)livingEntity).isAdult() && TownySettings.isRemovingVillagerBabiesTown()) {
                    event.setCancelled(true);
                }
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityInteract(EntityInteractEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        Block block = event.getBlock();
        Entity entity = event.getEntity();
        List passengers = entity.getPassengers();
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        TownyWorld World2 = null;
        if (!TownyAPI.getInstance().isTownyWorld(event.getBlock().getWorld())) {
            return;
        }
        try {
            TownyWorld townyWorld = townyUniverse.getDataSource().getWorld(block.getLocation().getWorld().getName());
            if (townyWorld.isDisableCreatureTrample() && (block.getType() == Material.FARMLAND || block.getType() == Material.WHEAT) && entity instanceof Creature) {
                event.setCancelled(true);
                return;
            }
            if (passengers != null) {
                for (Entity passenger : passengers) {
                    if (!passenger.getType().equals((Object)EntityType.PLAYER)) {
                        return;
                    }
                    if (!TownySettings.isSwitchMaterial(block.getType().name()) || this.plugin.getPlayerListener().onPlayerSwitchEvent((Player)passenger, block, null, World2)) continue;
                    return;
                }
            }
            if (TownySettings.isCreatureTriggeringPressurePlateDisabled() && block.getType() == Material.STONE_PRESSURE_PLATE && entity instanceof Creature) {
                event.setCancelled(true);
                return;
            }
        }
        catch (NotRegisteredException e) {
            e.printStackTrace();
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityChangeBlockEvent(EntityChangeBlockEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        switch (event.getEntity().getType()) {
            case WITHER: {
                try {
                    TownyWorld townyWorld = townyUniverse.getDataSource().getWorld(event.getBlock().getWorld().getName());
                    if (!townyWorld.isUsingTowny()) {
                        return;
                    }
                    if (!this.locationCanExplode(townyWorld, event.getBlock().getLocation())) {
                        event.setCancelled(true);
                        return;
                    }
                }
                catch (NotRegisteredException townyWorld) {}
                break;
            }
            case ENDERMAN: {
                try {
                    TownyWorld townyWorld = townyUniverse.getDataSource().getWorld(event.getBlock().getWorld().getName());
                    if (!townyWorld.isUsingTowny()) {
                        return;
                    }
                    if (!townyWorld.isEndermanProtect()) break;
                    event.setCancelled(true);
                }
                catch (NotRegisteredException notRegisteredException) {}
                break;
            }
        }
    }

    public boolean locationCanExplode(TownyWorld world, Location target) {
        Coord coord = Coord.parseCoord(target);
        if (world.isWarZone(coord) && !TownyWarConfig.isAllowingExplosionsInWarZone()) {
            return false;
        }
        try {
            TownBlock townBlock = world.getTownBlock(coord);
            if (world.isUsingTowny() && !world.isForceExpl() && (!townBlock.getPermissions().explosion || TownyAPI.getInstance().isWarTime() && TownySettings.isAllowWarBlockGriefing() && !townBlock.getTown().hasNation() && !townBlock.getTown().isBANG())) {
                return false;
            }
        }
        catch (NotRegisteredException e) {
            return world.isExpl();
        }
        return true;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent event) {
        TownyWorld townyWorld;
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        try {
            townyWorld = TownyUniverse.getInstance().getDataSource().getWorld(event.getLocation().getWorld().getName());
            if (!townyWorld.isUsingTowny()) {
                return;
            }
        }
        catch (NotRegisteredException e) {
            return;
        }
        List blocks = event.blockList();
        Entity entity = event.getEntity();
        blocks.sort(ArraySort.getInstance());
        if (TownyAPI.getInstance().isWarTime()) {
            Iterator it = event.blockList().iterator();
            int count = 0;
            while (it.hasNext()) {
                Block block = (Block)it.next();
                TownBlock townBlock = null;
                boolean isNeutralTownBlock = false;
                ++count;
                try {
                    townBlock = townyWorld.getTownBlock(Coord.parseCoord(block.getLocation()));
                    if (townBlock.hasTown() && !War.isWarringTown(townBlock.getTown())) {
                        isNeutralTownBlock = true;
                    }
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
                if (!isNeutralTownBlock) {
                    if (!TownyWarConfig.isAllowingExplosionsInWarZone()) {
                        if (event.getEntity() != null) {
                            TownyMessaging.sendDebugMsg("onEntityExplode: Canceled " + event.getEntity().getEntityId() + " from exploding within " + Coord.parseCoord(block.getLocation()).toString() + ".");
                        }
                        event.setCancelled(true);
                        return;
                    }
                    event.setCancelled(false);
                    if (TownyWarConfig.explosionsBreakBlocksInWarZone()) {
                        if (TownyWarConfig.getExplosionsIgnoreList().contains(block.getType().toString()) || TownyWarConfig.getExplosionsIgnoreList().contains(block.getRelative(BlockFace.UP).getType().toString())) {
                            it.remove();
                            continue;
                        }
                        if (!TownyWarConfig.regenBlocksAfterExplosionInWarZone() || TownyRegenAPI.hasProtectionRegenTask(new BlockLocation(block.getLocation())) || block.getType() == Material.TNT) continue;
                        ProtectionRegenTask task = new ProtectionRegenTask(this.plugin, block);
                        task.setTaskId(this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)task, (TownySettings.getPlotManagementWildRegenDelay() + (long)count) * 20L));
                        TownyRegenAPI.addProtectionRegenTask(task);
                        event.setYield(0.0f);
                        block.getDrops().clear();
                        continue;
                    }
                    event.blockList().remove(block);
                    continue;
                }
                if (townyWorld.isForceExpl()) continue;
                try {
                    if (townBlock.getPermissions().explosion && (!TownySettings.isAllowWarBlockGriefing() || townBlock.getTown().isBANG()) || event.getEntity() == null) continue;
                    event.setCancelled(true);
                    return;
                }
                catch (TownyException x) {
                    if (!townyWorld.isUsingTowny()) continue;
                    if (townyWorld.isExpl()) {
                        if (!townyWorld.isUsingPlotManagementWildRevert() || entity == null || !townyWorld.isProtectingExplosionEntity(entity) || TownyRegenAPI.hasProtectionRegenTask(new BlockLocation(block.getLocation())) || block.getType() == Material.TNT) continue;
                        ProtectionRegenTask task = new ProtectionRegenTask(this.plugin, block);
                        task.setTaskId(this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)task, (TownySettings.getPlotManagementWildRegenDelay() + (long)count) * 20L));
                        TownyRegenAPI.addProtectionRegenTask(task);
                        event.setYield(0.0f);
                        block.getDrops().clear();
                        continue;
                    }
                    event.setCancelled(true);
                    return;
                }
            }
        } else {
            int count = 0;
            for (Block block : blocks) {
                Coord coord = Coord.parseCoord(block.getLocation());
                ++count;
                TownBlock townBlock = null;
                try {
                    townBlock = townyWorld.getTownBlock(coord);
                    if (!townyWorld.isUsingTowny() || townyWorld.isForceExpl() || townBlock.getPermissions().explosion && (!TownyAPI.getInstance().isWarTime() || !TownySettings.isAllowWarBlockGriefing() || townBlock.getTown().hasNation() || townBlock.getTown().isBANG()) || event.getEntity() == null) continue;
                    TownyMessaging.sendDebugMsg("onEntityExplode: Canceled " + event.getEntity().getEntityId() + " from exploding within " + coord.toString() + ".");
                    event.setCancelled(true);
                    return;
                }
                catch (TownyException x) {
                    if (!townyWorld.isUsingTowny()) continue;
                    if (townyWorld.isExpl()) {
                        if (!townyWorld.isUsingPlotManagementWildRevert() || entity == null || !townyWorld.isProtectingExplosionEntity(entity)) continue;
                        if (block.getType().equals((Object)Material.PISTON_HEAD)) {
                            PistonHead blockData = (PistonHead)block.getBlockData();
                            Block baseBlock = block.getRelative(blockData.getFacing().getOppositeFace());
                            if (TownyRegenAPI.hasProtectionRegenTask(new BlockLocation((block = baseBlock).getLocation())) || block.getType() == Material.TNT) continue;
                            ProtectionRegenTask task = new ProtectionRegenTask(this.plugin, block);
                            task.setTaskId(this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)task, (TownySettings.getPlotManagementWildRegenDelay() + (long)count) * 20L));
                            TownyRegenAPI.addProtectionRegenTask(task);
                            event.setYield(0.0f);
                            block.getDrops().clear();
                            continue;
                        }
                        if (TownyRegenAPI.hasProtectionRegenTask(new BlockLocation(block.getLocation())) || block.getType() == Material.TNT) continue;
                        ProtectionRegenTask task = new ProtectionRegenTask(this.plugin, block);
                        task.setTaskId(this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)task, (TownySettings.getPlotManagementWildRegenDelay() + (long)count) * 20L));
                        TownyRegenAPI.addProtectionRegenTask(task);
                        event.setYield(0.0f);
                        block.getDrops().clear();
                        if (!(block.getState().getData() instanceof Attachable) && !Tag.SIGNS.isTagged((Keyed)block.getType()) && !Tag.WOODEN_PRESSURE_PLATES.isTagged((Keyed)block.getType()) && !block.getType().equals((Object)Material.HEAVY_WEIGHTED_PRESSURE_PLATE) && !block.getType().equals((Object)Material.LIGHT_WEIGHTED_PRESSURE_PLATE) && !(block.getState() instanceof ShulkerBox)) continue;
                        block.setType(Material.AIR);
                        continue;
                    }
                    event.setCancelled(true);
                    return;
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityCombustByEntityEvent(EntityCombustByEntityEvent event) throws NotRegisteredException {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        Entity combuster = event.getCombuster();
        Entity defender = event.getEntity();
        if (combuster instanceof Projectile) {
            ProjectileSource source = ((Projectile)combuster).getShooter();
            if (!(source instanceof LivingEntity)) {
                return;
            }
            LivingEntity attacker = (LivingEntity)source;
            if (attacker != null && !TownyAPI.getInstance().isWarTime() && CombatUtil.preventDamageCall(this.plugin, (Entity)attacker, defender)) {
                combuster.remove();
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onHangingBreak(HangingBreakEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        TownyWorld townyWorld = null;
        String worldName = null;
        Hanging hanging = event.getEntity();
        try {
            worldName = hanging.getWorld().getName();
            townyWorld = TownyUniverse.getInstance().getDataSource().getWorld(worldName);
            if (!townyWorld.isUsingTowny()) {
                return;
            }
        }
        catch (NotRegisteredException e1) {
            return;
        }
        if (event instanceof HangingBreakByEntityEvent) {
            HangingBreakByEntityEvent evt = (HangingBreakByEntityEvent)event;
            Entity remover = evt.getRemover();
            if (remover instanceof Projectile) {
                remover = ((Projectile)remover).getShooter();
            }
            if (remover instanceof Player) {
                Player player = (Player)remover;
                boolean bDestroy = PlayerCacheUtil.getCachePermission(player, hanging.getLocation(), Material.PAINTING, TownyPermission.ActionType.DESTROY);
                if (bDestroy) {
                    return;
                }
                PlayerCache cache = this.plugin.getCache(player);
                event.setCancelled(true);
                if (cache.hasBlockErrMsg()) {
                    TownyMessaging.sendErrorMsg((Object)player, cache.getBlockErrMsg());
                }
            } else if (!this.locationCanExplode(townyWorld, hanging.getLocation())) {
                event.setCancelled(true);
            } else {
                TownBlock tb = TownyAPI.getInstance().getTownBlock(hanging.getLocation());
                if (tb == null && townyWorld.isExpl() && townyWorld.isUsingPlotManagementWildRevert() && remover != null && townyWorld.isProtectingExplosionEntity(remover)) {
                    event.setCancelled(true);
                }
            }
        } else {
            switch (event.getCause()) {
                case EXPLOSION: {
                    if (this.locationCanExplode(townyWorld, event.getEntity().getLocation())) break;
                    event.setCancelled(true);
                    break;
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onHangingPlace(HangingPlaceEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        Hanging hanging = event.getEntity();
        if (!TownyAPI.getInstance().isTownyWorld(hanging.getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        boolean bBuild = PlayerCacheUtil.getCachePermission(player, hanging.getLocation(), Material.PAINTING, TownyPermission.ActionType.BUILD);
        event.setCancelled(!bBuild);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPigHitByLightning(PigZapEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        try {
            if (!this.locationCanExplode(TownyAPI.getInstance().getDataSource().getWorld(event.getEntity().getWorld().getName()), event.getEntity().getLocation())) {
                event.setCancelled(true);
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
    }
}

